/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.waltz;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.benchmark.waltz.Line;
import org.drools.benchmark.waltz.Stage;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.WorkingMemory;

public abstract class WaltzBenchmark {
    public static void main(String[] args) throws Exception {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"waltz.drl", WaltzBenchmark.class), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        long totalTime = 0L;
        for (int i = 0; i < 5; ++i) {
            String arg;
            StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
            String filename = args.length != 0 ? (arg = args[0]) : "waltz50.dat";
            WaltzBenchmark.loadLines((WorkingMemory)session, filename);
            Stage stage = new Stage(1);
            session.insert((Object)stage);
            long start = System.currentTimeMillis();
            session.setGlobal("time", (Object)start);
            session.fireAllRules();
            long time = System.currentTimeMillis() - start;
            System.err.println(time);
            totalTime += time;
            session.dispose();
        }
        System.out.println("average : " + totalTime / 5L);
    }

    private static void loadLines(WorkingMemory wm, String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(WaltzBenchmark.class.getResourceAsStream(filename)));
        Pattern pat = Pattern.compile(".*make line \\^p1 ([0-9]*) \\^p2 ([0-9]*).*");
        String line = reader.readLine();
        while (line != null) {
            Matcher m = pat.matcher(line);
            if (m.matches()) {
                Line l = new Line(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
                wm.insert((Object)l);
            }
            line = reader.readLine();
        }
        reader.close();
    }
}

