/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.drools.examples.conway.CellGrid;
import org.drools.examples.conway.CellGridImpl;
import org.drools.examples.conway.ConwayApplicationProperties;
import org.drools.examples.conway.patterns.ConwayPattern;
import org.drools.examples.conway.ui.CellGridCanvas;

public class ConwayGUI
extends JPanel {
    private static final long serialVersionUID = 510L;
    private final JButton nextGenerationButton;
    private final JButton startStopButton;
    private final JButton clearButton;
    private final JComboBox patternSelector = new JComboBox();
    private final Timer timer;
    private final CellGrid grid;

    public ConwayGUI(int executionControl) {
        super(new BorderLayout());
        String nextGenerationLabel = ConwayApplicationProperties.getProperty("next.generation.label");
        this.nextGenerationButton = new JButton(nextGenerationLabel);
        String startLabel = ConwayApplicationProperties.getProperty("start.label");
        this.startStopButton = new JButton(startLabel);
        String clearLabel = ConwayApplicationProperties.getProperty("clear.label");
        this.clearButton = new JButton(clearLabel);
        this.grid = new CellGridImpl(30, 30, executionControl);
        final CellGridCanvas canvas = new CellGridCanvas(this.grid);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add("Center", canvas);
        Border etchedBorder = BorderFactory.createEtchedBorder(1);
        Border outerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border innerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(outerBlankBorder, etchedBorder), innerBlankBorder);
        panel.setBorder(border);
        this.add("Center", panel);
        this.add("East", this.createControlPanel());
        this.nextGenerationButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConwayGUI.this.grid.nextGeneration();
                canvas.repaint();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConwayGUI.this.grid.killAll();
                canvas.repaint();
            }
        });
        ActionListener timerAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (!ConwayGUI.this.grid.nextGeneration()) {
                    ConwayGUI.this.stopTimer();
                }
                canvas.repaint();
            }
        };
        this.timer = new Timer(500, timerAction);
        this.startStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ConwayGUI.this.timer.isRunning()) {
                    ConwayGUI.this.stopTimer();
                } else {
                    ConwayGUI.this.startTimer();
                }
            }
        });
        this.populatePatternSelector();
        this.patternSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConwayPattern pattern = (ConwayPattern)ConwayGUI.this.patternSelector.getSelectedItem();
                if (pattern != null) {
                    ConwayGUI.this.grid.setPattern(pattern);
                    canvas.repaint();
                }
            }
        });
        this.patternSelector.setSelectedIndex(-1);
    }

    public void dispose() {
        this.grid.dispose();
    }

    private void populatePatternSelector() {
        String patternClassNames = ConwayApplicationProperties.getProperty("conway.pattern.classnames");
        StringTokenizer tokenizer = new StringTokenizer(patternClassNames);
        String className = null;
        while (tokenizer.hasMoreTokens()) {
            className = tokenizer.nextToken().trim();
            try {
                Class<?> clazz = Class.forName(className);
                if (ConwayPattern.class.isAssignableFrom(clazz)) {
                    this.patternSelector.addItem(clazz.newInstance());
                    continue;
                }
                System.err.println("Invalid pattern class name: " + className);
            }
            catch (Exception e) {
                System.err.println("An error occurred populating patterns: ");
                e.printStackTrace();
            }
        }
    }

    private void startTimer() {
        String stopLabel = ConwayApplicationProperties.getProperty("stop.label");
        this.startStopButton.setText(stopLabel);
        this.nextGenerationButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.patternSelector.setEnabled(false);
        this.timer.start();
    }

    private void stopTimer() {
        this.timer.stop();
        String startLabel = ConwayApplicationProperties.getProperty("start.label");
        this.startStopButton.setText(startLabel);
        this.nextGenerationButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.patternSelector.setEnabled(true);
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel(new BorderLayout());
        JPanel formPanel = new JPanel();
        GroupLayout formLayout = new GroupLayout(formPanel);
        formPanel.setLayout(formLayout);
        formLayout.setAutoCreateGaps(true);
        formLayout.setAutoCreateContainerGaps(true);
        String title = ConwayApplicationProperties.getProperty("app.title");
        JLabel titleLabel = new JLabel(title);
        String description = ConwayApplicationProperties.getProperty("app.description");
        JLabel descriptionLabel = new JLabel(description);
        String patternLabelText = ConwayApplicationProperties.getProperty("pattern.label");
        JLabel patternLabel = new JLabel(patternLabelText);
        formLayout.setHorizontalGroup(formLayout.createParallelGroup().addComponent(titleLabel).addComponent(descriptionLabel).addGroup(formLayout.createSequentialGroup().addComponent(patternLabel).addComponent(this.patternSelector)));
        formLayout.setVerticalGroup(formLayout.createSequentialGroup().addComponent(titleLabel).addComponent(descriptionLabel).addGroup(formLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(patternLabel).addComponent(this.patternSelector)));
        controlPanel.add((Component)formPanel, "North");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(this.nextGenerationButton);
        buttonPanel.add(this.startStopButton);
        buttonPanel.add(this.clearButton);
        controlPanel.add((Component)buttonPanel, "South");
        Border etchedBorder = BorderFactory.createEtchedBorder(1);
        Border outerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border innerBlankBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(outerBlankBorder, etchedBorder), innerBlankBorder);
        controlPanel.setBorder(border);
        return controlPanel;
    }

    public static void main(String[] args) {
        final ConwayGUI gui = new ConwayGUI(1);
        String appTitle = ConwayApplicationProperties.getProperty("app.title");
        JFrame f = new JFrame(appTitle);
        f.setResizable(false);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add("Center", gui);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                gui.dispose();
            }
        });
        f.pack();
        f.setVisible(true);
    }
}

