/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.events;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import org.drools.examples.broker.events.StockTickPersister;
import org.drools.examples.broker.model.Company;
import org.drools.examples.broker.model.CompanyRegistry;
import org.drools.examples.broker.model.StockTick;

public class EventGenerator {
    private static final String DATA_FILE = "src/main/resources/stocktickstream.dat";
    private static Random steps = new Random(System.currentTimeMillis());
    private static Random symbols = new Random(System.currentTimeMillis());
    private static Random prices = new Random(System.currentTimeMillis());

    public static void main(String[] args) throws IOException {
        long timespam = 1200000L;
        long[] interval = new long[]{200L, 2000L};
        double[] priceChanges = new double[]{-0.1, 0.1};
        double[] startingPrices = new double[]{50.0, 120.0};
        Company[] companies = new CompanyRegistry().getCompanies().toArray(new Company[0]);
        StockTickPersister persister = new StockTickPersister();
        persister.openForSave(new FileWriter(DATA_FILE));
        System.out.print("Generating data for 20 min...");
        for (Company company : companies) {
            company.setCurrentPrice(EventGenerator.nextStartingPrice(startingPrices));
            StockTick tick = new StockTick(company.getSymbol(), company.getCurrentPrice(), 0L);
            persister.save(tick);
        }
        for (long offset = 0L; offset < timespam; offset += EventGenerator.nextStep(interval)) {
            int company = symbols.nextInt(companies.length);
            double price = companies[company].getCurrentPrice() * (1.0 + EventGenerator.nextPriceChange(priceChanges));
            StockTick tick = new StockTick(companies[company].getSymbol(), price, offset);
            persister.save(tick);
            companies[company].setCurrentPrice(price);
        }
        persister.close();
        System.out.println("done.");
    }

    private static double nextStartingPrice(double[] startingPrices) {
        double range = startingPrices[1] - startingPrices[0];
        return prices.nextDouble() * range + startingPrices[0];
    }

    private static long nextStep(long[] interval) {
        long range = interval[1] - interval[0];
        return (long)(steps.nextFloat() * (float)range + (float)interval[0]);
    }

    private static double nextPriceChange(double[] interval) {
        double range = interval[1] - interval[0];
        return prices.nextDouble() * range + interval[0];
    }
}

