/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.broker.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.drools.examples.broker.model.Company;

public class CompanyPanel {
    private final Company model;
    private final JLabel current;
    private final JLabel previous;
    private final JPanel panel;
    private NumberFormat format = NumberFormat.getCurrencyInstance();

    public CompanyPanel(Company model) {
        this.model = model;
        FormLayout layout = new FormLayout("right:pref:grow, 6dlu, right:pref:grow", "pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.addSeparator(model.getName(), cc.xyw(1, 1, 3));
        builder.addLabel("Current :", cc.xy(1, 3));
        this.current = builder.addLabel(this.format.format(model.getCurrentPrice()), cc.xy(3, 3));
        builder.addLabel("Previous :", cc.xy(1, 5));
        this.previous = builder.addLabel(this.format.format(model.getPreviousPrice()), cc.xy(3, 5));
        this.panel = builder.getPanel();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void updatePanel() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CompanyPanel.this.current.setText(CompanyPanel.this.format.format(CompanyPanel.this.model.getCurrentPrice()));
                CompanyPanel.this.previous.setText(CompanyPanel.this.format.format(CompanyPanel.this.model.getPreviousPrice()));
                if (CompanyPanel.this.model.getCurrentPrice() > CompanyPanel.this.model.getPreviousPrice()) {
                    CompanyPanel.this.current.setForeground(Color.BLUE);
                } else {
                    CompanyPanel.this.current.setForeground(Color.RED);
                }
            }
        });
    }
}

