/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.WorkingMemory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.spi.EvalExpression;
import org.drools.spi.Tuple;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELEvalExpression
implements EvalExpression,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;

    public MVELEvalExpression() {
    }

    public MVELEvalExpression(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    public void compile(MVELDialectRuntimeData runtimeData) {
        this.expr = this.unit.getCompiledExpression(runtimeData);
    }

    public Object createContext() {
        return this.unit.createFactory();
    }

    public boolean evaluate(Tuple tuple, Declaration[] requiredDeclarations, WorkingMemory workingMemory, Object context) throws Exception {
        VariableResolverFactory factory = (VariableResolverFactory)context;
        this.unit.updateFactory(null, null, null, (LeftTuple)tuple, null, (InternalWorkingMemory)workingMemory, workingMemory.getGlobalResolver(), factory);
        Package pkg = workingMemory.getRuleBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory((VariableResolverFactory)data.getFunctionFactory());
        }
        Boolean result = (Boolean)MVEL.executeExpression((Object)this.expr, null, (VariableResolverFactory)factory);
        return result;
    }

    public String toString() {
        return this.unit.getExpression();
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        this.unit.replaceDeclaration(declaration, resolved);
    }

    public MVELEvalExpression clone() {
        MVELEvalExpression clone = new MVELEvalExpression(this.unit.clone(), this.id);
        clone.expr = this.expr;
        return clone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.expr == null) {
            throw new RuntimeException("this MVELPredicateExpression must be compiled for hashCode");
        }
        result = 31 * result + this.unit.getExpression().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.expr == null) {
            throw new RuntimeException("this MVELReturnValueExpression must be compiled for equality");
        }
        MVELEvalExpression other = (MVELEvalExpression)obj;
        if (other.expr == null) {
            throw new RuntimeException("other MVELReturnValueExpression must be compiled for equality");
        }
        return this.unit.getExpression().equals(other.unit.getExpression());
    }
}

