/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.LeftTupleList;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.constraint.MvelConstraint;
import org.drools.spi.BetaNodeFieldConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 510L;
    protected BetaNodeFieldConstraint constraint;
    private boolean indexed;
    private RuleBaseConfiguration conf;

    public SingleBetaConstraints() {
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint[] constraint, RuleBaseConfiguration conf) {
        this(constraint[0], conf, false);
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf) {
        this(constraint, conf, false);
    }

    public SingleBetaConstraints(BetaNodeFieldConstraint constraint, RuleBaseConfiguration conf, boolean disableIndex) {
        int depth;
        this.conf = conf;
        this.indexed = disableIndex || !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory() ? false : (depth = conf.getCompositeKeyDepth()) >= 1 && DefaultBetaConstraints.isIndexable(constraint);
        this.constraint = constraint;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraint = (BetaNodeFieldConstraint)in.readObject();
        this.indexed = in.readBoolean();
        this.conf = (RuleBaseConfiguration)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraint);
        out.writeBoolean(this.indexed);
        out.writeObject(this.conf);
    }

    @Override
    public ContextEntry[] createContext() {
        return new ContextEntry[]{this.constraint.createContextEntry()};
    }

    @Override
    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, LeftTuple tuple) {
        context[0].updateFromTuple(workingMemory, tuple);
    }

    @Override
    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        context[0].updateFromFactHandle(workingMemory, handle);
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        return this.indexed || this.constraint.isAllowedCachedLeft(context[0], handle);
    }

    @Override
    public boolean isAllowedCachedRight(ContextEntry[] context, LeftTuple tuple) {
        return this.constraint.isAllowedCachedRight(tuple, context[0]);
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public int getIndexCount() {
        return this.indexed ? 1 : 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public BetaMemory createBetaMemory(RuleBaseConfiguration config, short nodeType) {
        BetaMemory memory;
        if (this.indexed) {
            IndexableConstraint indexableConstraint = (IndexableConstraint)((Object)this.constraint);
            AbstractHashTable.FieldIndex index = indexableConstraint.getFieldIndex();
            LeftTupleMemory tupleMemory = this.conf.isIndexLeftBetaMemory() ? new LeftTupleIndexHashTable(new AbstractHashTable.FieldIndex[]{index}) : new LeftTupleList();
            RightTupleMemory factHandleMemory = this.conf.isIndexRightBetaMemory() ? new RightTupleIndexHashTable(new AbstractHashTable.FieldIndex[]{index}) : new RightTupleList();
            memory = new BetaMemory(config.isSequential() ? null : tupleMemory, factHandleMemory, this.createContext(), nodeType);
        } else {
            memory = new BetaMemory(config.isSequential() ? null : new LeftTupleList(), new RightTupleList(), this.createContext(), nodeType);
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint.hashCode();
    }

    public BetaNodeFieldConstraint getConstraint() {
        return this.constraint;
    }

    @Override
    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SingleBetaConstraints other = (SingleBetaConstraints)object;
        return this.constraint == other.constraint || this.constraint.equals(other.constraint);
    }

    @Override
    public void resetFactHandle(ContextEntry[] context) {
        context[0].resetFactHandle();
    }

    @Override
    public void resetTuple(ContextEntry[] context) {
        context[0].resetTuple();
    }

    @Override
    public BetaConstraints getOriginalConstraint() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getListenedPropertyMask(List<String> settableProperties) {
        return this.constraint instanceof MvelConstraint ? ((MvelConstraint)this.constraint).getListenedPropertyMask(settableProperties) : Long.MAX_VALUE;
    }
}

