/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import org.drools.common.InternalFactHandle;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;

public class RightTupleList
implements RightTupleMemory,
Entry {
    private static final long serialVersionUID = 510L;
    public Entry previous;
    public Entry next;
    public RightTuple first;
    public RightTuple last;
    private final int hashCode;
    private final AbstractHashTable.Index index;
    private TupleHashTableIterator iterator;

    public RightTupleList() {
        this.hashCode = 0;
        this.index = null;
    }

    public RightTupleList(AbstractHashTable.Index index, int hashCode) {
        this.index = index;
        this.hashCode = hashCode;
    }

    public RightTupleList(AbstractHashTable.Index index, int hashCode, Entry next) {
        this.index = index;
        this.hashCode = hashCode;
        this.next = next;
    }

    public RightTupleList(RightTupleList p, Entry next) {
        this.index = p.index;
        this.hashCode = p.hashCode;
        this.next = next;
        this.first = p.first;
        this.last = p.last;
    }

    public RightTuple getFirst(LeftTuple leftTuple, InternalFactHandle factHandle) {
        return this.first;
    }

    public RightTuple getFirst() {
        return this.first;
    }

    public RightTuple getLast() {
        return this.last;
    }

    public void removeAdd(RightTuple rightTuple) {
        this.remove(rightTuple);
        this.add(rightTuple);
    }

    public void add(RightTuple rightTuple) {
        if (this.last != null) {
            this.last.setNext(rightTuple);
            rightTuple.setPrevious(this.last);
            this.last = rightTuple;
        } else {
            this.first = rightTuple;
            this.last = rightTuple;
        }
        rightTuple.setMemory(this);
    }

    public void remove(RightTuple rightTuple) {
        RightTuple previous = (RightTuple)rightTuple.getPrevious();
        RightTuple next = (RightTuple)rightTuple.getNext();
        if (previous != null && next != null) {
            previous.setNext(next);
            next.setPrevious(previous);
        } else if (next != null) {
            this.first = next;
            next.setPrevious(null);
        } else if (previous != null) {
            this.last = previous;
            previous.setNext(null);
        } else {
            this.last = null;
            this.first = null;
        }
        rightTuple.setPrevious(null);
        rightTuple.setNext(null);
        rightTuple.setMemory(null);
    }

    public RightTuple get(InternalFactHandle handle) {
        for (RightTuple current = this.first; current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(InternalFactHandle handle) {
        return this.get(handle) != null;
    }

    public RightTuple get(RightTuple rightTuple) {
        InternalFactHandle handle = rightTuple.getFactHandle();
        for (RightTuple current = this.first; current != null; current = (RightTuple)current.getNext()) {
            if (handle != current.getFactHandle()) continue;
            return current;
        }
        return null;
    }

    public boolean contains(RightTuple rightTuple) {
        return this.get(rightTuple) != null;
    }

    public int size() {
        int i = 0;
        RightTuple current = this.first;
        while (current != null) {
            current = (RightTuple)current.getNext();
            ++i;
        }
        return i;
    }

    public FastIterator fastIterator() {
        return LinkedList.fastIterator;
    }

    public FastIterator fullFastIterator() {
        return LinkedList.fastIterator;
    }

    public FastIterator fullFastIterator(RightTuple rightTuple) {
        return LinkedList.fastIterator;
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new TupleHashTableIterator();
        }
        this.iterator.reset(this.first);
        return this.iterator;
    }

    public boolean matches(Object object, int objectHashCode) {
        return this.hashCode == objectHashCode && this.index.equal(this.first.getFactHandle().getObject(), object);
    }

    public boolean matches(LeftTuple tuple, int tupleHashCode, InternalFactHandle factHandle) {
        RightTuple rightTuple;
        if (this.hashCode != tupleHashCode) {
            return false;
        }
        if (this.first.getFactHandle() == factHandle && (rightTuple = (RightTuple)this.first.getNext()) != null) {
            return this.index.equal(rightTuple.getFactHandle().getObject(), tuple);
        }
        return this.index.equal(this.first.getFactHandle().getObject(), tuple);
    }

    public RightTuple[] toArray() {
        int size = this.size();
        RightTuple[] tuples = new RightTuple[size];
        RightTuple current = this.first;
        for (int i = 0; i < size; ++i) {
            tuples[i] = current;
            current = (RightTuple)current.getNext();
        }
        return tuples;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        RightTupleList other = (RightTupleList)object;
        return this.hashCode == other.hashCode && this.index == other.index;
    }

    public Entry getNext() {
        return this.next;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public boolean isIndexed() {
        return this.index != null;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (RightTuple rightTuple = this.first; rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            builder.append(rightTuple);
        }
        return builder.toString();
    }

    public static class TupleHashTableIterator
    implements Iterator {
        private RightTuple current;

        public void reset(RightTuple first) {
            this.current = first;
        }

        public Object next() {
            if (this.current != null) {
                RightTuple returnValue = this.current;
                this.current = (RightTuple)this.current.getNext();
                return returnValue;
            }
            return null;
        }

        public void remove() {
        }
    }
}

