/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.drools.base.SalienceInteger;
import org.drools.common.BaseNode;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.EvalConditionNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNode;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.WindowNode;
import org.drools.reteoo.builder.ReteooRuleBuilder;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Rule;
import org.drools.rule.WindowDeclaration;
import org.drools.spi.Salience;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReteooBuilder
implements Externalizable {
    private static final long serialVersionUID = 510L;
    private transient InternalRuleBase ruleBase;
    private Map<Rule, BaseNode[]> rules;
    private Map<String, WindowNode> namedWindows;
    private transient ReteooRuleBuilder ruleBuilder;
    private IdGenerator idGenerator;
    private boolean ordered;

    public ReteooBuilder() {
    }

    ReteooBuilder(InternalRuleBase ruleBase) {
        this.ruleBase = ruleBase;
        this.rules = new HashMap<Rule, BaseNode[]>();
        this.namedWindows = new HashMap<String, WindowNode>();
        this.idGenerator = new IdGenerator(1);
        this.ruleBuilder = new ReteooRuleBuilder();
    }

    synchronized void addRule(Rule rule) throws InvalidPatternException {
        List<TerminalNode> terminals = this.ruleBuilder.addRule(rule, this.ruleBase, this.idGenerator);
        this.rules.put(rule, terminals.toArray(new BaseNode[terminals.size()]));
    }

    public void addEntryPoint(String id) {
        this.ruleBuilder.addEntryPoint(id, this.ruleBase, this.idGenerator);
    }

    public synchronized void addNamedWindow(WindowDeclaration window) {
        WindowNode wnode = this.ruleBuilder.addWindowNode(window, this.ruleBase, this.idGenerator);
        this.namedWindows.put(window.getName(), wnode);
    }

    public WindowNode getWindowNode(String name) {
        return this.namedWindows.get(name);
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    protected void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    public synchronized void order() {
        if (this.ordered) {
            return;
        }
        HashMap<String, ArrayList<RuleTerminalNode>> map = new HashMap<String, ArrayList<RuleTerminalNode>>();
        for (BaseNode[] baseNodeArray : this.rules.values()) {
            for (int i = 0; i < baseNodeArray.length; ++i) {
                ArrayList<RuleTerminalNode> rules;
                if (!(baseNodeArray[i] instanceof RuleTerminalNode)) continue;
                RuleTerminalNode node = (RuleTerminalNode)baseNodeArray[i];
                String agendaGroup = node.getRule().getAgendaGroup();
                if (agendaGroup == null || agendaGroup.equals("")) {
                    agendaGroup = "MAIN";
                }
                if ((rules = (ArrayList<RuleTerminalNode>)map.get(agendaGroup)) == null) {
                    rules = new ArrayList<RuleTerminalNode>();
                    map.put(agendaGroup, rules);
                }
                rules.add(node);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String agendaGroup = (String)entry.getKey();
            List rules = (List)entry.getValue();
            Collections.sort(rules, RuleSequenceComparator.INSTANCE);
            int i = 0;
            for (RuleTerminalNode node : rules) {
                node.setSequence(i++);
            }
            this.ruleBase.getAgendaGroupRuleTotals().put(agendaGroup, i);
        }
        this.ordered = true;
    }

    public synchronized BaseNode[] getTerminalNodes(Rule rule) {
        return this.rules.get(rule);
    }

    public synchronized Map<Rule, BaseNode[]> getTerminalNodes() {
        return this.rules;
    }

    public synchronized void removeRule(Rule rule) {
        BaseNode[] object;
        InternalWorkingMemory[] workingMemories = this.ruleBase.getWorkingMemories();
        BaseNode[] nodes = object = this.rules.remove(rule);
        RuleRemovalContext context = new RuleRemovalContext(rule);
        for (BaseNode node : nodes) {
            node.remove(context, this, null, workingMemories);
        }
        this.resetMasks(context);
    }

    public void resetMasks(RuleRemovalContext context) {
        List<BaseNode> nodes = context.getRemovedNodes();
        HashSet<BaseNode> leafSet = new HashSet<BaseNode>();
        for (BaseNode node : nodes) {
            RuleTerminalNode rtNode;
            if (!node.isInUse()) continue;
            if (node instanceof AlphaNode) {
                this.updateLeafSet(node, leafSet);
                continue;
            }
            if (node instanceof BetaNode) {
                BetaNode betaNode = (BetaNode)node;
                if (!betaNode.isInUse()) continue;
                leafSet.add(betaNode);
                continue;
            }
            if (!(node instanceof RuleTerminalNode) || !(rtNode = (RuleTerminalNode)node).isInUse()) continue;
            leafSet.add(rtNode);
        }
        for (BaseNode node : leafSet) {
            if (node instanceof RuleTerminalNode) {
                ((TerminalNode)((Object)node)).initInferredMask();
                continue;
            }
            ((BetaNode)node).initInferredMask();
        }
    }

    private void updateLeafSet(BaseNode baseNode, Set<BaseNode> leafSet) {
        if (baseNode instanceof AlphaNode) {
            ((AlphaNode)baseNode).resetInferredMask();
            for (ObjectSink sink : ((AlphaNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode instanceof LeftInputAdapterNode) {
            for (LeftTupleSink sink : ((LeftInputAdapterNode)baseNode).getSinkPropagator().getSinks()) {
                if (sink instanceof RuleTerminalNode) {
                    leafSet.add((BaseNode)((Object)sink));
                    continue;
                }
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode instanceof EvalConditionNode) {
            for (LeftTupleSink sink : ((EvalConditionNode)baseNode).getSinkPropagator().getSinks()) {
                if (!((BaseNode)((Object)sink)).isInUse()) continue;
                this.updateLeafSet((BaseNode)((Object)sink), leafSet);
            }
        } else if (baseNode instanceof LeftTupleSink && baseNode.isInUse()) {
            leafSet.add(baseNode);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        DroolsObjectOutputStream droolsStream;
        ByteArrayOutputStream bytes;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        if (isDrools) {
            bytes = null;
            droolsStream = (DroolsObjectOutputStream)out;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        droolsStream.writeObject(this.rules);
        droolsStream.writeObject(this.namedWindows);
        droolsStream.writeObject(this.idGenerator);
        droolsStream.writeBoolean(this.ordered);
        if (!isDrools) {
            droolsStream.flush();
            droolsStream.close();
            bytes.close();
            out.writeInt(bytes.size());
            out.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInputStream droolsStream;
        ByteArrayInputStream bytes;
        boolean isDrools = in instanceof DroolsObjectInputStream;
        if (isDrools) {
            bytes = null;
            droolsStream = (DroolsObjectInputStream)in;
        } else {
            bytes = new ByteArrayInputStream((byte[])in.readObject());
            droolsStream = new DroolsObjectInputStream(bytes);
        }
        this.rules = (Map)droolsStream.readObject();
        this.namedWindows = (Map)droolsStream.readObject();
        this.idGenerator = (IdGenerator)droolsStream.readObject();
        this.ordered = droolsStream.readBoolean();
        if (!isDrools) {
            droolsStream.close();
            bytes.close();
        }
        this.ruleBuilder = new ReteooRuleBuilder();
    }

    public void setRuleBase(ReteooRuleBase reteooRuleBase) {
        this.ruleBase = reteooRuleBase;
    }

    public static class IdGenerator
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private Queue<Integer> recycledIds;
        private int nextId;

        public IdGenerator() {
        }

        public IdGenerator(int firstId) {
            this.nextId = firstId;
            this.recycledIds = new LinkedList<Integer>();
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.recycledIds = (Queue)in.readObject();
            this.nextId = in.readInt();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.recycledIds);
            out.writeInt(this.nextId);
        }

        public synchronized int getNextId() {
            int n;
            Integer id = this.recycledIds.poll();
            if (id == null) {
                int n2 = this.nextId;
                n = n2;
                this.nextId = n2 + 1;
            } else {
                n = id;
            }
            return n;
        }

        public synchronized void releaseId(int id) {
            this.recycledIds.add(id);
        }

        public int getLastId() {
            return this.nextId - 1;
        }
    }

    public static class RuleSequenceComparator
    implements Comparator {
        public static final RuleSequenceComparator INSTANCE = new RuleSequenceComparator();

        public int compare(Object o1, Object o2) {
            int id2;
            int s2;
            RuleTerminalNode r1 = (RuleTerminalNode)o1;
            RuleTerminalNode r2 = (RuleTerminalNode)o2;
            Salience so1 = r1.getRule().getSalience();
            if (so1 != null && !(so1 instanceof SalienceInteger)) {
                throw new RuntimeException(r1.getRule().getName() + "must not have a dynamic salience");
            }
            Salience so2 = r2.getRule().getSalience();
            if (so2 != null && !(so2 instanceof SalienceInteger)) {
                throw new RuntimeException(r2.getRule().getName() + "must not have a dynamic salience");
            }
            int s1 = so1.getValue(null, null, null);
            if (s1 > (s2 = so2.getValue(null, null, null))) {
                return -1;
            }
            if (s1 < s2) {
                return 1;
            }
            int id1 = r1.getId();
            if (id1 < (id2 = r2.getId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }
    }
}

