/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.ObjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupElement
extends ConditionalElement
implements Externalizable {
    private static final long serialVersionUID = 510L;
    public static final Type AND = Type.AND;
    public static final Type OR = Type.OR;
    public static final Type NOT = Type.NOT;
    public static final Type EXISTS = Type.EXISTS;
    private Type type = null;
    private List<RuleConditionElement> children = new ArrayList<RuleConditionElement>();
    private ObjectType forallBaseObjectType = null;
    private boolean root;
    private Map<String, Declaration> outerDeclrarations;

    public GroupElement() {
        this(Type.AND);
    }

    public GroupElement(Type type) {
        this.type = type;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = (Type)((Object)in.readObject());
        this.children = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeObject(this.children);
    }

    public void addChild(RuleConditionElement child) {
        if ((this.isNot() || this.isExists()) && this.children.size() > 0) {
            throw new RuntimeDroolsException(this.type.toString() + " can have only a single child element. Either a single Pattern or another CE.");
        }
        this.children.add(child);
    }

    public void addChild(int index, RuleConditionElement rce) {
        this.children.add(index, rce);
    }

    public List<RuleConditionElement> getChildren() {
        return this.children;
    }

    @Override
    public Map<String, Declaration> getInnerDeclarations() {
        return this.type.getInnerDeclarations(this.children);
    }

    @Override
    public Map<String, Declaration> getOuterDeclarations() {
        if (this.outerDeclrarations != null) {
            return this.outerDeclrarations;
        }
        if (this.root) {
            this.outerDeclrarations = this.type.getOuterDeclarations(this.children);
            return this.outerDeclrarations;
        }
        return this.type.getOuterDeclarations(this.children);
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.type.getInnerDeclarations(this.children).get(identifier);
    }

    public void setForallBaseObjectType(ObjectType objectType) {
        this.forallBaseObjectType = objectType;
    }

    public ObjectType getForallBaseObjectType() {
        return this.forallBaseObjectType;
    }

    public void pack() {
        RuleConditionElement child;
        Object[] clone;
        for (Object aClone : clone = this.children.toArray()) {
            if (!(aClone instanceof GroupElement)) continue;
            GroupElement childGroup = (GroupElement)aClone;
            childGroup.pack(this);
        }
        if ((this.isAnd() || this.isOr()) && this.children.size() == 1 && (child = this.getChildren().get(0)) instanceof GroupElement) {
            GroupElement group = (GroupElement)child;
            this.type = group.getType();
            this.children.clear();
            this.children.addAll(group.getChildren());
        }
        if (this.isNot() && this.children.size() == 1 && this.getChildren().get(0) instanceof GroupElement && ((GroupElement)(child = (GroupElement)this.getChildren().get(0))).isExists()) {
            this.children.clear();
            this.children.addAll(((GroupElement)child).getChildren());
        }
        if (this.isExists() && this.children.size() == 1 && this.getChildren().get(0) instanceof GroupElement && ((GroupElement)(child = (GroupElement)this.getChildren().get(0))).isNot()) {
            this.setType(NOT);
            this.children.clear();
            this.children.addAll(((GroupElement)child).getChildren());
        }
    }

    public void pack(GroupElement parent) {
        if (this.children.size() == 0) {
            parent.children.remove(this);
            return;
        }
        if (this.isAnd() || this.isOr() || this.isExists()) {
            if (parent.getType() == this.getType()) {
                int index = parent.getChildren().indexOf(this);
                parent.getChildren().remove(this);
                for (RuleConditionElement child : this.children) {
                    parent.getChildren().add(index++, child);
                    if (!(child instanceof GroupElement)) continue;
                    int previousSize = parent.getChildren().size();
                    ((GroupElement)child).pack(parent);
                    index += parent.getChildren().size() - previousSize;
                }
            } else if (!this.isExists() && this.children.size() == 1) {
                int index = parent.getChildren().indexOf(this);
                parent.getChildren().remove(this);
                RuleConditionElement child = this.children.get(0);
                parent.getChildren().add(index, child);
                if (child instanceof GroupElement) {
                    ((GroupElement)child).pack(parent);
                }
            } else {
                this.pack();
            }
        } else {
            this.pack();
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof GroupElement)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GroupElement e2 = (GroupElement)object;
        if (!this.type.equals((Object)e2.type)) {
            return false;
        }
        List<RuleConditionElement> e1Children = this.getChildren();
        List<RuleConditionElement> e2Children = e2.getChildren();
        if (e1Children.size() != e2Children.size()) {
            return false;
        }
        for (int i = 0; i < e1Children.size(); ++i) {
            RuleConditionElement e2Object1;
            RuleConditionElement e1Object1 = e1Children.get(i);
            if (e1Object1.equals(e2Object1 = e2Children.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.type.hashCode() + ((Object)this.children).hashCode();
    }

    @Override
    public GroupElement clone() {
        return this.clone(true);
    }

    public GroupElement cloneOnlyGroup() {
        return this.clone(false);
    }

    private GroupElement clone(boolean deepClone) {
        GroupElement cloned = new GroupElement();
        cloned.setType(this.getType());
        for (RuleConditionElement re : this.children) {
            cloned.addChild(deepClone && (re instanceof GroupElement || re instanceof Pattern) ? re.clone() : re);
        }
        return cloned;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isAnd() {
        return AND.equals((Object)this.type);
    }

    public boolean isOr() {
        return OR.equals((Object)this.type);
    }

    public boolean isNot() {
        return NOT.equals((Object)this.type);
    }

    public boolean isExists() {
        return EXISTS.equals((Object)this.type);
    }

    public String toString() {
        return this.type.toString() + this.children.toString();
    }

    @Override
    public List<RuleConditionElement> getNestedElements() {
        return this.children;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return this.type.isPatternScopeDelimiter();
    }

    public boolean isRoot() {
        return this.root;
    }

    public void setRoot(boolean root) {
        this.root = root;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        AND(ScopeDelimiter.NEVER),
        OR(ScopeDelimiter.CONSENSUS),
        NOT(ScopeDelimiter.ALWAYS),
        EXISTS(ScopeDelimiter.ALWAYS);

        private final ScopeDelimiter scopeDelimiter;

        private Type(ScopeDelimiter scopeDelimiter) {
            this.scopeDelimiter = scopeDelimiter;
        }

        public Map<String, Declaration> getInnerDeclarations(List<RuleConditionElement> children) {
            return this.getDeclarations(children, ScopeDelimiter.NEVER);
        }

        public Map<String, Declaration> getOuterDeclarations(List<RuleConditionElement> children) {
            return this.getDeclarations(children, this.scopeDelimiter);
        }

        private Map<String, Declaration> getDeclarations(List<RuleConditionElement> children, ScopeDelimiter scopeDelimiter) {
            HashMap<String, Declaration> declarations;
            block5: {
                block4: {
                    if (scopeDelimiter == ScopeDelimiter.ALWAYS || children.isEmpty()) {
                        return Collections.EMPTY_MAP;
                    }
                    if (children.size() == 1) {
                        return children.get(0).getOuterDeclarations();
                    }
                    declarations = new HashMap<String, Declaration>();
                    if (scopeDelimiter != ScopeDelimiter.NEVER) break block4;
                    for (RuleConditionElement re : children) {
                        declarations.putAll(re.getOuterDeclarations());
                    }
                    break block5;
                }
                if (scopeDelimiter != ScopeDelimiter.CONSENSUS) break block5;
                Iterator<RuleConditionElement> i = children.iterator();
                declarations.putAll(i.next().getOuterDeclarations());
                while (i.hasNext()) {
                    declarations.keySet().retainAll(i.next().getOuterDeclarations().keySet());
                }
            }
            return declarations;
        }

        public boolean isPatternScopeDelimiter() {
            return this.scopeDelimiter == ScopeDelimiter.ALWAYS;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ScopeDelimiter {
            NEVER,
            CONSENSUS,
            ALWAYS;

        }
    }
}

