/*
 * Decompiled with CFR 0.152.
 */
package org.drools.benchmark.manners;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.benchmark.manners.Context;
import org.drools.benchmark.manners.Count;
import org.drools.benchmark.manners.Guest;
import org.drools.benchmark.manners.Hobby;
import org.drools.benchmark.manners.LastSeat;
import org.drools.benchmark.manners.Sex;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MannersBenchmark {
    private static int numGuests = 16;
    private static int numSeats = 16;
    private static int minHobbies = 2;
    private static int maxHobbies = 3;

    public static void main(String[] args) throws Exception {
        KnowledgeBuilderConfiguration kbuilderConfig = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration();
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)kbuilderConfig);
        kbuilder.add(ResourceFactory.newClassPathResource((String)"manners.drl", MannersBenchmark.class), ResourceType.DRL);
        Collection pkgs = kbuilder.getKnowledgePackages();
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(pkgs);
        long totalTime = 0L;
        for (int i = 0; i < 5; ++i) {
            String arg;
            StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
            String filename = args.length != 0 ? (arg = args[0]) : "manners128.dat";
            InputStream is = MannersBenchmark.class.getResourceAsStream(filename);
            List<Object> list = MannersBenchmark.getInputObjects(is);
            for (Object object : list) {
                ksession.insert(object);
            }
            ksession.insert((Object)new Count(1));
            long start = System.currentTimeMillis();
            ksession.fireAllRules();
            long time = System.currentTimeMillis() - start;
            System.err.println(time);
            totalTime += time;
            ksession.dispose();
        }
        System.out.println("average : " + totalTime / 5L);
    }

    protected static List<Object> getInputObjects(InputStream inputStream) throws IOException {
        String line;
        ArrayList<Object> list = new ArrayList<Object>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
            StringTokenizer st = new StringTokenizer(line, "() ");
            String type = st.nextToken();
            if ("guest".equals(type)) {
                if (!"name".equals(st.nextToken())) {
                    throw new IOException("expected 'name' in: " + line);
                }
                String name = st.nextToken();
                if (!"sex".equals(st.nextToken())) {
                    throw new IOException("expected 'sex' in: " + line);
                }
                String sex = st.nextToken();
                if (!"hobby".equals(st.nextToken())) {
                    throw new IOException("expected 'hobby' in: " + line);
                }
                String hobby = st.nextToken();
                Guest guest = new Guest(name, Sex.resolve(sex), Hobby.resolve(hobby));
                list.add(guest);
            }
            if ("last_seat".equals(type)) {
                if (!"seat".equals(st.nextToken())) {
                    throw new IOException("expected 'seat' in: " + line);
                }
                list.add(new LastSeat(new Integer(st.nextToken())));
            }
            if (!"context".equals(type)) continue;
            if (!"state".equals(st.nextToken())) {
                throw new IOException("expected 'state' in: " + line);
            }
            list.add(new Context(st.nextToken()));
        }
        inputStream.close();
        return list;
    }

    public static InputStream generateData() {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringWriter writer = new StringWriter();
        int maxMale = numGuests / 2;
        int maxFemale = numGuests / 2;
        int maleCount = 0;
        int femaleCount = 0;
        ArrayList<String> hobbyList = new ArrayList<String>();
        for (int i = 1; i <= maxHobbies; ++i) {
            hobbyList.add("h" + i);
        }
        Random rnd = new Random();
        for (int i = 1; i <= numGuests; ++i) {
            char sex;
            char c = sex = rnd.nextBoolean() ? (char)'m' : 'f';
            if (sex == 'm' && maleCount == maxMale) {
                sex = 'f';
            }
            if (sex == 'f' && femaleCount == maxFemale) {
                sex = 'm';
            }
            if (sex == 'm') {
                ++maleCount;
            }
            if (sex == 'f') {
                ++femaleCount;
            }
            ArrayList guestHobbies = new ArrayList(hobbyList);
            int numHobbies = minHobbies + rnd.nextInt(maxHobbies - minHobbies + 1);
            for (int j = 0; j < numHobbies; ++j) {
                int hobbyIndex = rnd.nextInt(guestHobbies.size());
                String hobby = (String)guestHobbies.get(hobbyIndex);
                writer.write("(guest (name n" + i + ") (sex " + sex + ") (hobby " + hobby + "))" + LINE_SEPARATOR);
                guestHobbies.remove(hobbyIndex);
            }
        }
        writer.write("(last_seat (seat " + numSeats + "))" + LINE_SEPARATOR);
        writer.write(LINE_SEPARATOR);
        writer.write("(context (state start))" + LINE_SEPARATOR);
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
    }
}

