/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.impl.BinaryResourceDiffProducerImpl;
import org.drools.agent.impl.KnowledgeAgentConfigurationImpl;
import org.drools.agent.impl.ResourceDiffResult;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalRuleBase;
import org.drools.concurrent.ExecutorProviderFactory;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgeDefinition;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.event.KnowledgeAgentEventSupport;
import org.drools.event.io.ResourceChangeListener;
import org.drools.event.knowledgeagent.KnowledgeAgentEventListener;
import org.drools.impl.InternalKnowledgeBase;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeMonitor;
import org.drools.io.ResourceFactory;
import org.drools.io.ResourcedObject;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.ReaderResource;
import org.drools.io.impl.ResourceChangeNotifierImpl;
import org.drools.io.internal.InternalResource;
import org.drools.rule.Function;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.util.CompositeClassLoader;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.SemanticModules;
import org.drools.xml.XmlChangeSetReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeAgentImpl
implements KnowledgeAgent,
ResourceChangeListener {
    private final String name;
    private final Set<Resource> resourceDirectories;
    private KnowledgeBase kbase;
    private ResourceChangeNotifierImpl notifier;
    private boolean newInstance;
    private SystemEventListener listener;
    private boolean scanDirectories;
    private boolean useKBaseClassLoaderForCompiling;
    private final LinkedBlockingQueue<ChangeSet> queue;
    private Future<Boolean> notificationDetectorExecutor;
    private ChangeSetNotificationDetector changeSetNotificationDetector;
    private SemanticModules semanticModules;
    private final RegisteredResourceMap registeredResources = new RegisteredResourceMap();
    private final Map<Resource, String> dslResources = new HashMap<Resource, String>();
    private final KnowledgeAgentEventSupport eventSupport = new KnowledgeAgentEventSupport();
    private final KnowledgeBuilderConfiguration builderConfiguration;
    private int validationTimeout = 0;

    public KnowledgeAgentImpl(String name, KnowledgeBase kbase, KnowledgeAgentConfiguration configuration, KnowledgeBuilderConfiguration builderConfiguration) {
        this.name = name;
        this.kbase = kbase;
        this.builderConfiguration = builderConfiguration;
        this.resourceDirectories = new HashSet<Resource>();
        this.listener = SystemEventListenerFactory.getSystemEventListener();
        this.queue = new LinkedBlockingQueue();
        boolean scanResources = false;
        boolean monitor = false;
        if (configuration != null) {
            this.newInstance = ((KnowledgeAgentConfigurationImpl)configuration).isNewInstance();
            this.useKBaseClassLoaderForCompiling = configuration.isUseKBaseClassLoaderForCompiling();
            this.notifier = (ResourceChangeNotifierImpl)ResourceFactory.getResourceChangeNotifierService();
            if (configuration.isMonitorChangeSetEvents()) {
                monitor = true;
            }
            if (configuration.isScanDirectories()) {
                this.scanDirectories = true;
            }
            if (scanResources = configuration.isScanResources()) {
                this.notifier.addResourceChangeMonitor((ResourceChangeMonitor)ResourceFactory.getResourceChangeScannerService());
                monitor = true;
            }
            this.validationTimeout = configuration.getValidationTimeout();
        }
        this.monitorResourceChangeEvents(monitor);
        this.autoBuildResourceMapping();
        this.listener.info("KnowledgeAgent created, with configuration:\nmonitorChangeSetEvents=" + monitor + " scanResources=" + scanResources + " scanDirectories=" + this.scanDirectories + " newInstance=" + this.newInstance);
    }

    public void setSystemEventListener(SystemEventListener listener) {
        this.listener = listener;
    }

    public Set<Resource> getResourceDirectories() {
        return this.resourceDirectories;
    }

    public boolean isNewInstance() {
        return this.newInstance;
    }

    public boolean isUseKBaseClassLoaderForCompiling() {
        return this.useKBaseClassLoaderForCompiling;
    }

    public void applyChangeSet(Resource resource) {
        ChangeSet cs = this.getChangeSet(resource);
        if (cs != null) {
            this.applyChangeSet(cs);
        } else {
            this.listener.warning(" Warning : KnowledgeAgent was requested to apply a Changeset, but no Changeset could be determined", (Object)resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangeSet(ChangeSet changeSet) {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            this.eventSupport.fireBeforeChangeSetApplied(changeSet);
            this.listener.info("KnowledgeAgent applying ChangeSet");
            ChangeSetState changeSetState = new ChangeSetState();
            changeSetState.scanDirectories = this.scanDirectories;
            changeSetState.incrementalBuild = !this.newInstance;
            this.processChangeSet(changeSet, changeSetState);
            this.buildKnowledgeBase(changeSetState);
            this.eventSupport.fireAfterChangeSetApplied(changeSet);
        }
    }

    public void processChangeSet(Resource resource, ChangeSetState changeSetState) {
        this.processChangeSet(this.getChangeSet(resource), changeSetState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeSet(ChangeSet changeSet, ChangeSetState changeSetState) {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            this.eventSupport.fireBeforeChangeSetProcessed(changeSet);
            for (Resource resource : changeSet.getResourcesAdded()) {
                this.eventSupport.fireBeforeResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_ADDED);
                if (((InternalResource)resource).getResourceType() == ResourceType.DSL) {
                    this.notifier.subscribeResourceChangeListener(this, resource);
                    try {
                        this.retrieveDSLResource(resource);
                    }
                    catch (IOException ex) {
                        this.listener.exception("KnowledgeAgent Fails trying to read DSL Resource: " + resource, (Throwable)ex);
                    }
                } else if (((InternalResource)resource).getResourceType() == ResourceType.CHANGE_SET) {
                    this.listener.debug("KnowledgeAgent processing sub ChangeSet=" + resource);
                    this.processChangeSet(resource, changeSetState);
                } else if (changeSetState.scanDirectories && ((InternalResource)resource).isDirectory()) {
                    this.resourceDirectories.add(resource);
                    this.listener.debug("KnowledgeAgent subscribing to directory=" + resource);
                    this.notifier.subscribeResourceChangeListener(this, resource);
                    for (Resource child : ((InternalResource)resource).listResources()) {
                        if (((InternalResource)child).isDirectory()) continue;
                        ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                        this.addDefinitionMapping(child, null, true);
                        if (!this.addResourceMapping(child, true) || !changeSetState.incrementalBuild) continue;
                        changeSetState.addedResources.add(child);
                    }
                } else if (this.addResourceMapping(resource, true) && changeSetState.incrementalBuild) {
                    changeSetState.addedResources.add(resource);
                }
                this.eventSupport.fireAfterResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_ADDED);
            }
            for (Resource resource : changeSet.getResourcesRemoved()) {
                this.eventSupport.fireBeforeResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_MODIFIED);
                if (((InternalResource)resource).getResourceType() == ResourceType.DSL) {
                    this.notifier.unsubscribeResourceChangeListener(this, resource);
                    this.dslResources.remove(resource);
                } else if (((InternalResource)resource).getResourceType() == ResourceType.CHANGE_SET) {
                    this.processChangeSet(resource, changeSetState);
                } else if (changeSetState.scanDirectories && ((InternalResource)resource).isDirectory()) {
                    this.listener.debug("KnowledgeAgent unsubscribing from directory resource=" + resource);
                    this.resourceDirectories.remove(resource);
                    this.notifier.unsubscribeResourceChangeListener(this, resource);
                } else {
                    Set<KnowledgeDefinition> definitions = this.removeResourceMapping(resource, true);
                    if (definitions != null && changeSetState.incrementalBuild) {
                        changeSetState.removedResourceMappings.put(resource, definitions);
                    }
                }
                this.eventSupport.fireAfterResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_MODIFIED);
            }
            for (Resource resource : changeSet.getResourcesModified()) {
                this.eventSupport.fireBeforeResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_REMOVED);
                if (((InternalResource)resource).getResourceType() == ResourceType.DSL) {
                    try {
                        this.retrieveDSLResource(resource);
                    }
                    catch (IOException ex) {
                        this.listener.exception("KnowledgeAgent Fails trying to read DSL Resource: " + resource, (Throwable)ex);
                    }
                } else {
                    if (((InternalResource)resource).getResourceType() == ResourceType.CHANGE_SET) continue;
                    if (((InternalResource)resource).isDirectory()) {
                        if (this.resourceDirectories.add(resource)) {
                            this.listener.warning("KnowledgeAgent is subscribing to a modified directory=" + resource + " when it should have already been subscribed");
                            this.notifier.subscribeResourceChangeListener(this, resource);
                        }
                        for (Resource child : ((InternalResource)resource).listResources()) {
                            if (((InternalResource)child).isDirectory() || !this.addResourceMapping(child, true)) continue;
                            ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                            if (!changeSetState.incrementalBuild) continue;
                            changeSetState.addedResources.add(child);
                        }
                    } else {
                        boolean isResourceMapped = this.registeredResources.isResourceMapped(resource);
                        if (!isResourceMapped) {
                            this.listener.warning("KnowledgeAgent subscribing to new resource=" + resource + ", though it was marked as modified.");
                            this.addResourceMapping(resource, true);
                            if (changeSetState.incrementalBuild) {
                                changeSetState.addedResources.add(resource);
                            }
                        } else {
                            Set<KnowledgeDefinition> definitions = this.removeResourceMapping(resource, false);
                            changeSetState.modifiedResourceMappings.put(resource, definitions);
                            this.addResourceMapping(resource, false);
                        }
                    }
                }
                this.eventSupport.fireAfterResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_REMOVED);
            }
            this.eventSupport.fireAfterChangeSetProcessed(changeSet, changeSetState.addedResources, changeSetState.modifiedResourceMappings, changeSetState.removedResourceMappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ChangeSet getChangeSet(Resource resource) {
        block15: {
            if (this.semanticModules == null) {
                this.semanticModules = new SemanticModules();
                this.semanticModules.addSemanticModule(new ChangeSetSemanticModule());
            }
            reader = new XmlChangeSetReader(this.semanticModules, null, this.validationTimeout);
            if (resource instanceof ClassPathResource) {
                reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), null);
            } else {
                reader.setClassLoader((ClassLoader)((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration().getClassLoader(), null);
            }
            changeSet = null;
            resourceReader = null;
            try {
                resourceReader = resource.getReader();
                changeSet = reader.read(resourceReader);
                var7_5 = null;
                ** if (resourceReader == null) goto lbl-1000
            }
            catch (Throwable var6_12) {
                var7_7 = null;
                if (resourceReader != null) {
                    try {
                        resourceReader.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var6_12;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    resourceReader.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block15;
                catch (Exception e) {
                    this.listener.exception((Throwable)new RuntimeException("Unable to parse ChangeSet", e));
                    var7_6 = null;
                    if (resourceReader != null) {
                        try {
                            resourceReader.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        if (changeSet == null) {
            this.listener.exception((Throwable)new RuntimeException("Unable to parse ChangeSet"));
        }
        return changeSet;
    }

    private void buildResourceMapping(Package pkg, Resource resource) {
        if (resource == null) {
            this.listener.warning("KnowledgeAgent: trying to build a resource map for a null resource!");
            return;
        }
        this.buildResourceMapping(pkg, resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResourceMapping(Package pkg, Resource resource, boolean autoDiscoverResource) {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            if (!autoDiscoverResource && resource == null) {
                this.listener.warning("KnowledgeAgent: Impossible to map to a null resource! Use autoDiscoverResource = true ");
                return;
            }
            if (autoDiscoverResource && resource != null) {
                this.listener.warning("KnowledgeAgent: building resource map with resource set and autoDiscoverResource=true. Resource value wil be overwritten!");
            }
            for (Rule rule : pkg.getRules()) {
                if (autoDiscoverResource) {
                    resource = rule.getResource();
                }
                if (resource == null) {
                    this.listener.debug("KnowledgeAgent no resource mapped for rule=" + rule);
                }
                if (!this.isNewDefinition(resource, (KnowledgeDefinition)rule)) continue;
                this.addDefinitionMapping(resource, (KnowledgeDefinition)rule, true);
            }
            for (Process process : pkg.getRuleFlows().values()) {
                if (resource == null) {
                    this.listener.debug("KnowledgeAgent no resource mapped for process=" + process);
                }
                if (autoDiscoverResource) {
                    resource = ((ResourcedObject)process).getResource();
                }
                if (!this.isNewDefinition(resource, (KnowledgeDefinition)process)) continue;
                this.addDefinitionMapping(resource, (KnowledgeDefinition)process, true);
            }
            for (TypeDeclaration typeDeclaration : pkg.getTypeDeclarations().values()) {
                if (resource == null) {
                    this.listener.debug("KnowledgeAgent no resource mapped for type=" + typeDeclaration);
                }
                if (autoDiscoverResource) {
                    resource = typeDeclaration.getResource();
                }
                if (!this.isNewDefinition(resource, typeDeclaration)) continue;
                this.addDefinitionMapping(resource, typeDeclaration, true);
            }
            for (Function function : pkg.getFunctions().values()) {
                if (resource != null && !((InternalResource)resource).hasURL()) {
                    this.listener.debug("KnowledgeAgent no resource mapped for function=" + function);
                }
                if (autoDiscoverResource) {
                    resource = function.getResource();
                }
                if (!this.isNewDefinition(resource, function)) continue;
                this.addDefinitionMapping(resource, function, true);
            }
        }
    }

    private boolean isNewDefinition(Resource resource, KnowledgeDefinition def) {
        return !this.registeredResources.isResourceMapped(resource) || !this.registeredResources.getDefinitions(resource).contains(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoBuildResourceMapping() {
        this.listener.debug("KnowledgeAgent building resource map");
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            RuleBase rbase = ((KnowledgeBaseImpl)this.kbase).ruleBase;
            for (Package pkg : rbase.getPackages()) {
                this.buildResourceMapping(pkg, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBase getKnowledgeBase() {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            return this.kbase;
        }
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        return new StatelessKnowledgeSessionImpl(null, this, null);
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession(KnowledgeSessionConfiguration conf) {
        return new StatelessKnowledgeSessionImpl(null, this, conf);
    }

    public void resourcesChanged(ChangeSet changeSet) {
        try {
            this.listener.debug("KnowledgeAgent received ChangeSet changed notification");
            this.queue.put(changeSet);
        }
        catch (InterruptedException e) {
            this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent error while adding ChangeSet notification to queue", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildKnowledgeBase(ChangeSetState changeSetState) {
        this.listener.debug("KnowledgeAgent rebuilding KnowledgeBase using ChangeSet");
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            if (this.newInstance) {
                this.rebuildResources(changeSetState);
            } else {
                this.incrementalBuildResources(changeSetState);
            }
            InternalRuleBase ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase;
            ruleBase.lock();
            try {
                if (ruleBase.getConfiguration().isSequential()) {
                    ruleBase.getReteooBuilder().order();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ruleBase.unlock();
                throw throwable;
            }
            ruleBase.unlock();
        }
        this.eventSupport.fireKnowledgeBaseUpdated(this.kbase);
        this.listener.debug("KnowledgeAgent finished rebuilding KnowledgeBase using ChangeSet");
    }

    private Collection<KnowledgePackage> createPackageFromResource(Resource resource) {
        return this.createPackageFromResource(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Collection<KnowledgePackage> createPackageFromResource(Resource resource, KnowledgeBuilder kbuilder) {
        List<KnowledgePackage> kpkgs;
        block31: {
            if (((InternalResource)resource).getResourceType() != ResourceType.PKG) {
                if (kbuilder == null) {
                    kbuilder = this.createKBuilder();
                }
                kbuilder.add(resource, ((InternalResource)resource).getResourceType());
                if (kbuilder.hasErrors()) {
                    this.eventSupport.fireResourceCompilationFailed(kbuilder, resource, ((InternalResource)resource).getResourceType());
                    this.listener.warning("KnowledgeAgent has KnowledgeBuilder errors ", (Object)kbuilder.getErrors());
                }
                if (kbuilder.getKnowledgePackages().iterator().hasNext()) {
                    return kbuilder.getKnowledgePackages();
                }
                return Collections.emptyList();
            }
            InputStream is = null;
            kpkgs = null;
            is = resource.getInputStream();
            CompositeClassLoader classLoader = null;
            if (this.isUseKBaseClassLoaderForCompiling()) {
                classLoader = ((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getRootClassLoader();
            } else if (this.builderConfiguration != null) {
                this.listener.warning("Even if a custom KnowledgeBuilderConfiguration was provided,  the Knowledge Agent will not use any specific classloader while deserializing packages. Expect ClassNotFoundExceptions.");
            }
            Object object = DroolsStreamUtils.streamIn(is, classLoader);
            if (object instanceof Collection) {
                kpkgs = (List<KnowledgePackage>)object;
            } else if (object instanceof KnowledgePackageImp) {
                kpkgs = Collections.singletonList((KnowledgePackage)object);
            } else if (object instanceof Package) {
                kpkgs = Collections.singletonList(new KnowledgePackageImp((Package)object));
            } else if (object instanceof Package[]) {
                kpkgs = new ArrayList<KnowledgePackage>();
                for (Package pkg : (Package[])object) {
                    kpkgs.add(new KnowledgePackageImp(pkg));
                }
            } else {
                throw new RuntimeException("Unknown binary format trying to load resource " + resource.toString());
            }
            for (KnowledgePackage kpkg : kpkgs) {
                for (Rule rule : ((KnowledgePackageImp)kpkg).pkg.getRules()) {
                    rule.setResource(resource);
                }
                for (Process process : ((KnowledgePackageImp)kpkg).pkg.getRuleFlows().values()) {
                    ((ResourcedObject)process).setResource(resource);
                }
                for (TypeDeclaration type : ((KnowledgePackageImp)kpkg).pkg.getTypeDeclarations().values()) {
                    type.setResource(resource);
                }
            }
            Object var14_19 = null;
            try {
                if (is != null) {
                    is.close();
                }
                break block31;
            }
            catch (IOException e) {
                this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to close KnowledgeDefinitionsPackage  ", e));
            }
            break block31;
            {
                catch (Exception ex) {
                    this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to deserialize KnowledgeDefinitionsPackage  ", ex));
                    Object var14_20 = null;
                    try {
                        if (is != null) {
                            is.close();
                        }
                        break block31;
                    }
                    catch (IOException e) {
                        this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to close KnowledgeDefinitionsPackage  ", e));
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to close KnowledgeDefinitionsPackage  ", e));
                }
                throw throwable;
            }
        }
        return kpkgs;
    }

    private void rebuildResources(ChangeSetState changeSetState) {
        if (!this.newInstance) {
            this.listener.warning("KnowledgeAgent rebuilding KnowledgeBase when newInstance is false");
        }
        this.kbase = this.kbase != null ? KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration()) : KnowledgeBaseFactory.newKnowledgeBase();
        changeSetState.addedResources.clear();
        for (Resource resource : this.registeredResources.getAllResources()) {
            if (resource instanceof ReaderResource && ((ReaderResource)resource).getReader() == null) continue;
            changeSetState.addedResources.add(resource);
        }
        this.addResourcesToKnowledgeBase(changeSetState);
        this.listener.info("KnowledgeAgent new KnowledgeBase now built and in use");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalBuildResources(ChangeSetState changeSetState) {
        if (this.newInstance) {
            this.listener.warning("KnowledgeAgent incremental build of KnowledgeBase when newInstance is true");
        }
        KnowledgeBuilder kBuilder = this.createKBuilder();
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            this.listener.info("KnowledgeAgent performing an incremental build of the ChangeSet");
            if (this.kbase == null) {
                this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
            }
            for (Map.Entry<Resource, Set<KnowledgeDefinition>> entry : changeSetState.removedResourceMappings.entrySet()) {
                for (KnowledgeDefinition kd : entry.getValue()) {
                    this.removeKnowledgeDefinitionFromBase(kd);
                }
            }
            for (Map.Entry<Resource, Set<KnowledgeDefinition>> entry : changeSetState.modifiedResourceMappings.entrySet()) {
                Collection<KnowledgePackage> newPackages = this.createPackageFromResource(entry.getKey());
                this.removeDeletedPackages(entry, newPackages);
                if (newPackages == null) continue;
                for (KnowledgePackage pkage : newPackages) {
                    KnowledgePackageImp newPackage = (KnowledgePackageImp)pkage;
                    Set<KnowledgeDefinition> kdefs = this.getKnowledgeDefinitions(entry, newPackage);
                    KnowledgePackageImp oldPackage = (KnowledgePackageImp)this.kbase.getKnowledgePackage(newPackage.getName());
                    AbstractRuleBase abstractRuleBase = (AbstractRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase;
                    CompositeClassLoader rootClassLoader = abstractRuleBase.getRootClassLoader();
                    JavaDialectRuntimeData.TypeDeclarationClassLoader tdClassLoader = (JavaDialectRuntimeData.TypeDeclarationClassLoader)((AbstractRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getTypeDeclarationClassLoader();
                    JavaDialectRuntimeData jdata = (JavaDialectRuntimeData)newPackage.pkg.getDialectRuntimeRegistry().getDialectData("java");
                    Map definedClasses = jdata.getClassDefinitions();
                    for (String className : definedClasses.keySet()) {
                        if (tdClassLoader.getStore().getClassDefinition(className) == null) continue;
                        jdata.removeClassDefinition(className);
                        jdata.getStore().remove(className);
                    }
                    newPackage.pkg.getDialectRuntimeRegistry().onAdd(rootClassLoader);
                    newPackage.pkg.getDialectRuntimeRegistry().onBeforeExecute();
                    newPackage.pkg.getClassFieldAccessorStore().setClassFieldAccessorCache(abstractRuleBase.getClassFieldAccessorCache());
                    newPackage.pkg.getClassFieldAccessorStore().wire();
                    this.listener.debug("KnowledgeAgent: Diffing: " + entry.getKey());
                    BinaryResourceDiffProducerImpl rdp = new BinaryResourceDiffProducerImpl();
                    ResourceDiffResult diff = rdp.diff(kdefs, newPackage, oldPackage);
                    for (KnowledgeDefinition kd : diff.getRemovedDefinitions()) {
                        this.listener.debug("KnowledgeAgent: Removing: " + kd);
                        this.removeKnowledgeDefinitionFromBase(kd);
                    }
                    for (KnowledgeDefinition knowledgeDefinition : diff.getUnmodifiedDefinitions()) {
                        this.addDefinitionMapping(entry.getKey(), knowledgeDefinition, false);
                    }
                    Set<KnowledgePackage> set = changeSetState.createdPackages.get(entry.getKey());
                    if (set == null) {
                        set = new HashSet<KnowledgePackage>();
                        changeSetState.createdPackages.put(entry.getKey(), set);
                    }
                    set.add(diff.getPkg());
                }
            }
            for (Resource resource : changeSetState.addedResources) {
                Collection<KnowledgePackage> kpkgs = this.createPackageFromResource(resource, kBuilder);
                if (kpkgs == null || kpkgs.isEmpty()) {
                    this.listener.warning("KnowledgeAgent: The resource didn't create any package: " + resource);
                    continue;
                }
                changeSetState.createdPackages.put(resource, new HashSet<KnowledgePackage>(kpkgs));
            }
            changeSetState.addedResources.clear();
            changeSetState.modifiedResourceMappings.clear();
            this.addResourcesToKnowledgeBase(changeSetState);
        }
        this.listener.info("KnowledgeAgent incremental build of KnowledgeBase finished and in use");
    }

    private void removeDeletedPackages(Map.Entry<Resource, Set<KnowledgeDefinition>> entry, Collection<KnowledgePackage> newPackages) {
        HashSet<String> newPkgNames = new HashSet<String>();
        if (newPackages == null || newPackages.isEmpty()) {
            this.listener.warning("KnowledgeAgent: The resource didn't create any package: " + entry.getKey() + ". Removing any existing knowledge definition of " + entry.getKey());
        } else {
            for (KnowledgePackage kp : newPackages) {
                newPkgNames.add(kp.getName());
            }
        }
        for (KnowledgeDefinition kd : entry.getValue()) {
            if (newPkgNames.contains(kd.getNamespace())) continue;
            this.listener.debug("KnowledgeAgent: Removing: " + kd);
            this.removeKnowledgeDefinitionFromBase(kd);
        }
    }

    private Set<KnowledgeDefinition> getKnowledgeDefinitions(Map.Entry<Resource, Set<KnowledgeDefinition>> entry, KnowledgePackageImp newPackage) {
        HashSet<KnowledgeDefinition> kdefs = new HashSet<KnowledgeDefinition>();
        for (KnowledgeDefinition kdef : entry.getValue()) {
            if (!kdef.getNamespace().equals(newPackage.getName())) continue;
            kdefs.add(kdef);
        }
        return kdefs;
    }

    private void removeKnowledgeDefinitionFromBase(KnowledgeDefinition kd) {
        try {
            if (kd instanceof Query) {
                Query query = (Query)kd;
                this.listener.debug("KnowledgeAgent removing Query=" + query + " from package=" + query.getPackageName());
                this.kbase.removeQuery(query.getPackageName(), query.getName());
            } else if (kd instanceof Rule) {
                Rule rule = (Rule)kd;
                this.listener.debug("KnowledgeAgent removing Rule=" + rule + " from package=" + rule.getPackageName());
                this.kbase.removeRule(rule.getPackageName(), rule.getName());
            } else if (kd instanceof Process) {
                Process process = (Process)kd;
                this.listener.debug("KnowledgeAgent removing Process=" + process);
                this.kbase.removeProcess(process.getId());
            } else if (!(kd instanceof TypeDeclaration) && kd instanceof Function) {
                Function function = (Function)kd;
                this.kbase.removeFunction(function.getNamespace(), function.getName());
            }
        }
        catch (IllegalArgumentException e) {
            this.listener.warning(e.getMessage());
        }
    }

    private void addResourcesToKnowledgeBase(ChangeSetState changeSetState) {
        if (!changeSetState.addedResources.isEmpty()) {
            KnowledgeBuilder builder = this.createKBuilder();
            for (Resource resource : changeSetState.addedResources) {
                Collection<KnowledgePackage> createdPackages = this.createPackageFromResource(resource, builder);
                Set<KnowledgePackage> packs = changeSetState.createdPackages.get(resource);
                if (packs == null) {
                    packs = new HashSet<KnowledgePackage>();
                    changeSetState.createdPackages.put(resource, packs);
                }
                packs.addAll(createdPackages);
            }
        }
        LinkedHashSet createdDistinctPackages = new LinkedHashSet();
        for (Resource resource : changeSetState.createdPackages.keySet()) {
            createdDistinctPackages.addAll(changeSetState.createdPackages.get(resource));
        }
        this.kbase.addKnowledgePackages(createdDistinctPackages);
        this.autoBuildResourceMapping();
    }

    public String getName() {
        return this.name;
    }

    public void monitorResourceChangeEvents(boolean monitor) {
        HashSet<Resource> allResources = new HashSet<Resource>();
        allResources.addAll(this.resourceDirectories);
        allResources.addAll(this.registeredResources.getAllResources());
        allResources.addAll(this.dslResources.keySet());
        for (Resource resource : allResources) {
            if (monitor) {
                this.listener.debug("KnowledgeAgent subscribing from resource=" + resource);
                this.notifier.subscribeResourceChangeListener(this, resource);
                continue;
            }
            this.listener.debug("KnowledgeAgent unsubscribing from resource=" + resource);
            this.notifier.unsubscribeResourceChangeListener(this, resource);
        }
        if (!monitor && this.changeSetNotificationDetector != null) {
            this.changeSetNotificationDetector.stop();
            this.notificationDetectorExecutor.cancel(true);
            this.changeSetNotificationDetector = null;
        } else if (monitor && this.changeSetNotificationDetector == null) {
            this.changeSetNotificationDetector = new ChangeSetNotificationDetector(this, this.queue, this.listener);
            this.notificationDetectorExecutor = ExecutorProviderFactory.getExecutorProvider().getCompletionService().submit(this.changeSetNotificationDetector, true);
        }
    }

    public boolean addResourceMapping(Resource resource, boolean notify) {
        boolean newMapping = this.registeredResources.createNewResourceEntry(resource);
        if (notify && newMapping) {
            this.listener.debug("KnowledgeAgent notifier subscribing to resource=" + resource);
            this.notifier.subscribeResourceChangeListener(this, resource);
            return true;
        }
        return false;
    }

    public Map<Resource, Set<KnowledgeDefinition>> getRegisteredResources() {
        return this.registeredResources.map;
    }

    public boolean addDefinitionMapping(Resource resource, KnowledgeDefinition definition, boolean notify) {
        boolean isNewResource;
        if (resource == null) {
            this.listener.warning("KnowledgeAgent: impossible to add a map for a null resource! skiping.");
            return false;
        }
        this.listener.debug("KnowledgeAgent mapping resource=" + resource + " to KnowledgeDefinition=" + definition);
        boolean bl = isNewResource = !this.registeredResources.isResourceMapped(resource);
        if (resource instanceof ClassPathResource && ((ClassPathResource)resource).getClassLoader() == null) {
            ((ClassPathResource)resource).setClassLoader((ClassLoader)((InternalRuleBase)((InternalKnowledgeBase)this.kbase).getRuleBase()).getRootClassLoader());
        }
        boolean isNewDefinition = true;
        if (definition != null) {
            isNewDefinition = this.registeredResources.putDefinition(resource, definition);
        }
        if (notify && isNewResource) {
            this.listener.debug("KnowledgeAgent notifier subscribing to resource=" + resource);
            this.notifier.subscribeResourceChangeListener(this, resource);
        }
        return isNewDefinition;
    }

    public Set<KnowledgeDefinition> removeResourceMapping(Resource resource, boolean unsubscribe) {
        this.listener.debug("KnowledgeAgent removing mappings for resource=" + resource + " with unsubscribe=" + unsubscribe);
        Set<KnowledgeDefinition> definitions = this.registeredResources.removeDefinitions(resource);
        if (definitions != null && unsubscribe) {
            this.listener.debug("KnowledgeAgent notifier unsubscribing to resource=" + resource);
            this.notifier.unsubscribeResourceChangeListener(this, resource);
        }
        return definitions;
    }

    private KnowledgeBuilder createKBuilder() {
        if (this.registeredResources.onlyHasPKGResources()) {
            return null;
        }
        KnowledgeBuilder kbuilder = this.builderConfiguration != null ? KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.builderConfiguration) : (this.isUseKBaseClassLoaderForCompiling() ? KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBase)this.kbase) : KnowledgeBuilderFactory.newKnowledgeBuilder());
        if (this.dslResources != null) {
            for (Map.Entry<Resource, String> entry : this.dslResources.entrySet()) {
                kbuilder.add(ResourceFactory.newByteArrayResource((byte[])entry.getValue().getBytes()), ResourceType.DSL);
            }
        }
        return kbuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void retrieveDSLResource(Resource resource) throws IOException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(resource.getReader());
            StringBuilder content = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line);
                content.append("\n");
            }
            this.dslResources.put(resource, content.toString());
            Object var6_5 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (bufferedReader == null) throw throwable;
            bufferedReader.close();
            throw throwable;
        }
        bufferedReader.close();
    }

    public void addEventListener(KnowledgeAgentEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    public void removeEventListener(KnowledgeAgentEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            Collection statefulSessions;
            if (this.kbase != null && (statefulSessions = this.kbase.getStatefulKnowledgeSessions()) != null && !statefulSessions.isEmpty()) {
                String message = "The kbase still contains " + statefulSessions.size() + " stateful sessions. You must dispose them first.";
                this.listener.warning(message);
                throw new IllegalStateException(message);
            }
            this.monitorResourceChangeEvents(false);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.changeSetNotificationDetector != null) {
            this.changeSetNotificationDetector.monitor = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegisteredResourceMap {
        private final Map<Resource, Set<KnowledgeDefinition>> map = new HashMap<Resource, Set<KnowledgeDefinition>>();

        private RegisteredResourceMap() {
        }

        public boolean createNewResourceEntry(Resource resource) {
            if (!this.isResourceMapped(resource)) {
                this.map.put(resource, new HashSet());
                return true;
            }
            return false;
        }

        public boolean putDefinition(Resource resource, KnowledgeDefinition definition) {
            Set<KnowledgeDefinition> defList = this.map.get(resource);
            if (defList == null) {
                defList = new HashSet<KnowledgeDefinition>();
                this.map.put(resource, defList);
            }
            return definition != null && defList.add(definition);
        }

        public Set<KnowledgeDefinition> removeDefinitions(Resource resource) {
            return this.map.remove(resource);
        }

        public Set<KnowledgeDefinition> getDefinitions(Resource resource) {
            return this.getDefinitions(resource, false);
        }

        public Set<KnowledgeDefinition> getDefinitions(Resource resource, boolean returnEmptyIfNull) {
            Set<KnowledgeDefinition> definitions = this.map.get(resource);
            if (returnEmptyIfNull && definitions == null) {
                definitions = new HashSet<KnowledgeDefinition>();
            }
            return definitions;
        }

        public boolean isResourceMapped(Resource resource) {
            return this.map.containsKey(resource);
        }

        public Set<Resource> getAllResources() {
            return this.map.keySet();
        }

        public boolean onlyHasPKGResources() {
            for (Resource resource : this.map.keySet()) {
                if (((InternalResource)resource).getResourceType() == ResourceType.PKG) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeSetNotificationDetector
    implements Runnable {
        private final LinkedBlockingQueue<ChangeSet> queue;
        private volatile boolean monitor;
        private final KnowledgeAgentImpl kagent;
        private final SystemEventListener listener;

        public ChangeSetNotificationDetector(KnowledgeAgentImpl kagent, LinkedBlockingQueue<ChangeSet> queue, SystemEventListener listener) {
            this.queue = queue;
            this.kagent = kagent;
            this.listener = listener;
            this.monitor = true;
        }

        public void stop() {
            this.monitor = false;
        }

        @Override
        public void run() {
            if (this.monitor) {
                this.listener.info("KnowledgeAgent has started listening for ChangeSet notifications");
            }
            while (this.monitor) {
                InterruptedException exception = null;
                try {
                    this.kagent.applyChangeSet(this.queue.take());
                }
                catch (InterruptedException e) {
                    exception = e;
                }
                Thread.yield();
                if (!this.monitor || exception == null) continue;
                this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent ChangeSet notification thread has been interrupted, but shutdown was not scheduled", exception));
            }
            this.listener.info("KnowledgeAgent has stopped listening for ChangeSet notifications");
        }
    }

    public static class ChangeSetState {
        List<Resource> addedResources = new ArrayList<Resource>();
        Map<Resource, Set<KnowledgeDefinition>> removedResourceMappings = new HashMap<Resource, Set<KnowledgeDefinition>>();
        Map<Resource, Set<KnowledgeDefinition>> modifiedResourceMappings = new HashMap<Resource, Set<KnowledgeDefinition>>();
        Map<Resource, Set<KnowledgePackage>> createdPackages = new LinkedHashMap<Resource, Set<KnowledgePackage>>();
        boolean scanDirectories;
        boolean incrementalBuild;
    }
}

