/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.traits;

import java.util.Collection;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.io.impl.ClassPathResource;
import org.drools.runtime.StatefulKnowledgeSession;

public class TraitExample {
    private static StatefulKnowledgeSession getSession(String drl) {
        KnowledgeBuilder kBuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kBuilder.add(new ClassPathResource("org/drools/examples/traits/" + drl), ResourceType.DRL);
        if (kBuilder.hasErrors()) {
            System.err.println(kBuilder.getErrors().toString());
        }
        KnowledgeBase kBase = KnowledgeBaseFactory.newKnowledgeBase();
        kBase.addKnowledgePackages(kBuilder.getKnowledgePackages());
        return kBase.newStatefulKnowledgeSession();
    }

    public static void run(String demo) {
        TraitFactory.reset();
        StatefulKnowledgeSession kSession = TraitExample.getSession(demo);
        kSession.fireAllRules();
        Collection<Object> c = kSession.getObjects();
        System.out.println("------------------------- " + c.size() + " ----------------------");
        for (Object o : c) {
            System.out.println(" \t --- " + o);
        }
        System.out.println("-----------------------------------------------------------------");
        kSession.dispose();
    }

    public static void main(String[] args) {
        TraitExample.run("noTraits.drl");
        TraitExample.run("traitsDon.drl");
        TraitExample.run("multipleTraits.drl");
        TraitExample.run("traitsMixins.drl");
        TraitExample.run("traitsShed.drl");
    }
}

