/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.components;

import org.drools.verifier.components.Pattern;
import org.drools.verifier.components.RuleComponent;
import org.drools.verifier.components.VerifierComponentType;

public abstract class PatternComponent
extends RuleComponent {
    private String patternName;
    private int patternOrderNumber;

    public PatternComponent(Pattern pattern) {
        super(pattern.getDescr(), pattern.getPackageName(), pattern.getRuleName());
        this.patternName = pattern.getName();
        this.patternOrderNumber = pattern.getOrderNumber();
    }

    PatternComponent(String packageName, String ruleName, String patternName, int patternOrderNumber) {
        super(null, packageName, ruleName);
        this.patternName = patternName;
        this.patternOrderNumber = patternOrderNumber;
    }

    public String getPatternPath() {
        return String.format("%s/ruleComponent[@type=%s @orderNumber=%s]", this.getRulePath(), VerifierComponentType.PATTERN.getType(), this.patternOrderNumber);
    }

    public String getPath() {
        return String.format("%s/patternComponent[%s]", this.getPatternPath(), this.getOrderNumber());
    }

    public String getPatternName() {
        return this.patternName;
    }

    public int getPatternOrderNumber() {
        return this.patternOrderNumber;
    }
}

