/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.ObjectHashSet;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.core.util.index.RightTupleIndexHashTable;
import org.drools.core.util.index.RightTupleList;
import org.drools.reteoo.AlphaNode;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkPropagator;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NotNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleMemory;
import org.drools.reteoo.RuleTerminalNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryVisitor
extends ReflectiveVisitor
implements Externalizable {
    protected static transient Logger logger = LoggerFactory.getLogger(MemoryVisitor.class);
    private InternalWorkingMemory workingMemory;
    private int indent = 0;

    public MemoryVisitor() {
    }

    public MemoryVisitor(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.indent = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeInt(this.indent);
    }

    public void visitReteooRuleBase(ReteooRuleBase ruleBase) {
        this.visit(ruleBase.getRete());
    }

    public void visitRete(Rete rete) {
        for (ObjectTypeNode node : rete.getObjectTypeNodes()) {
            this.visit(node);
        }
    }

    public void visitObjectTypeNode(ObjectTypeNode node) {
        logger.info(this.indent() + node);
        ObjectHashSet memory = (ObjectHashSet)((Object)this.workingMemory.getNodeMemory(node));
        this.checkObjectHashSet(memory);
        ++this.indent;
        try {
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            ObjectSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitAlphaNode(AlphaNode node) {
        logger.info(this.indent() + node);
        ++this.indent;
        try {
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            ObjectSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitLeftInputAdapterNode(LeftInputAdapterNode node) {
        logger.info(this.indent() + node);
        ++this.indent;
        try {
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            LeftTupleSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitJoinNode(JoinNode node) {
        logger.info(this.indent() + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getRightTupleMemory());
            this.checkLeftTupleMemory(memory.getLeftTupleMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.indent;
        try {
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            LeftTupleSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitNotNode(NotNode node) {
        logger.info(this.indent() + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getRightTupleMemory());
            this.checkLeftTupleMemory(memory.getLeftTupleMemory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.indent;
        try {
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            LeftTupleSink[] sinks = sink.getSinks();
            int length = sinks.length;
            for (int i = 0; i < length; ++i) {
                this.visit(sinks[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this.indent;
    }

    public void visitRuleTerminalNode(RuleTerminalNode node) {
        logger.info(this.indent() + node);
    }

    private void checkObjectHashSet(ObjectHashSet memory) {
        FastIterator it = LinkedList.fastIterator;
        Entry[] entries = memory.getTable();
        int factCount = 0;
        boolean bucketCount = false;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            if (entries[i] == null) continue;
            Entry entry = entries[i];
            while (entry != null) {
                entry = it.next(entry);
                ++factCount;
            }
        }
        logger.info(this.indent() + "ObjectHashSet: " + memory.size() + ":" + factCount);
        if (factCount != memory.size()) {
            logger.info(this.indent() + "error");
        }
    }

    private void checkObjectHashTable(RightTupleMemory memory) {
        if (memory instanceof RightTupleList) {
            this.checkRightTupleList((RightTupleList)memory);
        } else if (memory instanceof RightTupleIndexHashTable) {
            this.checkRightTupleIndexHashTable((RightTupleIndexHashTable)memory);
        } else {
            throw new RuntimeException(memory.getClass() + " should not be here");
        }
    }

    private void checkRightTupleList(RightTupleList memory) {
        int count = 0;
        FastIterator rightIt = memory.fastIterator();
        RightTuple rightTuple = memory.getFirst();
        while (rightTuple != null) {
            ++count;
            rightTuple = (RightTuple)rightIt.next(rightTuple);
        }
        logger.info(this.indent() + "FactHashTable: " + memory.size() + ":" + count);
        if (memory.size() != count) {
            logger.info(this.indent() + "error");
        }
    }

    private void checkRightTupleIndexHashTable(RightTupleIndexHashTable memory) {
        Entry[] entries = memory.getTable();
        int factCount = 0;
        int bucketCount = 0;
        FastIterator it = LinkedList.fastIterator;
        int length = entries.length;
        for (int i = 0; i < length; ++i) {
            if (entries[i] == null) continue;
            RightTupleList rightTupleList = (RightTupleList)entries[i];
            while (rightTupleList != null) {
                if (rightTupleList.first != null) {
                    Entry entry = rightTupleList.first;
                    while (entry != null) {
                        entry = it.next(entry);
                        ++factCount;
                    }
                } else {
                    logger.info("error : fieldIndexHashTable cannot have empty FieldIndexEntry objects");
                }
                rightTupleList = (RightTupleList)rightTupleList.getNext();
                ++bucketCount;
            }
        }
        try {
            Field field = AbstractHashTable.class.getDeclaredField("size");
            field.setAccessible(true);
            logger.info(this.indent() + "FieldIndexBuckets: " + (Integer)field.get(memory) + ":" + bucketCount);
            if ((Integer)field.get(memory) != bucketCount) {
                logger.info(this.indent() + "error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info(this.indent() + "FieldIndexFacts: " + memory.size() + ":" + factCount);
        if (memory.size() != factCount) {
            logger.info(this.indent() + "error");
        }
    }

    private void checkLeftTupleMemory(LeftTupleMemory memory) {
    }

    private String indent() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }
}

