/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.lang.descr.AndDescr;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BehaviorDescr;
import org.drools.lang.descr.ConditionalElementDescr;
import org.drools.lang.descr.EntryPointDescr;
import org.drools.lang.descr.PatternSourceDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternDescr
extends AnnotatedBaseDescr
implements Cloneable {
    private static final long serialVersionUID = 510L;
    private String objectType;
    private String identifier;
    private boolean unification;
    private ConditionalElementDescr constraint = new AndDescr();
    private int leftParentCharacter = -1;
    private int rightParentCharacter = -1;
    private PatternSourceDescr source;
    private List<BehaviorDescr> behaviors;
    private boolean query;

    public PatternDescr() {
        this(null, null);
    }

    public PatternDescr(String objectType) {
        this(objectType, null);
    }

    public PatternDescr(String objectType, String identifier) {
        this.objectType = objectType;
        this.identifier = identifier;
    }

    public PatternDescr(String objectType, String identifier, boolean isQuery) {
        this.objectType = objectType;
        this.identifier = identifier;
        this.query = isQuery;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public void setQuery(boolean query) {
        this.query = query;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isQuery() {
        return this.query;
    }

    public List<? extends BaseDescr> getDescrs() {
        return this.constraint.getDescrs();
    }

    public void addConstraint(BaseDescr base) {
        this.constraint.addDescr(base);
    }

    public boolean removeConstraint(BaseDescr base) {
        return this.constraint.removeDescr(base);
    }

    public ConditionalElementDescr getConstraint() {
        return this.constraint;
    }

    public boolean isInternalFact() {
        return this.getSource() != null && !(this.getSource() instanceof EntryPointDescr);
    }

    public String toString() {
        return "[Pattern: id=" + this.identifier + "; objectType=" + this.objectType + "]";
    }

    public int getLeftParentCharacter() {
        return this.leftParentCharacter;
    }

    public void setLeftParentCharacter(int leftParentCharacter) {
        this.leftParentCharacter = leftParentCharacter;
    }

    public int getRightParentCharacter() {
        return this.rightParentCharacter;
    }

    public void setRightParentCharacter(int rightParentCharacter) {
        this.rightParentCharacter = rightParentCharacter;
    }

    public PatternSourceDescr getSource() {
        return this.source;
    }

    public void setSource(PatternSourceDescr source) {
        this.source = source;
    }

    public List<BehaviorDescr> getBehaviors() {
        if (this.behaviors == null) {
            return Collections.emptyList();
        }
        return this.behaviors;
    }

    public void setBehaviors(List<BehaviorDescr> behaviors) {
        this.behaviors = behaviors;
    }

    public void addBehavior(BehaviorDescr behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<BehaviorDescr>();
        }
        this.behaviors.add(behavior);
    }

    public boolean isUnification() {
        return this.unification;
    }

    public void setUnification(boolean unification) {
        this.unification = unification;
    }

    public Object clone() {
        PatternDescr clone = new PatternDescr(this.objectType, this.identifier);
        clone.setQuery(this.query);
        clone.setUnification(this.unification);
        clone.setLeftParentCharacter(this.leftParentCharacter);
        clone.setRightParentCharacter(this.rightParentCharacter);
        clone.setSource(this.source);
        clone.setStartCharacter(this.getStartCharacter());
        clone.setEndCharacter(this.getEndCharacter());
        clone.setLocation(this.getLine(), this.getColumn());
        clone.setEndLocation(this.getEndLine(), this.getEndColumn());
        clone.setText(this.getText());
        for (BaseDescr baseDescr : this.getDescrs()) {
            clone.addConstraint(baseDescr);
        }
        if (this.behaviors != null) {
            for (BehaviorDescr behaviorDescr : this.behaviors) {
                clone.addBehavior(behaviorDescr);
            }
        }
        return clone;
    }
}

