/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.workitemconsequence;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;

public class WorkItemConsequenceExample2 {
    public static void main(String[] args) {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource("WorkItemConsequence2.drl", WorkItemConsequenceExample2.class), ResourceType.DRL);
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Compilation error.\n" + kbuilder.getErrors().toString());
        }
        StatefulKnowledgeSession ksession = kbase.newStatefulKnowledgeSession();
        ksession.getWorkItemManager().registerWorkItemHandler("GreetingWorkItemHandler", new GreetingWorkItemHandler());
        ksession.insert(new Greeting("Michael"));
        ksession.fireAllRules();
        ksession.dispose();
    }

    public static class GreetingWorkItemHandler
    implements WorkItemHandler {
        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            String name = (String)workItem.getParameter("name");
            String response = "Hello, " + name;
            workItem.getResults().put("response", response);
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    public static class Greeting {
        private String name;
        private String response;

        public Greeting(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setResponse(String response) {
            this.response = response;
        }

        public String getResponse() {
            return this.response;
        }
    }
}

