/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.definition.type.FactField;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.MapCore;
import org.drools.factmodel.traits.CoreWrapper;
import org.drools.factmodel.traits.Entity;
import org.drools.factmodel.traits.LogicalMapCore;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.rule.TypeDeclaration;
import org.drools.util.HierarchyEncoder;
import org.drools.util.HierarchyEncoderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitRegistry
implements Externalizable {
    private Map<String, ClassDefinition> traits;
    private Map<String, ClassDefinition> traitables;
    private int codeSize = 0;
    private Map<String, BitSet> masks;
    private HierarchyEncoder<String> hierarchy = new HierarchyEncoderImpl<String>();

    public TraitRegistry() {
        this.init();
    }

    private void init() {
        TypeDeclaration thingType = new TypeDeclaration(Thing.class.getName());
        thingType.setKind(TypeDeclaration.Kind.TRAIT);
        thingType.setTypeClass(Thing.class);
        ClassDefinition def = new ClassDefinition();
        def.setClassName(thingType.getTypeClass().getName());
        def.setDefinedClass(Thing.class);
        this.addTrait(def);
        ClassDefinition individualDef = new ClassDefinition();
        individualDef.setClassName(Entity.class.getName());
        individualDef.setDefinedClass(Entity.class);
        individualDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName()});
        individualDef.setTraitable(true);
        this.addTraitable(individualDef);
        ClassDefinition mapcoreDef = new ClassDefinition();
        mapcoreDef.setClassName(MapCore.class.getName());
        mapcoreDef.setDefinedClass(MapCore.class);
        mapcoreDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName(), CoreWrapper.class.getName()});
        mapcoreDef.setTraitable(true);
        this.addTraitable(mapcoreDef);
        ClassDefinition logicalMapcoreDef = new ClassDefinition();
        logicalMapcoreDef.setClassName(LogicalMapCore.class.getName());
        logicalMapcoreDef.setDefinedClass(LogicalMapCore.class);
        logicalMapcoreDef.setInterfaces(new String[]{Serializable.class.getName(), TraitableBean.class.getName(), CoreWrapper.class.getName()});
        logicalMapcoreDef.setTraitable(true, true);
        this.addTraitable(logicalMapcoreDef);
    }

    public void merge(TraitRegistry other) {
        if (this.traits == null) {
            this.traits = new HashMap<String, ClassDefinition>();
        }
        if (other.traits != null) {
            this.traits.putAll(other.traits);
        }
        if (this.traitables == null) {
            this.traitables = new HashMap<String, ClassDefinition>();
        }
        if (other.traitables != null) {
            this.traitables.putAll(other.traitables);
        }
        if (this.masks == null) {
            this.masks = new HashMap<String, BitSet>();
        }
        if (other.masks != null) {
            this.masks.putAll(other.masks);
        }
        if (this.hierarchy == null || this.hierarchy.size() <= 1) {
            this.hierarchy = other.hierarchy;
        } else if (other.traits != null) {
            for (String traitName : other.traits.keySet()) {
                ClassDefinition trait = other.traits.get(traitName);
                ArrayList<String> parentTraits = new ArrayList<String>();
                for (String candidateIntf : trait.getInterfaces()) {
                    if (this.hierarchy.getCode(candidateIntf) == null) continue;
                    parentTraits.add(candidateIntf);
                }
                this.hierarchy.encode(trait.getName(), parentTraits);
            }
        }
    }

    public Map<String, ClassDefinition> getTraits() {
        return this.traits;
    }

    protected ClassDefinition getTrait(String key) {
        ClassDefinition traitDef;
        if (key.endsWith("_Trait__Extension")) {
            key = key.replace("_Trait__Extension", "");
        }
        ClassDefinition classDefinition = traitDef = this.traits != null ? this.traits.get(key) : null;
        if (traitDef == null) {
            // empty if block
        }
        return traitDef;
    }

    public Map<String, ClassDefinition> getTraitables() {
        return this.traitables;
    }

    protected ClassDefinition getTraitable(String key) {
        return this.traitables != null ? this.traitables.get(key) : null;
    }

    public void addTrait(ClassDefinition trait) {
        this.addTrait(trait.getClassName(), trait);
    }

    public void addTrait(String className, ClassDefinition trait) {
        if (this.traits == null) {
            this.traits = new HashMap<String, ClassDefinition>();
        }
        this.traits.put(className, trait);
        this.hierarchy.encode(className, this.getTraitInterfaces(trait));
    }

    private Collection<String> getTraitInterfaces(ClassDefinition trait) {
        ArrayList<String> intfs = new ArrayList<String>();
        for (String s : trait.getInterfaces()) {
            if (!this.traits.containsKey(s)) continue;
            intfs.add(s);
        }
        return intfs;
    }

    public void addTraitable(ClassDefinition traitable) {
        if (this.traitables == null) {
            this.traitables = new HashMap<String, ClassDefinition>();
        }
        this.traitables.put(traitable.getClassName(), traitable);
    }

    public static boolean isSoftField(FieldDefinition field, int index, BitSet mask) {
        return !mask.get(index);
    }

    public BitSet getFieldMask(String trait, String traitable) {
        String key;
        BitSet mask;
        if (this.masks == null) {
            this.masks = new HashMap<String, BitSet>();
        }
        if ((mask = this.masks.get(key = trait + traitable)) == null) {
            mask = this.bind(trait, traitable);
            this.masks.put(key, mask);
        }
        return mask;
    }

    private BitSet bind(String trait, String traitable) throws UnsupportedOperationException {
        ClassDefinition traitDef = this.getTrait(trait);
        if (traitDef == null) {
            throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : not a trait ");
        }
        ClassDefinition traitableDef = this.getTraitable(traitable);
        if (traitableDef == null) {
            throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " : not a traitable ");
        }
        int j = 0;
        BitSet bitmask = new BitSet(traitDef.getFields().size());
        for (FactField field : traitDef.getFields()) {
            String alias = ((FieldDefinition)field).resolveAlias();
            FieldDefinition concreteField = traitableDef.getFieldByAlias(alias);
            if (concreteField != null) {
                if (!traitableDef.isFullTraiting() && !concreteField.getType().isAssignableFrom(field.getType())) {
                    throw new UnsupportedOperationException(" Unable to apply trait " + trait + " to class " + traitable + " :" + " trait field " + field.getName() + ":" + ((FieldDefinition)field).getTypeName() + " is incompatible with" + " concrete hard field " + concreteField.getName() + ":" + concreteField.getTypeName() + ". Consider enabling logical traiting" + " mode using @Traitable( logical = true )");
                }
                bitmask.set(j);
            }
            ++j;
        }
        return bitmask;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.traits);
        objectOutput.writeObject(this.traitables);
        objectOutput.writeObject(this.masks);
        objectOutput.writeObject(this.hierarchy);
        objectOutput.writeInt(this.codeSize);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.traits = (Map)objectInput.readObject();
        this.traitables = (Map)objectInput.readObject();
        this.masks = (Map)objectInput.readObject();
        this.hierarchy = (HierarchyEncoderImpl)objectInput.readObject();
        this.codeSize = objectInput.readInt();
        this.init();
    }

    public HierarchyEncoder getHierarchy() {
        return this.hierarchy;
    }
}

