/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.beans.IntrospectionException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleFactory;
import org.drools.core.util.TripleStore;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.definition.type.FactField;
import org.drools.factmodel.BuildUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;
import org.drools.factmodel.traits.Thing;
import org.drools.factmodel.traits.Trait;
import org.drools.factmodel.traits.TraitFactory;
import org.drools.factmodel.traits.TraitFieldTMS;
import org.drools.factmodel.traits.TraitProxy;
import org.drools.factmodel.traits.TraitProxyClassBuilder;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.factmodel.traits.TraitType;
import org.drools.factmodel.traits.TraitTypeMap;
import org.drools.factmodel.traits.TraitableBean;
import org.drools.factmodel.traits.TripleBasedBean;
import org.drools.factmodel.traits.TripleBasedTypes;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.WriteAccessor;
import org.mvel2.MVEL;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraitTripleProxyClassBuilderImpl
implements TraitProxyClassBuilder,
Serializable {
    private transient ClassDefinition trait;
    private transient Class<?> proxyBaseClass;
    private transient TraitRegistry traitRegistry;

    protected ClassDefinition getTrait() {
        return this.trait;
    }

    @Override
    public void init(ClassDefinition trait, Class<?> baseClass, TraitRegistry traitRegistry) {
        this.trait = trait;
        this.proxyBaseClass = baseClass;
        this.traitRegistry = traitRegistry;
    }

    @Override
    public byte[] buildClass(ClassDefinition core) throws IOException, IntrospectionException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = new ClassWriter(1);
        BitSet mask = this.traitRegistry.getFieldMask(this.getTrait().getName(), core.getDefinedClass().getName());
        String name = TraitFactory.getPropertyWrapperName(this.getTrait(), core);
        String masterName = TraitFactory.getProxyName(this.getTrait(), core);
        String internalWrapper = BuildUtils.getInternalType(name);
        String internalProxy = BuildUtils.getInternalType(masterName);
        String internalCore = Type.getInternalName(core.getDefinedClass());
        String descrCore = Type.getDescriptor(core.getDefinedClass());
        String internalTrait = Type.getInternalName(this.getTrait().getDefinedClass());
        Class mixinClass = null;
        String mixin = null;
        HashSet<Method> mixinMethods = new HashSet<Method>();
        HashMap<String, Method> mixinGetSet = new HashMap<String, Method>();
        try {
            Trait annTrait;
            if (this.getTrait().getDefinedClass() != null && this.hasImpl(annTrait = this.getAnnotation(this.getTrait().getDefinedClass(), Trait.class))) {
                mixinClass = annTrait.impl();
                mixin = mixinClass.getSimpleName().substring(0, 1).toLowerCase() + mixinClass.getSimpleName().substring(1);
                ClassFieldInspector cfi = new ClassFieldInspector(mixinClass);
                for (Method m : mixinClass.getMethods()) {
                    try {
                        this.getTrait().getDefinedClass().getMethod(m.getName(), m.getParameterTypes());
                        if (cfi.getGetterMethods().containsValue(m) || cfi.getSetterMethods().containsValue(m)) {
                            mixinGetSet.put(m.getName(), m);
                            continue;
                        }
                        mixinMethods.add(m);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cw.visit(49, 33, internalProxy, null, Type.getInternalName(this.proxyBaseClass), new String[]{internalTrait, Type.getInternalName(Externalizable.class)});
        FieldVisitor fv = cw.visitField(26, "__$$trait_Name", Type.getDescriptor(String.class), null, null);
        fv.visitEnd();
        fv = cw.visitField(1, "object", descrCore, null, null);
        fv.visitEnd();
        fv = cw.visitField(2, "store", Type.getDescriptor(TripleStore.class), null, null);
        fv.visitEnd();
        fv = cw.visitField(2, "storeId", Type.getDescriptor(String.class), null, null);
        fv.visitEnd();
        if (mixinClass != null) {
            fv = cw.visitField(2, mixin, Type.getDescriptor((Class)mixinClass), null, null);
            fv.visitEnd();
        }
        MethodVisitor mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(this.trait.getDefinedClass())));
        mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getName", "()" + Type.getDescriptor(String.class));
        mv.visitFieldInsn(179, internalProxy, "__$$trait_Name", Type.getDescriptor(String.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "<init>", "(" + descrCore + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + Type.getDescriptor(BitSet.class) + Type.getDescriptor(BitSet.class) + Type.getDescriptor(Boolean.TYPE) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "getId", "()" + Type.getDescriptor(String.class));
        mv.visitFieldInsn(181, internalProxy, "storeId", Type.getDescriptor(String.class));
        int size = this.buildConstructorCore(cw, mv, internalProxy, internalWrapper, internalCore, descrCore, mixin, mixinClass);
        this.initFields(mv, internalProxy);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTraitName", "()" + Type.getDescriptor(String.class), null, null);
        mv.visitCode();
        mv.visitFieldInsn(178, internalProxy, "__$$trait_Name", Type.getDescriptor(String.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getCore", "()" + descrCore + "", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getObject", "()" + Type.getDescriptor(TraitableBean.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "object", descrCore);
        mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "setObject", "(" + Type.getDescriptor(Object.class) + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(4161, "getCore", "()" + Type.getDescriptor(Object.class), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getCore", "()" + descrCore);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "isTop", "()Z", null, null);
        mv.visitCode();
        mv.visitInsn(Thing.class.equals(this.trait.getDefinedClass()) ? 4 : 3);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "shed", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        mv.visitCode();
        if (core.isFullTraiting()) {
            Iterator<FieldDefinition> iter = this.trait.getFieldsDefinitions().iterator();
            for (int j = 0; j < this.trait.getFieldsDefinitions().size(); ++j) {
                FieldDefinition fld = iter.next();
                boolean hardField = !TraitRegistry.isSoftField(fld, j, mask);
                this.shedField(mv, fld, internalProxy, this.trait, core, hardField, j + 2);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "writeExternal", "(" + Type.getDescriptor(ObjectOutput.class) + ")V", null, new String[]{Type.getInternalName(IOException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "writeExternal", "(" + Type.getDescriptor(ObjectOutput.class) + ")V");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalProxy, "getObject", "()" + Type.getDescriptor(TraitableBean.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "storeId", Type.getDescriptor(String.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V");
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, internalProxy, "store", Type.getDescriptor(TripleStore.class));
        mv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), "writeObject", "(" + Type.getDescriptor(Object.class) + ")V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "readExternal", "(" + Type.getDescriptor(ObjectInput.class) + ")V", null, new String[]{Type.getInternalName(IOException.class), Type.getInternalName(ClassNotFoundException.class)});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "readExternal", "(" + Type.getDescriptor(ObjectInput.class) + ")V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class));
        mv.visitTypeInsn(192, internalCore);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class));
        mv.visitTypeInsn(192, Type.getInternalName(String.class));
        mv.visitFieldInsn(181, internalProxy, "storeId", Type.getDescriptor(String.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), "readObject", "()" + Type.getDescriptor(Object.class));
        mv.visitTypeInsn(192, Type.getInternalName(TripleStore.class));
        mv.visitFieldInsn(181, internalProxy, "store", Type.getDescriptor(TripleStore.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        this.buildProxyAccessors(mask, cw, masterName, core, mixinGetSet);
        boolean hasKeys = false;
        for (FactField ff : this.getTrait().getFields()) {
            if (!ff.isKey()) continue;
            hasKeys = true;
            break;
        }
        if (!hasKeys) {
            this.buildEqualityMethods((ClassVisitor)cw, masterName, core.getClassName());
        } else {
            this.buildKeyedEqualityMethods((ClassVisitor)cw, this.getTrait(), masterName, core.getClassName());
        }
        if (mixinClass != null) {
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinMethods);
            this.buildMixinMethods(cw, masterName, mixin, mixinClass, mixinGetSet.values());
        }
        this.buildCommonMethods(cw, masterName);
        this.buildExtendedMethods(cw, this.getTrait(), core, mask);
        cw.visitEnd();
        return cw.toByteArray();
    }

    private boolean hasImpl(Trait annTrait) {
        return annTrait != null && !annTrait.impl().equals(Trait.NullMixin.class);
    }

    private <K extends Annotation> K getAnnotation(Class klass, Class<K> annotationClass) {
        if (klass.equals(Thing.class)) {
            return null;
        }
        K ann = klass.getAnnotation(annotationClass);
        if (ann == null) {
            for (Class<?> sup : klass.getInterfaces()) {
                ann = this.getAnnotation(sup, annotationClass);
                if (ann == null) continue;
                return ann;
            }
            return null;
        }
        return ann;
    }

    protected int buildConstructorCore(ClassWriter cw, MethodVisitor mv, String internalProxy, String internalWrapper, String internalCore, String descrCore, String mixin, Class mixinClass) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, Type.getInternalName(this.proxyBaseClass), "<init>", "()V");
        if (mixinClass != null) {
            try {
                Class actualArg = this.getPossibleConstructor(mixinClass, this.trait.getDefinedClass());
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, Type.getInternalName((Class)mixinClass));
                mv.visitInsn(89);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, Type.getInternalName((Class)mixinClass), "<init>", "(" + Type.getDescriptor((Class)actualArg) + ")V");
                mv.visitFieldInsn(181, internalProxy, mixin, Type.getDescriptor((Class)mixinClass));
            }
            catch (NoSuchMethodException nsme) {
                mv.visitVarInsn(25, 0);
                mv.visitTypeInsn(187, Type.getInternalName((Class)mixinClass));
                mv.visitInsn(89);
                mv.visitMethodInsn(183, Type.getInternalName((Class)mixinClass), "<init>", "()V");
                mv.visitFieldInsn(181, internalProxy, mixin, Type.getDescriptor((Class)mixinClass));
            }
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, internalProxy, "object", descrCore);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitFieldInsn(181, internalProxy, "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, internalProxy, "setTripleFactory", "(" + Type.getDescriptor(TripleFactory.class) + ")V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(182, internalProxy, "setTypeCode", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(BitSet.class)}));
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, internalWrapper);
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, internalWrapper, "<init>", "(" + descrCore + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V");
        mv.visitFieldInsn(181, internalProxy, "fields", Type.getDescriptor(Map.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, internalCore, "_getDynamicProperties", "()" + Type.getDescriptor(Map.class));
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, Type.getInternalName(TripleBasedBean.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedBean.class), "<init>", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V");
        mv.visitMethodInsn(182, internalCore, "_setDynamicProperties", "(" + Type.getDescriptor(Map.class) + ")V");
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, internalCore, "_getTraitMap", "()" + Type.getDescriptor(Map.class));
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(187, Type.getInternalName(TraitTypeMap.class));
        mv.visitInsn(89);
        mv.visitTypeInsn(187, Type.getInternalName(TripleBasedTypes.class));
        mv.visitInsn(89);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, Type.getInternalName(TripleBasedTypes.class), "<init>", "(" + Type.getDescriptor(Object.class) + Type.getDescriptor(TripleStore.class) + Type.getDescriptor(TripleFactory.class) + ")V");
        mv.visitMethodInsn(183, Type.getInternalName(TraitTypeMap.class), "<init>", "(" + Type.getDescriptor(Map.class) + ")V");
        mv.visitMethodInsn(182, internalCore, "_setTraitMap", "(" + Type.getDescriptor(Map.class) + ")V");
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 5);
        mv.visitMethodInsn(182, internalCore, "_setBottomTypeCode", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(BitSet.class)}));
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)this.trait.getName());
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, internalCore, "addTrait", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Thing.class)}));
        return 3;
    }

    protected void initFields(MethodVisitor mv, String internalProxy) {
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 6);
        mv.visitMethodInsn(183, internalProxy, "synchFields", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE}));
    }

    private Class getPossibleConstructor(Class klass, Class arg) throws NoSuchMethodException {
        Constructor<?>[] ctors;
        for (Constructor<?> c : ctors = klass.getConstructors()) {
            Class<?>[] cpars = c.getParameterTypes();
            if (cpars.length != 1 || !cpars[0].isAssignableFrom(arg)) continue;
            return cpars[0];
        }
        throw new NoSuchMethodException("Constructor for " + klass + " using " + arg + " not found ");
    }

    protected void buildProxyAccessors(BitSet mask, ClassWriter cw, String masterName, ClassDefinition core, Map<String, Method> mixinGetSet) {
        int j = 0;
        for (FieldDefinition field : this.getTrait().getFieldsDefinitions()) {
            boolean isSoftField = TraitRegistry.isSoftField(field, j++, mask);
            this.buildProxyAccessor(mask, cw, masterName, core, mixinGetSet, field, isSoftField);
        }
    }

    protected void buildProxyAccessor(BitSet mask, ClassWriter cw, String masterName, ClassDefinition core, Map<String, Method> mixinGetSet, FieldDefinition field, boolean isSoftField) {
        if (!isSoftField) {
            FieldVisitor fv = cw.visitField(9, field.getName() + "_reader", Type.getDescriptor(InternalReadAccessor.class), null, null);
            fv.visitEnd();
            fv = cw.visitField(9, field.getName() + "_writer", Type.getDescriptor(WriteAccessor.class), null, null);
            fv.visitEnd();
        }
        if (core.isFullTraiting()) {
            this.buildLogicalGetter((ClassVisitor)cw, field, masterName, this.trait, core);
            if (!isSoftField) {
                this.buildHardSetter((ClassVisitor)cw, field, masterName, this.trait, core);
            } else {
                this.buildSoftSetter((ClassVisitor)cw, field, masterName, this.trait, core);
            }
        } else if (isSoftField) {
            if (!mixinGetSet.containsKey(BuildUtils.getterName(field.getName(), field.getTypeName()))) {
                this.buildSoftGetter((ClassVisitor)cw, field, masterName, this.trait, core);
                this.buildSoftSetter((ClassVisitor)cw, field, masterName, this.trait, core);
            }
        } else {
            this.buildHardGetter((ClassVisitor)cw, field, masterName, this.trait, core);
            this.buildHardSetter((ClassVisitor)cw, field, masterName, this.trait, core);
        }
    }

    private void buildMixinMethods(ClassWriter cw, String wrapperName, String mixin, Class mixinClass, Collection<Method> mixinMethods) {
        for (Method method : mixinMethods) {
            String signature = TraitFactory.buildSignature(method);
            MethodVisitor mv = cw.visitMethod(1, method.getName(), signature, null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(wrapperName), mixin, Type.getDescriptor((Class)mixinClass));
            int j = 1;
            for (Class<?> arg : method.getParameterTypes()) {
                mv.visitVarInsn(BuildUtils.varType(arg.getName()), j++);
            }
            mv.visitMethodInsn(182, Type.getInternalName((Class)mixinClass), method.getName(), signature);
            mv.visitInsn(BuildUtils.returnType(method.getReturnType().getName()));
            int stack = TraitFactory.getStackSize(method);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    private void logicalSetter(MethodVisitor mv, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core, boolean hardField) {
        String fieldType = field.getTypeName();
        int reg = 1 + BuildUtils.sizeOf(fieldType);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(masterName), "object", Type.getDescriptor(core.getDefinedClass()));
        mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
        mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "_getFieldTMS", Type.getMethodDescriptor((Type)Type.getType(TraitFieldTMS.class), (Type[])new Type[0]));
        mv.visitVarInsn(58, reg);
        mv.visitVarInsn(25, reg);
        mv.visitLdcInsn((Object)field.resolveAlias());
        if (BuildUtils.isPrimitive(fieldType)) {
            mv.visitVarInsn(BuildUtils.varType(fieldType), 1);
            mv.visitMethodInsn(184, BuildUtils.getInternalType(BuildUtils.box(fieldType)), "valueOf", Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(fieldType))), (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(fieldType))}));
        } else {
            mv.visitVarInsn(25, 1);
        }
        if (BuildUtils.isPrimitive(fieldType)) {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(field.getTypeName()))));
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(field.getType())));
        }
        mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "set", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class), Type.getType(Class.class)}));
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        if (BuildUtils.isPrimitive(fieldType)) {
            Label l0 = new Label();
            mv.visitJumpInsn(198, l0);
            mv.visitVarInsn(25, 1);
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(fieldType));
            mv.visitMethodInsn(184, BuildUtils.getInternalType(BuildUtils.box(fieldType)), "valueOf", Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(fieldType))), (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(fieldType))}));
            mv.visitLabel(l1);
            mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fieldType)));
            mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fieldType)), BuildUtils.numericMorph(BuildUtils.box(fieldType)), Type.getMethodDescriptor((Type)Type.getType(field.getType()), (Type[])new Type[0]));
            mv.visitVarInsn(BuildUtils.storeType(fieldType), 1);
        }
    }

    private void buildLogicalGetter(ClassVisitor cw, FieldDefinition field, String proxy, ClassDefinition trait, ClassDefinition core) {
        String fieldName = field.getName();
        String fieldType = field.getTypeName();
        String getter = BuildUtils.getterName(fieldName, fieldType);
        MethodVisitor mv = cw.visitMethod(1, getter, "()" + BuildUtils.getTypeDescriptor(fieldType), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "object", Type.getDescriptor(core.getDefinedClass()));
        mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
        mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "_getFieldTMS", Type.getMethodDescriptor((Type)Type.getType(TraitFieldTMS.class), (Type[])new Type[0]));
        mv.visitLdcInsn((Object)field.resolveAlias());
        if (BuildUtils.isPrimitive(fieldType)) {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(field.getTypeName()))));
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(field.getType())));
        }
        mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class)}));
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        if (BuildUtils.isPrimitive(fieldType)) {
            Label l0 = new Label();
            mv.visitJumpInsn(198, l0);
            mv.visitVarInsn(25, 1);
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(fieldType));
            mv.visitMethodInsn(184, BuildUtils.getInternalType(BuildUtils.box(fieldType)), "valueOf", Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(fieldType))), (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor(fieldType))}));
            mv.visitLabel(l1);
            mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fieldType)));
            mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fieldType)), BuildUtils.numericMorph(BuildUtils.box(fieldType)), Type.getMethodDescriptor((Type)Type.getType(field.getType()), (Type[])new Type[0]));
            mv.visitInsn(BuildUtils.returnType(fieldType));
        } else {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(fieldType));
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core) {
        this.buildHardGetter(cw, field, masterName, proxy, core, BuildUtils.getterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildHardGetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition proxy, ClassDefinition core, String getterName, boolean protect) {
        Class<?> fieldType = field.getType();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, getterName, "()" + Type.getDescriptor(fieldType), null, null);
        mv.visitCode();
        TraitFactory.invokeExtractor(mv, masterName, proxy, core, field);
        if (!BuildUtils.isPrimitive(field.getTypeName())) {
            mv.visitTypeInsn(192, Type.getInternalName(fieldType));
        }
        mv.visitInsn(BuildUtils.returnType(fieldType.getName()));
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core) {
        this.buildHardSetter(cw, field, masterName, trait, core, BuildUtils.setterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildHardSetter(ClassVisitor cw, FieldDefinition field, String masterName, ClassDefinition trait, ClassDefinition core, String setterName, boolean protect) {
        Class<?> fieldType = field.getType();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, setterName, "(" + Type.getDescriptor(field.getType()) + ")V", null, null);
        mv.visitCode();
        if (core.isFullTraiting()) {
            FieldDefinition hardField = core.getFieldByAlias(field.resolveAlias());
            if (!field.getType().isPrimitive() && !field.getTypeName().equals(hardField.getTypeName())) {
                boolean isCoreTrait = hardField.getType().getAnnotation(Trait.class) != null;
                boolean isTraitTrait = field.getType().getAnnotation(Trait.class) != null;
                Label l0 = new Label();
                mv.visitVarInsn(25, 1);
                mv.visitJumpInsn(198, l0);
                if (isCoreTrait && !isTraitTrait) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
                    mv.visitLdcInsn((Object)hardField.getTypeName());
                    mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "getTrait", Type.getMethodDescriptor((Type)Type.getType(Thing.class), (Type[])new Type[]{Type.getType(String.class)}));
                    mv.visitVarInsn(58, 1);
                } else if (!isCoreTrait && isTraitTrait) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, Type.getInternalName(TraitProxy.class));
                    mv.visitMethodInsn(182, Type.getInternalName(TraitProxy.class), "getObject", Type.getMethodDescriptor((Type)Type.getType(TraitableBean.class), (Type[])new Type[0]));
                    mv.visitVarInsn(58, 1);
                } else if (isCoreTrait && isTraitTrait) {
                    mv.visitVarInsn(25, 1);
                    mv.visitTypeInsn(192, Type.getInternalName(TraitProxy.class));
                    mv.visitMethodInsn(182, Type.getInternalName(TraitProxy.class), "getObject", Type.getMethodDescriptor((Type)Type.getType(TraitableBean.class), (Type[])new Type[0]));
                    mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
                    mv.visitLdcInsn((Object)hardField.getTypeName());
                    mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "getTrait", Type.getMethodDescriptor((Type)Type.getType(Thing.class), (Type[])new Type[]{Type.getType(String.class)}));
                    mv.visitVarInsn(58, 1);
                } else if (!hardField.getType().isAssignableFrom(field.getType())) {
                    mv.visitInsn(177);
                }
                Label l1 = new Label();
                mv.visitJumpInsn(167, l1);
                mv.visitLabel(l0);
                mv.visitInsn(1);
                mv.visitVarInsn(58, 1);
                mv.visitLabel(l1);
            } else if (field.getType().isPrimitive() && !hardField.getType().equals(field.getType())) {
                mv.visitInsn(177);
            }
        }
        TraitFactory.invokeInjector(mv, masterName, trait, core, field, false, 1);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSoftSetter(ClassVisitor cw, FieldDefinition field, String proxy, ClassDefinition trait, ClassDefinition core) {
        this.buildSoftSetter(cw, field, proxy, trait, core, BuildUtils.setterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildSoftSetter(ClassVisitor cw, FieldDefinition field, String proxy, ClassDefinition trait, ClassDefinition core, String setterName, boolean protect) {
        String fieldName = field.getName();
        String type = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, setterName, "(" + Type.getDescriptor(field.getType()) + ")V", null, null);
        mv.visitCode();
        if (core.isFullTraiting()) {
            this.logicalSetter(mv, field, proxy, this.trait, core, true);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)field.resolveAlias());
        mv.visitVarInsn(BuildUtils.varType(type), 1);
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.valueOf(mv, type);
        }
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "property", "(" + Type.getDescriptor(String.class) + Type.getDescriptor(Object.class) + ")" + Type.getDescriptor(Triple.class));
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "put", "(" + Type.getDescriptor(Triple.class) + ")Z");
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSoftGetter(ClassVisitor cw, FieldDefinition field, String proxy, ClassDefinition trait, ClassDefinition core) {
        this.buildSoftGetter(cw, field, proxy, trait, core, BuildUtils.getterName(field.getName(), field.getTypeName()), false);
    }

    protected void buildSoftGetter(ClassVisitor cw, FieldDefinition field, String proxy, ClassDefinition trait, ClassDefinition core, String getterName, boolean protect) {
        String fieldName = field.getName();
        String type = field.getTypeName();
        MethodVisitor mv = cw.visitMethod(protect ? 4 : 1, getterName, "()" + Type.getDescriptor(field.getType()), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxy), "store", Type.getDescriptor(TripleStore.class));
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)field.resolveAlias());
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "propertyKey", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(Triple.class));
        mv.visitMethodInsn(182, Type.getInternalName(TripleStore.class), "get", "(" + Type.getDescriptor(Triple.class) + ")" + Type.getDescriptor(Triple.class));
        String actualType = BuildUtils.isPrimitive(type) ? BuildUtils.box(type) : type;
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Triple.class), "getValue", "()" + Type.getDescriptor(Object.class));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(193, BuildUtils.getInternalType(actualType));
        Label l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, BuildUtils.getInternalType(actualType));
        if (BuildUtils.isPrimitive(type)) {
            TraitFactory.primitiveValue(mv, type);
            mv.visitInsn(BuildUtils.returnType(type));
            mv.visitLabel(l1);
            mv.visitInsn(BuildUtils.zero(type));
            mv.visitInsn(BuildUtils.returnType(type));
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(type));
            mv.visitInsn(BuildUtils.returnType(type));
        } else {
            mv.visitInsn(176);
            mv.visitLabel(l1);
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitLabel(l0);
            mv.visitInsn(1);
            mv.visitInsn(176);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    public void buildEqualityMethods(ClassVisitor cw, String proxy, String core) {
    }

    public void buildKeyedEqualityMethods(ClassVisitor cw, ClassDefinition trait, String proxy, String core) {
        String proxyType = BuildUtils.getInternalType(proxy);
        this.buildKeyedEquals(cw, trait, proxyType);
        this.buildKeyedHashCode(cw, trait, proxyType);
    }

    protected void buildKeyedEquals(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(" + Type.getDescriptor(Object.class) + ")Z", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(198, l1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", "()" + Type.getDescriptor(Class.class));
        Label l2 = new Label();
        mv.visitJumpInsn(165, l2);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, proxyType);
        mv.visitVarInsn(58, 2);
        int x = 2;
        int count = 0;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                Label l11 = new Label();
                mv.visitJumpInsn(198, l11);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "equals", "(" + Type.getDescriptor(Object.class) + ")Z");
                Label l12 = new Label();
                mv.visitJumpInsn(154, l12);
                Label l13 = new Label();
                mv.visitJumpInsn(167, l13);
                mv.visitLabel(l11);
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitJumpInsn(198, l12);
                mv.visitLabel(l13);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l12);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "compare", "(DD)I");
                Label l5 = new Label();
                mv.visitJumpInsn(153, l5);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l5);
                x = Math.max(x, 4);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "compare", "(FF)I");
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l6);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 2);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitInsn(148);
                Label l8 = new Label();
                mv.visitJumpInsn(153, l8);
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitLabel(l8);
                x = Math.max(x, 4);
                continue;
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
            Label l4 = new Label();
            mv.visitJumpInsn(159, l4);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l4);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildKeyedHashCode(ClassVisitor cw, ClassDefinition classDef, String proxyType) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitIntInsn(16, 31);
        mv.visitVarInsn(54, 1);
        int count = 0;
        int x = 2;
        int y = 2;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            if (!BuildUtils.isPrimitive(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                Label l8 = new Label();
                mv.visitJumpInsn(198, l8);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(field.getTypeName()), "hashCode", "()I");
                Label l9 = new Label();
                mv.visitJumpInsn(167, l9);
                mv.visitLabel(l8);
                mv.visitInsn(3);
                mv.visitLabel(l9);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("double".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitInsn(14);
                mv.visitInsn(151);
                Label l2 = new Label();
                mv.visitJumpInsn(153, l2);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "doubleToLongBits", "(D)J");
                Label l3 = new Label();
                mv.visitJumpInsn(167, l3);
                mv.visitLabel(l2);
                mv.visitInsn(9);
                mv.visitLabel(l3);
                mv.visitVarInsn(55, 2);
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(22, 2);
                mv.visitVarInsn(22, 2);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                y = Math.max(4, y);
                continue;
            }
            if ("boolean".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                Label l4 = new Label();
                mv.visitJumpInsn(153, l4);
                mv.visitInsn(4);
                Label l5 = new Label();
                mv.visitJumpInsn(167, l5);
                mv.visitLabel(l4);
                mv.visitInsn(3);
                mv.visitLabel(l5);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                continue;
            }
            if ("float".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitInsn(11);
                mv.visitInsn(149);
                Label l6 = new Label();
                mv.visitJumpInsn(153, l6);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToIntBits", "(F)I");
                Label l7 = new Label();
                mv.visitJumpInsn(167, l7);
                mv.visitLabel(l6);
                mv.visitInsn(3);
                mv.visitLabel(l7);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(3, x);
                continue;
            }
            if ("long".equals(field.getTypeName())) {
                mv.visitIntInsn(16, 31);
                mv.visitVarInsn(21, 1);
                mv.visitInsn(104);
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
                mv.visitInsn(96);
                mv.visitVarInsn(54, 1);
                x = Math.max(6, x);
                continue;
            }
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, proxyType, BuildUtils.getterName(field.getName(), field.getTypeName()), "()" + BuildUtils.getTypeDescriptor(field.getTypeName()));
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildCommonMethods(ClassWriter cw, String proxy) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()" + Type.getDescriptor(String.class), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitLdcInsn((Object)("(@" + proxy + ") : "));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxy), "getFields", "()" + Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "entrySet", "()" + Type.getDescriptor(Set.class));
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "toString", "()" + Type.getDescriptor(String.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(" + Type.getDescriptor(String.class) + ")" + Type.getDescriptor(StringBuilder.class));
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()" + Type.getDescriptor(String.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildExtendedMethods(ClassWriter cw, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        this.buildSynchFields(cw, TraitFactory.getProxyName(trait, core), trait, core, mask);
    }

    protected void buildSynchFields(ClassWriter cw, String proxyName, ClassDefinition trait, ClassDefinition core, BitSet mask) {
        MethodVisitor mv = cw.visitMethod(2, "synchFields", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.BOOLEAN_TYPE}), null, null);
        mv.visitCode();
        if (core.isFullTraiting()) {
            Iterator<FieldDefinition> iter = trait.getFieldsDefinitions().iterator();
            for (int j = 0; j < trait.getFieldsDefinitions().size(); ++j) {
                FieldDefinition fld = iter.next();
                boolean hardField = !TraitRegistry.isSoftField(fld, j, mask);
                this.synchFieldLogical(mv, fld, proxyName, trait, core, hardField, j + 3);
            }
        } else {
            for (FieldDefinition fld : trait.getFieldsDefinitions()) {
                if (fld.getInitExpr() == null) continue;
                this.synchField(mv, fld, proxyName);
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void synchField(MethodVisitor mv, FieldDefinition fld, String proxyName) {
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxyName), BuildUtils.getterName(fld.getName(), fld.getTypeName()), "()" + BuildUtils.getTypeDescriptor(fld.getTypeName()));
        Label l0 = null;
        if (!BuildUtils.isPrimitive(fld.getTypeName())) {
            l0 = new Label();
            mv.visitJumpInsn(199, l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)fld.getInitExpr());
        if (BuildUtils.isPrimitive(fld.getTypeName())) {
            mv.visitFieldInsn(178, BuildUtils.getInternalType(BuildUtils.box(fld.getTypeName())), "TYPE", Type.getDescriptor(Class.class));
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(fld.getTypeName())));
        }
        mv.visitMethodInsn(184, Type.getInternalName(MVEL.class), "eval", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class)}));
        if (BuildUtils.isPrimitive(fld.getTypeName())) {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fld.getTypeName())));
            mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fld.getTypeName())), BuildUtils.numericMorph(BuildUtils.box(fld.getTypeName())), "()" + BuildUtils.getTypeDescriptor(fld.getTypeName()));
        } else {
            mv.visitTypeInsn(192, BuildUtils.getInternalType(fld.getTypeName()));
        }
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxyName), BuildUtils.setterName(fld.getName(), fld.getTypeName()), "(" + BuildUtils.getTypeDescriptor(fld.getTypeName()) + ")" + Type.getDescriptor(Void.TYPE));
        if (!BuildUtils.isPrimitive(fld.getTypeName())) {
            mv.visitLabel(l0);
        }
    }

    protected void synchFieldLogical(MethodVisitor mv, FieldDefinition fld, String proxyName, ClassDefinition trait, ClassDefinition core, boolean hardField, int j) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxyName), "object", Type.getDescriptor(core.getDefinedClass()));
        mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
        mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "_getFieldTMS", Type.getMethodDescriptor((Type)Type.getType(TraitFieldTMS.class), (Type[])new Type[0]));
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitLdcInsn((Object)fld.resolveAlias());
        mv.visitVarInsn(25, 0);
        if (fld.getInitExpr() != null) {
            mv.visitLdcInsn((Object)fld.getInitExpr());
        } else {
            mv.visitInsn(1);
        }
        if (BuildUtils.isPrimitive(fld.getTypeName())) {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(fld.getTypeName()))));
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(fld.getType())));
        }
        mv.visitVarInsn(21, 1);
        mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "donField", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(TraitType.class), Type.getType(String.class), Type.getType(Class.class), Type.BOOLEAN_TYPE}));
        mv.visitVarInsn(58, j);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, j);
        if (BuildUtils.isPrimitive(fld.getTypeName())) {
            Label l0 = new Label();
            mv.visitJumpInsn(198, l0);
            mv.visitVarInsn(25, j);
            mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(fld.getTypeName())));
            mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(fld.getTypeName())), BuildUtils.numericMorph(BuildUtils.box(fld.getTypeName())), Type.getMethodDescriptor((Type)Type.getType(fld.getType()), (Type[])new Type[0]));
            Label l1 = new Label();
            mv.visitJumpInsn(167, l1);
            mv.visitLabel(l0);
            mv.visitInsn(BuildUtils.zero(fld.getTypeName()));
            mv.visitLabel(l1);
        } else {
            mv.visitTypeInsn(192, Type.getInternalName(fld.getType()));
        }
        mv.visitMethodInsn(182, BuildUtils.getInternalType(proxyName), BuildUtils.setterName(fld.getName(), fld.getTypeName()), "(" + BuildUtils.getTypeDescriptor(fld.getTypeName()) + ")" + Type.getDescriptor(Void.TYPE));
    }

    protected void shedField(MethodVisitor mv, FieldDefinition fld, String proxyName, ClassDefinition trait, ClassDefinition core, boolean hardField, int j) {
        FieldDefinition coreField = core.getFieldByAlias(fld.resolveAlias());
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType(proxyName), "object", Type.getDescriptor(core.getDefinedClass()));
        mv.visitTypeInsn(192, Type.getInternalName(TraitableBean.class));
        mv.visitMethodInsn(185, Type.getInternalName(TraitableBean.class), "_getFieldTMS", Type.getMethodDescriptor((Type)Type.getType(TraitFieldTMS.class), (Type[])new Type[0]));
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)fld.resolveAlias());
        mv.visitVarInsn(25, 0);
        if (BuildUtils.isPrimitive(fld.getTypeName())) {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(fld.getTypeName()))));
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(fld.getType())));
        }
        if (hardField) {
            if (BuildUtils.isPrimitive(coreField.getTypeName())) {
                mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor(BuildUtils.box(coreField.getTypeName()))));
            } else {
                mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(coreField.getType())));
            }
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)Type.getDescriptor(Object.class)));
        }
        mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "shedField", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(TraitType.class), Type.getType(Class.class), Type.getType(Class.class)}));
        mv.visitVarInsn(58, j);
        if (hardField) {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(proxyName), "object", Type.getDescriptor(core.getDefinedClass()));
            mv.visitVarInsn(25, j);
            if (BuildUtils.isPrimitive(coreField.getTypeName())) {
                Label l0 = new Label();
                mv.visitJumpInsn(198, l0);
                mv.visitVarInsn(25, j);
                mv.visitTypeInsn(192, BuildUtils.getInternalType(BuildUtils.box(coreField.getTypeName())));
                mv.visitMethodInsn(182, BuildUtils.getInternalType(BuildUtils.box(coreField.getTypeName())), BuildUtils.numericMorph(BuildUtils.box(coreField.getTypeName())), Type.getMethodDescriptor((Type)Type.getType(coreField.getType()), (Type[])new Type[0]));
                Label l1 = new Label();
                mv.visitJumpInsn(167, l1);
                mv.visitLabel(l0);
                mv.visitInsn(BuildUtils.zero(coreField.getTypeName()));
                mv.visitLabel(l1);
            } else {
                mv.visitTypeInsn(192, Type.getInternalName(coreField.getType()));
            }
            mv.visitMethodInsn(182, Type.getInternalName(core.getDefinedClass()), BuildUtils.setterName(coreField.getName(), coreField.getTypeName()), "(" + BuildUtils.getTypeDescriptor(coreField.getTypeName()) + ")" + Type.getDescriptor(Void.TYPE));
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType(proxyName), "map", Type.getDescriptor(Map.class));
            mv.visitLdcInsn((Object)fld.resolveAlias());
            mv.visitVarInsn(25, j);
            mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}));
        }
    }
}

