/*
 * Decompiled with CFR 0.152.
 */
package org.drools.games.adventures;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.swing.MigLayout;
import org.drools.games.adventures.Action;
import org.drools.games.adventures.GameEngine;
import org.drools.games.adventures.TextAdventure;
import org.drools.games.adventures.UserSession;
import org.kie.runtime.Channel;

public class AdventureFrame
extends JFrame {
    private final ToolTipListener toolTipListener = new ToolTipListener();
    private final ConstraintListener constraintListener = new ConstraintListener();
    private static final Font BUTT_FONT = new Font("monospaced", 0, 12);
    private JPanel contentPane;
    private JTextArea outputTextArea;
    private JComboBox characterSelectCombo;
    private JTextArea localEventsTextArea;
    private JTable exitsTable;
    private JTable thingsTable;
    private JTable inventoryTable;
    private JFormattedTextField cmdTextField;
    private JTextArea globalEventsTextArea;
    private GameEngine gameEngine;
    private UserSession session;
    private List cmd;

    public AdventureFrame(UserSession session, int onClose) {
        this.setDefaultCloseOperation(onClose);
        this.setBounds(100, 100, 1100, 787);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        JToolBar toolBar_1 = new JToolBar();
        toolBar_1.setAlignmentX(0.0f);
        this.contentPane.add(toolBar_1);
        JToggleButton newFrame = new JToggleButton("New Window");
        toolBar_1.add(newFrame);
        newFrame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextAdventure.createFrame(AdventureFrame.this.gameEngine, 2);
            }
        });
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.4);
        this.contentPane.add(splitPane);
        Component leftPanel = this.createEventsAndInvetoryPanel();
        splitPane.setLeftComponent(leftPanel);
        JPanel test = new JPanel();
        splitPane.setRightComponent(test);
        test.setLayout((LayoutManager)new MigLayout("", "[][][]", "[][grow, fill][][][][][fill][]"));
        this.createpOutputPanel(test);
        this.createCharacterPanel(test);
        this.createBuildActionsPanel(test);
        this.createSendCommandPanel(test);
        this.session = session;
    }

    public UserSession getSession() {
        return this.session;
    }

    public void setSession(UserSession session) {
        this.session = session;
    }

    public GameEngine getGameEngine() {
        return this.gameEngine;
    }

    public void setGameEngine(GameEngine gameEngine) {
        this.gameEngine = gameEngine;
    }

    public JTextArea getOutputTextArea() {
        return this.outputTextArea;
    }

    public JComboBox getCharacterSelectCombo() {
        return this.characterSelectCombo;
    }

    public JTextArea getLocalEventsTextArea() {
        return this.localEventsTextArea;
    }

    public JTable getExitsTable() {
        return this.exitsTable;
    }

    public JTable getThingsTable() {
        return this.thingsTable;
    }

    public JTable getInventoryTable() {
        return this.inventoryTable;
    }

    private Component createEventsAndInvetoryPanel() {
        JSplitPane leftSplitPanel = new JSplitPane();
        leftSplitPanel.setOrientation(0);
        leftSplitPanel.setDividerLocation(500);
        Component eventsPanel = this.createEventsPanel();
        leftSplitPanel.setLeftComponent(eventsPanel);
        Component inventoryPanel = this.createInventoryPanel();
        leftSplitPanel.setRightComponent(inventoryPanel);
        return leftSplitPanel;
    }

    private Component createEventsPanel() {
        JSplitPane splitPanel = new JSplitPane();
        splitPanel.setResizeWeight(0.4);
        splitPanel.setOrientation(0);
        splitPanel.setRightComponent(this.createGlobalEventsPanel());
        splitPanel.setLeftComponent(this.createLocalEventsPanel());
        return splitPanel;
    }

    private Component createGlobalEventsPanel() {
        JPanel globalEventsPanel = new JPanel();
        globalEventsPanel.setLayout(new BoxLayout(globalEventsPanel, 1));
        JLabel globalEventsLabel = new JLabel("Global Events");
        globalEventsPanel.add(globalEventsLabel);
        JScrollPane pane1 = this.createTextAreaScroll("", 20, 50, true, true);
        this.globalEventsTextArea = (JTextArea)((JViewport)pane1.getComponents()[0]).getComponents()[0];
        globalEventsPanel.add(pane1);
        return globalEventsPanel;
    }

    private Component createLocalEventsPanel() {
        JPanel localEventsPanel = new JPanel();
        localEventsPanel.setLayout(new BoxLayout(localEventsPanel, 1));
        JLabel localEventsLabel = new JLabel("Local Events");
        localEventsPanel.add(localEventsLabel);
        JTextArea ta = new JTextArea("", 20, 50);
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(ta, 20, 30);
        this.localEventsTextArea = (JTextArea)((JViewport)scroll.getComponents()[0]).getComponents()[0];
        localEventsPanel.add(scroll);
        return localEventsPanel;
    }

    private Component createInventoryPanel() {
        this.inventoryTable = new JTable();
        this.inventoryTable.setBorder(null);
        this.inventoryTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Inventory"}));
        this.inventoryTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AdventureFrame.this.cmd == null) {
                    return;
                }
                int row = AdventureFrame.this.inventoryTable.rowAtPoint(e.getPoint());
                int col = AdventureFrame.this.inventoryTable.columnAtPoint(e.getPoint());
                Object o = AdventureFrame.this.inventoryTable.getModel().getValueAt(row, col);
                AdventureFrame.this.cmdTextField.setText(AdventureFrame.this.cmdTextField.getText() + o.toString() + " ");
                AdventureFrame.this.cmd.add(o);
            }
        });
        JScrollPane inventoryPanel = new JScrollPane(this.inventoryTable);
        return inventoryPanel;
    }

    private void createpOutputPanel(JPanel parent) {
        parent.add((Component)this.createLabel("Output"), "wrap, spanx 3");
        JTextArea ta = new JTextArea("", 20, 50);
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(ta, 20, 30);
        this.outputTextArea = (JTextArea)((JViewport)scroll.getComponents()[0]).getComponents()[0];
        parent.add((Component)scroll, "wrap, span 3");
    }

    private void createCharacterPanel(JPanel parent) {
        parent.add((Component)this.createLabel("Character"), "wrap, spanx 3");
        this.characterSelectCombo = new JComboBox();
        this.characterSelectCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{null, null}));
        parent.add((Component)this.characterSelectCombo, "top, left");
        this.characterSelectCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.cmd = new ArrayList();
                AdventureFrame.this.cmd.add(Action.SELECT_CHARACTER);
                AdventureFrame.this.cmd.add(AdventureFrame.this.session);
                AdventureFrame.this.cmd.add(AdventureFrame.this.characterSelectCombo.getSelectedObjects()[0]);
                AdventureFrame.this.gameEngine.receiveMessage(AdventureFrame.this.session, AdventureFrame.this.cmd);
                AdventureFrame.this.cmd = null;
            }
        });
        JTable characterPropertiesTable = new JTable();
        characterPropertiesTable.setPreferredScrollableViewportSize(new Dimension(240, 200));
        characterPropertiesTable.setBorder(null);
        characterPropertiesTable.setModel(new DefaultTableModel(new Object[][]{{"strength", "100"}, {"health", "100"}, {"coiins", "100"}, {"speed", "100"}, {"mana", "100"}}, new String[]{"property", "value"}));
        JScrollPane characterPropertiesPanel = new JScrollPane(characterPropertiesTable);
        parent.add((Component)characterPropertiesPanel, "top, left, wrap, spanx 2");
    }

    private void createBuildActionsPanel(JPanel parent) {
        parent.add((Component)this.createLabel("Actions"), "wrap, spanx 3");
        JPanel actionsPanel = new JPanel();
        actionsPanel.setBorder(null);
        actionsPanel.setLayout(new BoxLayout(actionsPanel, 1));
        JButton moveBtn = new JButton("Move");
        actionsPanel.add(moveBtn);
        moveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.cmdTextField.setText("Move ");
                AdventureFrame.this.cmd = new ArrayList();
                AdventureFrame.this.cmd.add(Action.MOVE);
                AdventureFrame.this.cmd.add(AdventureFrame.this.characterSelectCombo.getSelectedObjects()[0]);
            }
        });
        JButton pickupBtn = new JButton("Pick Up");
        actionsPanel.add(pickupBtn);
        pickupBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.cmdTextField.setText("Pickup ");
                AdventureFrame.this.cmd = new ArrayList();
                AdventureFrame.this.cmd.add(Action.PICKUP);
                AdventureFrame.this.cmd.add(AdventureFrame.this.characterSelectCombo.getSelectedObjects()[0]);
            }
        });
        JButton dropBtn = new JButton("Drop");
        actionsPanel.add(dropBtn);
        dropBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.cmdTextField.setText("Drop ");
                AdventureFrame.this.cmd = new ArrayList();
                AdventureFrame.this.cmd.add(Action.DROP);
                AdventureFrame.this.cmd.add(AdventureFrame.this.characterSelectCombo.getSelectedObjects()[0]);
            }
        });
        JButton giveBtn = new JButton("Give");
        actionsPanel.add(giveBtn);
        giveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.cmdTextField.setText("Request Give ");
                AdventureFrame.this.cmd = new ArrayList();
                AdventureFrame.this.cmd.add(Action.GIVE);
                AdventureFrame.this.cmd.add(AdventureFrame.this.characterSelectCombo.getSelectedObjects()[0]);
            }
        });
        JButton lookBtn = new JButton("Look");
        actionsPanel.add(lookBtn);
        lookBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.cmdTextField.setText("Look ");
                AdventureFrame.this.cmd = new ArrayList();
                AdventureFrame.this.cmd.add(Action.LOOK);
                AdventureFrame.this.cmd.add(AdventureFrame.this.characterSelectCombo.getSelectedObjects()[0]);
            }
        });
        parent.add((Component)actionsPanel, "top, left");
        this.thingsTable = new JTable();
        this.thingsTable.setPreferredScrollableViewportSize(new Dimension(245, 250));
        this.thingsTable.setBorder(null);
        this.thingsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Items"}));
        this.thingsTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AdventureFrame.this.cmd == null) {
                    return;
                }
                int row = AdventureFrame.this.thingsTable.rowAtPoint(e.getPoint());
                int col = AdventureFrame.this.thingsTable.columnAtPoint(e.getPoint());
                Object o = AdventureFrame.this.thingsTable.getModel().getValueAt(row, col);
                AdventureFrame.this.cmdTextField.setText(AdventureFrame.this.cmdTextField.getText() + o.toString() + " ");
                AdventureFrame.this.cmd.add(o);
            }
        });
        JScrollPane itemsPanel = new JScrollPane(this.thingsTable);
        parent.add((Component)itemsPanel, "top, left");
        this.exitsTable = new JTable();
        this.exitsTable.setPreferredScrollableViewportSize(new Dimension(245, 250));
        this.exitsTable.setBorder(null);
        this.exitsTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Exits"}));
        this.exitsTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AdventureFrame.this.cmd == null) {
                    return;
                }
                int row = AdventureFrame.this.exitsTable.rowAtPoint(e.getPoint());
                int col = AdventureFrame.this.exitsTable.columnAtPoint(e.getPoint());
                Object o = AdventureFrame.this.exitsTable.getModel().getValueAt(row, col);
                AdventureFrame.this.cmdTextField.setText(AdventureFrame.this.cmdTextField.getText() + o.toString() + " ");
                AdventureFrame.this.cmd.add(o);
            }
        });
        JScrollPane exitsPanel = new JScrollPane(this.exitsTable);
        parent.add((Component)exitsPanel, "top, left, wrap");
    }

    public void createSendCommandPanel(JPanel parent) {
        this.cmdTextField = new JFormattedTextField();
        this.cmdTextField.setText("");
        parent.add((Component)this.cmdTextField, "growx, spanx 3, wrap");
        JToggleButton sendBtn = new JToggleButton("send");
        parent.add(sendBtn);
        sendBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdventureFrame.this.gameEngine.receiveMessage(AdventureFrame.this.session, AdventureFrame.this.cmd);
                AdventureFrame.this.cmd = null;
                AdventureFrame.this.cmdTextField.setText("");
            }
        });
    }

    private JLabel createLabel(String text) {
        return this.createLabel(text, 10);
    }

    private JLabel createLabel(String text, int align) {
        JLabel b = new JLabel(text, align);
        return b;
    }

    private JScrollPane createTextAreaScroll(String text, int rows, int cols, boolean hasVerScroll, boolean hasHorScroll) {
        JTextArea ta = new JTextArea(text, rows, cols);
        ta.setFont(UIManager.getFont("TextField.font"));
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        JScrollPane scroll = new JScrollPane(ta, hasVerScroll ? 20 : 21, hasHorScroll ? 30 : 31);
        return scroll;
    }

    public void handleRequestGive() {
        final JOptionPane pane = new JOptionPane("xxx msg");
        pane.setWantsInput(true);
        pane.setInputValue("");
        pane.setOptions(new String[]{"Yes", "No"});
        JInternalFrame internalFrame = pane.createInternalFrame(this.contentPane, "xxx title");
        internalFrame.setVisible(true);
        pane.show();
        internalFrame.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                System.out.println(pane.getInputValue() + ":" + pane.getValue());
            }

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }
        });
    }

    public static class JTableChannel
    implements Channel {
        private JTable jTable;

        public JTableChannel(JTable exitsTable) {
            this.jTable = exitsTable;
        }

        @Override
        public void send(Object object) {
            DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
            List list = (List)object;
            if (model.getRowCount() < list.size()) {
                int i;
                Object[][] exits = new Object[list.size()][];
                int length = model.getRowCount();
                for (i = 0; i < length; ++i) {
                    model.setValueAt(list.get(i), i, 0);
                }
                length = exits.length;
                for (i = model.getRowCount(); i < length; ++i) {
                    model.addRow(new Object[]{list.get(i)});
                }
            } else {
                int i;
                Object[][] exits = new Object[list.size()][];
                for (i = 0; i < exits.length; ++i) {
                    model.setValueAt(list.get(i), i, 0);
                }
                i = exits.length;
                while (model.getRowCount() > exits.length) {
                    model.removeRow(i);
                }
            }
        }
    }

    public static class JComboBoxChannel
    implements Channel {
        private JComboBox jcomboBox;

        public JComboBoxChannel(JComboBox jcomboBox) {
            this.jcomboBox = jcomboBox;
        }

        @Override
        public void send(Object object) {
            List list = (List)object;
            this.jcomboBox.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        }
    }

    public static class JTextAreaChannel
    implements Channel {
        private JTextArea textArea;

        public JTextAreaChannel(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void send(Object object) {
            this.textArea.append(object.toString() + "\n");
            JScrollPane scrollPane = (JScrollPane)((JViewport)this.textArea.getParent()).getParent();
        }
    }

    private static class ConstraintsDialog
    extends JDialog
    implements ActionListener,
    KeyEventDispatcher {
        private static final Color ERROR_COLOR = new Color(255, 180, 180);
        private final JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fillx,flowy,ins dialog", "[fill]", "2[]2"));
        final JTextField layoutConstrTF;
        final JTextField rowsConstrTF;
        final JTextField colsConstrTF;
        final JTextField componentConstrTF;
        private final JButton okButt = new JButton("OK");
        private final JButton cancelButt = new JButton("Cancel");
        private boolean okPressed = false;

        public ConstraintsDialog(Frame owner, String layoutConstr, String rowsConstr, String colsConstr, String compConstr) {
            super(owner, compConstr != null ? "Edit Component Constraints" : "Edit Container Constraints", true);
            this.layoutConstrTF = this.createConstraintField(layoutConstr);
            this.rowsConstrTF = this.createConstraintField(rowsConstr);
            this.colsConstrTF = this.createConstraintField(colsConstr);
            this.componentConstrTF = this.createConstraintField(compConstr);
            if (this.componentConstrTF != null) {
                this.mainPanel.add(new JLabel("Component Constraints"));
                this.mainPanel.add(this.componentConstrTF);
            }
            if (this.layoutConstrTF != null) {
                this.mainPanel.add(new JLabel("Layout Constraints"));
                this.mainPanel.add(this.layoutConstrTF);
            }
            if (this.colsConstrTF != null) {
                this.mainPanel.add((Component)new JLabel("Column Constraints"), "gaptop unrel");
                this.mainPanel.add(this.colsConstrTF);
            }
            if (this.rowsConstrTF != null) {
                this.mainPanel.add((Component)new JLabel("Row Constraints"), "gaptop unrel");
                this.mainPanel.add(this.rowsConstrTF);
            }
            this.mainPanel.add((Component)this.okButt, "tag ok,split,flowx,gaptop 15");
            this.mainPanel.add((Component)this.cancelButt, "tag cancel,gaptop 15");
            this.setContentPane(this.mainPanel);
            this.okButt.addActionListener(this);
            this.cancelButt.addActionListener(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        }

        @Override
        public void removeNotify() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            super.removeNotify();
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                this.dispose();
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.okButt) {
                this.okPressed = true;
            }
            this.dispose();
        }

        private JTextField createConstraintField(String text) {
            if (text == null) {
                return null;
            }
            final JTextField tf = new JTextField(text, 50);
            tf.setFont(new Font("monospaced", 0, 12));
            tf.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        ConstraintsDialog.this.okButt.doClick();
                        return;
                    }
                    Timer timer = new Timer(50, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String constr = tf.getText();
                            try {
                                if (tf == ConstraintsDialog.this.layoutConstrTF) {
                                    ConstraintParser.parseLayoutConstraint((String)constr);
                                } else if (tf == ConstraintsDialog.this.rowsConstrTF) {
                                    ConstraintParser.parseRowConstraints((String)constr);
                                } else if (tf == ConstraintsDialog.this.colsConstrTF) {
                                    ConstraintParser.parseColumnConstraints((String)constr);
                                } else if (tf == ConstraintsDialog.this.componentConstrTF) {
                                    ConstraintParser.parseComponentConstraint((String)constr);
                                }
                                tf.setBackground(Color.WHITE);
                                ConstraintsDialog.this.okButt.setEnabled(true);
                            }
                            catch (Exception ex) {
                                tf.setBackground(ERROR_COLOR);
                                ConstraintsDialog.this.okButt.setEnabled(false);
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            });
            return tf;
        }

        private boolean showDialog() {
            this.setVisible(true);
            return this.okPressed;
        }
    }

    private static class ToolTipListener
    extends MouseMotionAdapter {
        private ToolTipListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Object constr;
            JComponent c = (JComponent)e.getSource();
            LayoutManager lm = c.getParent().getLayout();
            if (lm instanceof MigLayout && (constr = ((MigLayout)lm).getComponentConstraints((Component)c)) instanceof String) {
                c.setToolTipText(constr != null ? "\"" + constr + "\"" : "null");
            }
        }
    }

    private class ConstraintListener
    extends MouseAdapter {
        private ConstraintListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.react(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.react(e);
            }
        }

        public void react(MouseEvent e) {
            JComponent c = (JComponent)e.getSource();
            LayoutManager lm = c.getParent().getLayout();
            if (!(lm instanceof MigLayout)) {
                lm = c.getLayout();
            }
            if (lm instanceof MigLayout) {
                Object compConstr;
                MigLayout layout = (MigLayout)lm;
                boolean isComp = layout.isManagingComponent((Component)c);
                Object object = compConstr = isComp ? layout.getComponentConstraints((Component)c) : null;
                if (isComp && compConstr == null) {
                    compConstr = "";
                }
                Object rowsConstr = isComp ? null : layout.getRowConstraints();
                Object colsConstr = isComp ? null : layout.getColumnConstraints();
                Object layoutConstr = isComp ? null : layout.getLayoutConstraints();
                ConstraintsDialog cDlg = new ConstraintsDialog(AdventureFrame.this, (String)layoutConstr, (String)rowsConstr, (String)colsConstr, (String)compConstr);
                cDlg.pack();
                cDlg.setLocationRelativeTo(c);
                if (cDlg.showDialog()) {
                    try {
                        if (isComp) {
                            String constrStr = cDlg.componentConstrTF.getText().trim();
                            layout.setComponentConstraints((Component)c, (Object)constrStr);
                            if (c instanceof JButton) {
                                c.setFont(BUTT_FONT);
                                ((JButton)c).setText(constrStr.length() == 0 ? "<Empty>" : constrStr);
                            }
                        } else {
                            layout.setLayoutConstraints((Object)cDlg.layoutConstrTF.getText());
                            layout.setRowConstraints((Object)cDlg.rowsConstrTF.getText());
                            layout.setColumnConstraints((Object)cDlg.colsConstrTF.getText());
                        }
                    }
                    catch (Exception ex) {
                        StringWriter sw = new StringWriter();
                        ex.printStackTrace(new PrintWriter(sw));
                        JOptionPane.showMessageDialog(SwingUtilities.getWindowAncestor(c), sw.toString(), "Error parsing Constraint!", 0);
                        return;
                    }
                    c.invalidate();
                    c.getParent().validate();
                }
            }
        }
    }
}

