/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorCache;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.mvel2.util.Soundex;

public class SoundslikeEvaluatorsDefinition
implements EvaluatorDefinition {
    public static final Operator SOUNDSLIKE = Operator.addOperatorToRegistry("soundslike", false);
    public static final Operator NOT_SOUNDSLIKE = Operator.addOperatorToRegistry("soundslike", true);
    private static final String[] SUPPORTED_IDS = new String[]{SOUNDSLIKE.getOperatorString()};
    private EvaluatorCache evaluators = new EvaluatorCache(){
        private static final long serialVersionUID = 510L;
        {
            this.addEvaluator(ValueType.STRING_TYPE, SOUNDSLIKE, StringSoundsLikeEvaluator.INSTANCE);
            this.addEvaluator(ValueType.STRING_TYPE, NOT_SOUNDSLIKE, StringNotSoundsLikeEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, SOUNDSLIKE, StringSoundsLikeEvaluator.INSTANCE);
            this.addEvaluator(ValueType.OBJECT_TYPE, NOT_SOUNDSLIKE, StringNotSoundsLikeEvaluator.INSTANCE);
        }
    };

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluators = (EvaluatorCache)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluators);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.evaluators.getEvaluator(type, operator);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        return this.evaluators.getEvaluator(type, Operator.determineOperator(operatorId, isNegated));
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return this.evaluators.supportsType(type);
    }

    private static boolean soundslike(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return false;
        }
        String soundex1 = Soundex.soundex((String)value1);
        String soundex2 = Soundex.soundex((String)value2);
        if (soundex1 == null) {
            return false;
        }
        return soundex1.equals(soundex2);
    }

    public static class StringNotSoundsLikeEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new StringNotSoundsLikeEvaluator();

        public StringNotSoundsLikeEvaluator() {
            super(ValueType.STRING_TYPE, NOT_SOUNDSLIKE);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue object2) {
            String value2;
            String value1 = (String)extractor.getValue(workingMemory, handle1.getObject());
            return !SoundslikeEvaluatorsDefinition.soundslike(value1, value2 = (String)object2.getValue());
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return !SoundslikeEvaluatorsDefinition.soundslike(value, (String)context.declaration.getExtractor().getValue(workingMemory, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            String value = (String)context.extractor.getValue(workingMemory, right.getObject());
            return !SoundslikeEvaluatorsDefinition.soundslike(value, (String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handl1, InternalReadAccessor extractor2, InternalFactHandle handl2) {
            Object value2;
            Object value1 = extractor1.getValue(workingMemory, handl1.getObject());
            return !SoundslikeEvaluatorsDefinition.soundslike((String)value1, (String)(value2 = extractor2.getValue(workingMemory, handl2.getObject())));
        }

        @Override
        public String toString() {
            return "Strings not sound alike";
        }
    }

    public static class StringSoundsLikeEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        public static final Evaluator INSTANCE = new StringSoundsLikeEvaluator();

        public StringSoundsLikeEvaluator() {
            super(ValueType.STRING_TYPE, SOUNDSLIKE);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle handle1, FieldValue handle2) {
            String value1 = (String)extractor.getValue(workingMemory, handle1.getObject());
            String value2 = (String)handle2.getValue();
            return SoundslikeEvaluatorsDefinition.soundslike(value1, value2);
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            String value = (String)((VariableRestriction.ObjectVariableContextEntry)context).right;
            return SoundslikeEvaluatorsDefinition.soundslike(value, (String)context.declaration.getExtractor().getValue(workingMemory, left.getObject()));
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle rightHandle) {
            String value = (String)context.extractor.getValue(workingMemory, rightHandle.getObject());
            return SoundslikeEvaluatorsDefinition.soundslike(value, (String)((VariableRestriction.ObjectVariableContextEntry)context).left);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            Object value1 = extractor1.getValue(workingMemory, handle1.getObject());
            Object value2 = extractor2.getValue(workingMemory, handle2.getObject());
            return SoundslikeEvaluatorsDefinition.soundslike((String)value1, (String)value2);
        }

        @Override
        public String toString() {
            return "Strings sound alike";
        }
    }
}

