/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.base.DroolsQuery;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.UpdateContext;
import org.drools.reteoo.AbstractTerminalNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.NodeSet;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public class QueryTerminalNode
extends AbstractTerminalNode
implements LeftTupleSinkNode {
    private static final long serialVersionUID = 510L;
    public static final short type = 8;
    private Query query;
    private GroupElement subrule;
    private int subruleIndex;
    private Declaration[] declarations;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private transient ObjectTypeNode.Id leftInputOtnId;

    public QueryTerminalNode() {
    }

    public QueryTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, int subruleIndex, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source);
        this.query = (Query)rule;
        this.subrule = subrule;
        this.subruleIndex = subruleIndex;
        this.initDeclaredMask(context);
        this.initInferredMask();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.query = (Query)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.subruleIndex = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.query);
        out.writeObject(this.subrule);
        out.writeInt(this.subruleIndex);
    }

    public Rule getRule() {
        return this.query;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowAdded(this.query, leftTuple, context, workingMemory);
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowRemoved(this.query, leftTuple, context, workingMemory);
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery(this.query);
        query.getQueryResultCollector().rowUpdated(this.query, leftTuple, context, workingMemory);
    }

    @Override
    public String toString() {
        return "[QueryTerminalNode(" + this.getId() + "): query=" + this.query.getName() + "]";
    }

    @Override
    public void attach(BuildContext context) {
        this.getLeftTupleSource().addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.getLeftTupleSource().updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.getLeftTupleSource().networkUpdated(updateContext);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        this.getLeftTupleSource().removeTupleSink(this);
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.getLeftTupleSource().collectAncestors(nodeSet);
    }

    @Override
    public boolean isInUse() {
        return false;
    }

    public void updateNewNode(InternalWorkingMemory workingMemory, PropagationContext context) {
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public GroupElement getSubrule() {
        return this.subrule;
    }

    public Declaration[] getDeclarations() {
        if (this.declarations == null) {
            this.declarations = new Declaration[this.query.getParameters().length];
            Map<String, Declaration> declMap = this.subrule.getOuterDeclarations();
            int i = 0;
            for (Declaration declr : this.query.getParameters()) {
                this.declarations[i++] = declMap.get(declr.getIdentifier());
            }
        }
        return this.declarations;
    }

    public int getSubruleIndex() {
        return this.subruleIndex;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public short getType() {
        return 91;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new RuleTerminalNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public ObjectTypeNode.Id getLeftInputOtnId() {
        return this.leftInputOtnId;
    }

    @Override
    public void setLeftInputOtnId(ObjectTypeNode.Id leftInputOtnId) {
        this.leftInputOtnId = leftInputOtnId;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        return null;
    }
}

