/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.extractors;

import java.lang.reflect.Method;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseClassFieldWriter;
import org.drools.base.ValueType;

public abstract class BaseShortClassFieldWriter
extends BaseClassFieldWriter {
    private static final long serialVersionUID = 510L;

    public BaseShortClassFieldWriter(Class<?> clazz, String fieldName) {
        super(clazz, fieldName);
    }

    protected BaseShortClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    @Override
    public void setValue(Object bean, Object value) {
        this.setShortValue(bean, value == null ? (short)0 : ((Number)value).shortValue());
    }

    @Override
    public void setBooleanValue(Object bean, boolean value) {
        throw new RuntimeDroolsException("Conversion to short not supported from boolean");
    }

    @Override
    public void setByteValue(Object bean, byte value) {
        this.setShortValue(bean, value);
    }

    @Override
    public void setCharValue(Object bean, char value) {
        throw new RuntimeDroolsException("Conversion to short not supported from char");
    }

    @Override
    public void setDoubleValue(Object bean, double value) {
        this.setShortValue(bean, (short)value);
    }

    @Override
    public void setFloatValue(Object bean, float value) {
        this.setShortValue(bean, (short)value);
    }

    @Override
    public void setIntValue(Object bean, int value) {
        this.setShortValue(bean, (short)value);
    }

    @Override
    public void setLongValue(Object bean, long value) {
        this.setShortValue(bean, (short)value);
    }

    @Override
    public abstract void setShortValue(Object var1, short var2);

    @Override
    public Method getNativeWriteMethod() {
        try {
            return this.getClass().getDeclaredMethod("setShortValue", Object.class, Short.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }
}

