/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import org.drools.beliefsystem.BeliefSystem;
import org.drools.beliefsystem.jtms.JTMSBeliefSystem;
import org.drools.beliefsystem.simple.SimpleBeliefSystem;
import org.drools.common.NamedEntryPoint;
import org.drools.common.TruthMaintenanceSystem;

public enum BeliefSystemType {
    SIMPLE("simple"){

        @Override
        public BeliefSystem createInstance(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
            return new SimpleBeliefSystem(ep, tms);
        }
    }
    ,
    JTMS("jtms"){

        @Override
        public BeliefSystem createInstance(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
            return new JTMSBeliefSystem(ep, tms);
        }
    };

    private String string;

    public abstract BeliefSystem createInstance(NamedEntryPoint var1, TruthMaintenanceSystem var2);

    private BeliefSystemType(String string2) {
        this.string = string2;
    }

    public String toExternalForm() {
        return this.string;
    }

    public String toString() {
        return this.string;
    }

    public String getId() {
        return this.string;
    }

    public static BeliefSystemType resolveBeliefSystemType(String id) {
        if (SIMPLE.getId().equalsIgnoreCase(id)) {
            return SIMPLE;
        }
        if (JTMS.getId().equalsIgnoreCase(id)) {
            return JTMS;
        }
        throw new IllegalArgumentException("Illegal enum value '" + id + "' for BeliefSystem");
    }
}

