/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.kie.runtime.rule.AccumulateFunction;

public class AverageAccumulateFunction
implements AccumulateFunction {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public Serializable createContext() {
        return new AverageData();
    }

    @Override
    public void init(Serializable context) throws Exception {
        AverageData data = (AverageData)context;
        data.count = 0;
        data.total = 0.0;
    }

    @Override
    public void accumulate(Serializable context, Object value) {
        AverageData data = (AverageData)context;
        ++data.count;
        data.total += ((Number)value).doubleValue();
    }

    @Override
    public void reverse(Serializable context, Object value) throws Exception {
        AverageData data = (AverageData)context;
        --data.count;
        data.total -= ((Number)value).doubleValue();
    }

    @Override
    public Object getResult(Serializable context) throws Exception {
        AverageData data = (AverageData)context;
        return new Double(data.count == 0 ? 0.0 : data.total / (double)data.count);
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    public static class AverageData
    implements Externalizable {
        public int count = 0;
        public double total = 0.0;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.count = in.readInt();
            this.total = in.readDouble();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.count);
            out.writeDouble(this.total);
        }
    }
}

