/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.FactException;
import org.drools.beliefsystem.BeliefSet;
import org.drools.beliefsystem.BeliefSystem;
import org.drools.common.AbstractWorkingMemory;
import org.drools.common.EqualityKey;
import org.drools.common.EqualityKeyComparator;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.LogicalDependency;
import org.drools.common.NamedEntryPoint;
import org.drools.common.WorkingMemoryAction;
import org.drools.core.util.ObjectHashMap;
import org.drools.impl.StatefulKnowledgeSessionImpl;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.PersisterHelper;
import org.drools.marshalling.impl.ProtobufMessages;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.PropagationContext;

public class TruthMaintenanceSystem {
    private AbstractWorkingMemory wm;
    private NamedEntryPoint ep;
    private ObjectHashMap equalityKeyMap;
    private BeliefSystem beliefSystem;

    public TruthMaintenanceSystem() {
    }

    public TruthMaintenanceSystem(AbstractWorkingMemory wm, NamedEntryPoint ep) {
        this.wm = wm;
        this.equalityKeyMap = new ObjectHashMap();
        this.equalityKeyMap.setComparator(EqualityKeyComparator.getInstance());
        this.beliefSystem = wm.getSessionConfiguration().getBeliefSystemType().createInstance(ep, this);
    }

    public ObjectHashMap getEqualityKeyMap() {
        return this.equalityKeyMap;
    }

    public Object put(EqualityKey key) {
        return this.equalityKeyMap.put(key, key, false);
    }

    public EqualityKey get(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.get(key);
    }

    public EqualityKey get(Object object) {
        return (EqualityKey)this.equalityKeyMap.get(object);
    }

    public EqualityKey remove(EqualityKey key) {
        return (EqualityKey)this.equalityKeyMap.remove(key);
    }

    public void readLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, Rule rule, ObjectTypeConf typeConf) throws FactException {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, true);
    }

    public void addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, Rule rule, ObjectTypeConf typeConf) throws FactException {
        this.addLogicalDependency(handle, object, value, activation, context, rule, typeConf, false);
    }

    public void addLogicalDependency(InternalFactHandle handle, Object object, Object value, Activation activation, PropagationContext context, Rule rule, ObjectTypeConf typeConf, boolean read) throws FactException {
        BeliefSet beliefSet = handle.getEqualityKey().getBeliefSet();
        if (beliefSet == null) {
            if (context.getType() == 2) {
                // empty if block
            }
            beliefSet = this.beliefSystem.newBeliefSet(handle);
            handle.getEqualityKey().setBeliefSet(beliefSet);
        }
        LogicalDependency node = this.beliefSystem.newLogicalDependency(activation, beliefSet, object, value);
        activation.getRule().setHasLogicalDependency(true);
        activation.addLogicalDependency(node);
        if (read) {
            this.beliefSystem.read(node, beliefSet, context, typeConf);
        } else {
            this.beliefSystem.insert(node, beliefSet, context, typeConf);
        }
    }

    public void clear() {
        this.equalityKeyMap.clear();
    }

    public BeliefSystem getBeliefSystem() {
        return this.beliefSystem;
    }

    public static class LogicalCallback
    implements WorkingMemoryAction {
        private InternalFactHandle handle;
        private PropagationContext context;
        private Activation activation;
        private boolean update;
        private boolean fullyRetract;

        public LogicalCallback() {
        }

        public LogicalCallback(InternalFactHandle handle, PropagationContext context, Activation activation, boolean update, boolean fullyRetract) {
            this.handle = handle;
            this.context = context;
            this.activation = activation;
            this.update = update;
            this.fullyRetract = fullyRetract;
        }

        public LogicalCallback(MarshallerReaderContext context) throws IOException {
            this.handle = context.handles.get(context.readInt());
            this.context = context.propagationContexts.get(context.readLong());
            this.activation = (Activation)context.terminalTupleMap.get(context.readInt()).getObject();
        }

        public LogicalCallback(MarshallerReaderContext context, ProtobufMessages.ActionQueue.Action _action) {
            ProtobufMessages.ActionQueue.LogicalRetract _retract = _action.getLogicalRetract();
            this.handle = context.handles.get(_retract.getHandleId());
            this.activation = (Activation)context.filter.getTuplesCache().get(PersisterHelper.createActivationKey(_retract.getActivation().getPackageName(), _retract.getActivation().getRuleName(), _retract.getActivation().getTuple())).getObject();
            this.context = this.activation.getPropagationContext();
            this.fullyRetract = _retract.getFullyRetract();
            this.update = _retract.getUpdate();
        }

        @Override
        public void write(MarshallerWriteContext context) throws IOException {
            context.writeShort(4);
            context.writeInt(this.handle.getId());
            context.writeLong(this.context.getPropagationNumber());
            context.writeInt(context.terminalTupleMap.get(this.activation.getTuple()));
        }

        @Override
        public ProtobufMessages.ActionQueue.Action serialize(MarshallerWriteContext context) {
            ProtobufMessages.ActionQueue.LogicalRetract _retract = ProtobufMessages.ActionQueue.LogicalRetract.newBuilder().setHandleId(this.handle.getId()).setActivation(PersisterHelper.createActivation(this.activation.getRule().getPackageName(), this.activation.getRule().getName(), this.activation.getTuple())).setFullyRetract(this.fullyRetract).setUpdate(this.update).build();
            return ProtobufMessages.ActionQueue.Action.newBuilder().setType(ProtobufMessages.ActionQueue.ActionType.LOGICAL_RETRACT).setLogicalRetract(_retract).build();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.activation = (Activation)in.readObject();
            this.fullyRetract = in.readBoolean();
            this.update = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
            out.writeObject(this.activation);
            out.writeBoolean(this.fullyRetract);
            out.writeBoolean(this.update);
        }

        public boolean isUpdate() {
            return this.update;
        }

        public void setUpdate(boolean update) {
            this.update = update;
        }

        public boolean isFullyRetract() {
            return this.fullyRetract;
        }

        public void setFullyRetract(boolean fullyRetract) {
            this.fullyRetract = fullyRetract;
        }

        @Override
        public void execute(InternalWorkingMemory workingMemory) {
            NamedEntryPoint nep = (NamedEntryPoint)this.handle.getEntryPoint();
            BeliefSet bs = this.handle.getEqualityKey().getBeliefSet();
            bs.setWorkingMemoryAction(null);
            if (this.update) {
                if (!bs.isEmpty()) {
                    ((NamedEntryPoint)this.handle.getEntryPoint()).update(this.handle, true, this.handle.getObject(), Long.MAX_VALUE, null);
                }
            } else if (this.fullyRetract) {
                ((NamedEntryPoint)this.handle.getEntryPoint()).delete(this.handle, this.context.getRuleOrigin(), this.activation);
            } else {
                ObjectTypeConf typeConf = nep.getObjectTypeConfigurationRegistry().getObjectTypeConf(nep.getEntryPoint(), this.handle.getObject());
                ((NamedEntryPoint)this.handle.getEntryPoint()).getEntryPointNode().retractObject(this.handle, this.context, typeConf, workingMemory);
            }
        }

        @Override
        public void execute(InternalKnowledgeRuntime kruntime) {
            this.execute(((StatefulKnowledgeSessionImpl)kruntime).getInternalWorkingMemory());
        }
    }
}

