/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.xml.rules;

import org.drools.lang.descr.ConnectiveDescr;
import org.drools.lang.descr.ExprConstraintDescr;
import org.drools.lang.descr.PatternDescr;
import org.drools.lang.descr.RestrictionConnectiveDescr;
import org.drools.xml.BaseAbstractHandler;
import org.drools.xml.ExtensibleXmlParser;
import org.drools.xml.Handler;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RestrictionConnectiveHandler
extends BaseAbstractHandler
implements Handler {
    public static final String AND = "and-";
    public static final String OR = "or-";

    @Override
    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        if (localName.startsWith(OR)) {
            return new ConnectiveDescr(ConnectiveDescr.RestrictionConnectiveType.OR);
        }
        if (localName.startsWith(AND)) {
            return new ConnectiveDescr(ConnectiveDescr.RestrictionConnectiveType.AND);
        }
        throw new SAXParseException("<" + localName + "> should have'", parser.getLocator());
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Object op = parser.getParent();
        ConnectiveDescr c = (ConnectiveDescr)parser.getCurrent();
        if (op instanceof PatternDescr) {
            StringBuilder sb = new StringBuilder();
            c.buildExpression(sb);
            ExprConstraintDescr expr = new ExprConstraintDescr();
            expr.setExpression(sb.toString());
            PatternDescr patternDescr = (PatternDescr)op;
            patternDescr.addConstraint(expr);
        } else {
            ConnectiveDescr p = (ConnectiveDescr)op;
            p.add(c);
        }
        return c;
    }

    public Class generateNodeFor() {
        return RestrictionConnectiveDescr.class;
    }
}

