/*
 * Decompiled with CFR 0.152.
 */
package org.drools.definitions.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.drools.definitions.rule.impl.GlobalImpl;
import org.drools.definitions.rule.impl.RuleImpl;
import org.drools.rule.Function;
import org.drools.rule.Package;
import org.drools.rule.Query;
import org.kie.definition.KnowledgePackage;
import org.kie.definition.process.Process;
import org.kie.definition.rule.Global;
import org.kie.definition.rule.Rule;
import org.kie.definition.type.FactType;

public class KnowledgePackageImp
implements KnowledgePackage,
Externalizable {
    public Package pkg;

    public KnowledgePackageImp() {
        this.pkg = null;
    }

    public KnowledgePackageImp(Package pkg) {
        this.pkg = pkg;
    }

    @Override
    public String getName() {
        return this.pkg.getName();
    }

    @Override
    public Collection<Rule> getRules() {
        org.drools.rule.Rule[] rules = this.pkg.getRules();
        ArrayList<RuleImpl> list = new ArrayList<RuleImpl>(rules.length);
        for (org.drools.rule.Rule rule : rules) {
            list.add(new RuleImpl(rule));
        }
        return Collections.unmodifiableCollection(list);
    }

    public Rule getRule(String name) {
        return this.pkg.getRule(name);
    }

    public void removeRule(org.drools.rule.Rule rule) {
        this.pkg.removeRule(rule);
    }

    public Function getFunction(String name) {
        return this.pkg.getFunctions().containsKey(name) ? this.pkg.getFunctions().get(name) : null;
    }

    public void removeFunction(String functionName) {
        this.pkg.removeFunction(functionName);
    }

    @Override
    public Collection<Process> getProcesses() {
        Collection<Process> processes = this.pkg.getRuleFlows().values();
        ArrayList<Process> list = new ArrayList<Process>(processes.size());
        for (Process process : processes) {
            list.add(process);
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<FactType> getFactTypes() {
        ArrayList<FactType> list = new ArrayList<FactType>(this.pkg.getFactTypes().size());
        for (Map.Entry<String, FactType> entry : this.pkg.getFactTypes().entrySet()) {
            if (entry.getValue().getName() == null) continue;
            list.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<org.kie.definition.rule.Query> getQueries() {
        org.drools.rule.Rule[] rules = this.pkg.getRules();
        ArrayList<RuleImpl> list = new ArrayList<RuleImpl>(rules.length);
        for (org.drools.rule.Rule rule : rules) {
            if (!(rule instanceof Query)) continue;
            list.add(new RuleImpl(rule));
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Collection<String> getFunctionNames() {
        return Collections.unmodifiableCollection(this.pkg.getFunctions().keySet());
    }

    @Override
    public Collection<Global> getGlobalVariables() {
        ArrayList<GlobalImpl> list = new ArrayList<GlobalImpl>(this.pkg.getGlobals().size());
        for (Map.Entry<String, String> global : this.pkg.getGlobals().entrySet()) {
            list.add(new GlobalImpl(global.getKey(), global.getValue()));
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pkg = new Package();
        this.pkg.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.pkg.writeExternal(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgePackageImp that = (KnowledgePackageImp)o;
        if (this.pkg == null || that.pkg == null) {
            return false;
        }
        return this.pkg == that.pkg;
    }

    public int hashCode() {
        return this.pkg != null ? this.pkg.hashCode() : 0;
    }

    public String toString() {
        return this.pkg != null ? this.pkg.toString() : "[EMPTY PACKAGE]";
    }
}

