/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.ConditionalElement;
import org.drools.rule.Declaration;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;

public class Collect
extends ConditionalElement
implements PatternSource {
    private static final long serialVersionUID = 510L;
    private Pattern sourcePattern;
    private Pattern resultPattern;
    private Class<Collection<Object>> cls;

    public Collect() {
    }

    public Collect(Pattern sourcePattern, Pattern resultPattern) {
        this.sourcePattern = sourcePattern;
        this.resultPattern = resultPattern;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sourcePattern = (Pattern)in.readObject();
        this.resultPattern = (Pattern)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sourcePattern);
        out.writeObject(this.resultPattern);
    }

    @Override
    public Collect clone() {
        PatternSource source = this.resultPattern.getSource();
        if (source == this) {
            this.resultPattern.setSource(null);
        }
        Pattern clonedResultPattern = this.resultPattern.clone();
        Collect collect = new Collect(this.sourcePattern.clone(), clonedResultPattern);
        collect.getResultPattern().setSource(collect);
        if (source == this) {
            this.resultPattern.setSource(this);
        }
        return collect;
    }

    public Pattern getResultPattern() {
        return this.resultPattern;
    }

    public Pattern getSourcePattern() {
        return this.sourcePattern;
    }

    public Collection<Object> instantiateResultObject(InternalWorkingMemory wm) throws RuntimeDroolsException {
        try {
            if (this.cls == null) {
                ClassObjectType objType = (ClassObjectType)this.resultPattern.getObjectType();
                String className = this.determineResultClassName(objType);
                this.cls = Class.forName(className, true, ((InternalRuleBase)wm.getRuleBase()).getRootClassLoader());
            }
            return this.cls.newInstance();
        }
        catch (ClassCastException cce) {
            throw new RuntimeDroolsException("Collect CE requires a Collection implementation as return type", cce);
        }
        catch (InstantiationException e) {
            throw new RuntimeDroolsException("Collect CE requires a non-argument constructor for the return type", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeDroolsException("Collect CE requires an accessible constructor for the return type", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Collect CE could not resolve return result class '" + ((ClassObjectType)this.resultPattern.getObjectType()).getClassName() + "'", e);
        }
    }

    private String determineResultClassName(ClassObjectType objType) {
        String className = objType.getClassName();
        if (List.class.getName().equals(className)) {
            className = ArrayList.class.getName();
        } else if (Set.class.getName().equals(className)) {
            className = HashSet.class.getName();
        } else if (Collection.class.getName().equals(className)) {
            className = ArrayList.class.getName();
        }
        return className;
    }

    public Map getInnerDeclarations() {
        return this.sourcePattern.getInnerDeclarations();
    }

    public Map getOuterDeclarations() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.sourcePattern.getInnerDeclarations().get(identifier);
    }

    public List getNestedElements() {
        return Collections.singletonList(this.sourcePattern);
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }
}

