/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.File;
import org.drools.audit.KnowledgeRuntimeLoggerProviderImpl;
import org.drools.command.impl.CommandFactoryServiceImpl;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.drools.concurrent.ExecutorProviderImpl;
import org.drools.io.impl.ResourceFactoryServiceImpl;
import org.drools.kproject.ReleaseIdImpl;
import org.drools.kproject.models.KieModuleModelImpl;
import org.drools.marshalling.impl.MarshallerProviderImpl;
import org.kie.KieServices;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieRepository;
import org.kie.builder.KieScanner;
import org.kie.builder.ReleaseId;
import org.kie.builder.impl.ClasspathKieProject;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.InternalKieScanner;
import org.kie.builder.impl.KieBuilderImpl;
import org.kie.builder.impl.KieContainerImpl;
import org.kie.builder.impl.KieFileSystemImpl;
import org.kie.builder.impl.KieModuleKieProject;
import org.kie.builder.impl.KieRepositoryImpl;
import org.kie.builder.model.KieModuleModel;
import org.kie.command.KieCommands;
import org.kie.concurrent.KieExecutors;
import org.kie.internal.utils.ServiceRegistryImpl;
import org.kie.io.KieResources;
import org.kie.io.ResourceFactoryService;
import org.kie.logger.KieLoggers;
import org.kie.marshalling.KieMarshallers;
import org.kie.persistence.jpa.KieStoreServices;
import org.kie.runtime.KieContainer;

public class KieServicesImpl
implements KieServices {
    private ResourceFactoryService resourceFactory;
    private volatile KieContainerImpl classpathKContainer;
    private final Object lock = new Object();

    public ResourceFactoryService getResourceFactory() {
        if (this.resourceFactory == null) {
            this.resourceFactory = new ResourceFactoryServiceImpl();
        }
        return this.resourceFactory;
    }

    @Override
    public KieRepository getRepository() {
        return KieRepositoryImpl.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieContainer getKieClasspathContainer() {
        if (this.classpathKContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classpathKContainer == null) {
                    this.classpathKContainer = new KieContainerImpl(new ClasspathKieProject(), null);
                }
            }
        }
        return this.classpathKContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullKieClasspathContainer() {
        Object object = this.lock;
        synchronized (object) {
            this.classpathKContainer = null;
        }
    }

    @Override
    public KieContainer newKieContainer(ReleaseId releaseId) {
        InternalKieModule kieModule = (InternalKieModule)this.getRepository().getKieModule(releaseId);
        if (kieModule == null) {
            throw new RuntimeException("Cannot find KieModule: " + releaseId);
        }
        KieModuleKieProject kProject = new KieModuleKieProject(kieModule, this.getRepository());
        return new KieContainerImpl(kProject, this.getRepository());
    }

    @Override
    public KieBuilder newKieBuilder(File file) {
        return file.isDirectory() ? new KieBuilderImpl(file) : this.newKieBuilder(new KieFileSystemImpl(MemoryFileSystem.readFromJar(file)));
    }

    @Override
    public KieBuilder newKieBuilder(KieFileSystem kieFileSystem) {
        return new KieBuilderImpl(kieFileSystem);
    }

    @Override
    public KieScanner newKieScanner(KieContainer kieContainer) {
        InternalKieScanner scanner = (InternalKieScanner)ServiceRegistryImpl.getInstance().get(KieScanner.class);
        scanner.setKieContainer(kieContainer);
        return scanner;
    }

    @Override
    public KieResources getResources() {
        return new ResourceFactoryServiceImpl();
    }

    @Override
    public KieCommands getCommands() {
        return new CommandFactoryServiceImpl();
    }

    @Override
    public KieMarshallers getMarshallers() {
        return new MarshallerProviderImpl();
    }

    @Override
    public KieLoggers getLoggers() {
        return new KnowledgeRuntimeLoggerProviderImpl();
    }

    public KieExecutors getExecutors() {
        return new ExecutorProviderImpl();
    }

    @Override
    public KieStoreServices getStoreServices() {
        return ServiceRegistryImpl.getInstance().get(KieStoreServices.class);
    }

    @Override
    public ReleaseId newReleaseId(String groupId, String artifactId, String version) {
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    @Override
    public KieModuleModel newKieModuleModel() {
        return new KieModuleModelImpl();
    }

    @Override
    public KieFileSystem newKieFileSystem() {
        return new KieFileSystemImpl();
    }
}

