/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.runtime.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.command.IdentifiableResult;
import org.drools.command.impl.GenericCommand;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.runtime.impl.ExecutionResultImpl;
import org.drools.xml.jaxb.util.JaxbMapAdapter;
import org.kie.command.Context;
import org.kie.runtime.StatefulKnowledgeSession;
import org.kie.runtime.process.ProcessInstance;

@XmlAccessorType(value=XmlAccessType.NONE)
public class CreateProcessInstanceCommand
implements GenericCommand<ProcessInstance>,
IdentifiableResult {
    @XmlAttribute(required=true)
    private String processId;
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="parameter")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @XmlElementWrapper(name="data")
    private List<Object> data = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;

    public CreateProcessInstanceCommand() {
    }

    public CreateProcessInstanceCommand(String processId) {
        this.processId = processId;
    }

    public CreateProcessInstanceCommand(String processId, String outIdentifier) {
        this(processId);
        this.outIdentifier = outIdentifier;
    }

    public CreateProcessInstanceCommand(String processId, Map<String, Object> parameters) {
        this(processId);
        this.parameters = parameters;
    }

    public CreateProcessInstanceCommand(String processId, Map<String, Object> parameters, String outIdentifier) {
        this(processId, outIdentifier);
        this.parameters = parameters;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters != null ? new HashMap<String, Object>(parameters) : new HashMap<String, Object>();
    }

    public void putParameter(String key, Object value) {
        this.getParameters().put(key, value);
    }

    public List<Object> getData() {
        return this.data;
    }

    public void setData(List<Object> data) {
        this.data = data;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public ProcessInstance execute(Context context) {
        StatefulKnowledgeSession ksession = ((KnowledgeCommandContext)context).getStatefulKnowledgesession();
        if (this.data != null) {
            for (Object o : this.data) {
                ksession.insert(o);
            }
        }
        ProcessInstance processInstance = ksession.createProcessInstance(this.processId, this.parameters);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((KnowledgeCommandContext)context).getExecutionResults()).getResults().put(this.outIdentifier, processInstance.getId());
        }
        return processInstance;
    }

    public String toString() {
        String result = "session.createProcessInstance(" + this.processId + ", [";
        if (this.parameters != null) {
            int i = 0;
            for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
                if (i++ > 0) {
                    result = result + ", ";
                }
                result = result + entry.getKey() + "=" + entry.getValue();
            }
        }
        result = result + "]);";
        return result;
    }
}

