/*
 * Decompiled with CFR 0.152.
 */
package org.drools.management;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.drools.common.InternalWorkingMemory;
import org.drools.management.KieSessionMonitoringImpl;
import org.drools.management.KnowledgeBaseMonitoring;
import org.drools.reteoo.ReteooRuleBase;
import org.kie.management.KieManagementAgentMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsManagementAgent
implements KieManagementAgentMBean {
    private static final String MBEAN_NAME = "org.drools:type=DroolsManagementAgent";
    private static DroolsManagementAgent INSTANCE;
    private static MBeanServer mbs;
    protected static final transient Logger logger;
    private long kbases = 0L;
    private long ksessions = 0L;
    private Map<Object, List<ObjectName>> mbeans = new HashMap<Object, List<ObjectName>>();

    private DroolsManagementAgent() {
    }

    public static synchronized DroolsManagementAgent getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DroolsManagementAgent();
            try {
                MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
                ObjectName mbName = DroolsManagementAgent.createObjectName(MBEAN_NAME);
                if (!mbs.isRegistered(mbName)) {
                    StandardMBean adapter = new StandardMBean(INSTANCE, KieManagementAgentMBean.class);
                    mbs.registerMBean(adapter, mbName);
                }
            }
            catch (Exception e) {
                logger.error("Unable to register DroolsManagementAgent into the platform MBean Server", (Throwable)e);
            }
        }
        return INSTANCE;
    }

    public synchronized long getKieBaseCount() {
        return this.kbases;
    }

    public synchronized long getSessionCount() {
        return this.ksessions;
    }

    public synchronized long getNextKnowledgeBaseId() {
        return ++this.kbases;
    }

    public synchronized long getNextKnowledgeSessionId() {
        return ++this.ksessions;
    }

    public void registerKnowledgeBase(ReteooRuleBase kbase) {
        KnowledgeBaseMonitoring mbean = new KnowledgeBaseMonitoring(kbase);
        this.registerMBean(kbase, mbean, mbean.getName());
    }

    public void registerKnowledgeSession(InternalWorkingMemory ksession) {
        KieSessionMonitoringImpl mbean = new KieSessionMonitoringImpl(ksession);
        this.registerMBean(ksession, mbean, mbean.getName());
    }

    public void unregisterKnowledgeSession(InternalWorkingMemory ksession) {
        this.unregisterMBeansFromOwner(ksession);
    }

    public void registerMBean(Object owner, Object mbean, ObjectName name) {
        try {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(mbean, name);
                List<ObjectName> mbl = this.mbeans.get(owner);
                if (mbl == null) {
                    mbl = new LinkedList<ObjectName>();
                    this.mbeans.put(owner, mbl);
                }
                mbl.add(name);
            }
        }
        catch (Exception e) {
            logger.error("Unable to register mbean " + name + " into the platform MBean Server", (Throwable)e);
        }
    }

    public void unregisterMBeansFromOwner(Object owner) {
        List<ObjectName> mbl = this.mbeans.remove(owner);
        if (mbl != null) {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            for (ObjectName name : mbl) {
                this.unregisterMBeanFromServer(mbs, name);
            }
        }
    }

    private void unregisterMBeanFromServer(MBeanServer mbs, ObjectName name) {
        try {
            mbs.unregisterMBean(name);
        }
        catch (Exception e) {
            logger.error("Exception unregistering mbean: " + name, (Throwable)e);
        }
    }

    public void unregisterMBean(Object owner, ObjectName mbean) {
        List<ObjectName> mbl = this.mbeans.get(owner);
        if (mbl != null) {
            mbl.remove(mbean);
        }
        MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
        this.unregisterMBeanFromServer(mbs, mbean);
    }

    public void unregisterDependentsMBeansFromOwner(Object owner) {
        List<ObjectName> mbl = this.mbeans.get(owner);
        if (mbl != null) {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            for (ObjectName name : mbl.subList(1, mbl.size())) {
                this.unregisterMBeanFromServer(mbs, name);
            }
            mbl.subList(1, mbl.size()).clear();
        }
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            logger.error("This is a bug. Error creating ObjectName for MBean: " + name + "\nPlease contact the development team and provide the following stack trace: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static MBeanServer getMBeanServer() {
        if (mbs == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return mbs;
    }

    static {
        logger = LoggerFactory.getLogger(DroolsManagementAgent.class);
    }
}

