/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa.processinstance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.WorkItemHandlerNotFoundException;
import org.drools.common.InternalKnowledgeRuntime;
import org.drools.common.InternalRuleBase;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.PersistenceContextManager;
import org.drools.persistence.info.WorkItemInfo;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.kie.runtime.Environment;
import org.kie.runtime.process.ProcessInstance;
import org.kie.runtime.process.WorkItemHandler;

public class JPAWorkItemManager
implements WorkItemManager {
    private InternalKnowledgeRuntime kruntime;
    private Map<String, WorkItemHandler> workItemHandlers = new HashMap<String, WorkItemHandler>();
    private transient Map<Long, WorkItemInfo> workItems;

    public JPAWorkItemManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    @Override
    public void internalExecuteWorkItem(WorkItem workItem) {
        Environment env = this.kruntime.getEnvironment();
        WorkItemInfo workItemInfo = new WorkItemInfo(workItem, env);
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        context.persist(workItemInfo);
        ((WorkItemImpl)workItem).setId(workItemInfo.getId());
        workItemInfo.update();
        if (this.workItems == null) {
            this.workItems = new HashMap<Long, WorkItemInfo>();
        }
        this.workItems.put(workItem.getId(), workItemInfo);
        WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
        if (handler != null) {
            handler.executeWorkItem((org.kie.runtime.process.WorkItem)workItem, (org.kie.runtime.process.WorkItemManager)this);
        } else {
            this.throwWorkItemNotFoundException(workItem);
        }
    }

    private void throwWorkItemNotFoundException(WorkItem workItem) {
        throw new WorkItemHandlerNotFoundException("Could not find work item handler for " + workItem.getName(), workItem.getName());
    }

    @Override
    public void internalAbortWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = context.findWorkItemInfo(id);
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)this.internalGetWorkItem(workItemInfo);
            WorkItemHandler handler = this.workItemHandlers.get(workItem.getName());
            if (handler != null) {
                handler.abortWorkItem((org.kie.runtime.process.WorkItem)workItem, (org.kie.runtime.process.WorkItemManager)this);
            } else if (this.workItems != null) {
                this.workItems.remove(id);
                this.throwWorkItemNotFoundException(workItem);
            }
            if (this.workItems != null) {
                this.workItems.remove(id);
            }
            context.remove(workItemInfo);
        }
    }

    @Override
    public void internalAddWorkItem(WorkItem workItem) {
    }

    public void completeWorkItem(long id, Map<String, Object> results) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null && (workItemInfo = this.workItems.get(id)) != null) {
            workItemInfo = context.merge(workItemInfo);
        }
        if (workItemInfo == null) {
            workItemInfo = context.findWorkItemInfo(id);
        }
        if (workItemInfo != null) {
            WorkItem workItem = this.internalGetWorkItem(workItemInfo);
            workItem.setResults(results);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(2);
            if (processInstance != null) {
                processInstance.signalEvent("workItemCompleted", (Object)workItem);
            }
            context.remove(workItemInfo);
            if (this.workItems != null) {
                this.workItems.remove(workItem.getId());
            }
        }
    }

    public void abortWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null && (workItemInfo = this.workItems.get(id)) != null) {
            workItemInfo = context.merge(workItemInfo);
        }
        if (workItemInfo == null) {
            workItemInfo = context.findWorkItemInfo(id);
        }
        if (workItemInfo != null) {
            WorkItemImpl workItem = (WorkItemImpl)this.internalGetWorkItem(workItemInfo);
            ProcessInstance processInstance = this.kruntime.getProcessInstance(workItem.getProcessInstanceId());
            workItem.setState(3);
            if (processInstance != null) {
                processInstance.signalEvent("workItemAborted", (Object)workItem);
            }
            context.remove(workItemInfo);
            if (this.workItems != null) {
                this.workItems.remove(workItem.getId());
            }
        }
    }

    @Override
    public WorkItem getWorkItem(long id) {
        Environment env = this.kruntime.getEnvironment();
        PersistenceContext context = ((PersistenceContextManager)env.get("org.kie.persistence.PersistenceContextManager")).getCommandScopedPersistenceContext();
        WorkItemInfo workItemInfo = null;
        if (this.workItems != null) {
            workItemInfo = this.workItems.get(id);
        }
        if (workItemInfo == null && context != null) {
            workItemInfo = context.findWorkItemInfo(id);
        }
        if (workItemInfo == null) {
            return null;
        }
        return this.internalGetWorkItem(workItemInfo);
    }

    private WorkItem internalGetWorkItem(WorkItemInfo workItemInfo) {
        Environment env = this.kruntime.getEnvironment();
        InternalRuleBase ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kruntime.getKieBase()).getRuleBase();
        WorkItem workItem = workItemInfo.getWorkItem(env, ruleBase);
        return workItem;
    }

    @Override
    public Set<WorkItem> getWorkItems() {
        return new HashSet<WorkItem>();
    }

    public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
        this.workItemHandlers.put(workItemName, handler);
    }

    public void clearWorkItems() {
        if (this.workItems != null) {
            this.workItems.clear();
        }
    }

    @Override
    public void clear() {
        this.clearWorkItems();
    }
}

