/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.drools.RuntimeDroolsException;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.MutableTypeConstraint;
import org.drools.spi.CompiledInvoker;
import org.drools.spi.Evaluator;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.PredicateExpression;
import org.drools.spi.Restriction;
import org.drools.spi.Wireable;

public class PredicateConstraint
extends MutableTypeConstraint
implements Restriction,
Wireable,
Externalizable {
    private static final long serialVersionUID = 510L;
    private PredicateExpression expression;
    private Declaration[] requiredDeclarations;
    private Declaration[] previousDeclarations;
    private Declaration[] localDeclarations;
    private String[] requiredGlobals;
    private String[] requiredOperators;
    private List<PredicateConstraint> cloned = Collections.emptyList();
    private static final Declaration[] EMPTY_DECLARATIONS = new Declaration[0];
    private static final String[] EMPTY_STRINGS = new String[0];

    public PredicateConstraint() {
        this(null);
    }

    public PredicateConstraint(PredicateExpression evaluator) {
        this(evaluator, null, null, null, null);
    }

    public PredicateConstraint(Declaration[] previousDeclarations, Declaration[] localDeclarations) {
        this(null, previousDeclarations, localDeclarations, null, null);
    }

    public PredicateConstraint(PredicateExpression expression, Declaration[] previousDeclarations, Declaration[] localDeclarations, String[] requiredGlobals, String[] requiredOperators) {
        this.expression = expression;
        this.previousDeclarations = previousDeclarations == null ? EMPTY_DECLARATIONS : previousDeclarations;
        this.localDeclarations = localDeclarations == null ? EMPTY_DECLARATIONS : localDeclarations;
        this.requiredGlobals = requiredGlobals == null ? EMPTY_STRINGS : requiredGlobals;
        this.requiredOperators = requiredOperators == null ? EMPTY_STRINGS : requiredOperators;
        this.requiredDeclarations = new Declaration[this.previousDeclarations.length + this.localDeclarations.length];
        System.arraycopy(this.previousDeclarations, 0, this.requiredDeclarations, 0, this.previousDeclarations.length);
        System.arraycopy(this.localDeclarations, 0, this.requiredDeclarations, this.previousDeclarations.length, this.localDeclarations.length);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.expression = (PredicateExpression)in.readObject();
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.previousDeclarations = (Declaration[])in.readObject();
        this.localDeclarations = (Declaration[])in.readObject();
        this.requiredGlobals = (String[])in.readObject();
        this.requiredOperators = (String[])in.readObject();
        this.cloned = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.expression instanceof CompiledInvoker) {
            out.writeObject(null);
        } else {
            out.writeObject(this.expression);
        }
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.previousDeclarations);
        out.writeObject(this.localDeclarations);
        out.writeObject(this.requiredGlobals);
        out.writeObject(this.requiredOperators);
        out.writeObject(this.cloned);
    }

    @Override
    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public Declaration[] getPreviousDeclarations() {
        return this.previousDeclarations;
    }

    public Declaration[] getLocalDeclarations() {
        return this.localDeclarations;
    }

    public String[] getGlobals() {
        return this.requiredGlobals;
    }

    public String[] getOperators() {
        return this.requiredOperators;
    }

    @Override
    public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        int i;
        for (i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(oldDecl)) continue;
            this.requiredDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.previousDeclarations.length; ++i) {
            if (!this.previousDeclarations[i].equals(oldDecl)) continue;
            this.previousDeclarations[i] = newDecl;
        }
        for (i = 0; i < this.localDeclarations.length; ++i) {
            if (!this.localDeclarations[i].equals(oldDecl)) continue;
            this.localDeclarations[i] = newDecl;
        }
    }

    @Override
    public void wire(Object object) {
        this.setPredicateExpression((PredicateExpression)object);
        for (PredicateConstraint clone : this.cloned) {
            clone.wire(object);
        }
    }

    public void setPredicateExpression(PredicateExpression expression) {
        this.expression = expression;
    }

    public PredicateExpression getPredicateExpression() {
        return this.expression;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    public String toString() {
        return "[PredicateConstraint previousDeclarations=" + this.previousDeclarations + " localDeclarations=" + this.localDeclarations + "]";
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean equals(Object object) {
        int i;
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != PredicateConstraint.class) {
            return false;
        }
        PredicateConstraint other = (PredicateConstraint)object;
        if (this.previousDeclarations.length != other.previousDeclarations.length) {
            return false;
        }
        if (this.localDeclarations.length != other.localDeclarations.length) {
            return false;
        }
        if (this.requiredGlobals.length != other.requiredGlobals.length) {
            return false;
        }
        if (this.requiredOperators.length != other.requiredOperators.length) {
            return false;
        }
        int length = this.previousDeclarations.length;
        for (i = 0; i < length; ++i) {
            if (this.previousDeclarations[i].getPattern().getOffset() != other.previousDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.previousDeclarations[i].getExtractor().equals(other.previousDeclarations[i].getExtractor())) continue;
            return false;
        }
        length = this.localDeclarations.length;
        for (i = 0; i < length; ++i) {
            if (this.localDeclarations[i].getPattern().getOffset() != other.localDeclarations[i].getPattern().getOffset()) {
                return false;
            }
            if (this.localDeclarations[i].getExtractor().equals(other.localDeclarations[i].getExtractor())) continue;
            return false;
        }
        if (!Arrays.equals(this.requiredGlobals, other.requiredGlobals)) {
            return false;
        }
        if (!Arrays.equals(this.requiredOperators, other.requiredOperators)) {
            return false;
        }
        return this.expression.equals(other.expression);
    }

    @Override
    public ContextEntry createContextEntry() {
        PredicateContextEntry ctx = new PredicateContextEntry();
        ctx.dialectContext = this.expression.createContext();
        return ctx;
    }

    @Override
    public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry ctx) {
        try {
            return this.expression.evaluate(handle.getObject(), null, this.previousDeclarations, this.localDeclarations, workingMemory, ((PredicateContextEntry)ctx).dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    @Override
    public boolean isAllowed(InternalReadAccessor extractor, InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
        throw new UnsupportedOperationException("Method not supported. Please contact development team.");
    }

    @Override
    public boolean isAllowedCachedLeft(ContextEntry context, InternalFactHandle handle) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(handle.getObject(), ctx.leftTuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    @Override
    public boolean isAllowedCachedRight(LeftTuple tuple, ContextEntry context) {
        try {
            PredicateContextEntry ctx = (PredicateContextEntry)context;
            return this.expression.evaluate(ctx.rightObject, tuple, this.previousDeclarations, this.localDeclarations, ctx.workingMemory, ctx.dialectContext);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("Exception executing predicate " + this.expression, e);
        }
    }

    @Override
    public PredicateConstraint clone() {
        Declaration[] previous = new Declaration[this.previousDeclarations.length];
        for (int i = 0; i < previous.length; ++i) {
            previous[i] = this.previousDeclarations[i].clone();
        }
        Declaration[] local = new Declaration[this.localDeclarations.length];
        for (int i = 0; i < local.length; ++i) {
            local[i] = this.localDeclarations[i].clone();
        }
        PredicateConstraint clone = new PredicateConstraint(this.expression, previous, local, this.requiredGlobals, this.requiredOperators);
        if (this.cloned == Collections.EMPTY_LIST) {
            this.cloned = new ArrayList<PredicateConstraint>(1);
        }
        this.cloned.add(clone);
        return clone;
    }

    @Override
    public Evaluator getEvaluator() {
        return null;
    }

    public static class PredicateContextEntry
    implements ContextEntry {
        private static final long serialVersionUID = 510L;
        public LeftTuple leftTuple;
        public Object rightObject;
        public InternalWorkingMemory workingMemory;
        public Object dialectContext;
        private ContextEntry entry;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (LeftTuple)in.readObject();
            this.rightObject = in.readObject();
            this.workingMemory = (InternalWorkingMemory)in.readObject();
            this.dialectContext = in.readObject();
            this.entry = (ContextEntry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.rightObject);
            out.writeObject(this.workingMemory);
            out.writeObject(this.dialectContext);
            out.writeObject(this.entry);
        }

        @Override
        public ContextEntry getNext() {
            return this.entry;
        }

        @Override
        public void setNext(ContextEntry entry) {
            this.entry = entry;
        }

        @Override
        public void updateFromFactHandle(InternalWorkingMemory workingMemory, InternalFactHandle handle) {
            this.workingMemory = workingMemory;
            this.rightObject = handle.getObject();
        }

        @Override
        public void updateFromTuple(InternalWorkingMemory workingMemory, LeftTuple tuple) {
            this.workingMemory = workingMemory;
            this.leftTuple = tuple;
        }

        @Override
        public void resetTuple() {
            this.leftTuple = null;
        }

        @Override
        public void resetFactHandle() {
            this.rightObject = null;
        }
    }
}

