/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule.builder;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.ClassObjectType;
import org.drools.base.DroolsQuery;
import org.drools.base.extractors.ArrayElementReader;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.compiler.DescrBuildError;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.index.IndexUtil;
import org.drools.lang.descr.QueryDescr;
import org.drools.rule.ContextEntry;
import org.drools.rule.Declaration;
import org.drools.rule.IndexableConstraint;
import org.drools.rule.Pattern;
import org.drools.rule.Query;
import org.drools.rule.builder.EngineElementBuilder;
import org.drools.rule.builder.PatternBuilder;
import org.drools.rule.builder.RuleBuildContext;
import org.drools.spi.AcceptsReadAccessor;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.Constraint;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class QueryBuilder
implements EngineElementBuilder {
    public Pattern build(RuleBuildContext context, QueryDescr queryDescr) {
        ClassObjectType queryObjectType = ClassObjectType.DroolsQuery_ObjectType;
        Pattern pattern = new Pattern(context.getNextPatternId(), 0, queryObjectType, null);
        InternalReadAccessor extractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, queryObjectType, "name", null, true);
        QueryNameConstraint constraint = new QueryNameConstraint(extractor, queryDescr.getName());
        PatternBuilder.registerReadAccessor(context, queryObjectType, "name", constraint);
        pattern.addConstraint(constraint);
        ClassObjectType argsObjectType = ClassObjectType.DroolsQuery_ObjectType;
        InternalReadAccessor arrayExtractor = PatternBuilder.getFieldReadAccessor(context, queryDescr, argsObjectType, "elements", null, true);
        String[] params = queryDescr.getParameters();
        String[] types = queryDescr.getParameterTypes();
        int i = 0;
        Declaration[] declarations = new Declaration[params.length];
        try {
            for (i = 0; i < params.length; ++i) {
                Declaration declr = pattern.addDeclaration(params[i]);
                ArrayElementReader reader = new ArrayElementReader(arrayExtractor, i, context.getDialect().getTypeResolver().resolveType(types[i]));
                PatternBuilder.registerReadAccessor(context, argsObjectType, "elements", reader);
                declr.setReadAccessor(reader);
                declarations[i] = declr;
            }
            ((Query)context.getRule()).setParameters(declarations);
        }
        catch (ClassNotFoundException e) {
            context.addError(new DescrBuildError(context.getParentDescr(), queryDescr, e, "Unable to resolve type '" + types[i] + " for parameter" + params[i]));
        }
        return pattern;
    }

    public static class QueryNameConstraint
    implements AlphaNodeFieldConstraint,
    IndexableConstraint,
    AcceptsReadAccessor,
    Externalizable {
        private InternalReadAccessor readAccessor;
        private String queryName;

        public QueryNameConstraint() {
        }

        public QueryNameConstraint(InternalReadAccessor readAccessor, String queryName) {
            this.readAccessor = readAccessor;
            this.queryName = queryName;
        }

        @Override
        public ContextEntry createContextEntry() {
            return null;
        }

        @Override
        public boolean isAllowed(InternalFactHandle handle, InternalWorkingMemory workingMemory, ContextEntry context) {
            return ((DroolsQuery)handle.getObject()).getName().equals(this.queryName);
        }

        @Override
        public boolean isUnification() {
            return false;
        }

        @Override
        public boolean isIndexable(short nodeType) {
            return true;
        }

        @Override
        public IndexUtil.ConstraintType getConstraintType() {
            return IndexUtil.ConstraintType.EQUAL;
        }

        @Override
        public FieldValue getField() {
            return null;
        }

        @Override
        public AbstractHashTable.FieldIndex getFieldIndex() {
            return null;
        }

        @Override
        public InternalReadAccessor getFieldExtractor() {
            return this.readAccessor;
        }

        @Override
        public void setReadAccessor(InternalReadAccessor readAccessor) {
            this.readAccessor = readAccessor;
        }

        @Override
        public Declaration[] getRequiredDeclarations() {
            return new Declaration[0];
        }

        @Override
        public void replaceDeclaration(Declaration oldDecl, Declaration newDecl) {
        }

        @Override
        public Constraint clone() {
            return new QueryNameConstraint(this.readAccessor, this.queryName);
        }

        @Override
        public Constraint.ConstraintType getType() {
            return Constraint.ConstraintType.ALPHA;
        }

        @Override
        public boolean isTemporal() {
            return false;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.readAccessor = (InternalReadAccessor)in.readObject();
            this.queryName = (String)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.readAccessor);
            out.writeObject(this.queryName);
        }

        public int hashCode() {
            return this.queryName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof QueryNameConstraint && this.queryName.equals(((QueryNameConstraint)obj).queryName);
        }

        public String toString() {
            return "QueryNameConstraint for " + this.queryName;
        }
    }
}

