/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.extractors.BaseDateClassFieldReader;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.ClassUtils;
import org.drools.facttemplates.Fact;
import org.drools.spi.AcceptsClassObjectType;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ObjectType;

public class GlobalExtractor
extends BaseDateClassFieldReader
implements InternalReadAccessor,
AcceptsClassObjectType,
Externalizable {
    private static final long serialVersionUID = 510L;
    private ObjectType objectType;
    private String identifier;

    public GlobalExtractor() {
    }

    public GlobalExtractor(String identifier, ObjectType objectType) {
        super(-1, (Class)((ClassObjectType)objectType).getClassType(), objectType.getValueType());
        this.identifier = identifier;
        this.objectType = objectType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.identifier = in.readUTF();
        this.objectType = (ObjectType)in.readObject();
        this.setIndex(-1);
        this.setFieldType(((ClassObjectType)this.objectType).getClassType());
        this.setValueType(this.objectType.getValueType());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.identifier);
        out.writeObject(this.objectType);
    }

    @Override
    public void setClassObjectType(ClassObjectType objectType) {
        this.objectType = objectType;
        this.setIndex(-1);
        this.setFieldType(objectType.getClassType());
        this.setValueType(objectType.getValueType());
    }

    @Override
    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return workingMemory.getGlobal(this.identifier);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public Class<?> getExtractToClass() {
        if (this.objectType instanceof ClassObjectType) {
            return ((ClassObjectType)this.objectType).getClassType();
        }
        return Fact.class;
    }

    @Override
    public String getExtractToClassName() {
        Class clazz = null;
        clazz = this.objectType instanceof ClassObjectType ? ((ClassObjectType)this.objectType).getClassType() : Fact.class;
        return ClassUtils.canonicalName(clazz);
    }

    @Override
    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    @Override
    public String getNativeReadMethodName() {
        return "getValue";
    }

    @Override
    public int hashCode() {
        return this.objectType.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlobalExtractor)) {
            return false;
        }
        GlobalExtractor other = (GlobalExtractor)obj;
        return this.objectType.equals(other.objectType);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    @Override
    public boolean isSelfReference() {
        return true;
    }

    @Override
    public boolean getBooleanValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public byte getByteValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public char getCharValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public double getDoubleValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public float getFloatValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getHashCode(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getIndex() {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public int getIntValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public long getLongValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public short getShortValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public Object getValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public BigDecimal getBigDecimalValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public BigInteger getBigIntegerValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }

    @Override
    public boolean isNullValue(Object object) {
        throw new RuntimeDroolsException("Can't extract a value from global " + this.identifier + " without a working memory reference");
    }
}

