/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.beliefsystem.BeliefSet;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.core.util.LinkedList;

public class EqualityKey
extends LinkedList<DefaultFactHandle>
implements Externalizable {
    public static final int STATED = 1;
    public static final int JUSTIFIED = 2;
    private int hashCode;
    private int status;
    private BeliefSet beliefSet;

    public EqualityKey() {
    }

    public EqualityKey(InternalFactHandle handle) {
        super((DefaultFactHandle)handle);
        this.hashCode = handle.getObjectHashCode();
    }

    public EqualityKey(InternalFactHandle handle, int status) {
        super((DefaultFactHandle)handle);
        this.hashCode = handle.getObjectHashCode();
        this.status = status;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.hashCode = in.readInt();
        this.status = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.hashCode);
        out.writeInt(this.status);
    }

    public InternalFactHandle getFactHandle() {
        return (InternalFactHandle)this.getFirst();
    }

    public void addFactHandle(InternalFactHandle handle) {
        this.add((DefaultFactHandle)handle);
    }

    public void removeFactHandle(InternalFactHandle handle) {
        this.remove((DefaultFactHandle)handle);
    }

    public int getStatus() {
        return this.status;
    }

    public BeliefSet getBeliefSet() {
        return this.beliefSet;
    }

    public void setBeliefSet(BeliefSet beliefSet) {
        this.beliefSet = beliefSet;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        String str = null;
        switch (this.status) {
            case 1: {
                str = "STATED";
                break;
            }
            case 2: {
                str = "JUSTIFIED";
            }
        }
        return "[FactStatus status=" + this.status + "]";
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EqualityKey) {
            return this == object;
        }
        return ((DefaultFactHandle)this.getFirst()).getObject().equals(object);
    }
}

