/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.reteoo.LeftTuple;
import org.drools.rule.Declaration;
import org.drools.rule.IndexEvaluator;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.ReadAccessor;

public abstract class AbstractHashTable
implements Externalizable {
    static final int MAX_CAPACITY = 0x40000000;
    protected int size;
    protected int threshold;
    protected float loadFactor;
    protected ObjectComparator comparator;
    protected Entry[] table;
    private HashTableIterator iterator;

    public AbstractHashTable() {
        this(16, 0.75f);
    }

    public AbstractHashTable(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.comparator = EqualityEquals.getInstance();
    }

    public AbstractHashTable(Entry[] table) {
        this(0.75f, table);
    }

    public AbstractHashTable(float loadFactor, Entry[] table) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)table.length * loadFactor);
        this.table = table;
        this.comparator = EqualityEquals.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.threshold = in.readInt();
        this.loadFactor = in.readFloat();
        this.comparator = (ObjectComparator)in.readObject();
        this.table = (Entry[])in.readObject();
        this.iterator = (HashTableIterator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.threshold);
        out.writeFloat(this.loadFactor);
        out.writeObject(this.comparator);
        out.writeObject(this.table);
        out.writeObject(this.iterator);
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new HashTableIterator(this);
        } else {
            this.iterator.reset();
        }
        return this.iterator;
    }

    public Iterator newIterator() {
        HashTableIterator iterator = new HashTableIterator(this);
        iterator.reset();
        return iterator;
    }

    public void setComparator(ObjectComparator comparator) {
        this.comparator = comparator;
    }

    protected void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        for (int i = 0; i < this.table.length; ++i) {
            Entry entry = this.table[i];
            if (entry == null) continue;
            this.table[i] = null;
            Object next = null;
            while (entry != null) {
                next = entry.getNext();
                int index = AbstractHashTable.indexOf(this.getResizeHashcode(entry), newTable.length);
                entry.setNext(newTable[index]);
                newTable[index] = entry;
                entry = next;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    public abstract int getResizeHashcode(Entry var1);

    public Entry[] toArray() {
        Entry[] result = new Entry[this.size];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (Entry entry = this.table[i]; entry != null; entry = entry.getNext()) {
                result[index++] = entry;
            }
        }
        return result;
    }

    protected Entry getBucket(int hashCode) {
        return this.table[AbstractHashTable.indexOf(hashCode, this.table.length)];
    }

    public Entry[] getTable() {
        return this.table;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public static int rehash(int hash) {
        hash ^= hash >>> 20 ^ hash >>> 12;
        return hash ^ hash >>> 7 ^ hash >>> 4;
    }

    protected static int indexOf(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    public abstract Entry getBucket(Object var1);

    public String toString() {
        StringBuilder sbuilder = new StringBuilder();
        Iterator it = this.iterator();
        boolean isFirst = true;
        Entry entry = (Entry)it.next();
        while (entry != null) {
            sbuilder.append(entry.toString());
            if (!isFirst) {
                sbuilder.append(", ");
            }
            isFirst = false;
            entry = (Entry)it.next();
        }
        return sbuilder.toString();
    }

    public static class TripleCompositeIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index0;
        private FieldIndex index1;
        private FieldIndex index2;
        private int startResult;

        public TripleCompositeIndex() {
        }

        public TripleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index0 = indexes[0];
            this.index1 = indexes[1];
            this.index2 = indexes[2];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index0 = (FieldIndex)in.readObject();
            this.index1 = (FieldIndex)in.readObject();
            this.index2 = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index0);
            out.writeObject(this.index1);
            out.writeObject(this.index2);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            switch (index) {
                case 0: {
                    return this.index0;
                }
                case 1: {
                    return this.index1;
                }
                case 2: {
                    return this.index2;
                }
            }
            throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
        }

        @Override
        public int hashCodeOf(Object object) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.extractor.getHashCode(null, object);
            hashCode = 31 * hashCode + this.index1.extractor.getHashCode(null, object);
            hashCode = 31 * hashCode + this.index2.extractor.getHashCode(null, object);
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public int hashCodeOf(LeftTuple tuple) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.declaration.getHashCode(null, tuple.get(this.index0.declaration).getObject());
            hashCode = 31 * hashCode + this.index1.declaration.getHashCode(null, tuple.get(this.index1.declaration).getObject());
            hashCode = 31 * hashCode + this.index2.declaration.getHashCode(null, tuple.get(this.index2.declaration).getObject());
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public boolean equal(Object right, LeftTuple tuple) {
            Object left1 = tuple.get(this.index0.declaration).getObject();
            Object left2 = tuple.get(this.index1.declaration).getObject();
            Object left3 = tuple.get(this.index2.declaration).getObject();
            return this.index0.evaluator.evaluate(null, this.index0.declaration.getExtractor(), left1, this.index0.extractor, right) && this.index1.evaluator.evaluate(null, this.index1.declaration.getExtractor(), left2, this.index1.extractor, right) && this.index2.evaluator.evaluate(null, this.index2.declaration.getExtractor(), left3, this.index2.extractor, right);
        }

        @Override
        public boolean equal(LeftTuple tuple1, LeftTuple tuple2) {
            Object object11 = tuple1.get(this.index0.declaration).getObject();
            Object object12 = tuple2.get(this.index0.declaration).getObject();
            Object object21 = tuple1.get(this.index1.declaration).getObject();
            Object object22 = tuple2.get(this.index1.declaration).getObject();
            Object object31 = tuple1.get(this.index2.declaration).getObject();
            Object object32 = tuple2.get(this.index2.declaration).getObject();
            return this.index0.evaluator.evaluate(null, this.index0.declaration.getExtractor(), object11, this.index0.declaration.getExtractor(), object12) && this.index1.evaluator.evaluate(null, this.index1.declaration.getExtractor(), object21, this.index1.declaration.getExtractor(), object22) && this.index2.evaluator.evaluate(null, this.index2.declaration.getExtractor(), object31, this.index2.declaration.getExtractor(), object32);
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return this.index0.evaluator.evaluate(null, this.index0.extractor, object1, this.index0.extractor, object2) && this.index1.evaluator.evaluate(null, this.index1.extractor, object1, this.index1.extractor, object2) && this.index2.evaluator.evaluate(null, this.index2.extractor, object1, this.index2.extractor, object2);
        }
    }

    public static class DoubleCompositeIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index0;
        private FieldIndex index1;
        private int startResult;

        public DoubleCompositeIndex() {
        }

        public DoubleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index0 = indexes[0];
            this.index1 = indexes[1];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index0 = (FieldIndex)in.readObject();
            this.index1 = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index0);
            out.writeObject(this.index1);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            switch (index) {
                case 0: {
                    return this.index0;
                }
                case 1: {
                    return this.index1;
                }
            }
            throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
        }

        @Override
        public int hashCodeOf(Object object) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.extractor.getHashCode(null, object);
            hashCode = 31 * hashCode + this.index1.extractor.getHashCode(null, object);
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public int hashCodeOf(LeftTuple tuple) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.index0.declaration.getHashCode(null, tuple.get(this.index0.declaration).getObject());
            hashCode = 31 * hashCode + this.index1.declaration.getHashCode(null, tuple.get(this.index1.declaration).getObject());
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public boolean equal(Object right, LeftTuple tuple) {
            Object left1 = tuple.get(this.index0.declaration).getObject();
            Object left2 = tuple.get(this.index1.declaration).getObject();
            return this.index0.evaluator.evaluate(null, this.index0.declaration.getExtractor(), left1, this.index0.extractor, right) && this.index1.evaluator.evaluate(null, this.index1.declaration.getExtractor(), left2, this.index1.extractor, right);
        }

        @Override
        public boolean equal(LeftTuple tuple1, LeftTuple tuple2) {
            Object object11 = tuple1.get(this.index0.declaration).getObject();
            Object object12 = tuple2.get(this.index0.declaration).getObject();
            Object object21 = tuple1.get(this.index1.declaration).getObject();
            Object object22 = tuple2.get(this.index1.declaration).getObject();
            return this.index0.evaluator.evaluate(null, this.index0.declaration.getExtractor(), object11, this.index0.declaration.getExtractor(), object12) && this.index1.evaluator.evaluate(null, this.index1.declaration.getExtractor(), object21, this.index1.declaration.getExtractor(), object22);
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return this.index0.evaluator.evaluate(null, this.index0.extractor, object1, this.index0.extractor, object2) && this.index1.evaluator.evaluate(null, this.index1.extractor, object1, this.index1.extractor, object2);
        }
    }

    public static class SingleIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private InternalReadAccessor extractor;
        private Declaration declaration;
        private IndexEvaluator evaluator;
        private int startResult;

        public SingleIndex() {
        }

        public SingleIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.extractor = indexes[0].extractor;
            this.declaration = indexes[0].declaration;
            this.evaluator = indexes[0].evaluator;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (InternalReadAccessor)in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.evaluator = (IndexEvaluator)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.declaration);
            out.writeObject(this.evaluator);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            if (index > 0) {
                throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
            }
            return new FieldIndex(this.extractor, this.declaration, this.evaluator);
        }

        @Override
        public int hashCodeOf(Object object) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.extractor.getHashCode(null, object);
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public int hashCodeOf(LeftTuple tuple) {
            int hashCode = this.startResult;
            hashCode = 31 * hashCode + this.declaration.getHashCode(null, tuple.get(this.declaration).getObject());
            return AbstractHashTable.rehash(hashCode);
        }

        @Override
        public boolean equal(Object right, LeftTuple tuple) {
            Object left = tuple.get(this.declaration).getObject();
            return this.evaluator.evaluate(null, this.declaration.getExtractor(), left, this.extractor, right);
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return this.evaluator.evaluate(null, this.extractor, object1, this.extractor, object2);
        }

        @Override
        public boolean equal(LeftTuple tuple1, LeftTuple tuple2) {
            Object object1 = tuple1.get(this.declaration).getObject();
            Object object2 = tuple2.get(this.declaration).getObject();
            return this.evaluator.evaluate(null, this.declaration.getExtractor(), object1, this.declaration.getExtractor(), object2);
        }
    }

    public static interface Index
    extends Externalizable {
        public FieldIndex getFieldIndex(int var1);

        public int hashCodeOf(LeftTuple var1);

        public int hashCodeOf(Object var1);

        public boolean equal(Object var1, LeftTuple var2);

        public boolean equal(LeftTuple var1, LeftTuple var2);

        public boolean equal(Object var1, Object var2);
    }

    public static class FieldIndex
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private InternalReadAccessor extractor;
        private Declaration declaration;
        private IndexEvaluator evaluator;

        public FieldIndex() {
        }

        public FieldIndex(InternalReadAccessor extractor, Declaration declaration, IndexEvaluator evaluator) {
            this.extractor = extractor;
            this.declaration = declaration;
            this.evaluator = evaluator;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.extractor = (InternalReadAccessor)in.readObject();
            this.declaration = (Declaration)in.readObject();
            this.evaluator = (IndexEvaluator)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.extractor);
            out.writeObject(this.declaration);
            out.writeObject(this.evaluator);
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public ReadAccessor getExtractor() {
            return this.extractor;
        }

        public IndexEvaluator getEvaluator() {
            return this.evaluator;
        }
    }

    public static class EqualityEquals
    extends AbstractObjectComparator {
        private static final long serialVersionUID = 510L;
        public static ObjectComparator INSTANCE = new EqualityEquals();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int hashCodeOf(Object key) {
            return AbstractHashTable.rehash(key.hashCode());
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return object1.equals(object2);
        }
    }

    public static class InstanceEquals
    extends AbstractObjectComparator {
        private static final long serialVersionUID = 510L;
        public static ObjectComparator INSTANCE = new InstanceEquals();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        private InstanceEquals() {
        }

        @Override
        public int hashCodeOf(Object obj) {
            return AbstractHashTable.rehash(System.identityHashCode(obj));
        }

        @Override
        public boolean equal(Object object1, Object object2) {
            return object1 == object2;
        }
    }

    public static class HashTableIterator
    implements Iterator,
    Externalizable {
        private static final long serialVersionUID = 510L;
        private AbstractHashTable hashTable;
        private Entry[] table;
        private int row;
        private int length;
        private Entry entry;

        public HashTableIterator() {
        }

        public HashTableIterator(AbstractHashTable hashTable) {
            this.hashTable = hashTable;
            this.reset();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.hashTable = (AbstractHashTable)in.readObject();
            this.table = (Entry[])in.readObject();
            this.row = in.readInt();
            this.length = in.readInt();
            this.entry = (Entry)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.hashTable);
            out.writeObject(this.table);
            out.writeInt(this.row);
            out.writeInt(this.length);
            out.writeObject(this.entry);
        }

        public Object next() {
            if (this.entry != null) {
                this.entry = this.entry.getNext();
            }
            while (this.entry == null && this.row < this.length) {
                this.entry = this.table[this.row];
                ++this.row;
            }
            return this.entry;
        }

        public void reset() {
            this.table = this.hashTable.getTable();
            this.length = this.table.length;
            this.entry = null;
            this.row = 0;
        }
    }

    public static abstract class AbstractObjectComparator
    implements ObjectComparator {
    }

    public static interface ObjectComparator
    extends Externalizable {
        public int hashCodeOf(Object var1);

        public boolean equal(Object var1, Object var2);
    }
}

