/*
 * Decompiled with CFR 0.152.
 */
package org.kie.marshalling;

import org.kie.KieBase;
import org.kie.internal.utils.ServiceRegistryImpl;
import org.kie.marshalling.KieMarshallers;
import org.kie.marshalling.Marshaller;
import org.kie.marshalling.ObjectMarshallingStrategy;
import org.kie.marshalling.ObjectMarshallingStrategyAcceptor;

public class MarshallerFactory {
    private static volatile KieMarshallers provider;

    public static ObjectMarshallingStrategyAcceptor newClassFilterAcceptor(String[] patterns) {
        return MarshallerFactory.getMarshallerProvider().newClassFilterAcceptor(patterns);
    }

    public static ObjectMarshallingStrategy newIdentityMarshallingStrategy() {
        return MarshallerFactory.getMarshallerProvider().newIdentityMarshallingStrategy();
    }

    public static ObjectMarshallingStrategy newIdentityMarshallingStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        return MarshallerFactory.getMarshallerProvider().newIdentityMarshallingStrategy(acceptor);
    }

    public static ObjectMarshallingStrategy newSerializeMarshallingStrategy() {
        return MarshallerFactory.getMarshallerProvider().newSerializeMarshallingStrategy();
    }

    public static ObjectMarshallingStrategy newSerializeMarshallingStrategy(ObjectMarshallingStrategyAcceptor acceptor) {
        return MarshallerFactory.getMarshallerProvider().newSerializeMarshallingStrategy(acceptor);
    }

    public static Marshaller newMarshaller(KieBase kbase) {
        return MarshallerFactory.getMarshallerProvider().newMarshaller(kbase);
    }

    public static Marshaller newMarshaller(KieBase kbase, ObjectMarshallingStrategy[] strategies) {
        return MarshallerFactory.getMarshallerProvider().newMarshaller(kbase, strategies);
    }

    private static synchronized void setMarshallerProvider(KieMarshallers provider) {
        MarshallerFactory.provider = provider;
    }

    private static synchronized KieMarshallers getMarshallerProvider() {
        if (provider == null) {
            MarshallerFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        MarshallerFactory.setMarshallerProvider(ServiceRegistryImpl.getInstance().get(KieMarshallers.class));
    }
}

