/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.descr;

import java.util.ArrayList;
import java.util.List;
import org.drools.lang.descr.AnnotatedBaseDescr;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.BindingDescr;
import org.drools.lang.descr.ConnectiveType;

public class ConstraintConnectiveDescr
extends AnnotatedBaseDescr {
    private static final long serialVersionUID = 520L;
    private ConnectiveType connective = ConnectiveType.AND;
    private List<BaseDescr> descrs = new ArrayList<BaseDescr>();

    public ConstraintConnectiveDescr() {
    }

    public ConstraintConnectiveDescr(ConnectiveType connective) {
        this.connective = connective;
    }

    public static ConstraintConnectiveDescr newAnd() {
        return new ConstraintConnectiveDescr(ConnectiveType.AND);
    }

    public static ConstraintConnectiveDescr newOr() {
        return new ConstraintConnectiveDescr(ConnectiveType.OR);
    }

    public static ConstraintConnectiveDescr newXor() {
        return new ConstraintConnectiveDescr(ConnectiveType.XOR);
    }

    public static ConstraintConnectiveDescr newIncAnd() {
        return new ConstraintConnectiveDescr(ConnectiveType.INC_AND);
    }

    public static ConstraintConnectiveDescr newIncOr() {
        return new ConstraintConnectiveDescr(ConnectiveType.INC_OR);
    }

    public void addDescr(BaseDescr baseDescr) {
        this.descrs.add(baseDescr);
    }

    public List<BaseDescr> getDescrs() {
        return this.descrs;
    }

    public ConnectiveType getConnective() {
        return this.connective;
    }

    public void setConnective(ConnectiveType connective) {
        this.connective = connective;
    }

    public void addOrMerge(BaseDescr baseDescr) {
        if (baseDescr instanceof ConstraintConnectiveDescr) {
            ConstraintConnectiveDescr con = (ConstraintConnectiveDescr)baseDescr;
            if (con.getConnective().equals((Object)this.connective)) {
                for (BaseDescr descr : con.getDescrs()) {
                    this.addDescr(descr);
                    for (String annKey : con.getAnnotationNames()) {
                        this.addAnnotation(con.getAnnotation(annKey));
                    }
                }
            } else {
                this.addDescr(con);
            }
        } else {
            this.addDescr(baseDescr);
        }
    }

    public String toString() {
        return "[" + (Object)((Object)this.connective) + " " + this.descrs + " ]";
    }

    @Override
    public void copyLocation(BaseDescr d) {
        super.copyLocation(d);
        if (this.descrs.size() == 1 && this.descrs.get(0) instanceof BindingDescr) {
            this.descrs.get(0).copyLocation(d);
        }
    }
}

