/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.builder.impl.KnowledgeBuilderImpl;
import org.drools.commons.jci.compilers.CompilationResult;
import org.drools.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.drools.commons.jci.problems.CompilationProblem;
import org.drools.commons.jci.readers.DiskResourceReader;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.drools.core.util.StringUtils;
import org.drools.factmodel.ClassDefinition;
import org.drools.kproject.ReleaseIdImpl;
import org.drools.kproject.models.KieModuleModelImpl;
import org.drools.kproject.xml.MinimalPomParser;
import org.drools.kproject.xml.PomModel;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.TypeDeclaration;
import org.drools.rule.TypeMetaInfo;
import org.kie.KieBaseConfiguration;
import org.kie.KieServices;
import org.kie.KnowledgeBaseFactory;
import org.kie.builder.InternalKieBuilder;
import org.kie.builder.KieBuilder;
import org.kie.builder.KieBuilderSet;
import org.kie.builder.KieFileSystem;
import org.kie.builder.KieModule;
import org.kie.builder.Message;
import org.kie.builder.ReleaseId;
import org.kie.builder.Results;
import org.kie.builder.impl.FormatConversionResult;
import org.kie.builder.impl.FormatConverter;
import org.kie.builder.impl.FormatsManager;
import org.kie.builder.impl.InternalKieModule;
import org.kie.builder.impl.KieBuilderSetImpl;
import org.kie.builder.impl.KieFileSystemImpl;
import org.kie.builder.impl.KieModuleKieProject;
import org.kie.builder.impl.KieRepositoryImpl;
import org.kie.builder.impl.MemoryKieModule;
import org.kie.builder.impl.ResultsImpl;
import org.kie.builder.model.KieBaseModel;
import org.kie.builder.model.KieModuleModel;
import org.kie.builder.model.KieSessionModel;
import org.kie.conf.KieBaseOption;
import org.kie.definition.KnowledgePackage;
import org.kie.definition.type.FactType;
import org.kie.io.Resource;

public class KieBuilderImpl
implements InternalKieBuilder {
    static final String RESOURCES_ROOT = "src/main/resources/";
    private ResultsImpl results;
    private final ResourceReader srcMfs;
    private MemoryFileSystem trgMfs;
    private MemoryKieModule kModule;
    private PomModel pomModel;
    private byte[] pomXml;
    private ReleaseId releaseId;
    private byte[] kModuleModelXml;
    private KieModuleModel kModuleModel;
    private Collection<KieModule> dependencies;

    public KieBuilderImpl(File file) {
        this.srcMfs = new DiskResourceReader(file);
        this.init();
    }

    public KieBuilderImpl(KieFileSystem kieFileSystem) {
        this.srcMfs = ((KieFileSystemImpl)kieFileSystem).asMemoryFileSystem();
        this.init();
    }

    public KieBuilder setDependencies(KieModule ... dependencies) {
        this.dependencies = Arrays.asList(dependencies);
        return this;
    }

    public KieBuilder setDependencies(Resource ... resources) {
        KieRepositoryImpl kr = (KieRepositoryImpl)KieServices.Factory.get().getRepository();
        ArrayList<KieModule> list = new ArrayList<KieModule>();
        for (Resource res : resources) {
            InternalKieModule depKieMod = (InternalKieModule)kr.getKieModule(res);
            list.add(depKieMod);
        }
        this.dependencies = list;
        return this;
    }

    private void init() {
        KieServices ks = KieServices.Factory.get();
        this.results = new ResultsImpl();
        this.buildPomModel();
        this.buildKieModuleModel();
        if (this.pomModel != null) {
            this.releaseId = this.pomModel.getReleaseId();
            KieRepositoryImpl repository = (KieRepositoryImpl)ks.getRepository();
            for (ReleaseId dep : this.pomModel.getDependencies()) {
                KieModule depModule = repository.getKieModule(dep, this.pomXml);
                if (depModule == null) continue;
                this.addDependency(depModule);
            }
        }
    }

    private void addDependency(KieModule depModule) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<KieModule>();
        }
        this.dependencies.add(depModule);
    }

    public KieBuilder buildAll() {
        if (!this.isBuilt() && this.releaseId != null && this.kModuleModel != null) {
            this.trgMfs = new MemoryFileSystem();
            this.writePomAndKModule();
            this.compileJavaClasses();
            this.addKBasesFilesToTrg();
            this.kModule = new MemoryKieModule(this.releaseId, this.kModuleModel, this.trgMfs);
            if (this.dependencies != null && !this.dependencies.isEmpty()) {
                for (KieModule kieModule : this.dependencies) {
                    this.kModule.addDependency((InternalKieModule)kieModule);
                }
            }
            if (KieBuilderImpl.buildKieModule(this.kModule, this.results)) {
                Map<String, TypeDeclaration> typeDeclarations = this.addTypeDeclarationClassesToTrg();
                this.writeTypeMetaInfosToTrg(typeDeclarations);
            }
        }
        return this;
    }

    private Map<String, TypeDeclaration> addTypeDeclarationClassesToTrg() {
        HashMap<String, TypeDeclaration> typeDeclarations = new HashMap<String, TypeDeclaration>();
        KieModuleModel kieModuleModel = this.kModule.getKieModuleModel();
        for (String kieBaseNames : kieModuleModel.getKieBaseModels().keySet()) {
            KnowledgeBuilderImpl kBuilder = (KnowledgeBuilderImpl)this.kModule.getKnowledgeBuilderForKieBase(kieBaseNames);
            Map<String, PackageRegistry> pkgRegistryMap = kBuilder.getPackageBuilder().getPackageRegistry();
            for (KnowledgePackage kPkg : kBuilder.getKnowledgePackages()) {
                PackageRegistry pkgRegistry = pkgRegistryMap.get(kPkg.getName());
                JavaDialectRuntimeData runtimeData = (JavaDialectRuntimeData)pkgRegistry.getDialectRuntimeRegistry().getDialectData("java");
                for (FactType factType : kPkg.getFactTypes()) {
                    Class typeClass = ((ClassDefinition)factType).getDefinedClass();
                    TypeDeclaration typeDeclaration = pkgRegistry.getPackage().getTypeDeclaration(typeClass);
                    if (typeDeclaration != null) {
                        typeDeclarations.put(typeClass.getName(), typeDeclaration);
                    }
                    String className = factType.getName();
                    String internalName = className.replace('.', '/') + ".class";
                    byte[] bytes = (byte[])runtimeData.getStore().get(internalName);
                    this.trgMfs.write(internalName, bytes, true);
                }
            }
        }
        return typeDeclarations;
    }

    private void writeTypeMetaInfosToTrg(Map<String, TypeDeclaration> typeDeclarations) {
        if (!typeDeclarations.isEmpty()) {
            this.trgMfs.write(KieModuleModelImpl.KMODULE_INFO_JAR_PATH, TypeMetaInfo.marshallMetaInfos(typeDeclarations).getBytes(), true);
        }
    }

    public static boolean buildKieModule(InternalKieModule kModule, ResultsImpl messages) {
        KieModuleKieProject kProject = new KieModuleKieProject(kModule, null);
        kProject.init();
        kProject.verify(messages);
        if (messages.filterMessages(Message.Level.ERROR).isEmpty()) {
            KieServices.Factory.get().getRepository().addKieModule((KieModule)kModule);
            return true;
        }
        return false;
    }

    private void addKBasesFilesToTrg() {
        for (KieBaseModel kieBaseModel : this.kModuleModel.getKieBaseModels().values()) {
            this.addKBaseFilesToTrg(kieBaseModel);
        }
    }

    private KieBaseConfiguration getKnowledgeBaseConfiguration(KieBaseModel kieBase, Properties properties, ClassLoader ... classLoaders) {
        KieBaseConfiguration kbConf = KnowledgeBaseFactory.newKnowledgeBaseConfiguration((Properties)properties, (ClassLoader[])classLoaders);
        kbConf.setOption((KieBaseOption)kieBase.getEqualsBehavior());
        kbConf.setOption((KieBaseOption)kieBase.getEventProcessingMode());
        return kbConf;
    }

    private void addKBaseFilesToTrg(KieBaseModel kieBase) {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || !KieBuilderImpl.isFileInKieBase(kieBase, fileName)) continue;
            this.copySourceToTarget(fileName);
        }
    }

    void copySourceToTarget(String fileName) {
        byte[] bytes = this.srcMfs.getBytes(fileName);
        fileName = fileName.substring(RESOURCES_ROOT.length() - 1);
        if (bytes != null) {
            FormatConverter formatConverter = FormatsManager.get().getConverterFor(fileName);
            if (formatConverter == null) {
                return;
            }
            FormatConversionResult result = formatConverter.convert(fileName, bytes);
            this.trgMfs.write(result.getConvertedName(), result.getContent(), true);
        } else {
            this.trgMfs.remove(fileName);
        }
    }

    private void addMetaInfBuilder() {
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.startsWith(RESOURCES_ROOT) || FormatsManager.isKieExtension(fileName)) continue;
            byte[] bytes = this.srcMfs.getBytes(fileName);
            this.trgMfs.write(fileName.substring(RESOURCES_ROOT.length() - 1), bytes, true);
        }
    }

    static boolean filterFileInKBase(KieBaseModel kieBase, String fileName) {
        return FormatsManager.isKieExtension(fileName) && KieBuilderImpl.isFileInKieBase(kieBase, fileName);
    }

    private static boolean isFileInKieBase(KieBaseModel kieBase, String fileName) {
        if (kieBase.getPackages().isEmpty()) {
            String pathName = kieBase.getName().replace('.', '/');
            return fileName.startsWith(RESOURCES_ROOT + pathName + "/") || fileName.startsWith(pathName + "/");
        }
        int lastSep = fileName.lastIndexOf("/");
        String pkgNameForFile = lastSep > 0 ? fileName.substring(0, lastSep) : fileName;
        pkgNameForFile = pkgNameForFile.replace('/', '.');
        for (String pkgName : kieBase.getPackages()) {
            boolean isNegative = pkgName.startsWith("!");
            if (isNegative) {
                pkgName = pkgName.substring(1);
            }
            if (!pkgName.equals("*") && !pkgNameForFile.endsWith(pkgName) && (!pkgName.endsWith(".*") || !pkgNameForFile.contains(pkgName.substring(0, pkgName.length() - 2)))) continue;
            return !isNegative;
        }
        return false;
    }

    public Results getResults() {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        return this.results;
    }

    public KieModule getKieModule() {
        return this.getKieModule(false);
    }

    KieModule getKieModuleIgnoringErrors() {
        return this.getKieModule(true);
    }

    private KieModule getKieModule(boolean ignoreErrors) {
        if (!this.isBuilt()) {
            this.buildAll();
        }
        if (!ignoreErrors && (this.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}) || this.kModule == null)) {
            throw new RuntimeException("Unable to get KieModule, Errors Existed");
        }
        return this.kModule;
    }

    private boolean isBuilt() {
        return this.kModule != null;
    }

    private void buildKieModuleModel() {
        if (this.srcMfs.isAvailable(KieModuleModelImpl.KMODULE_SRC_PATH)) {
            this.kModuleModelXml = this.srcMfs.getBytes(KieModuleModelImpl.KMODULE_SRC_PATH);
            try {
                this.kModuleModel = KieModuleModelImpl.fromXML(new ByteArrayInputStream(this.kModuleModelXml));
            }
            catch (Exception e) {
                this.results.addMessage(Message.Level.ERROR, "kmodule.xml", "kmodulet.xml found, but unable to read\n" + e.getMessage());
            }
        } else {
            this.kModuleModel = KieServices.Factory.get().newKieModuleModel();
        }
        if (KieBuilderImpl.setDefaultsforEmptyKieModule(this.kModuleModel)) {
            this.kModuleModelXml = this.kModuleModel.toXML().getBytes();
        }
    }

    static boolean setDefaultsforEmptyKieModule(KieModuleModel kModuleModel) {
        if (kModuleModel != null && kModuleModel.getKieBaseModels().isEmpty()) {
            KieBaseModel kieBaseModel = kModuleModel.newKieBaseModel("defaultKieBase").addPackage("*").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultKieSession").setDefault(true);
            kieBaseModel.newKieSessionModel("defaultStatelessKieSession").setType(KieSessionModel.KieSessionType.STATELESS).setDefault(true);
            return true;
        }
        return false;
    }

    private void buildPomModel() {
        this.pomXml = KieBuilderImpl.getOrGeneratePomXml(this.srcMfs);
        if (this.pomXml == null) {
            return;
        }
        try {
            PomModel tempPomModel = MinimalPomParser.parse("pom.xml", new ByteArrayInputStream(this.pomXml));
            KieBuilderImpl.validatePomModel(tempPomModel);
            this.pomModel = tempPomModel;
        }
        catch (Exception e) {
            this.results.addMessage(Message.Level.ERROR, "pom.xml", "maven pom.xml found, but unable to read\n" + e.getMessage());
        }
    }

    public static void validatePomModel(PomModel pomModel) {
        ReleaseId pomReleaseId = pomModel.getReleaseId();
        if (StringUtils.isEmpty((CharSequence)pomReleaseId.getGroupId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getArtifactId()) || StringUtils.isEmpty((CharSequence)pomReleaseId.getVersion())) {
            throw new RuntimeException("Maven pom.properties exists but ReleaseId content is malformed");
        }
    }

    public static byte[] getOrGeneratePomXml(ResourceReader mfs) {
        if (mfs.isAvailable("pom.xml")) {
            return mfs.getBytes("pom.xml");
        }
        return KieBuilderImpl.generatePomXml(KieServices.Factory.get().getRepository().getDefaultReleaseId()).getBytes();
    }

    public void writePomAndKModule() {
        this.addMetaInfBuilder();
        if (this.pomXml != null) {
            ReleaseIdImpl g = (ReleaseIdImpl)this.releaseId;
            this.trgMfs.write(g.getPomXmlPath(), this.pomXml, true);
            this.trgMfs.write(g.getPomPropertiesPath(), KieBuilderImpl.generatePomProperties(this.releaseId).getBytes(), true);
        }
        if (this.kModuleModelXml != null) {
            this.trgMfs.write(KieModuleModelImpl.KMODULE_JAR_PATH, this.kModuleModel.toXML().getBytes(), true);
        }
    }

    public static String generatePomXml(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sBuilder.append("         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\"> \n");
        sBuilder.append("    <modelVersion>4.0.0</modelVersion> \n");
        sBuilder.append("    <groupId>");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("</groupId> \n");
        sBuilder.append("    <artifactId>");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("</artifactId> \n");
        sBuilder.append("    <version>");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("</version> \n");
        sBuilder.append("    <packaging>jar</packaging> \n");
        sBuilder.append("    <name>Default</name> \n");
        sBuilder.append("</project>  \n");
        return sBuilder.toString();
    }

    public static String generatePomProperties(ReleaseId releaseId) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("groupId=");
        sBuilder.append(releaseId.getGroupId());
        sBuilder.append("\n");
        sBuilder.append("artifactId=");
        sBuilder.append(releaseId.getArtifactId());
        sBuilder.append("\n");
        sBuilder.append("version=");
        sBuilder.append(releaseId.getVersion());
        sBuilder.append("\n");
        return sBuilder.toString();
    }

    private void compileJavaClasses() {
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            this.trgMfs.write(fileName, this.srcMfs.getBytes(fileName), true);
            classFiles.add(fileName.substring(0, fileName.length() - ".class".length()));
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        for (String fileName : this.srcMfs.getFileNames()) {
            if (!fileName.endsWith(".java") || classFiles.contains(fileName.substring(0, fileName.length() - ".java".length()))) continue;
            javaFiles.add(fileName);
        }
        if (javaFiles.isEmpty()) {
            return;
        }
        String[] sourceFiles = javaFiles.toArray(new String[javaFiles.size()]);
        EclipseJavaCompiler compiler = this.createCompiler("src/main/java/");
        CompilationResult res = compiler.compile(sourceFiles, this.srcMfs, this.trgMfs);
        for (CompilationProblem problem : res.getErrors()) {
            this.results.addMessage(problem);
        }
        for (CompilationProblem problem : res.getWarnings()) {
            this.results.addMessage(problem);
        }
    }

    public static String findPomProperties(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            String fileName = zipEntry.getName();
            if (!fileName.endsWith("pom.properties") || !fileName.startsWith("META-INF/maven/")) continue;
            return fileName;
        }
        return null;
    }

    public static File findPomProperties(File root) {
        File mavenRoot = new File(root, "META-INF/maven");
        return KieBuilderImpl.recurseToPomProperties(mavenRoot);
    }

    public static File recurseToPomProperties(File file) {
        for (File child : file.listFiles()) {
            if (child.isDirectory()) {
                File returnedFile = KieBuilderImpl.recurseToPomProperties(child);
                if (returnedFile == null) continue;
                return returnedFile;
            }
            if (!child.getName().endsWith("pom.properties")) continue;
            return child;
        }
        return null;
    }

    private EclipseJavaCompiler createCompiler(String prefix) {
        EclipseJavaCompilerSettings settings = new EclipseJavaCompilerSettings();
        settings.setSourceVersion("1.5");
        settings.setTargetVersion("1.5");
        return new EclipseJavaCompiler(settings, prefix);
    }

    public KieBuilderSet createFileSet(String ... files) {
        return new KieBuilderSetImpl(this, files);
    }
}

