/*
 * Decompiled with CFR 0.152.
 */
package org.kie.builder.impl;

import java.io.File;
import java.util.Collection;
import org.drools.commons.jci.readers.ResourceReader;
import org.drools.compiler.io.memory.MemoryFileSystem;
import org.drools.kproject.models.KieModuleModelImpl;
import org.kie.builder.ReleaseId;
import org.kie.builder.impl.AbstractKieModule;
import org.kie.builder.model.KieModuleModel;

public class MemoryKieModule
extends AbstractKieModule
implements ResourceReader {
    private final MemoryFileSystem mfs;

    public MemoryKieModule(ReleaseId releaseId) {
        this(releaseId, new KieModuleModelImpl(), new MemoryFileSystem());
    }

    public MemoryKieModule(ReleaseId releaseId, KieModuleModel kieProject, MemoryFileSystem mfs) {
        super(releaseId, kieProject);
        this.mfs = mfs;
    }

    @Override
    public boolean isAvailable(String path) {
        return this.mfs.existsFile(path);
    }

    @Override
    public byte[] getBytes(String path) {
        return this.mfs.getBytes(path);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.mfs.getFileNames();
    }

    public MemoryFileSystem getMemoryFileSystem() {
        return this.mfs;
    }

    @Override
    public File getFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes() {
        return this.mfs.writeAsBytes();
    }

    public String toString() {
        return "MemoryKieModule[ ReleaseId=" + this.getReleaseId() + "]";
    }
}

