/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSException;

class CMSEnvelopedHelper {
    static final CMSEnvelopedHelper INSTANCE = new CMSEnvelopedHelper();
    private static final Map KEYSIZES = new HashMap();
    private static final Map BASE_CIPHER_NAMES = new HashMap();
    private static final Map CIPHER_ALG_NAMES = new HashMap();

    CMSEnvelopedHelper() {
    }

    private String getAsymmetricEncryptionAlgName(String string) {
        if (PKCSObjectIdentifiers.rsaEncryption.getId().equals(string)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return string;
    }

    Cipher createAsymmetricCipher(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        try {
            return this.createCipher(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return this.createCipher(this.getAsymmetricEncryptionAlgName(string), string2);
        }
    }

    KeyGenerator createSymmetricKeyGenerator(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createKeyGenerator(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = (String)BASE_CIPHER_NAMES.get(string);
                if (string3 != null) {
                    return this.createKeyGenerator(string3, string2);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                // empty catch block
            }
            if (string2 != null) {
                return this.createSymmetricKeyGenerator(string, null);
            }
            throw noSuchAlgorithmException;
        }
    }

    AlgorithmParameters createAlgorithmParameters(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        try {
            return this.createAlgorithmParams(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = (String)BASE_CIPHER_NAMES.get(string);
                if (string3 != null) {
                    return this.createAlgorithmParams(string3, string2);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                // empty catch block
            }
            throw noSuchAlgorithmException;
        }
    }

    String getRFC3211WrapperName(String string) {
        String string2 = (String)BASE_CIPHER_NAMES.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("no name for " + string);
        }
        return string2 + "RFC3211Wrap";
    }

    int getKeySize(String string) {
        Integer n = (Integer)KEYSIZES.get(string);
        if (n == null) {
            throw new IllegalArgumentException("no keysize for " + string);
        }
        return n;
    }

    private Cipher createCipher(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (string2 != null) {
            return Cipher.getInstance(string, string2);
        }
        return Cipher.getInstance(string);
    }

    private AlgorithmParameters createAlgorithmParams(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 != null) {
            return AlgorithmParameters.getInstance(string, string2);
        }
        return AlgorithmParameters.getInstance(string);
    }

    private KeyGenerator createKeyGenerator(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException {
        if (string2 != null) {
            return KeyGenerator.getInstance(string, string2);
        }
        return KeyGenerator.getInstance(string);
    }

    Cipher getSymmetricCipher(String string, String string2) throws NoSuchProviderException, NoSuchAlgorithmException, NoSuchPaddingException {
        try {
            return this.createCipher(string, string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            String string3 = (String)CIPHER_ALG_NAMES.get(string);
            try {
                return this.createCipher(string3, string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                if (string2 != null) {
                    return this.getSymmetricCipher(string, null);
                }
                throw noSuchAlgorithmException;
            }
        }
    }

    AlgorithmParameters getEncryptionAlgorithmParameters(String string, byte[] byArray, String string2) throws CMSException, NoSuchProviderException {
        if (byArray == null) {
            return null;
        }
        try {
            AlgorithmParameters algorithmParameters = this.createAlgorithmParameters(string, string2);
            algorithmParameters.init(byArray, "ASN.1");
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find parameters for algorithm", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't find parse parameters", iOException);
        }
    }

    String getSymmetricCipherName(String string) {
        String string2 = (String)BASE_CIPHER_NAMES.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    static {
        KEYSIZES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES128_CBC, new Integer(128));
        KEYSIZES.put(CMSEnvelopedGenerator.AES192_CBC, new Integer(192));
        KEYSIZES.put(CMSEnvelopedGenerator.AES256_CBC, new Integer(256));
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSEnvelopedGenerator.AES256_CBC, "AES/CBC/PKCS5Padding");
    }
}

