// $ANTLR 3.3 Nov 30, 2010 12:46:29 src/main/resources/org/drools/lang/DRL6Lexer.g 2012-10-30 11:35:06

    package org.drools.lang;

        import org.drools.compiler.DroolsParserException;
    import org.drools.core.util.StringUtils;
import org.kie.builder.conf.LanguageLevelOption;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
public class DRL6Lexer extends AbstractDRLLexer {
    public static final int EOF=-1;
    public static final int SHARP=4;
    public static final int EOL=5;
    public static final int WS=6;
    public static final int Exponent=7;
    public static final int FloatTypeSuffix=8;
    public static final int FLOAT=9;
    public static final int HexDigit=10;
    public static final int IntegerTypeSuffix=11;
    public static final int HEX=12;
    public static final int DECIMAL=13;
    public static final int EscapeSequence=14;
    public static final int STRING=15;
    public static final int TIME_INTERVAL=16;
    public static final int UnicodeEscape=17;
    public static final int OctalEscape=18;
    public static final int BOOL=19;
    public static final int NULL=20;
    public static final int AT=21;
    public static final int PLUS_ASSIGN=22;
    public static final int MINUS_ASSIGN=23;
    public static final int MULT_ASSIGN=24;
    public static final int DIV_ASSIGN=25;
    public static final int AND_ASSIGN=26;
    public static final int OR_ASSIGN=27;
    public static final int XOR_ASSIGN=28;
    public static final int MOD_ASSIGN=29;
    public static final int UNIFY=30;
    public static final int DECR=31;
    public static final int INCR=32;
    public static final int ARROW=33;
    public static final int SEMICOLON=34;
    public static final int COLON=35;
    public static final int EQUALS=36;
    public static final int NOT_EQUALS=37;
    public static final int GREATER_EQUALS=38;
    public static final int LESS_EQUALS=39;
    public static final int GREATER=40;
    public static final int LESS=41;
    public static final int EQUALS_ASSIGN=42;
    public static final int LEFT_PAREN=43;
    public static final int RIGHT_PAREN=44;
    public static final int LEFT_SQUARE=45;
    public static final int RIGHT_SQUARE=46;
    public static final int LEFT_CURLY=47;
    public static final int RIGHT_CURLY=48;
    public static final int COMMA=49;
    public static final int DOT=50;
    public static final int NULL_SAFE_DOT=51;
    public static final int DOUBLE_AMPER=52;
    public static final int DOUBLE_PIPE=53;
    public static final int QUESTION=54;
    public static final int NEGATION=55;
    public static final int TILDE=56;
    public static final int PIPE=57;
    public static final int AMPER=58;
    public static final int XOR=59;
    public static final int MOD=60;
    public static final int STAR=61;
    public static final int MINUS=62;
    public static final int PLUS=63;
    public static final int SH_STYLE_SINGLE_LINE_COMMENT=64;
    public static final int C_STYLE_SINGLE_LINE_COMMENT=65;
    public static final int MULTI_LINE_COMMENT=66;
    public static final int IdentifierStart=67;
    public static final int IdentifierPart=68;
    public static final int ID=69;
    public static final int DIV=70;
    public static final int MISC=71;

        private List<DroolsParserException> errors = new ArrayList<DroolsParserException>();
        private DroolsParserExceptionFactory errorMessageFactory = new DroolsParserExceptionFactory(null, LanguageLevelOption.DRL6);

        /** The standard method called to automatically emit a token at the
         *  outermost lexical rule.  The token object should point into the
         *  char buffer start..stop.  If there is a text override in 'text',
         *  use that to set the token's text.  Override this method to emit
         *  custom Token objects.
         */
        public Token emit() {
            Token t = new DroolsToken(input, state.type, state.channel, state.tokenStartCharIndex, getCharIndex()-1);
            t.setLine(state.tokenStartLine);
            t.setText(state.text);
            t.setCharPositionInLine(state.tokenStartCharPositionInLine);
            emit(t);
            return t;
        }

        public void reportError(RecognitionException ex) {
            errors.add(errorMessageFactory.createDroolsException(ex));
        }

        /** return the raw DroolsParserException errors */
        public List<DroolsParserException> getErrors() {
            return errors;
        }

        /** Overrided this method to not output mesages */
        public void emitErrorMessage(String msg) {
        }
        
        public String normalizeString( String input ) {
            if( input != null && input.length() >= 4 ) {
                input = input.substring( 1, input.length() - 1 ); 
                input = input.replaceAll( "\'", "'" );
                input = input.replaceAll( "\"", "\\\"" );
                input = "\"" + input + "\"";
            }
            return input;
        }

        public boolean isValidBashComment() {
            try {
                return input.substring(input.index() - input.getCharPositionInLine(), input.index() - 2).trim().length() == 0;
            } catch (Exception ex) {
                return false;
            }
        }


    // delegates
    // delegators

    public DRL6Lexer() {;} 
    public DRL6Lexer(CharStream input) {
        this(input, new RecognizerSharedState());
    }
    public DRL6Lexer(CharStream input, RecognizerSharedState state) {
        super(input,state);

    }
    public String getGrammarFileName() { return "src/main/resources/org/drools/lang/DRL6Lexer.g"; }

    // $ANTLR start "WS"
    public final void mWS() throws RecognitionException {
        try {
            int _type = WS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:71:9: ( ( ' ' | '\\t' | '\\f' | EOL )+ )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:71:17: ( ' ' | '\\t' | '\\f' | EOL )+
            {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:71:17: ( ' ' | '\\t' | '\\f' | EOL )+
            int cnt1=0;
            loop1:
            do {
                int alt1=5;
                switch ( input.LA(1) ) {
                case ' ':
                    {
                    alt1=1;
                    }
                    break;
                case '\t':
                    {
                    alt1=2;
                    }
                    break;
                case '\f':
                    {
                    alt1=3;
                    }
                    break;
                case '\n':
                case '\r':
                    {
                    alt1=4;
                    }
                    break;

                }

                switch (alt1) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:71:19: ' '
            	    {
            	    match(' '); if (state.failed) return ;

            	    }
            	    break;
            	case 2 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:72:19: '\\t'
            	    {
            	    match('\t'); if (state.failed) return ;

            	    }
            	    break;
            	case 3 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:73:19: '\\f'
            	    {
            	    match('\f'); if (state.failed) return ;

            	    }
            	    break;
            	case 4 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:74:19: EOL
            	    {
            	    mEOL(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    if ( cnt1 >= 1 ) break loop1;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(1, input);
                        throw eee;
                }
                cnt1++;
            } while (true);

            if ( state.backtracking==0 ) {
               _channel=HIDDEN; 
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "WS"

    // $ANTLR start "EOL"
    public final void mEOL() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:80:6: ( ( ( '\\r\\n' )=> '\\r\\n' | '\\r' | '\\n' ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:81:12: ( ( '\\r\\n' )=> '\\r\\n' | '\\r' | '\\n' )
            {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:81:12: ( ( '\\r\\n' )=> '\\r\\n' | '\\r' | '\\n' )
            int alt2=3;
            int LA2_0 = input.LA(1);

            if ( (LA2_0=='\r') ) {
                int LA2_1 = input.LA(2);

                if ( (LA2_1=='\n') && (synpred1_DRL6Lexer())) {
                    alt2=1;
                }
                else {
                    alt2=2;}
            }
            else if ( (LA2_0=='\n') ) {
                alt2=3;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }
            switch (alt2) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:81:20: ( '\\r\\n' )=> '\\r\\n'
                    {
                    match("\r\n"); if (state.failed) return ;


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:82:25: '\\r'
                    {
                    match('\r'); if (state.failed) return ;

                    }
                    break;
                case 3 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:83:25: '\\n'
                    {
                    match('\n'); if (state.failed) return ;

                    }
                    break;

            }


            }

        }
        finally {
        }
    }
    // $ANTLR end "EOL"

    // $ANTLR start "FLOAT"
    public final void mFLOAT() throws RecognitionException {
        try {
            int _type = FLOAT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:88:5: ( ( '0' .. '9' )+ '.' ( '0' .. '9' )* ( Exponent )? ( FloatTypeSuffix )? | '.' ( '0' .. '9' )+ ( Exponent )? ( FloatTypeSuffix )? | ( '0' .. '9' )+ Exponent ( FloatTypeSuffix )? | ( '0' .. '9' )+ FloatTypeSuffix )
            int alt13=4;
            alt13 = dfa13.predict(input);
            switch (alt13) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:9: ( '0' .. '9' )+ '.' ( '0' .. '9' )* ( Exponent )? ( FloatTypeSuffix )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:9: ( '0' .. '9' )+
                    int cnt3=0;
                    loop3:
                    do {
                        int alt3=2;
                        int LA3_0 = input.LA(1);

                        if ( ((LA3_0>='0' && LA3_0<='9')) ) {
                            alt3=1;
                        }


                        switch (alt3) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:10: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt3 >= 1 ) break loop3;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(3, input);
                                throw eee;
                        }
                        cnt3++;
                    } while (true);

                    match('.'); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:25: ( '0' .. '9' )*
                    loop4:
                    do {
                        int alt4=2;
                        int LA4_0 = input.LA(1);

                        if ( ((LA4_0>='0' && LA4_0<='9')) ) {
                            alt4=1;
                        }


                        switch (alt4) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:26: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    break loop4;
                        }
                    } while (true);

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:37: ( Exponent )?
                    int alt5=2;
                    int LA5_0 = input.LA(1);

                    if ( (LA5_0=='E'||LA5_0=='e') ) {
                        alt5=1;
                    }
                    switch (alt5) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:88:37: Exponent
                            {
                            mExponent(); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:88:47: ( FloatTypeSuffix )?
                    int alt6=2;
                    int LA6_0 = input.LA(1);

                    if ( (LA6_0=='B'||LA6_0=='D'||LA6_0=='F'||LA6_0=='d'||LA6_0=='f') ) {
                        alt6=1;
                    }
                    switch (alt6) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:88:47: FloatTypeSuffix
                            {
                            mFloatTypeSuffix(); if (state.failed) return ;

                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:89:9: '.' ( '0' .. '9' )+ ( Exponent )? ( FloatTypeSuffix )?
                    {
                    match('.'); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:89:13: ( '0' .. '9' )+
                    int cnt7=0;
                    loop7:
                    do {
                        int alt7=2;
                        int LA7_0 = input.LA(1);

                        if ( ((LA7_0>='0' && LA7_0<='9')) ) {
                            alt7=1;
                        }


                        switch (alt7) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:89:14: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt7 >= 1 ) break loop7;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(7, input);
                                throw eee;
                        }
                        cnt7++;
                    } while (true);

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:89:25: ( Exponent )?
                    int alt8=2;
                    int LA8_0 = input.LA(1);

                    if ( (LA8_0=='E'||LA8_0=='e') ) {
                        alt8=1;
                    }
                    switch (alt8) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:89:25: Exponent
                            {
                            mExponent(); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:89:35: ( FloatTypeSuffix )?
                    int alt9=2;
                    int LA9_0 = input.LA(1);

                    if ( (LA9_0=='B'||LA9_0=='D'||LA9_0=='F'||LA9_0=='d'||LA9_0=='f') ) {
                        alt9=1;
                    }
                    switch (alt9) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:89:35: FloatTypeSuffix
                            {
                            mFloatTypeSuffix(); if (state.failed) return ;

                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:90:9: ( '0' .. '9' )+ Exponent ( FloatTypeSuffix )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:90:9: ( '0' .. '9' )+
                    int cnt10=0;
                    loop10:
                    do {
                        int alt10=2;
                        int LA10_0 = input.LA(1);

                        if ( ((LA10_0>='0' && LA10_0<='9')) ) {
                            alt10=1;
                        }


                        switch (alt10) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:90:10: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt10 >= 1 ) break loop10;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(10, input);
                                throw eee;
                        }
                        cnt10++;
                    } while (true);

                    mExponent(); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:90:30: ( FloatTypeSuffix )?
                    int alt11=2;
                    int LA11_0 = input.LA(1);

                    if ( (LA11_0=='B'||LA11_0=='D'||LA11_0=='F'||LA11_0=='d'||LA11_0=='f') ) {
                        alt11=1;
                    }
                    switch (alt11) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:90:30: FloatTypeSuffix
                            {
                            mFloatTypeSuffix(); if (state.failed) return ;

                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:91:9: ( '0' .. '9' )+ FloatTypeSuffix
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:91:9: ( '0' .. '9' )+
                    int cnt12=0;
                    loop12:
                    do {
                        int alt12=2;
                        int LA12_0 = input.LA(1);

                        if ( ((LA12_0>='0' && LA12_0<='9')) ) {
                            alt12=1;
                        }


                        switch (alt12) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:91:10: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt12 >= 1 ) break loop12;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(12, input);
                                throw eee;
                        }
                        cnt12++;
                    } while (true);

                    mFloatTypeSuffix(); if (state.failed) return ;

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "FLOAT"

    // $ANTLR start "Exponent"
    public final void mExponent() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:95:10: ( ( 'e' | 'E' ) ( '+' | '-' )? ( '0' .. '9' )+ )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:95:12: ( 'e' | 'E' ) ( '+' | '-' )? ( '0' .. '9' )+
            {
            if ( input.LA(1)=='E'||input.LA(1)=='e' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            // src/main/resources/org/drools/lang/DRL6Lexer.g:95:22: ( '+' | '-' )?
            int alt14=2;
            int LA14_0 = input.LA(1);

            if ( (LA14_0=='+'||LA14_0=='-') ) {
                alt14=1;
            }
            switch (alt14) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:
                    {
                    if ( input.LA(1)=='+'||input.LA(1)=='-' ) {
                        input.consume();
                    state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;}


                    }
                    break;

            }

            // src/main/resources/org/drools/lang/DRL6Lexer.g:95:33: ( '0' .. '9' )+
            int cnt15=0;
            loop15:
            do {
                int alt15=2;
                int LA15_0 = input.LA(1);

                if ( ((LA15_0>='0' && LA15_0<='9')) ) {
                    alt15=1;
                }


                switch (alt15) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:95:34: '0' .. '9'
            	    {
            	    matchRange('0','9'); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    if ( cnt15 >= 1 ) break loop15;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(15, input);
                        throw eee;
                }
                cnt15++;
            } while (true);


            }

        }
        finally {
        }
    }
    // $ANTLR end "Exponent"

    // $ANTLR start "FloatTypeSuffix"
    public final void mFloatTypeSuffix() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:98:17: ( ( 'f' | 'F' | 'd' | 'D' | 'B' ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:98:19: ( 'f' | 'F' | 'd' | 'D' | 'B' )
            {
            if ( input.LA(1)=='B'||input.LA(1)=='D'||input.LA(1)=='F'||input.LA(1)=='d'||input.LA(1)=='f' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "FloatTypeSuffix"

    // $ANTLR start "HEX"
    public final void mHEX() throws RecognitionException {
        try {
            int _type = HEX;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:100:6: ( '0' ( 'x' | 'X' ) ( HexDigit )+ ( IntegerTypeSuffix )? )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:100:8: '0' ( 'x' | 'X' ) ( HexDigit )+ ( IntegerTypeSuffix )?
            {
            match('0'); if (state.failed) return ;
            if ( input.LA(1)=='X'||input.LA(1)=='x' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}

            // src/main/resources/org/drools/lang/DRL6Lexer.g:100:22: ( HexDigit )+
            int cnt16=0;
            loop16:
            do {
                int alt16=2;
                int LA16_0 = input.LA(1);

                if ( ((LA16_0>='0' && LA16_0<='9')||(LA16_0>='A' && LA16_0<='F')||(LA16_0>='a' && LA16_0<='f')) ) {
                    alt16=1;
                }


                switch (alt16) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:100:22: HexDigit
            	    {
            	    mHexDigit(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    if ( cnt16 >= 1 ) break loop16;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(16, input);
                        throw eee;
                }
                cnt16++;
            } while (true);

            // src/main/resources/org/drools/lang/DRL6Lexer.g:100:32: ( IntegerTypeSuffix )?
            int alt17=2;
            int LA17_0 = input.LA(1);

            if ( (LA17_0=='I'||LA17_0=='L'||LA17_0=='l') ) {
                alt17=1;
            }
            switch (alt17) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:100:32: IntegerTypeSuffix
                    {
                    mIntegerTypeSuffix(); if (state.failed) return ;

                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "HEX"

    // $ANTLR start "DECIMAL"
    public final void mDECIMAL() throws RecognitionException {
        try {
            int _type = DECIMAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:102:9: ( ( '0' .. '9' )+ ( IntegerTypeSuffix )? )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:102:11: ( '0' .. '9' )+ ( IntegerTypeSuffix )?
            {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:102:11: ( '0' .. '9' )+
            int cnt18=0;
            loop18:
            do {
                int alt18=2;
                int LA18_0 = input.LA(1);

                if ( ((LA18_0>='0' && LA18_0<='9')) ) {
                    alt18=1;
                }


                switch (alt18) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:102:12: '0' .. '9'
            	    {
            	    matchRange('0','9'); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    if ( cnt18 >= 1 ) break loop18;
            	    if (state.backtracking>0) {state.failed=true; return ;}
                        EarlyExitException eee =
                            new EarlyExitException(18, input);
                        throw eee;
                }
                cnt18++;
            } while (true);

            // src/main/resources/org/drools/lang/DRL6Lexer.g:102:23: ( IntegerTypeSuffix )?
            int alt19=2;
            int LA19_0 = input.LA(1);

            if ( (LA19_0=='I'||LA19_0=='L'||LA19_0=='l') ) {
                alt19=1;
            }
            switch (alt19) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:102:23: IntegerTypeSuffix
                    {
                    mIntegerTypeSuffix(); if (state.failed) return ;

                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DECIMAL"

    // $ANTLR start "IntegerTypeSuffix"
    public final void mIntegerTypeSuffix() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:105:19: ( ( 'l' | 'L' | 'I' ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:105:21: ( 'l' | 'L' | 'I' )
            {
            if ( input.LA(1)=='I'||input.LA(1)=='L'||input.LA(1)=='l' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "IntegerTypeSuffix"

    // $ANTLR start "STRING"
    public final void mSTRING() throws RecognitionException {
        try {
            int _type = STRING;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:108:5: ( ( '\"' ( EscapeSequence | ~ ( '\\\\' | '\"' ) )* '\"' ) | ( '\\'' ( EscapeSequence | ~ ( '\\\\' | '\\'' ) )* '\\'' ) )
            int alt22=2;
            int LA22_0 = input.LA(1);

            if ( (LA22_0=='\"') ) {
                alt22=1;
            }
            else if ( (LA22_0=='\'') ) {
                alt22=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 22, 0, input);

                throw nvae;
            }
            switch (alt22) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:108:8: ( '\"' ( EscapeSequence | ~ ( '\\\\' | '\"' ) )* '\"' )
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:108:8: ( '\"' ( EscapeSequence | ~ ( '\\\\' | '\"' ) )* '\"' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:108:9: '\"' ( EscapeSequence | ~ ( '\\\\' | '\"' ) )* '\"'
                    {
                    match('\"'); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:108:13: ( EscapeSequence | ~ ( '\\\\' | '\"' ) )*
                    loop20:
                    do {
                        int alt20=3;
                        int LA20_0 = input.LA(1);

                        if ( (LA20_0=='\\') ) {
                            alt20=1;
                        }
                        else if ( ((LA20_0>='\u0000' && LA20_0<='!')||(LA20_0>='#' && LA20_0<='[')||(LA20_0>=']' && LA20_0<='\uFFFF')) ) {
                            alt20=2;
                        }


                        switch (alt20) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:108:15: EscapeSequence
                    	    {
                    	    mEscapeSequence(); if (state.failed) return ;

                    	    }
                    	    break;
                    	case 2 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:108:32: ~ ( '\\\\' | '\"' )
                    	    {
                    	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='!')||(input.LA(1)>='#' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
                    	        input.consume();
                    	    state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;}


                    	    }
                    	    break;

                    	default :
                    	    break loop20;
                        }
                    } while (true);

                    match('\"'); if (state.failed) return ;

                    }


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:109:8: ( '\\'' ( EscapeSequence | ~ ( '\\\\' | '\\'' ) )* '\\'' )
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:109:8: ( '\\'' ( EscapeSequence | ~ ( '\\\\' | '\\'' ) )* '\\'' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:109:9: '\\'' ( EscapeSequence | ~ ( '\\\\' | '\\'' ) )* '\\''
                    {
                    match('\''); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:109:14: ( EscapeSequence | ~ ( '\\\\' | '\\'' ) )*
                    loop21:
                    do {
                        int alt21=3;
                        int LA21_0 = input.LA(1);

                        if ( (LA21_0=='\\') ) {
                            alt21=1;
                        }
                        else if ( ((LA21_0>='\u0000' && LA21_0<='&')||(LA21_0>='(' && LA21_0<='[')||(LA21_0>=']' && LA21_0<='\uFFFF')) ) {
                            alt21=2;
                        }


                        switch (alt21) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:109:16: EscapeSequence
                    	    {
                    	    mEscapeSequence(); if (state.failed) return ;

                    	    }
                    	    break;
                    	case 2 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:109:33: ~ ( '\\\\' | '\\'' )
                    	    {
                    	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='&')||(input.LA(1)>='(' && input.LA(1)<='[')||(input.LA(1)>=']' && input.LA(1)<='\uFFFF') ) {
                    	        input.consume();
                    	    state.failed=false;
                    	    }
                    	    else {
                    	        if (state.backtracking>0) {state.failed=true; return ;}
                    	        MismatchedSetException mse = new MismatchedSetException(null,input);
                    	        recover(mse);
                    	        throw mse;}


                    	    }
                    	    break;

                    	default :
                    	    break loop21;
                        }
                    } while (true);

                    match('\''); if (state.failed) return ;

                    }

                    if ( state.backtracking==0 ) {
                       setText( normalizeString( getText() ) ); 
                    }

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "STRING"

    // $ANTLR start "TIME_INTERVAL"
    public final void mTIME_INTERVAL() throws RecognitionException {
        try {
            int _type = TIME_INTERVAL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:5: ( ( ( '0' .. '9' )+ 'd' ) ( ( '0' .. '9' )+ 'h' )? ( ( '0' .. '9' )+ 'm' )? ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ 'h' ) ( ( '0' .. '9' )+ 'm' )? ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ 'm' ) ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ 's' ) ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ ( 'ms' )? ) )
            int alt53=5;
            alt53 = dfa53.predict(input);
            switch (alt53) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:7: ( ( '0' .. '9' )+ 'd' ) ( ( '0' .. '9' )+ 'h' )? ( ( '0' .. '9' )+ 'm' )? ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:7: ( ( '0' .. '9' )+ 'd' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:8: ( '0' .. '9' )+ 'd'
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:8: ( '0' .. '9' )+
                    int cnt23=0;
                    loop23:
                    do {
                        int alt23=2;
                        int LA23_0 = input.LA(1);

                        if ( ((LA23_0>='0' && LA23_0<='9')) ) {
                            alt23=1;
                        }


                        switch (alt23) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:9: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt23 >= 1 ) break loop23;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(23, input);
                                throw eee;
                        }
                        cnt23++;
                    } while (true);

                    match('d'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:25: ( ( '0' .. '9' )+ 'h' )?
                    int alt25=2;
                    alt25 = dfa25.predict(input);
                    switch (alt25) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:26: ( '0' .. '9' )+ 'h'
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:26: ( '0' .. '9' )+
                            int cnt24=0;
                            loop24:
                            do {
                                int alt24=2;
                                int LA24_0 = input.LA(1);

                                if ( ((LA24_0>='0' && LA24_0<='9')) ) {
                                    alt24=1;
                                }


                                switch (alt24) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:27: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt24 >= 1 ) break loop24;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(24, input);
                                        throw eee;
                                }
                                cnt24++;
                            } while (true);

                            match('h'); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:43: ( ( '0' .. '9' )+ 'm' )?
                    int alt27=2;
                    alt27 = dfa27.predict(input);
                    switch (alt27) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:44: ( '0' .. '9' )+ 'm'
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:44: ( '0' .. '9' )+
                            int cnt26=0;
                            loop26:
                            do {
                                int alt26=2;
                                int LA26_0 = input.LA(1);

                                if ( ((LA26_0>='0' && LA26_0<='9')) ) {
                                    alt26=1;
                                }


                                switch (alt26) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:45: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt26 >= 1 ) break loop26;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(26, input);
                                        throw eee;
                                }
                                cnt26++;
                            } while (true);

                            match('m'); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:61: ( ( '0' .. '9' )+ 's' )?
                    int alt29=2;
                    alt29 = dfa29.predict(input);
                    switch (alt29) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:62: ( '0' .. '9' )+ 's'
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:62: ( '0' .. '9' )+
                            int cnt28=0;
                            loop28:
                            do {
                                int alt28=2;
                                int LA28_0 = input.LA(1);

                                if ( ((LA28_0>='0' && LA28_0<='9')) ) {
                                    alt28=1;
                                }


                                switch (alt28) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:63: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt28 >= 1 ) break loop28;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(28, input);
                                        throw eee;
                                }
                                cnt28++;
                            } while (true);

                            match('s'); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:79: ( ( '0' .. '9' )+ ( 'ms' )? )?
                    int alt32=2;
                    int LA32_0 = input.LA(1);

                    if ( ((LA32_0>='0' && LA32_0<='9')) ) {
                        alt32=1;
                    }
                    switch (alt32) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:80: ( '0' .. '9' )+ ( 'ms' )?
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:80: ( '0' .. '9' )+
                            int cnt30=0;
                            loop30:
                            do {
                                int alt30=2;
                                int LA30_0 = input.LA(1);

                                if ( ((LA30_0>='0' && LA30_0<='9')) ) {
                                    alt30=1;
                                }


                                switch (alt30) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:81: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt30 >= 1 ) break loop30;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(30, input);
                                        throw eee;
                                }
                                cnt30++;
                            } while (true);

                            // src/main/resources/org/drools/lang/DRL6Lexer.g:114:92: ( 'ms' )?
                            int alt31=2;
                            int LA31_0 = input.LA(1);

                            if ( (LA31_0=='m') ) {
                                alt31=1;
                            }
                            switch (alt31) {
                                case 1 :
                                    // src/main/resources/org/drools/lang/DRL6Lexer.g:114:92: 'ms'
                                    {
                                    match("ms"); if (state.failed) return ;


                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:7: ( ( '0' .. '9' )+ 'h' ) ( ( '0' .. '9' )+ 'm' )? ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:7: ( ( '0' .. '9' )+ 'h' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:8: ( '0' .. '9' )+ 'h'
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:8: ( '0' .. '9' )+
                    int cnt33=0;
                    loop33:
                    do {
                        int alt33=2;
                        int LA33_0 = input.LA(1);

                        if ( ((LA33_0>='0' && LA33_0<='9')) ) {
                            alt33=1;
                        }


                        switch (alt33) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:9: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt33 >= 1 ) break loop33;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(33, input);
                                throw eee;
                        }
                        cnt33++;
                    } while (true);

                    match('h'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:25: ( ( '0' .. '9' )+ 'm' )?
                    int alt35=2;
                    alt35 = dfa35.predict(input);
                    switch (alt35) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:26: ( '0' .. '9' )+ 'm'
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:26: ( '0' .. '9' )+
                            int cnt34=0;
                            loop34:
                            do {
                                int alt34=2;
                                int LA34_0 = input.LA(1);

                                if ( ((LA34_0>='0' && LA34_0<='9')) ) {
                                    alt34=1;
                                }


                                switch (alt34) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:27: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt34 >= 1 ) break loop34;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(34, input);
                                        throw eee;
                                }
                                cnt34++;
                            } while (true);

                            match('m'); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:43: ( ( '0' .. '9' )+ 's' )?
                    int alt37=2;
                    alt37 = dfa37.predict(input);
                    switch (alt37) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:44: ( '0' .. '9' )+ 's'
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:44: ( '0' .. '9' )+
                            int cnt36=0;
                            loop36:
                            do {
                                int alt36=2;
                                int LA36_0 = input.LA(1);

                                if ( ((LA36_0>='0' && LA36_0<='9')) ) {
                                    alt36=1;
                                }


                                switch (alt36) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:45: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt36 >= 1 ) break loop36;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(36, input);
                                        throw eee;
                                }
                                cnt36++;
                            } while (true);

                            match('s'); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:61: ( ( '0' .. '9' )+ ( 'ms' )? )?
                    int alt40=2;
                    int LA40_0 = input.LA(1);

                    if ( ((LA40_0>='0' && LA40_0<='9')) ) {
                        alt40=1;
                    }
                    switch (alt40) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:62: ( '0' .. '9' )+ ( 'ms' )?
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:62: ( '0' .. '9' )+
                            int cnt38=0;
                            loop38:
                            do {
                                int alt38=2;
                                int LA38_0 = input.LA(1);

                                if ( ((LA38_0>='0' && LA38_0<='9')) ) {
                                    alt38=1;
                                }


                                switch (alt38) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:63: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt38 >= 1 ) break loop38;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(38, input);
                                        throw eee;
                                }
                                cnt38++;
                            } while (true);

                            // src/main/resources/org/drools/lang/DRL6Lexer.g:115:74: ( 'ms' )?
                            int alt39=2;
                            int LA39_0 = input.LA(1);

                            if ( (LA39_0=='m') ) {
                                alt39=1;
                            }
                            switch (alt39) {
                                case 1 :
                                    // src/main/resources/org/drools/lang/DRL6Lexer.g:115:74: 'ms'
                                    {
                                    match("ms"); if (state.failed) return ;


                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 3 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:7: ( ( '0' .. '9' )+ 'm' ) ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:7: ( ( '0' .. '9' )+ 'm' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:8: ( '0' .. '9' )+ 'm'
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:8: ( '0' .. '9' )+
                    int cnt41=0;
                    loop41:
                    do {
                        int alt41=2;
                        int LA41_0 = input.LA(1);

                        if ( ((LA41_0>='0' && LA41_0<='9')) ) {
                            alt41=1;
                        }


                        switch (alt41) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:9: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt41 >= 1 ) break loop41;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(41, input);
                                throw eee;
                        }
                        cnt41++;
                    } while (true);

                    match('m'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:25: ( ( '0' .. '9' )+ 's' )?
                    int alt43=2;
                    alt43 = dfa43.predict(input);
                    switch (alt43) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:116:26: ( '0' .. '9' )+ 's'
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:116:26: ( '0' .. '9' )+
                            int cnt42=0;
                            loop42:
                            do {
                                int alt42=2;
                                int LA42_0 = input.LA(1);

                                if ( ((LA42_0>='0' && LA42_0<='9')) ) {
                                    alt42=1;
                                }


                                switch (alt42) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:27: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt42 >= 1 ) break loop42;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(42, input);
                                        throw eee;
                                }
                                cnt42++;
                            } while (true);

                            match('s'); if (state.failed) return ;

                            }
                            break;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:43: ( ( '0' .. '9' )+ ( 'ms' )? )?
                    int alt46=2;
                    int LA46_0 = input.LA(1);

                    if ( ((LA46_0>='0' && LA46_0<='9')) ) {
                        alt46=1;
                    }
                    switch (alt46) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:116:44: ( '0' .. '9' )+ ( 'ms' )?
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:116:44: ( '0' .. '9' )+
                            int cnt44=0;
                            loop44:
                            do {
                                int alt44=2;
                                int LA44_0 = input.LA(1);

                                if ( ((LA44_0>='0' && LA44_0<='9')) ) {
                                    alt44=1;
                                }


                                switch (alt44) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:45: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt44 >= 1 ) break loop44;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(44, input);
                                        throw eee;
                                }
                                cnt44++;
                            } while (true);

                            // src/main/resources/org/drools/lang/DRL6Lexer.g:116:56: ( 'ms' )?
                            int alt45=2;
                            int LA45_0 = input.LA(1);

                            if ( (LA45_0=='m') ) {
                                alt45=1;
                            }
                            switch (alt45) {
                                case 1 :
                                    // src/main/resources/org/drools/lang/DRL6Lexer.g:116:56: 'ms'
                                    {
                                    match("ms"); if (state.failed) return ;


                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 4 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:7: ( ( '0' .. '9' )+ 's' ) ( ( '0' .. '9' )+ ( 'ms' )? )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:7: ( ( '0' .. '9' )+ 's' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:8: ( '0' .. '9' )+ 's'
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:8: ( '0' .. '9' )+
                    int cnt47=0;
                    loop47:
                    do {
                        int alt47=2;
                        int LA47_0 = input.LA(1);

                        if ( ((LA47_0>='0' && LA47_0<='9')) ) {
                            alt47=1;
                        }


                        switch (alt47) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:9: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt47 >= 1 ) break loop47;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(47, input);
                                throw eee;
                        }
                        cnt47++;
                    } while (true);

                    match('s'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:25: ( ( '0' .. '9' )+ ( 'ms' )? )?
                    int alt50=2;
                    int LA50_0 = input.LA(1);

                    if ( ((LA50_0>='0' && LA50_0<='9')) ) {
                        alt50=1;
                    }
                    switch (alt50) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:117:26: ( '0' .. '9' )+ ( 'ms' )?
                            {
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:117:26: ( '0' .. '9' )+
                            int cnt48=0;
                            loop48:
                            do {
                                int alt48=2;
                                int LA48_0 = input.LA(1);

                                if ( ((LA48_0>='0' && LA48_0<='9')) ) {
                                    alt48=1;
                                }


                                switch (alt48) {
                            	case 1 :
                            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:27: '0' .. '9'
                            	    {
                            	    matchRange('0','9'); if (state.failed) return ;

                            	    }
                            	    break;

                            	default :
                            	    if ( cnt48 >= 1 ) break loop48;
                            	    if (state.backtracking>0) {state.failed=true; return ;}
                                        EarlyExitException eee =
                                            new EarlyExitException(48, input);
                                        throw eee;
                                }
                                cnt48++;
                            } while (true);

                            // src/main/resources/org/drools/lang/DRL6Lexer.g:117:38: ( 'ms' )?
                            int alt49=2;
                            int LA49_0 = input.LA(1);

                            if ( (LA49_0=='m') ) {
                                alt49=1;
                            }
                            switch (alt49) {
                                case 1 :
                                    // src/main/resources/org/drools/lang/DRL6Lexer.g:117:38: 'ms'
                                    {
                                    match("ms"); if (state.failed) return ;


                                    }
                                    break;

                            }


                            }
                            break;

                    }


                    }
                    break;
                case 5 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:118:7: ( ( '0' .. '9' )+ ( 'ms' )? )
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:118:7: ( ( '0' .. '9' )+ ( 'ms' )? )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:118:8: ( '0' .. '9' )+ ( 'ms' )?
                    {
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:118:8: ( '0' .. '9' )+
                    int cnt51=0;
                    loop51:
                    do {
                        int alt51=2;
                        int LA51_0 = input.LA(1);

                        if ( ((LA51_0>='0' && LA51_0<='9')) ) {
                            alt51=1;
                        }


                        switch (alt51) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:118:9: '0' .. '9'
                    	    {
                    	    matchRange('0','9'); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    if ( cnt51 >= 1 ) break loop51;
                    	    if (state.backtracking>0) {state.failed=true; return ;}
                                EarlyExitException eee =
                                    new EarlyExitException(51, input);
                                throw eee;
                        }
                        cnt51++;
                    } while (true);

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:118:20: ( 'ms' )?
                    int alt52=2;
                    int LA52_0 = input.LA(1);

                    if ( (LA52_0=='m') ) {
                        alt52=1;
                    }
                    switch (alt52) {
                        case 1 :
                            // src/main/resources/org/drools/lang/DRL6Lexer.g:118:20: 'ms'
                            {
                            match("ms"); if (state.failed) return ;


                            }
                            break;

                    }


                    }


                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "TIME_INTERVAL"

    // $ANTLR start "HexDigit"
    public final void mHexDigit() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:122:10: ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:122:12: ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
            {
            if ( (input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='F')||(input.LA(1)>='a' && input.LA(1)<='f') ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "HexDigit"

    // $ANTLR start "EscapeSequence"
    public final void mEscapeSequence() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:126:5: ( '\\\\' ( 'b' | 'B' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' | '.' | 'o' | 'x' | 'a' | 'e' | 'c' | 'd' | 'D' | 's' | 'S' | 'w' | 'W' | 'p' | 'A' | 'G' | 'Z' | 'z' | 'Q' | 'E' | '*' | '[' | ']' | '(' | ')' | '$' | '^' | '{' | '}' | '?' | '+' | '-' | '&' | '|' ) | UnicodeEscape | OctalEscape )
            int alt54=3;
            int LA54_0 = input.LA(1);

            if ( (LA54_0=='\\') ) {
                switch ( input.LA(2) ) {
                case '\"':
                case '$':
                case '&':
                case '\'':
                case '(':
                case ')':
                case '*':
                case '+':
                case '-':
                case '.':
                case '?':
                case 'A':
                case 'B':
                case 'D':
                case 'E':
                case 'G':
                case 'Q':
                case 'S':
                case 'W':
                case 'Z':
                case '[':
                case '\\':
                case ']':
                case '^':
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                case 'n':
                case 'o':
                case 'p':
                case 'r':
                case 's':
                case 't':
                case 'w':
                case 'x':
                case 'z':
                case '{':
                case '|':
                case '}':
                    {
                    alt54=1;
                    }
                    break;
                case 'u':
                    {
                    alt54=2;
                    }
                    break;
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                    {
                    alt54=3;
                    }
                    break;
                default:
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 54, 1, input);

                    throw nvae;
                }

            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 54, 0, input);

                throw nvae;
            }
            switch (alt54) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:126:9: '\\\\' ( 'b' | 'B' | 't' | 'n' | 'f' | 'r' | '\\\"' | '\\'' | '\\\\' | '.' | 'o' | 'x' | 'a' | 'e' | 'c' | 'd' | 'D' | 's' | 'S' | 'w' | 'W' | 'p' | 'A' | 'G' | 'Z' | 'z' | 'Q' | 'E' | '*' | '[' | ']' | '(' | ')' | '$' | '^' | '{' | '}' | '?' | '+' | '-' | '&' | '|' )
                    {
                    match('\\'); if (state.failed) return ;
                    if ( input.LA(1)=='\"'||input.LA(1)=='$'||(input.LA(1)>='&' && input.LA(1)<='+')||(input.LA(1)>='-' && input.LA(1)<='.')||input.LA(1)=='?'||(input.LA(1)>='A' && input.LA(1)<='B')||(input.LA(1)>='D' && input.LA(1)<='E')||input.LA(1)=='G'||input.LA(1)=='Q'||input.LA(1)=='S'||input.LA(1)=='W'||(input.LA(1)>='Z' && input.LA(1)<='^')||(input.LA(1)>='a' && input.LA(1)<='f')||(input.LA(1)>='n' && input.LA(1)<='p')||(input.LA(1)>='r' && input.LA(1)<='t')||(input.LA(1)>='w' && input.LA(1)<='x')||(input.LA(1)>='z' && input.LA(1)<='}') ) {
                        input.consume();
                    state.failed=false;
                    }
                    else {
                        if (state.backtracking>0) {state.failed=true; return ;}
                        MismatchedSetException mse = new MismatchedSetException(null,input);
                        recover(mse);
                        throw mse;}


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:130:9: UnicodeEscape
                    {
                    mUnicodeEscape(); if (state.failed) return ;

                    }
                    break;
                case 3 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:131:9: OctalEscape
                    {
                    mOctalEscape(); if (state.failed) return ;

                    }
                    break;

            }
        }
        finally {
        }
    }
    // $ANTLR end "EscapeSequence"

    // $ANTLR start "OctalEscape"
    public final void mOctalEscape() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:136:5: ( '\\\\' ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' ) | '\\\\' ( '0' .. '7' ) ( '0' .. '7' ) | '\\\\' ( '0' .. '7' ) )
            int alt55=3;
            int LA55_0 = input.LA(1);

            if ( (LA55_0=='\\') ) {
                int LA55_1 = input.LA(2);

                if ( ((LA55_1>='0' && LA55_1<='3')) ) {
                    int LA55_2 = input.LA(3);

                    if ( ((LA55_2>='0' && LA55_2<='7')) ) {
                        int LA55_4 = input.LA(4);

                        if ( ((LA55_4>='0' && LA55_4<='7')) ) {
                            alt55=1;
                        }
                        else {
                            alt55=2;}
                    }
                    else {
                        alt55=3;}
                }
                else if ( ((LA55_1>='4' && LA55_1<='7')) ) {
                    int LA55_3 = input.LA(3);

                    if ( ((LA55_3>='0' && LA55_3<='7')) ) {
                        alt55=2;
                    }
                    else {
                        alt55=3;}
                }
                else {
                    if (state.backtracking>0) {state.failed=true; return ;}
                    NoViableAltException nvae =
                        new NoViableAltException("", 55, 1, input);

                    throw nvae;
                }
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 55, 0, input);

                throw nvae;
            }
            switch (alt55) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:9: '\\\\' ( '0' .. '3' ) ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    match('\\'); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:14: ( '0' .. '3' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:15: '0' .. '3'
                    {
                    matchRange('0','3'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:25: ( '0' .. '7' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:26: '0' .. '7'
                    {
                    matchRange('0','7'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:36: ( '0' .. '7' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:136:37: '0' .. '7'
                    {
                    matchRange('0','7'); if (state.failed) return ;

                    }


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:137:9: '\\\\' ( '0' .. '7' ) ( '0' .. '7' )
                    {
                    match('\\'); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:137:14: ( '0' .. '7' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:137:15: '0' .. '7'
                    {
                    matchRange('0','7'); if (state.failed) return ;

                    }

                    // src/main/resources/org/drools/lang/DRL6Lexer.g:137:25: ( '0' .. '7' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:137:26: '0' .. '7'
                    {
                    matchRange('0','7'); if (state.failed) return ;

                    }


                    }
                    break;
                case 3 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:138:9: '\\\\' ( '0' .. '7' )
                    {
                    match('\\'); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:138:14: ( '0' .. '7' )
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:138:15: '0' .. '7'
                    {
                    matchRange('0','7'); if (state.failed) return ;

                    }


                    }
                    break;

            }
        }
        finally {
        }
    }
    // $ANTLR end "OctalEscape"

    // $ANTLR start "UnicodeEscape"
    public final void mUnicodeEscape() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:143:5: ( '\\\\' 'u' HexDigit HexDigit HexDigit HexDigit )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:143:9: '\\\\' 'u' HexDigit HexDigit HexDigit HexDigit
            {
            match('\\'); if (state.failed) return ;
            match('u'); if (state.failed) return ;
            mHexDigit(); if (state.failed) return ;
            mHexDigit(); if (state.failed) return ;
            mHexDigit(); if (state.failed) return ;
            mHexDigit(); if (state.failed) return ;

            }

        }
        finally {
        }
    }
    // $ANTLR end "UnicodeEscape"

    // $ANTLR start "BOOL"
    public final void mBOOL() throws RecognitionException {
        try {
            int _type = BOOL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:146:6: ( ( 'true' | 'false' ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:146:8: ( 'true' | 'false' )
            {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:146:8: ( 'true' | 'false' )
            int alt56=2;
            int LA56_0 = input.LA(1);

            if ( (LA56_0=='t') ) {
                alt56=1;
            }
            else if ( (LA56_0=='f') ) {
                alt56=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 56, 0, input);

                throw nvae;
            }
            switch (alt56) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:146:9: 'true'
                    {
                    match("true"); if (state.failed) return ;


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:146:16: 'false'
                    {
                    match("false"); if (state.failed) return ;


                    }
                    break;

            }


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "BOOL"

    // $ANTLR start "NULL"
    public final void mNULL() throws RecognitionException {
        try {
            int _type = NULL;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:149:6: ( 'null' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:149:8: 'null'
            {
            match("null"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NULL"

    // $ANTLR start "AT"
    public final void mAT() throws RecognitionException {
        try {
            int _type = AT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:152:4: ( '@' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:152:6: '@'
            {
            match('@'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "AT"

    // $ANTLR start "PLUS_ASSIGN"
    public final void mPLUS_ASSIGN() throws RecognitionException {
        try {
            int _type = PLUS_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:156:5: ( '+=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:156:7: '+='
            {
            match("+="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "PLUS_ASSIGN"

    // $ANTLR start "MINUS_ASSIGN"
    public final void mMINUS_ASSIGN() throws RecognitionException {
        try {
            int _type = MINUS_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:160:5: ( '-=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:160:7: '-='
            {
            match("-="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MINUS_ASSIGN"

    // $ANTLR start "MULT_ASSIGN"
    public final void mMULT_ASSIGN() throws RecognitionException {
        try {
            int _type = MULT_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:164:5: ( '*=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:164:7: '*='
            {
            match("*="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MULT_ASSIGN"

    // $ANTLR start "DIV_ASSIGN"
    public final void mDIV_ASSIGN() throws RecognitionException {
        try {
            int _type = DIV_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:168:5: ( '/=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:168:7: '/='
            {
            match("/="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DIV_ASSIGN"

    // $ANTLR start "AND_ASSIGN"
    public final void mAND_ASSIGN() throws RecognitionException {
        try {
            int _type = AND_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:172:5: ( '&=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:172:7: '&='
            {
            match("&="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "AND_ASSIGN"

    // $ANTLR start "OR_ASSIGN"
    public final void mOR_ASSIGN() throws RecognitionException {
        try {
            int _type = OR_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:176:5: ( '|=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:176:7: '|='
            {
            match("|="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "OR_ASSIGN"

    // $ANTLR start "XOR_ASSIGN"
    public final void mXOR_ASSIGN() throws RecognitionException {
        try {
            int _type = XOR_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:180:5: ( '^=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:180:7: '^='
            {
            match("^="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "XOR_ASSIGN"

    // $ANTLR start "MOD_ASSIGN"
    public final void mMOD_ASSIGN() throws RecognitionException {
        try {
            int _type = MOD_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:184:5: ( '%=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:184:7: '%='
            {
            match("%="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MOD_ASSIGN"

    // $ANTLR start "UNIFY"
    public final void mUNIFY() throws RecognitionException {
        try {
            int _type = UNIFY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:188:5: ( ':=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:188:7: ':='
            {
            match(":="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "UNIFY"

    // $ANTLR start "DECR"
    public final void mDECR() throws RecognitionException {
        try {
            int _type = DECR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:191:6: ( '--' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:191:8: '--'
            {
            match("--"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DECR"

    // $ANTLR start "INCR"
    public final void mINCR() throws RecognitionException {
        try {
            int _type = INCR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:194:6: ( '++' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:194:8: '++'
            {
            match("++"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "INCR"

    // $ANTLR start "ARROW"
    public final void mARROW() throws RecognitionException {
        try {
            int _type = ARROW;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:198:5: ( '->' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:198:7: '->'
            {
            match("->"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ARROW"

    // $ANTLR start "SEMICOLON"
    public final void mSEMICOLON() throws RecognitionException {
        try {
            int _type = SEMICOLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:202:5: ( ';' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:202:7: ';'
            {
            match(';'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "SEMICOLON"

    // $ANTLR start "COLON"
    public final void mCOLON() throws RecognitionException {
        try {
            int _type = COLON;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:206:5: ( ':' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:206:7: ':'
            {
            match(':'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COLON"

    // $ANTLR start "EQUALS"
    public final void mEQUALS() throws RecognitionException {
        try {
            int _type = EQUALS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:210:5: ( '==' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:210:7: '=='
            {
            match("=="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "EQUALS"

    // $ANTLR start "NOT_EQUALS"
    public final void mNOT_EQUALS() throws RecognitionException {
        try {
            int _type = NOT_EQUALS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:214:5: ( '!=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:214:7: '!='
            {
            match("!="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NOT_EQUALS"

    // $ANTLR start "GREATER_EQUALS"
    public final void mGREATER_EQUALS() throws RecognitionException {
        try {
            int _type = GREATER_EQUALS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:218:5: ( '>=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:218:7: '>='
            {
            match(">="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GREATER_EQUALS"

    // $ANTLR start "LESS_EQUALS"
    public final void mLESS_EQUALS() throws RecognitionException {
        try {
            int _type = LESS_EQUALS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:222:5: ( '<=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:222:7: '<='
            {
            match("<="); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LESS_EQUALS"

    // $ANTLR start "GREATER"
    public final void mGREATER() throws RecognitionException {
        try {
            int _type = GREATER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:226:5: ( '>' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:226:7: '>'
            {
            match('>'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "GREATER"

    // $ANTLR start "LESS"
    public final void mLESS() throws RecognitionException {
        try {
            int _type = LESS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:230:5: ( '<' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:230:7: '<'
            {
            match('<'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LESS"

    // $ANTLR start "EQUALS_ASSIGN"
    public final void mEQUALS_ASSIGN() throws RecognitionException {
        try {
            int _type = EQUALS_ASSIGN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:234:5: ( '=' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:234:7: '='
            {
            match('='); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "EQUALS_ASSIGN"

    // $ANTLR start "LEFT_PAREN"
    public final void mLEFT_PAREN() throws RecognitionException {
        try {
            int _type = LEFT_PAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:238:9: ( '(' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:238:11: '('
            {
            match('('); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LEFT_PAREN"

    // $ANTLR start "RIGHT_PAREN"
    public final void mRIGHT_PAREN() throws RecognitionException {
        try {
            int _type = RIGHT_PAREN;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:242:9: ( ')' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:242:11: ')'
            {
            match(')'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RIGHT_PAREN"

    // $ANTLR start "LEFT_SQUARE"
    public final void mLEFT_SQUARE() throws RecognitionException {
        try {
            int _type = LEFT_SQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:246:9: ( '[' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:246:11: '['
            {
            match('['); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LEFT_SQUARE"

    // $ANTLR start "RIGHT_SQUARE"
    public final void mRIGHT_SQUARE() throws RecognitionException {
        try {
            int _type = RIGHT_SQUARE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:250:9: ( ']' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:250:11: ']'
            {
            match(']'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RIGHT_SQUARE"

    // $ANTLR start "LEFT_CURLY"
    public final void mLEFT_CURLY() throws RecognitionException {
        try {
            int _type = LEFT_CURLY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:254:9: ( '{' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:254:11: '{'
            {
            match('{'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "LEFT_CURLY"

    // $ANTLR start "RIGHT_CURLY"
    public final void mRIGHT_CURLY() throws RecognitionException {
        try {
            int _type = RIGHT_CURLY;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:258:9: ( '}' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:258:11: '}'
            {
            match('}'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "RIGHT_CURLY"

    // $ANTLR start "COMMA"
    public final void mCOMMA() throws RecognitionException {
        try {
            int _type = COMMA;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:261:7: ( ',' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:261:9: ','
            {
            match(','); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "COMMA"

    // $ANTLR start "DOT"
    public final void mDOT() throws RecognitionException {
        try {
            int _type = DOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:264:5: ( '.' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:264:7: '.'
            {
            match('.'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DOT"

    // $ANTLR start "NULL_SAFE_DOT"
    public final void mNULL_SAFE_DOT() throws RecognitionException {
        try {
            int _type = NULL_SAFE_DOT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:267:15: ( '!.' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:267:17: '!.'
            {
            match("!."); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NULL_SAFE_DOT"

    // $ANTLR start "DOUBLE_AMPER"
    public final void mDOUBLE_AMPER() throws RecognitionException {
        try {
            int _type = DOUBLE_AMPER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:271:5: ( '&&' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:271:7: '&&'
            {
            match("&&"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DOUBLE_AMPER"

    // $ANTLR start "DOUBLE_PIPE"
    public final void mDOUBLE_PIPE() throws RecognitionException {
        try {
            int _type = DOUBLE_PIPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:275:5: ( '||' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:275:7: '||'
            {
            match("||"); if (state.failed) return ;


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DOUBLE_PIPE"

    // $ANTLR start "QUESTION"
    public final void mQUESTION() throws RecognitionException {
        try {
            int _type = QUESTION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:279:5: ( '?' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:279:7: '?'
            {
            match('?'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "QUESTION"

    // $ANTLR start "NEGATION"
    public final void mNEGATION() throws RecognitionException {
        try {
            int _type = NEGATION;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:283:5: ( '!' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:283:7: '!'
            {
            match('!'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "NEGATION"

    // $ANTLR start "TILDE"
    public final void mTILDE() throws RecognitionException {
        try {
            int _type = TILDE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:287:5: ( '~' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:287:7: '~'
            {
            match('~'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "TILDE"

    // $ANTLR start "PIPE"
    public final void mPIPE() throws RecognitionException {
        try {
            int _type = PIPE;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:291:5: ( '|' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:291:7: '|'
            {
            match('|'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "PIPE"

    // $ANTLR start "AMPER"
    public final void mAMPER() throws RecognitionException {
        try {
            int _type = AMPER;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:295:5: ( '&' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:295:7: '&'
            {
            match('&'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "AMPER"

    // $ANTLR start "XOR"
    public final void mXOR() throws RecognitionException {
        try {
            int _type = XOR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:299:5: ( '^' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:299:7: '^'
            {
            match('^'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "XOR"

    // $ANTLR start "MOD"
    public final void mMOD() throws RecognitionException {
        try {
            int _type = MOD;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:303:5: ( '%' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:303:7: '%'
            {
            match('%'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MOD"

    // $ANTLR start "STAR"
    public final void mSTAR() throws RecognitionException {
        try {
            int _type = STAR;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:306:6: ( '*' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:306:8: '*'
            {
            match('*'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "STAR"

    // $ANTLR start "MINUS"
    public final void mMINUS() throws RecognitionException {
        try {
            int _type = MINUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:309:7: ( '-' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:309:9: '-'
            {
            match('-'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MINUS"

    // $ANTLR start "PLUS"
    public final void mPLUS() throws RecognitionException {
        try {
            int _type = PLUS;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:312:6: ( '+' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:312:8: '+'
            {
            match('+'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "PLUS"

    // $ANTLR start "SH_STYLE_SINGLE_LINE_COMMENT"
    public final void mSH_STYLE_SINGLE_LINE_COMMENT() throws RecognitionException {
        try {
            int _type = SH_STYLE_SINGLE_LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:316:5: ( '#' (~ ( '\\r' | '\\n' ) )* ( EOL | EOF ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:316:9: '#' (~ ( '\\r' | '\\n' ) )* ( EOL | EOF )
            {
            match('#'); if (state.failed) return ;
            if ( state.backtracking==0 ) {

                      if ( !isValidBashComment() ) {
                          state.type = SHARP;
                          return;
                      }
                  
            }
            // src/main/resources/org/drools/lang/DRL6Lexer.g:323:6: (~ ( '\\r' | '\\n' ) )*
            loop57:
            do {
                int alt57=2;
                int LA57_0 = input.LA(1);

                if ( ((LA57_0>='\u0000' && LA57_0<='\t')||(LA57_0>='\u000B' && LA57_0<='\f')||(LA57_0>='\u000E' && LA57_0<='\uFFFF')) ) {
                    alt57=1;
                }


                switch (alt57) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:323:7: ~ ( '\\r' | '\\n' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop57;
                }
            } while (true);

            // src/main/resources/org/drools/lang/DRL6Lexer.g:323:22: ( EOL | EOF )
            int alt58=2;
            int LA58_0 = input.LA(1);

            if ( (LA58_0=='\n'||LA58_0=='\r') ) {
                alt58=1;
            }
            else {
                alt58=2;}
            switch (alt58) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:323:23: EOL
                    {
                    mEOL(); if (state.failed) return ;

                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:323:27: EOF
                    {
                    match(EOF); if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               _channel=HIDDEN; setText("//"+getText().substring(1)); 
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "SH_STYLE_SINGLE_LINE_COMMENT"

    // $ANTLR start "C_STYLE_SINGLE_LINE_COMMENT"
    public final void mC_STYLE_SINGLE_LINE_COMMENT() throws RecognitionException {
        try {
            int _type = C_STYLE_SINGLE_LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:328:5: ( '//' (~ ( '\\r' | '\\n' ) )* ( EOL | EOF ) )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:328:7: '//' (~ ( '\\r' | '\\n' ) )* ( EOL | EOF )
            {
            match("//"); if (state.failed) return ;

            // src/main/resources/org/drools/lang/DRL6Lexer.g:328:12: (~ ( '\\r' | '\\n' ) )*
            loop59:
            do {
                int alt59=2;
                int LA59_0 = input.LA(1);

                if ( ((LA59_0>='\u0000' && LA59_0<='\t')||(LA59_0>='\u000B' && LA59_0<='\f')||(LA59_0>='\u000E' && LA59_0<='\uFFFF')) ) {
                    alt59=1;
                }


                switch (alt59) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:328:13: ~ ( '\\r' | '\\n' )
            	    {
            	    if ( (input.LA(1)>='\u0000' && input.LA(1)<='\t')||(input.LA(1)>='\u000B' && input.LA(1)<='\f')||(input.LA(1)>='\u000E' && input.LA(1)<='\uFFFF') ) {
            	        input.consume();
            	    state.failed=false;
            	    }
            	    else {
            	        if (state.backtracking>0) {state.failed=true; return ;}
            	        MismatchedSetException mse = new MismatchedSetException(null,input);
            	        recover(mse);
            	        throw mse;}


            	    }
            	    break;

            	default :
            	    break loop59;
                }
            } while (true);

            // src/main/resources/org/drools/lang/DRL6Lexer.g:328:28: ( EOL | EOF )
            int alt60=2;
            int LA60_0 = input.LA(1);

            if ( (LA60_0=='\n'||LA60_0=='\r') ) {
                alt60=1;
            }
            else {
                alt60=2;}
            switch (alt60) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:328:29: EOL
                    {
                    mEOL(); if (state.failed) return ;

                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:328:33: EOF
                    {
                    match(EOF); if (state.failed) return ;

                    }
                    break;

            }

            if ( state.backtracking==0 ) {
               _channel=HIDDEN; 
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "C_STYLE_SINGLE_LINE_COMMENT"

    // $ANTLR start "MULTI_LINE_COMMENT"
    public final void mMULTI_LINE_COMMENT() throws RecognitionException {
        try {
            int _type = MULTI_LINE_COMMENT;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:333:5: ( '/*' ( options {greedy=false; } : . )* '*/' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:333:7: '/*' ( options {greedy=false; } : . )* '*/'
            {
            match("/*"); if (state.failed) return ;

            // src/main/resources/org/drools/lang/DRL6Lexer.g:333:12: ( options {greedy=false; } : . )*
            loop61:
            do {
                int alt61=2;
                int LA61_0 = input.LA(1);

                if ( (LA61_0=='*') ) {
                    int LA61_1 = input.LA(2);

                    if ( (LA61_1=='/') ) {
                        alt61=2;
                    }
                    else if ( ((LA61_1>='\u0000' && LA61_1<='.')||(LA61_1>='0' && LA61_1<='\uFFFF')) ) {
                        alt61=1;
                    }


                }
                else if ( ((LA61_0>='\u0000' && LA61_0<=')')||(LA61_0>='+' && LA61_0<='\uFFFF')) ) {
                    alt61=1;
                }


                switch (alt61) {
            	case 1 :
            	    // src/main/resources/org/drools/lang/DRL6Lexer.g:333:38: .
            	    {
            	    matchAny(); if (state.failed) return ;

            	    }
            	    break;

            	default :
            	    break loop61;
                }
            } while (true);

            match("*/"); if (state.failed) return ;

            if ( state.backtracking==0 ) {
               _channel=HIDDEN; 
            }

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MULTI_LINE_COMMENT"

    // $ANTLR start "ID"
    public final void mID() throws RecognitionException {
        try {
            int _type = ID;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:338:5: ( IdentifierStart ( IdentifierPart )* | '`' IdentifierStart ( IdentifierPart )* '`' )
            int alt64=2;
            int LA64_0 = input.LA(1);

            if ( (LA64_0=='$'||(LA64_0>='A' && LA64_0<='Z')||LA64_0=='_'||(LA64_0>='a' && LA64_0<='z')||(LA64_0>='\u00A2' && LA64_0<='\u00A5')||LA64_0=='\u00AA'||LA64_0=='\u00B5'||LA64_0=='\u00BA'||(LA64_0>='\u00C0' && LA64_0<='\u00D6')||(LA64_0>='\u00D8' && LA64_0<='\u00F6')||(LA64_0>='\u00F8' && LA64_0<='\u0236')||(LA64_0>='\u0250' && LA64_0<='\u02C1')||(LA64_0>='\u02C6' && LA64_0<='\u02D1')||(LA64_0>='\u02E0' && LA64_0<='\u02E4')||LA64_0=='\u02EE'||LA64_0=='\u037A'||LA64_0=='\u0386'||(LA64_0>='\u0388' && LA64_0<='\u038A')||LA64_0=='\u038C'||(LA64_0>='\u038E' && LA64_0<='\u03A1')||(LA64_0>='\u03A3' && LA64_0<='\u03CE')||(LA64_0>='\u03D0' && LA64_0<='\u03F5')||(LA64_0>='\u03F7' && LA64_0<='\u03FB')||(LA64_0>='\u0400' && LA64_0<='\u0481')||(LA64_0>='\u048A' && LA64_0<='\u04CE')||(LA64_0>='\u04D0' && LA64_0<='\u04F5')||(LA64_0>='\u04F8' && LA64_0<='\u04F9')||(LA64_0>='\u0500' && LA64_0<='\u050F')||(LA64_0>='\u0531' && LA64_0<='\u0556')||LA64_0=='\u0559'||(LA64_0>='\u0561' && LA64_0<='\u0587')||(LA64_0>='\u05D0' && LA64_0<='\u05EA')||(LA64_0>='\u05F0' && LA64_0<='\u05F2')||(LA64_0>='\u0621' && LA64_0<='\u063A')||(LA64_0>='\u0640' && LA64_0<='\u064A')||(LA64_0>='\u066E' && LA64_0<='\u066F')||(LA64_0>='\u0671' && LA64_0<='\u06D3')||LA64_0=='\u06D5'||(LA64_0>='\u06E5' && LA64_0<='\u06E6')||(LA64_0>='\u06EE' && LA64_0<='\u06EF')||(LA64_0>='\u06FA' && LA64_0<='\u06FC')||LA64_0=='\u06FF'||LA64_0=='\u0710'||(LA64_0>='\u0712' && LA64_0<='\u072F')||(LA64_0>='\u074D' && LA64_0<='\u074F')||(LA64_0>='\u0780' && LA64_0<='\u07A5')||LA64_0=='\u07B1'||(LA64_0>='\u0904' && LA64_0<='\u0939')||LA64_0=='\u093D'||LA64_0=='\u0950'||(LA64_0>='\u0958' && LA64_0<='\u0961')||(LA64_0>='\u0985' && LA64_0<='\u098C')||(LA64_0>='\u098F' && LA64_0<='\u0990')||(LA64_0>='\u0993' && LA64_0<='\u09A8')||(LA64_0>='\u09AA' && LA64_0<='\u09B0')||LA64_0=='\u09B2'||(LA64_0>='\u09B6' && LA64_0<='\u09B9')||LA64_0=='\u09BD'||(LA64_0>='\u09DC' && LA64_0<='\u09DD')||(LA64_0>='\u09DF' && LA64_0<='\u09E1')||(LA64_0>='\u09F0' && LA64_0<='\u09F3')||(LA64_0>='\u0A05' && LA64_0<='\u0A0A')||(LA64_0>='\u0A0F' && LA64_0<='\u0A10')||(LA64_0>='\u0A13' && LA64_0<='\u0A28')||(LA64_0>='\u0A2A' && LA64_0<='\u0A30')||(LA64_0>='\u0A32' && LA64_0<='\u0A33')||(LA64_0>='\u0A35' && LA64_0<='\u0A36')||(LA64_0>='\u0A38' && LA64_0<='\u0A39')||(LA64_0>='\u0A59' && LA64_0<='\u0A5C')||LA64_0=='\u0A5E'||(LA64_0>='\u0A72' && LA64_0<='\u0A74')||(LA64_0>='\u0A85' && LA64_0<='\u0A8D')||(LA64_0>='\u0A8F' && LA64_0<='\u0A91')||(LA64_0>='\u0A93' && LA64_0<='\u0AA8')||(LA64_0>='\u0AAA' && LA64_0<='\u0AB0')||(LA64_0>='\u0AB2' && LA64_0<='\u0AB3')||(LA64_0>='\u0AB5' && LA64_0<='\u0AB9')||LA64_0=='\u0ABD'||LA64_0=='\u0AD0'||(LA64_0>='\u0AE0' && LA64_0<='\u0AE1')||LA64_0=='\u0AF1'||(LA64_0>='\u0B05' && LA64_0<='\u0B0C')||(LA64_0>='\u0B0F' && LA64_0<='\u0B10')||(LA64_0>='\u0B13' && LA64_0<='\u0B28')||(LA64_0>='\u0B2A' && LA64_0<='\u0B30')||(LA64_0>='\u0B32' && LA64_0<='\u0B33')||(LA64_0>='\u0B35' && LA64_0<='\u0B39')||LA64_0=='\u0B3D'||(LA64_0>='\u0B5C' && LA64_0<='\u0B5D')||(LA64_0>='\u0B5F' && LA64_0<='\u0B61')||LA64_0=='\u0B71'||LA64_0=='\u0B83'||(LA64_0>='\u0B85' && LA64_0<='\u0B8A')||(LA64_0>='\u0B8E' && LA64_0<='\u0B90')||(LA64_0>='\u0B92' && LA64_0<='\u0B95')||(LA64_0>='\u0B99' && LA64_0<='\u0B9A')||LA64_0=='\u0B9C'||(LA64_0>='\u0B9E' && LA64_0<='\u0B9F')||(LA64_0>='\u0BA3' && LA64_0<='\u0BA4')||(LA64_0>='\u0BA8' && LA64_0<='\u0BAA')||(LA64_0>='\u0BAE' && LA64_0<='\u0BB5')||(LA64_0>='\u0BB7' && LA64_0<='\u0BB9')||LA64_0=='\u0BF9'||(LA64_0>='\u0C05' && LA64_0<='\u0C0C')||(LA64_0>='\u0C0E' && LA64_0<='\u0C10')||(LA64_0>='\u0C12' && LA64_0<='\u0C28')||(LA64_0>='\u0C2A' && LA64_0<='\u0C33')||(LA64_0>='\u0C35' && LA64_0<='\u0C39')||(LA64_0>='\u0C60' && LA64_0<='\u0C61')||(LA64_0>='\u0C85' && LA64_0<='\u0C8C')||(LA64_0>='\u0C8E' && LA64_0<='\u0C90')||(LA64_0>='\u0C92' && LA64_0<='\u0CA8')||(LA64_0>='\u0CAA' && LA64_0<='\u0CB3')||(LA64_0>='\u0CB5' && LA64_0<='\u0CB9')||LA64_0=='\u0CBD'||LA64_0=='\u0CDE'||(LA64_0>='\u0CE0' && LA64_0<='\u0CE1')||(LA64_0>='\u0D05' && LA64_0<='\u0D0C')||(LA64_0>='\u0D0E' && LA64_0<='\u0D10')||(LA64_0>='\u0D12' && LA64_0<='\u0D28')||(LA64_0>='\u0D2A' && LA64_0<='\u0D39')||(LA64_0>='\u0D60' && LA64_0<='\u0D61')||(LA64_0>='\u0D85' && LA64_0<='\u0D96')||(LA64_0>='\u0D9A' && LA64_0<='\u0DB1')||(LA64_0>='\u0DB3' && LA64_0<='\u0DBB')||LA64_0=='\u0DBD'||(LA64_0>='\u0DC0' && LA64_0<='\u0DC6')||(LA64_0>='\u0E01' && LA64_0<='\u0E30')||(LA64_0>='\u0E32' && LA64_0<='\u0E33')||(LA64_0>='\u0E3F' && LA64_0<='\u0E46')||(LA64_0>='\u0E81' && LA64_0<='\u0E82')||LA64_0=='\u0E84'||(LA64_0>='\u0E87' && LA64_0<='\u0E88')||LA64_0=='\u0E8A'||LA64_0=='\u0E8D'||(LA64_0>='\u0E94' && LA64_0<='\u0E97')||(LA64_0>='\u0E99' && LA64_0<='\u0E9F')||(LA64_0>='\u0EA1' && LA64_0<='\u0EA3')||LA64_0=='\u0EA5'||LA64_0=='\u0EA7'||(LA64_0>='\u0EAA' && LA64_0<='\u0EAB')||(LA64_0>='\u0EAD' && LA64_0<='\u0EB0')||(LA64_0>='\u0EB2' && LA64_0<='\u0EB3')||LA64_0=='\u0EBD'||(LA64_0>='\u0EC0' && LA64_0<='\u0EC4')||LA64_0=='\u0EC6'||(LA64_0>='\u0EDC' && LA64_0<='\u0EDD')||LA64_0=='\u0F00'||(LA64_0>='\u0F40' && LA64_0<='\u0F47')||(LA64_0>='\u0F49' && LA64_0<='\u0F6A')||(LA64_0>='\u0F88' && LA64_0<='\u0F8B')||(LA64_0>='\u1000' && LA64_0<='\u1021')||(LA64_0>='\u1023' && LA64_0<='\u1027')||(LA64_0>='\u1029' && LA64_0<='\u102A')||(LA64_0>='\u1050' && LA64_0<='\u1055')||(LA64_0>='\u10A0' && LA64_0<='\u10C5')||(LA64_0>='\u10D0' && LA64_0<='\u10F8')||(LA64_0>='\u1100' && LA64_0<='\u1159')||(LA64_0>='\u115F' && LA64_0<='\u11A2')||(LA64_0>='\u11A8' && LA64_0<='\u11F9')||(LA64_0>='\u1200' && LA64_0<='\u1206')||(LA64_0>='\u1208' && LA64_0<='\u1246')||LA64_0=='\u1248'||(LA64_0>='\u124A' && LA64_0<='\u124D')||(LA64_0>='\u1250' && LA64_0<='\u1256')||LA64_0=='\u1258'||(LA64_0>='\u125A' && LA64_0<='\u125D')||(LA64_0>='\u1260' && LA64_0<='\u1286')||LA64_0=='\u1288'||(LA64_0>='\u128A' && LA64_0<='\u128D')||(LA64_0>='\u1290' && LA64_0<='\u12AE')||LA64_0=='\u12B0'||(LA64_0>='\u12B2' && LA64_0<='\u12B5')||(LA64_0>='\u12B8' && LA64_0<='\u12BE')||LA64_0=='\u12C0'||(LA64_0>='\u12C2' && LA64_0<='\u12C5')||(LA64_0>='\u12C8' && LA64_0<='\u12CE')||(LA64_0>='\u12D0' && LA64_0<='\u12D6')||(LA64_0>='\u12D8' && LA64_0<='\u12EE')||(LA64_0>='\u12F0' && LA64_0<='\u130E')||LA64_0=='\u1310'||(LA64_0>='\u1312' && LA64_0<='\u1315')||(LA64_0>='\u1318' && LA64_0<='\u131E')||(LA64_0>='\u1320' && LA64_0<='\u1346')||(LA64_0>='\u1348' && LA64_0<='\u135A')||(LA64_0>='\u13A0' && LA64_0<='\u13F4')||(LA64_0>='\u1401' && LA64_0<='\u166C')||(LA64_0>='\u166F' && LA64_0<='\u1676')||(LA64_0>='\u1681' && LA64_0<='\u169A')||(LA64_0>='\u16A0' && LA64_0<='\u16EA')||(LA64_0>='\u16EE' && LA64_0<='\u16F0')||(LA64_0>='\u1700' && LA64_0<='\u170C')||(LA64_0>='\u170E' && LA64_0<='\u1711')||(LA64_0>='\u1720' && LA64_0<='\u1731')||(LA64_0>='\u1740' && LA64_0<='\u1751')||(LA64_0>='\u1760' && LA64_0<='\u176C')||(LA64_0>='\u176E' && LA64_0<='\u1770')||(LA64_0>='\u1780' && LA64_0<='\u17B3')||LA64_0=='\u17D7'||(LA64_0>='\u17DB' && LA64_0<='\u17DC')||(LA64_0>='\u1820' && LA64_0<='\u1877')||(LA64_0>='\u1880' && LA64_0<='\u18A8')||(LA64_0>='\u1900' && LA64_0<='\u191C')||(LA64_0>='\u1950' && LA64_0<='\u196D')||(LA64_0>='\u1970' && LA64_0<='\u1974')||(LA64_0>='\u1D00' && LA64_0<='\u1D6B')||(LA64_0>='\u1E00' && LA64_0<='\u1E9B')||(LA64_0>='\u1EA0' && LA64_0<='\u1EF9')||(LA64_0>='\u1F00' && LA64_0<='\u1F15')||(LA64_0>='\u1F18' && LA64_0<='\u1F1D')||(LA64_0>='\u1F20' && LA64_0<='\u1F45')||(LA64_0>='\u1F48' && LA64_0<='\u1F4D')||(LA64_0>='\u1F50' && LA64_0<='\u1F57')||LA64_0=='\u1F59'||LA64_0=='\u1F5B'||LA64_0=='\u1F5D'||(LA64_0>='\u1F5F' && LA64_0<='\u1F7D')||(LA64_0>='\u1F80' && LA64_0<='\u1FB4')||(LA64_0>='\u1FB6' && LA64_0<='\u1FBC')||LA64_0=='\u1FBE'||(LA64_0>='\u1FC2' && LA64_0<='\u1FC4')||(LA64_0>='\u1FC6' && LA64_0<='\u1FCC')||(LA64_0>='\u1FD0' && LA64_0<='\u1FD3')||(LA64_0>='\u1FD6' && LA64_0<='\u1FDB')||(LA64_0>='\u1FE0' && LA64_0<='\u1FEC')||(LA64_0>='\u1FF2' && LA64_0<='\u1FF4')||(LA64_0>='\u1FF6' && LA64_0<='\u1FFC')||(LA64_0>='\u203F' && LA64_0<='\u2040')||LA64_0=='\u2054'||LA64_0=='\u2071'||LA64_0=='\u207F'||(LA64_0>='\u20A0' && LA64_0<='\u20B1')||LA64_0=='\u2102'||LA64_0=='\u2107'||(LA64_0>='\u210A' && LA64_0<='\u2113')||LA64_0=='\u2115'||(LA64_0>='\u2119' && LA64_0<='\u211D')||LA64_0=='\u2124'||LA64_0=='\u2126'||LA64_0=='\u2128'||(LA64_0>='\u212A' && LA64_0<='\u212D')||(LA64_0>='\u212F' && LA64_0<='\u2131')||(LA64_0>='\u2133' && LA64_0<='\u2139')||(LA64_0>='\u213D' && LA64_0<='\u213F')||(LA64_0>='\u2145' && LA64_0<='\u2149')||(LA64_0>='\u2160' && LA64_0<='\u2183')||(LA64_0>='\u3005' && LA64_0<='\u3007')||(LA64_0>='\u3021' && LA64_0<='\u3029')||(LA64_0>='\u3031' && LA64_0<='\u3035')||(LA64_0>='\u3038' && LA64_0<='\u303C')||(LA64_0>='\u3041' && LA64_0<='\u3096')||(LA64_0>='\u309D' && LA64_0<='\u309F')||(LA64_0>='\u30A1' && LA64_0<='\u30FF')||(LA64_0>='\u3105' && LA64_0<='\u312C')||(LA64_0>='\u3131' && LA64_0<='\u318E')||(LA64_0>='\u31A0' && LA64_0<='\u31B7')||(LA64_0>='\u31F0' && LA64_0<='\u31FF')||(LA64_0>='\u3400' && LA64_0<='\u4DB5')||(LA64_0>='\u4E00' && LA64_0<='\u9FA5')||(LA64_0>='\uA000' && LA64_0<='\uA48C')||(LA64_0>='\uAC00' && LA64_0<='\uD7A3')||(LA64_0>='\uF900' && LA64_0<='\uFA2D')||(LA64_0>='\uFA30' && LA64_0<='\uFA6A')||(LA64_0>='\uFB00' && LA64_0<='\uFB06')||(LA64_0>='\uFB13' && LA64_0<='\uFB17')||LA64_0=='\uFB1D'||(LA64_0>='\uFB1F' && LA64_0<='\uFB28')||(LA64_0>='\uFB2A' && LA64_0<='\uFB36')||(LA64_0>='\uFB38' && LA64_0<='\uFB3C')||LA64_0=='\uFB3E'||(LA64_0>='\uFB40' && LA64_0<='\uFB41')||(LA64_0>='\uFB43' && LA64_0<='\uFB44')||(LA64_0>='\uFB46' && LA64_0<='\uFBB1')||(LA64_0>='\uFBD3' && LA64_0<='\uFD3D')||(LA64_0>='\uFD50' && LA64_0<='\uFD8F')||(LA64_0>='\uFD92' && LA64_0<='\uFDC7')||(LA64_0>='\uFDF0' && LA64_0<='\uFDFC')||(LA64_0>='\uFE33' && LA64_0<='\uFE34')||(LA64_0>='\uFE4D' && LA64_0<='\uFE4F')||LA64_0=='\uFE69'||(LA64_0>='\uFE70' && LA64_0<='\uFE74')||(LA64_0>='\uFE76' && LA64_0<='\uFEFC')||LA64_0=='\uFF04'||(LA64_0>='\uFF21' && LA64_0<='\uFF3A')||LA64_0=='\uFF3F'||(LA64_0>='\uFF41' && LA64_0<='\uFF5A')||(LA64_0>='\uFF65' && LA64_0<='\uFFBE')||(LA64_0>='\uFFC2' && LA64_0<='\uFFC7')||(LA64_0>='\uFFCA' && LA64_0<='\uFFCF')||(LA64_0>='\uFFD2' && LA64_0<='\uFFD7')||(LA64_0>='\uFFDA' && LA64_0<='\uFFDC')||(LA64_0>='\uFFE0' && LA64_0<='\uFFE1')||(LA64_0>='\uFFE5' && LA64_0<='\uFFE6')) ) {
                alt64=1;
            }
            else if ( (LA64_0=='`') ) {
                alt64=2;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                NoViableAltException nvae =
                    new NoViableAltException("", 64, 0, input);

                throw nvae;
            }
            switch (alt64) {
                case 1 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:338:7: IdentifierStart ( IdentifierPart )*
                    {
                    mIdentifierStart(); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:338:23: ( IdentifierPart )*
                    loop62:
                    do {
                        int alt62=2;
                        int LA62_0 = input.LA(1);

                        if ( ((LA62_0>='\u0000' && LA62_0<='\b')||(LA62_0>='\u000E' && LA62_0<='\u001B')||LA62_0=='$'||(LA62_0>='0' && LA62_0<='9')||(LA62_0>='A' && LA62_0<='Z')||LA62_0=='_'||(LA62_0>='a' && LA62_0<='z')||(LA62_0>='\u007F' && LA62_0<='\u009F')||(LA62_0>='\u00A2' && LA62_0<='\u00A5')||LA62_0=='\u00AA'||LA62_0=='\u00AD'||LA62_0=='\u00B5'||LA62_0=='\u00BA'||(LA62_0>='\u00C0' && LA62_0<='\u00D6')||(LA62_0>='\u00D8' && LA62_0<='\u00F6')||(LA62_0>='\u00F8' && LA62_0<='\u0236')||(LA62_0>='\u0250' && LA62_0<='\u02C1')||(LA62_0>='\u02C6' && LA62_0<='\u02D1')||(LA62_0>='\u02E0' && LA62_0<='\u02E4')||LA62_0=='\u02EE'||(LA62_0>='\u0300' && LA62_0<='\u0357')||(LA62_0>='\u035D' && LA62_0<='\u036F')||LA62_0=='\u037A'||LA62_0=='\u0386'||(LA62_0>='\u0388' && LA62_0<='\u038A')||LA62_0=='\u038C'||(LA62_0>='\u038E' && LA62_0<='\u03A1')||(LA62_0>='\u03A3' && LA62_0<='\u03CE')||(LA62_0>='\u03D0' && LA62_0<='\u03F5')||(LA62_0>='\u03F7' && LA62_0<='\u03FB')||(LA62_0>='\u0400' && LA62_0<='\u0481')||(LA62_0>='\u0483' && LA62_0<='\u0486')||(LA62_0>='\u048A' && LA62_0<='\u04CE')||(LA62_0>='\u04D0' && LA62_0<='\u04F5')||(LA62_0>='\u04F8' && LA62_0<='\u04F9')||(LA62_0>='\u0500' && LA62_0<='\u050F')||(LA62_0>='\u0531' && LA62_0<='\u0556')||LA62_0=='\u0559'||(LA62_0>='\u0561' && LA62_0<='\u0587')||(LA62_0>='\u0591' && LA62_0<='\u05A1')||(LA62_0>='\u05A3' && LA62_0<='\u05B9')||(LA62_0>='\u05BB' && LA62_0<='\u05BD')||LA62_0=='\u05BF'||(LA62_0>='\u05C1' && LA62_0<='\u05C2')||LA62_0=='\u05C4'||(LA62_0>='\u05D0' && LA62_0<='\u05EA')||(LA62_0>='\u05F0' && LA62_0<='\u05F2')||(LA62_0>='\u0600' && LA62_0<='\u0603')||(LA62_0>='\u0610' && LA62_0<='\u0615')||(LA62_0>='\u0621' && LA62_0<='\u063A')||(LA62_0>='\u0640' && LA62_0<='\u0658')||(LA62_0>='\u0660' && LA62_0<='\u0669')||(LA62_0>='\u066E' && LA62_0<='\u06D3')||(LA62_0>='\u06D5' && LA62_0<='\u06DD')||(LA62_0>='\u06DF' && LA62_0<='\u06E8')||(LA62_0>='\u06EA' && LA62_0<='\u06FC')||LA62_0=='\u06FF'||(LA62_0>='\u070F' && LA62_0<='\u074A')||(LA62_0>='\u074D' && LA62_0<='\u074F')||(LA62_0>='\u0780' && LA62_0<='\u07B1')||(LA62_0>='\u0901' && LA62_0<='\u0939')||(LA62_0>='\u093C' && LA62_0<='\u094D')||(LA62_0>='\u0950' && LA62_0<='\u0954')||(LA62_0>='\u0958' && LA62_0<='\u0963')||(LA62_0>='\u0966' && LA62_0<='\u096F')||(LA62_0>='\u0981' && LA62_0<='\u0983')||(LA62_0>='\u0985' && LA62_0<='\u098C')||(LA62_0>='\u098F' && LA62_0<='\u0990')||(LA62_0>='\u0993' && LA62_0<='\u09A8')||(LA62_0>='\u09AA' && LA62_0<='\u09B0')||LA62_0=='\u09B2'||(LA62_0>='\u09B6' && LA62_0<='\u09B9')||(LA62_0>='\u09BC' && LA62_0<='\u09C4')||(LA62_0>='\u09C7' && LA62_0<='\u09C8')||(LA62_0>='\u09CB' && LA62_0<='\u09CD')||LA62_0=='\u09D7'||(LA62_0>='\u09DC' && LA62_0<='\u09DD')||(LA62_0>='\u09DF' && LA62_0<='\u09E3')||(LA62_0>='\u09E6' && LA62_0<='\u09F3')||(LA62_0>='\u0A01' && LA62_0<='\u0A03')||(LA62_0>='\u0A05' && LA62_0<='\u0A0A')||(LA62_0>='\u0A0F' && LA62_0<='\u0A10')||(LA62_0>='\u0A13' && LA62_0<='\u0A28')||(LA62_0>='\u0A2A' && LA62_0<='\u0A30')||(LA62_0>='\u0A32' && LA62_0<='\u0A33')||(LA62_0>='\u0A35' && LA62_0<='\u0A36')||(LA62_0>='\u0A38' && LA62_0<='\u0A39')||LA62_0=='\u0A3C'||(LA62_0>='\u0A3E' && LA62_0<='\u0A42')||(LA62_0>='\u0A47' && LA62_0<='\u0A48')||(LA62_0>='\u0A4B' && LA62_0<='\u0A4D')||(LA62_0>='\u0A59' && LA62_0<='\u0A5C')||LA62_0=='\u0A5E'||(LA62_0>='\u0A66' && LA62_0<='\u0A74')||(LA62_0>='\u0A81' && LA62_0<='\u0A83')||(LA62_0>='\u0A85' && LA62_0<='\u0A8D')||(LA62_0>='\u0A8F' && LA62_0<='\u0A91')||(LA62_0>='\u0A93' && LA62_0<='\u0AA8')||(LA62_0>='\u0AAA' && LA62_0<='\u0AB0')||(LA62_0>='\u0AB2' && LA62_0<='\u0AB3')||(LA62_0>='\u0AB5' && LA62_0<='\u0AB9')||(LA62_0>='\u0ABC' && LA62_0<='\u0AC5')||(LA62_0>='\u0AC7' && LA62_0<='\u0AC9')||(LA62_0>='\u0ACB' && LA62_0<='\u0ACD')||LA62_0=='\u0AD0'||(LA62_0>='\u0AE0' && LA62_0<='\u0AE3')||(LA62_0>='\u0AE6' && LA62_0<='\u0AEF')||LA62_0=='\u0AF1'||(LA62_0>='\u0B01' && LA62_0<='\u0B03')||(LA62_0>='\u0B05' && LA62_0<='\u0B0C')||(LA62_0>='\u0B0F' && LA62_0<='\u0B10')||(LA62_0>='\u0B13' && LA62_0<='\u0B28')||(LA62_0>='\u0B2A' && LA62_0<='\u0B30')||(LA62_0>='\u0B32' && LA62_0<='\u0B33')||(LA62_0>='\u0B35' && LA62_0<='\u0B39')||(LA62_0>='\u0B3C' && LA62_0<='\u0B43')||(LA62_0>='\u0B47' && LA62_0<='\u0B48')||(LA62_0>='\u0B4B' && LA62_0<='\u0B4D')||(LA62_0>='\u0B56' && LA62_0<='\u0B57')||(LA62_0>='\u0B5C' && LA62_0<='\u0B5D')||(LA62_0>='\u0B5F' && LA62_0<='\u0B61')||(LA62_0>='\u0B66' && LA62_0<='\u0B6F')||LA62_0=='\u0B71'||(LA62_0>='\u0B82' && LA62_0<='\u0B83')||(LA62_0>='\u0B85' && LA62_0<='\u0B8A')||(LA62_0>='\u0B8E' && LA62_0<='\u0B90')||(LA62_0>='\u0B92' && LA62_0<='\u0B95')||(LA62_0>='\u0B99' && LA62_0<='\u0B9A')||LA62_0=='\u0B9C'||(LA62_0>='\u0B9E' && LA62_0<='\u0B9F')||(LA62_0>='\u0BA3' && LA62_0<='\u0BA4')||(LA62_0>='\u0BA8' && LA62_0<='\u0BAA')||(LA62_0>='\u0BAE' && LA62_0<='\u0BB5')||(LA62_0>='\u0BB7' && LA62_0<='\u0BB9')||(LA62_0>='\u0BBE' && LA62_0<='\u0BC2')||(LA62_0>='\u0BC6' && LA62_0<='\u0BC8')||(LA62_0>='\u0BCA' && LA62_0<='\u0BCD')||LA62_0=='\u0BD7'||(LA62_0>='\u0BE7' && LA62_0<='\u0BEF')||LA62_0=='\u0BF9'||(LA62_0>='\u0C01' && LA62_0<='\u0C03')||(LA62_0>='\u0C05' && LA62_0<='\u0C0C')||(LA62_0>='\u0C0E' && LA62_0<='\u0C10')||(LA62_0>='\u0C12' && LA62_0<='\u0C28')||(LA62_0>='\u0C2A' && LA62_0<='\u0C33')||(LA62_0>='\u0C35' && LA62_0<='\u0C39')||(LA62_0>='\u0C3E' && LA62_0<='\u0C44')||(LA62_0>='\u0C46' && LA62_0<='\u0C48')||(LA62_0>='\u0C4A' && LA62_0<='\u0C4D')||(LA62_0>='\u0C55' && LA62_0<='\u0C56')||(LA62_0>='\u0C60' && LA62_0<='\u0C61')||(LA62_0>='\u0C66' && LA62_0<='\u0C6F')||(LA62_0>='\u0C82' && LA62_0<='\u0C83')||(LA62_0>='\u0C85' && LA62_0<='\u0C8C')||(LA62_0>='\u0C8E' && LA62_0<='\u0C90')||(LA62_0>='\u0C92' && LA62_0<='\u0CA8')||(LA62_0>='\u0CAA' && LA62_0<='\u0CB3')||(LA62_0>='\u0CB5' && LA62_0<='\u0CB9')||(LA62_0>='\u0CBC' && LA62_0<='\u0CC4')||(LA62_0>='\u0CC6' && LA62_0<='\u0CC8')||(LA62_0>='\u0CCA' && LA62_0<='\u0CCD')||(LA62_0>='\u0CD5' && LA62_0<='\u0CD6')||LA62_0=='\u0CDE'||(LA62_0>='\u0CE0' && LA62_0<='\u0CE1')||(LA62_0>='\u0CE6' && LA62_0<='\u0CEF')||(LA62_0>='\u0D02' && LA62_0<='\u0D03')||(LA62_0>='\u0D05' && LA62_0<='\u0D0C')||(LA62_0>='\u0D0E' && LA62_0<='\u0D10')||(LA62_0>='\u0D12' && LA62_0<='\u0D28')||(LA62_0>='\u0D2A' && LA62_0<='\u0D39')||(LA62_0>='\u0D3E' && LA62_0<='\u0D43')||(LA62_0>='\u0D46' && LA62_0<='\u0D48')||(LA62_0>='\u0D4A' && LA62_0<='\u0D4D')||LA62_0=='\u0D57'||(LA62_0>='\u0D60' && LA62_0<='\u0D61')||(LA62_0>='\u0D66' && LA62_0<='\u0D6F')||(LA62_0>='\u0D82' && LA62_0<='\u0D83')||(LA62_0>='\u0D85' && LA62_0<='\u0D96')||(LA62_0>='\u0D9A' && LA62_0<='\u0DB1')||(LA62_0>='\u0DB3' && LA62_0<='\u0DBB')||LA62_0=='\u0DBD'||(LA62_0>='\u0DC0' && LA62_0<='\u0DC6')||LA62_0=='\u0DCA'||(LA62_0>='\u0DCF' && LA62_0<='\u0DD4')||LA62_0=='\u0DD6'||(LA62_0>='\u0DD8' && LA62_0<='\u0DDF')||(LA62_0>='\u0DF2' && LA62_0<='\u0DF3')||(LA62_0>='\u0E01' && LA62_0<='\u0E3A')||(LA62_0>='\u0E3F' && LA62_0<='\u0E4E')||(LA62_0>='\u0E50' && LA62_0<='\u0E59')||(LA62_0>='\u0E81' && LA62_0<='\u0E82')||LA62_0=='\u0E84'||(LA62_0>='\u0E87' && LA62_0<='\u0E88')||LA62_0=='\u0E8A'||LA62_0=='\u0E8D'||(LA62_0>='\u0E94' && LA62_0<='\u0E97')||(LA62_0>='\u0E99' && LA62_0<='\u0E9F')||(LA62_0>='\u0EA1' && LA62_0<='\u0EA3')||LA62_0=='\u0EA5'||LA62_0=='\u0EA7'||(LA62_0>='\u0EAA' && LA62_0<='\u0EAB')||(LA62_0>='\u0EAD' && LA62_0<='\u0EB9')||(LA62_0>='\u0EBB' && LA62_0<='\u0EBD')||(LA62_0>='\u0EC0' && LA62_0<='\u0EC4')||LA62_0=='\u0EC6'||(LA62_0>='\u0EC8' && LA62_0<='\u0ECD')||(LA62_0>='\u0ED0' && LA62_0<='\u0ED9')||(LA62_0>='\u0EDC' && LA62_0<='\u0EDD')||LA62_0=='\u0F00'||(LA62_0>='\u0F18' && LA62_0<='\u0F19')||(LA62_0>='\u0F20' && LA62_0<='\u0F29')||LA62_0=='\u0F35'||LA62_0=='\u0F37'||LA62_0=='\u0F39'||(LA62_0>='\u0F3E' && LA62_0<='\u0F47')||(LA62_0>='\u0F49' && LA62_0<='\u0F6A')||(LA62_0>='\u0F71' && LA62_0<='\u0F84')||(LA62_0>='\u0F86' && LA62_0<='\u0F8B')||(LA62_0>='\u0F90' && LA62_0<='\u0F97')||(LA62_0>='\u0F99' && LA62_0<='\u0FBC')||LA62_0=='\u0FC6'||(LA62_0>='\u1000' && LA62_0<='\u1021')||(LA62_0>='\u1023' && LA62_0<='\u1027')||(LA62_0>='\u1029' && LA62_0<='\u102A')||(LA62_0>='\u102C' && LA62_0<='\u1032')||(LA62_0>='\u1036' && LA62_0<='\u1039')||(LA62_0>='\u1040' && LA62_0<='\u1049')||(LA62_0>='\u1050' && LA62_0<='\u1059')||(LA62_0>='\u10A0' && LA62_0<='\u10C5')||(LA62_0>='\u10D0' && LA62_0<='\u10F8')||(LA62_0>='\u1100' && LA62_0<='\u1159')||(LA62_0>='\u115F' && LA62_0<='\u11A2')||(LA62_0>='\u11A8' && LA62_0<='\u11F9')||(LA62_0>='\u1200' && LA62_0<='\u1206')||(LA62_0>='\u1208' && LA62_0<='\u1246')||LA62_0=='\u1248'||(LA62_0>='\u124A' && LA62_0<='\u124D')||(LA62_0>='\u1250' && LA62_0<='\u1256')||LA62_0=='\u1258'||(LA62_0>='\u125A' && LA62_0<='\u125D')||(LA62_0>='\u1260' && LA62_0<='\u1286')||LA62_0=='\u1288'||(LA62_0>='\u128A' && LA62_0<='\u128D')||(LA62_0>='\u1290' && LA62_0<='\u12AE')||LA62_0=='\u12B0'||(LA62_0>='\u12B2' && LA62_0<='\u12B5')||(LA62_0>='\u12B8' && LA62_0<='\u12BE')||LA62_0=='\u12C0'||(LA62_0>='\u12C2' && LA62_0<='\u12C5')||(LA62_0>='\u12C8' && LA62_0<='\u12CE')||(LA62_0>='\u12D0' && LA62_0<='\u12D6')||(LA62_0>='\u12D8' && LA62_0<='\u12EE')||(LA62_0>='\u12F0' && LA62_0<='\u130E')||LA62_0=='\u1310'||(LA62_0>='\u1312' && LA62_0<='\u1315')||(LA62_0>='\u1318' && LA62_0<='\u131E')||(LA62_0>='\u1320' && LA62_0<='\u1346')||(LA62_0>='\u1348' && LA62_0<='\u135A')||(LA62_0>='\u1369' && LA62_0<='\u1371')||(LA62_0>='\u13A0' && LA62_0<='\u13F4')||(LA62_0>='\u1401' && LA62_0<='\u166C')||(LA62_0>='\u166F' && LA62_0<='\u1676')||(LA62_0>='\u1681' && LA62_0<='\u169A')||(LA62_0>='\u16A0' && LA62_0<='\u16EA')||(LA62_0>='\u16EE' && LA62_0<='\u16F0')||(LA62_0>='\u1700' && LA62_0<='\u170C')||(LA62_0>='\u170E' && LA62_0<='\u1714')||(LA62_0>='\u1720' && LA62_0<='\u1734')||(LA62_0>='\u1740' && LA62_0<='\u1753')||(LA62_0>='\u1760' && LA62_0<='\u176C')||(LA62_0>='\u176E' && LA62_0<='\u1770')||(LA62_0>='\u1772' && LA62_0<='\u1773')||(LA62_0>='\u1780' && LA62_0<='\u17D3')||LA62_0=='\u17D7'||(LA62_0>='\u17DB' && LA62_0<='\u17DD')||(LA62_0>='\u17E0' && LA62_0<='\u17E9')||(LA62_0>='\u180B' && LA62_0<='\u180D')||(LA62_0>='\u1810' && LA62_0<='\u1819')||(LA62_0>='\u1820' && LA62_0<='\u1877')||(LA62_0>='\u1880' && LA62_0<='\u18A9')||(LA62_0>='\u1900' && LA62_0<='\u191C')||(LA62_0>='\u1920' && LA62_0<='\u192B')||(LA62_0>='\u1930' && LA62_0<='\u193B')||(LA62_0>='\u1946' && LA62_0<='\u196D')||(LA62_0>='\u1970' && LA62_0<='\u1974')||(LA62_0>='\u1D00' && LA62_0<='\u1D6B')||(LA62_0>='\u1E00' && LA62_0<='\u1E9B')||(LA62_0>='\u1EA0' && LA62_0<='\u1EF9')||(LA62_0>='\u1F00' && LA62_0<='\u1F15')||(LA62_0>='\u1F18' && LA62_0<='\u1F1D')||(LA62_0>='\u1F20' && LA62_0<='\u1F45')||(LA62_0>='\u1F48' && LA62_0<='\u1F4D')||(LA62_0>='\u1F50' && LA62_0<='\u1F57')||LA62_0=='\u1F59'||LA62_0=='\u1F5B'||LA62_0=='\u1F5D'||(LA62_0>='\u1F5F' && LA62_0<='\u1F7D')||(LA62_0>='\u1F80' && LA62_0<='\u1FB4')||(LA62_0>='\u1FB6' && LA62_0<='\u1FBC')||LA62_0=='\u1FBE'||(LA62_0>='\u1FC2' && LA62_0<='\u1FC4')||(LA62_0>='\u1FC6' && LA62_0<='\u1FCC')||(LA62_0>='\u1FD0' && LA62_0<='\u1FD3')||(LA62_0>='\u1FD6' && LA62_0<='\u1FDB')||(LA62_0>='\u1FE0' && LA62_0<='\u1FEC')||(LA62_0>='\u1FF2' && LA62_0<='\u1FF4')||(LA62_0>='\u1FF6' && LA62_0<='\u1FFC')||(LA62_0>='\u200C' && LA62_0<='\u200F')||(LA62_0>='\u202A' && LA62_0<='\u202E')||(LA62_0>='\u203F' && LA62_0<='\u2040')||LA62_0=='\u2054'||(LA62_0>='\u2060' && LA62_0<='\u2063')||(LA62_0>='\u206A' && LA62_0<='\u206F')||LA62_0=='\u2071'||LA62_0=='\u207F'||(LA62_0>='\u20A0' && LA62_0<='\u20B1')||(LA62_0>='\u20D0' && LA62_0<='\u20DC')||LA62_0=='\u20E1'||(LA62_0>='\u20E5' && LA62_0<='\u20EA')||LA62_0=='\u2102'||LA62_0=='\u2107'||(LA62_0>='\u210A' && LA62_0<='\u2113')||LA62_0=='\u2115'||(LA62_0>='\u2119' && LA62_0<='\u211D')||LA62_0=='\u2124'||LA62_0=='\u2126'||LA62_0=='\u2128'||(LA62_0>='\u212A' && LA62_0<='\u212D')||(LA62_0>='\u212F' && LA62_0<='\u2131')||(LA62_0>='\u2133' && LA62_0<='\u2139')||(LA62_0>='\u213D' && LA62_0<='\u213F')||(LA62_0>='\u2145' && LA62_0<='\u2149')||(LA62_0>='\u2160' && LA62_0<='\u2183')||(LA62_0>='\u3005' && LA62_0<='\u3007')||(LA62_0>='\u3021' && LA62_0<='\u302F')||(LA62_0>='\u3031' && LA62_0<='\u3035')||(LA62_0>='\u3038' && LA62_0<='\u303C')||(LA62_0>='\u3041' && LA62_0<='\u3096')||(LA62_0>='\u3099' && LA62_0<='\u309A')||(LA62_0>='\u309D' && LA62_0<='\u309F')||(LA62_0>='\u30A1' && LA62_0<='\u30FF')||(LA62_0>='\u3105' && LA62_0<='\u312C')||(LA62_0>='\u3131' && LA62_0<='\u318E')||(LA62_0>='\u31A0' && LA62_0<='\u31B7')||(LA62_0>='\u31F0' && LA62_0<='\u31FF')||(LA62_0>='\u3400' && LA62_0<='\u4DB5')||(LA62_0>='\u4E00' && LA62_0<='\u9FA5')||(LA62_0>='\uA000' && LA62_0<='\uA48C')||(LA62_0>='\uAC00' && LA62_0<='\uD7A3')||(LA62_0>='\uF900' && LA62_0<='\uFA2D')||(LA62_0>='\uFA30' && LA62_0<='\uFA6A')||(LA62_0>='\uFB00' && LA62_0<='\uFB06')||(LA62_0>='\uFB13' && LA62_0<='\uFB17')||(LA62_0>='\uFB1D' && LA62_0<='\uFB28')||(LA62_0>='\uFB2A' && LA62_0<='\uFB36')||(LA62_0>='\uFB38' && LA62_0<='\uFB3C')||LA62_0=='\uFB3E'||(LA62_0>='\uFB40' && LA62_0<='\uFB41')||(LA62_0>='\uFB43' && LA62_0<='\uFB44')||(LA62_0>='\uFB46' && LA62_0<='\uFBB1')||(LA62_0>='\uFBD3' && LA62_0<='\uFD3D')||(LA62_0>='\uFD50' && LA62_0<='\uFD8F')||(LA62_0>='\uFD92' && LA62_0<='\uFDC7')||(LA62_0>='\uFDF0' && LA62_0<='\uFDFC')||(LA62_0>='\uFE00' && LA62_0<='\uFE0F')||(LA62_0>='\uFE20' && LA62_0<='\uFE23')||(LA62_0>='\uFE33' && LA62_0<='\uFE34')||(LA62_0>='\uFE4D' && LA62_0<='\uFE4F')||LA62_0=='\uFE69'||(LA62_0>='\uFE70' && LA62_0<='\uFE74')||(LA62_0>='\uFE76' && LA62_0<='\uFEFC')||LA62_0=='\uFEFF'||LA62_0=='\uFF04'||(LA62_0>='\uFF10' && LA62_0<='\uFF19')||(LA62_0>='\uFF21' && LA62_0<='\uFF3A')||LA62_0=='\uFF3F'||(LA62_0>='\uFF41' && LA62_0<='\uFF5A')||(LA62_0>='\uFF65' && LA62_0<='\uFFBE')||(LA62_0>='\uFFC2' && LA62_0<='\uFFC7')||(LA62_0>='\uFFCA' && LA62_0<='\uFFCF')||(LA62_0>='\uFFD2' && LA62_0<='\uFFD7')||(LA62_0>='\uFFDA' && LA62_0<='\uFFDC')||(LA62_0>='\uFFE0' && LA62_0<='\uFFE1')||(LA62_0>='\uFFE5' && LA62_0<='\uFFE6')||(LA62_0>='\uFFF9' && LA62_0<='\uFFFB')) ) {
                            alt62=1;
                        }


                        switch (alt62) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:338:23: IdentifierPart
                    	    {
                    	    mIdentifierPart(); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    break loop62;
                        }
                    } while (true);


                    }
                    break;
                case 2 :
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:339:7: '`' IdentifierStart ( IdentifierPart )* '`'
                    {
                    match('`'); if (state.failed) return ;
                    mIdentifierStart(); if (state.failed) return ;
                    // src/main/resources/org/drools/lang/DRL6Lexer.g:339:27: ( IdentifierPart )*
                    loop63:
                    do {
                        int alt63=2;
                        int LA63_0 = input.LA(1);

                        if ( ((LA63_0>='\u0000' && LA63_0<='\b')||(LA63_0>='\u000E' && LA63_0<='\u001B')||LA63_0=='$'||(LA63_0>='0' && LA63_0<='9')||(LA63_0>='A' && LA63_0<='Z')||LA63_0=='_'||(LA63_0>='a' && LA63_0<='z')||(LA63_0>='\u007F' && LA63_0<='\u009F')||(LA63_0>='\u00A2' && LA63_0<='\u00A5')||LA63_0=='\u00AA'||LA63_0=='\u00AD'||LA63_0=='\u00B5'||LA63_0=='\u00BA'||(LA63_0>='\u00C0' && LA63_0<='\u00D6')||(LA63_0>='\u00D8' && LA63_0<='\u00F6')||(LA63_0>='\u00F8' && LA63_0<='\u0236')||(LA63_0>='\u0250' && LA63_0<='\u02C1')||(LA63_0>='\u02C6' && LA63_0<='\u02D1')||(LA63_0>='\u02E0' && LA63_0<='\u02E4')||LA63_0=='\u02EE'||(LA63_0>='\u0300' && LA63_0<='\u0357')||(LA63_0>='\u035D' && LA63_0<='\u036F')||LA63_0=='\u037A'||LA63_0=='\u0386'||(LA63_0>='\u0388' && LA63_0<='\u038A')||LA63_0=='\u038C'||(LA63_0>='\u038E' && LA63_0<='\u03A1')||(LA63_0>='\u03A3' && LA63_0<='\u03CE')||(LA63_0>='\u03D0' && LA63_0<='\u03F5')||(LA63_0>='\u03F7' && LA63_0<='\u03FB')||(LA63_0>='\u0400' && LA63_0<='\u0481')||(LA63_0>='\u0483' && LA63_0<='\u0486')||(LA63_0>='\u048A' && LA63_0<='\u04CE')||(LA63_0>='\u04D0' && LA63_0<='\u04F5')||(LA63_0>='\u04F8' && LA63_0<='\u04F9')||(LA63_0>='\u0500' && LA63_0<='\u050F')||(LA63_0>='\u0531' && LA63_0<='\u0556')||LA63_0=='\u0559'||(LA63_0>='\u0561' && LA63_0<='\u0587')||(LA63_0>='\u0591' && LA63_0<='\u05A1')||(LA63_0>='\u05A3' && LA63_0<='\u05B9')||(LA63_0>='\u05BB' && LA63_0<='\u05BD')||LA63_0=='\u05BF'||(LA63_0>='\u05C1' && LA63_0<='\u05C2')||LA63_0=='\u05C4'||(LA63_0>='\u05D0' && LA63_0<='\u05EA')||(LA63_0>='\u05F0' && LA63_0<='\u05F2')||(LA63_0>='\u0600' && LA63_0<='\u0603')||(LA63_0>='\u0610' && LA63_0<='\u0615')||(LA63_0>='\u0621' && LA63_0<='\u063A')||(LA63_0>='\u0640' && LA63_0<='\u0658')||(LA63_0>='\u0660' && LA63_0<='\u0669')||(LA63_0>='\u066E' && LA63_0<='\u06D3')||(LA63_0>='\u06D5' && LA63_0<='\u06DD')||(LA63_0>='\u06DF' && LA63_0<='\u06E8')||(LA63_0>='\u06EA' && LA63_0<='\u06FC')||LA63_0=='\u06FF'||(LA63_0>='\u070F' && LA63_0<='\u074A')||(LA63_0>='\u074D' && LA63_0<='\u074F')||(LA63_0>='\u0780' && LA63_0<='\u07B1')||(LA63_0>='\u0901' && LA63_0<='\u0939')||(LA63_0>='\u093C' && LA63_0<='\u094D')||(LA63_0>='\u0950' && LA63_0<='\u0954')||(LA63_0>='\u0958' && LA63_0<='\u0963')||(LA63_0>='\u0966' && LA63_0<='\u096F')||(LA63_0>='\u0981' && LA63_0<='\u0983')||(LA63_0>='\u0985' && LA63_0<='\u098C')||(LA63_0>='\u098F' && LA63_0<='\u0990')||(LA63_0>='\u0993' && LA63_0<='\u09A8')||(LA63_0>='\u09AA' && LA63_0<='\u09B0')||LA63_0=='\u09B2'||(LA63_0>='\u09B6' && LA63_0<='\u09B9')||(LA63_0>='\u09BC' && LA63_0<='\u09C4')||(LA63_0>='\u09C7' && LA63_0<='\u09C8')||(LA63_0>='\u09CB' && LA63_0<='\u09CD')||LA63_0=='\u09D7'||(LA63_0>='\u09DC' && LA63_0<='\u09DD')||(LA63_0>='\u09DF' && LA63_0<='\u09E3')||(LA63_0>='\u09E6' && LA63_0<='\u09F3')||(LA63_0>='\u0A01' && LA63_0<='\u0A03')||(LA63_0>='\u0A05' && LA63_0<='\u0A0A')||(LA63_0>='\u0A0F' && LA63_0<='\u0A10')||(LA63_0>='\u0A13' && LA63_0<='\u0A28')||(LA63_0>='\u0A2A' && LA63_0<='\u0A30')||(LA63_0>='\u0A32' && LA63_0<='\u0A33')||(LA63_0>='\u0A35' && LA63_0<='\u0A36')||(LA63_0>='\u0A38' && LA63_0<='\u0A39')||LA63_0=='\u0A3C'||(LA63_0>='\u0A3E' && LA63_0<='\u0A42')||(LA63_0>='\u0A47' && LA63_0<='\u0A48')||(LA63_0>='\u0A4B' && LA63_0<='\u0A4D')||(LA63_0>='\u0A59' && LA63_0<='\u0A5C')||LA63_0=='\u0A5E'||(LA63_0>='\u0A66' && LA63_0<='\u0A74')||(LA63_0>='\u0A81' && LA63_0<='\u0A83')||(LA63_0>='\u0A85' && LA63_0<='\u0A8D')||(LA63_0>='\u0A8F' && LA63_0<='\u0A91')||(LA63_0>='\u0A93' && LA63_0<='\u0AA8')||(LA63_0>='\u0AAA' && LA63_0<='\u0AB0')||(LA63_0>='\u0AB2' && LA63_0<='\u0AB3')||(LA63_0>='\u0AB5' && LA63_0<='\u0AB9')||(LA63_0>='\u0ABC' && LA63_0<='\u0AC5')||(LA63_0>='\u0AC7' && LA63_0<='\u0AC9')||(LA63_0>='\u0ACB' && LA63_0<='\u0ACD')||LA63_0=='\u0AD0'||(LA63_0>='\u0AE0' && LA63_0<='\u0AE3')||(LA63_0>='\u0AE6' && LA63_0<='\u0AEF')||LA63_0=='\u0AF1'||(LA63_0>='\u0B01' && LA63_0<='\u0B03')||(LA63_0>='\u0B05' && LA63_0<='\u0B0C')||(LA63_0>='\u0B0F' && LA63_0<='\u0B10')||(LA63_0>='\u0B13' && LA63_0<='\u0B28')||(LA63_0>='\u0B2A' && LA63_0<='\u0B30')||(LA63_0>='\u0B32' && LA63_0<='\u0B33')||(LA63_0>='\u0B35' && LA63_0<='\u0B39')||(LA63_0>='\u0B3C' && LA63_0<='\u0B43')||(LA63_0>='\u0B47' && LA63_0<='\u0B48')||(LA63_0>='\u0B4B' && LA63_0<='\u0B4D')||(LA63_0>='\u0B56' && LA63_0<='\u0B57')||(LA63_0>='\u0B5C' && LA63_0<='\u0B5D')||(LA63_0>='\u0B5F' && LA63_0<='\u0B61')||(LA63_0>='\u0B66' && LA63_0<='\u0B6F')||LA63_0=='\u0B71'||(LA63_0>='\u0B82' && LA63_0<='\u0B83')||(LA63_0>='\u0B85' && LA63_0<='\u0B8A')||(LA63_0>='\u0B8E' && LA63_0<='\u0B90')||(LA63_0>='\u0B92' && LA63_0<='\u0B95')||(LA63_0>='\u0B99' && LA63_0<='\u0B9A')||LA63_0=='\u0B9C'||(LA63_0>='\u0B9E' && LA63_0<='\u0B9F')||(LA63_0>='\u0BA3' && LA63_0<='\u0BA4')||(LA63_0>='\u0BA8' && LA63_0<='\u0BAA')||(LA63_0>='\u0BAE' && LA63_0<='\u0BB5')||(LA63_0>='\u0BB7' && LA63_0<='\u0BB9')||(LA63_0>='\u0BBE' && LA63_0<='\u0BC2')||(LA63_0>='\u0BC6' && LA63_0<='\u0BC8')||(LA63_0>='\u0BCA' && LA63_0<='\u0BCD')||LA63_0=='\u0BD7'||(LA63_0>='\u0BE7' && LA63_0<='\u0BEF')||LA63_0=='\u0BF9'||(LA63_0>='\u0C01' && LA63_0<='\u0C03')||(LA63_0>='\u0C05' && LA63_0<='\u0C0C')||(LA63_0>='\u0C0E' && LA63_0<='\u0C10')||(LA63_0>='\u0C12' && LA63_0<='\u0C28')||(LA63_0>='\u0C2A' && LA63_0<='\u0C33')||(LA63_0>='\u0C35' && LA63_0<='\u0C39')||(LA63_0>='\u0C3E' && LA63_0<='\u0C44')||(LA63_0>='\u0C46' && LA63_0<='\u0C48')||(LA63_0>='\u0C4A' && LA63_0<='\u0C4D')||(LA63_0>='\u0C55' && LA63_0<='\u0C56')||(LA63_0>='\u0C60' && LA63_0<='\u0C61')||(LA63_0>='\u0C66' && LA63_0<='\u0C6F')||(LA63_0>='\u0C82' && LA63_0<='\u0C83')||(LA63_0>='\u0C85' && LA63_0<='\u0C8C')||(LA63_0>='\u0C8E' && LA63_0<='\u0C90')||(LA63_0>='\u0C92' && LA63_0<='\u0CA8')||(LA63_0>='\u0CAA' && LA63_0<='\u0CB3')||(LA63_0>='\u0CB5' && LA63_0<='\u0CB9')||(LA63_0>='\u0CBC' && LA63_0<='\u0CC4')||(LA63_0>='\u0CC6' && LA63_0<='\u0CC8')||(LA63_0>='\u0CCA' && LA63_0<='\u0CCD')||(LA63_0>='\u0CD5' && LA63_0<='\u0CD6')||LA63_0=='\u0CDE'||(LA63_0>='\u0CE0' && LA63_0<='\u0CE1')||(LA63_0>='\u0CE6' && LA63_0<='\u0CEF')||(LA63_0>='\u0D02' && LA63_0<='\u0D03')||(LA63_0>='\u0D05' && LA63_0<='\u0D0C')||(LA63_0>='\u0D0E' && LA63_0<='\u0D10')||(LA63_0>='\u0D12' && LA63_0<='\u0D28')||(LA63_0>='\u0D2A' && LA63_0<='\u0D39')||(LA63_0>='\u0D3E' && LA63_0<='\u0D43')||(LA63_0>='\u0D46' && LA63_0<='\u0D48')||(LA63_0>='\u0D4A' && LA63_0<='\u0D4D')||LA63_0=='\u0D57'||(LA63_0>='\u0D60' && LA63_0<='\u0D61')||(LA63_0>='\u0D66' && LA63_0<='\u0D6F')||(LA63_0>='\u0D82' && LA63_0<='\u0D83')||(LA63_0>='\u0D85' && LA63_0<='\u0D96')||(LA63_0>='\u0D9A' && LA63_0<='\u0DB1')||(LA63_0>='\u0DB3' && LA63_0<='\u0DBB')||LA63_0=='\u0DBD'||(LA63_0>='\u0DC0' && LA63_0<='\u0DC6')||LA63_0=='\u0DCA'||(LA63_0>='\u0DCF' && LA63_0<='\u0DD4')||LA63_0=='\u0DD6'||(LA63_0>='\u0DD8' && LA63_0<='\u0DDF')||(LA63_0>='\u0DF2' && LA63_0<='\u0DF3')||(LA63_0>='\u0E01' && LA63_0<='\u0E3A')||(LA63_0>='\u0E3F' && LA63_0<='\u0E4E')||(LA63_0>='\u0E50' && LA63_0<='\u0E59')||(LA63_0>='\u0E81' && LA63_0<='\u0E82')||LA63_0=='\u0E84'||(LA63_0>='\u0E87' && LA63_0<='\u0E88')||LA63_0=='\u0E8A'||LA63_0=='\u0E8D'||(LA63_0>='\u0E94' && LA63_0<='\u0E97')||(LA63_0>='\u0E99' && LA63_0<='\u0E9F')||(LA63_0>='\u0EA1' && LA63_0<='\u0EA3')||LA63_0=='\u0EA5'||LA63_0=='\u0EA7'||(LA63_0>='\u0EAA' && LA63_0<='\u0EAB')||(LA63_0>='\u0EAD' && LA63_0<='\u0EB9')||(LA63_0>='\u0EBB' && LA63_0<='\u0EBD')||(LA63_0>='\u0EC0' && LA63_0<='\u0EC4')||LA63_0=='\u0EC6'||(LA63_0>='\u0EC8' && LA63_0<='\u0ECD')||(LA63_0>='\u0ED0' && LA63_0<='\u0ED9')||(LA63_0>='\u0EDC' && LA63_0<='\u0EDD')||LA63_0=='\u0F00'||(LA63_0>='\u0F18' && LA63_0<='\u0F19')||(LA63_0>='\u0F20' && LA63_0<='\u0F29')||LA63_0=='\u0F35'||LA63_0=='\u0F37'||LA63_0=='\u0F39'||(LA63_0>='\u0F3E' && LA63_0<='\u0F47')||(LA63_0>='\u0F49' && LA63_0<='\u0F6A')||(LA63_0>='\u0F71' && LA63_0<='\u0F84')||(LA63_0>='\u0F86' && LA63_0<='\u0F8B')||(LA63_0>='\u0F90' && LA63_0<='\u0F97')||(LA63_0>='\u0F99' && LA63_0<='\u0FBC')||LA63_0=='\u0FC6'||(LA63_0>='\u1000' && LA63_0<='\u1021')||(LA63_0>='\u1023' && LA63_0<='\u1027')||(LA63_0>='\u1029' && LA63_0<='\u102A')||(LA63_0>='\u102C' && LA63_0<='\u1032')||(LA63_0>='\u1036' && LA63_0<='\u1039')||(LA63_0>='\u1040' && LA63_0<='\u1049')||(LA63_0>='\u1050' && LA63_0<='\u1059')||(LA63_0>='\u10A0' && LA63_0<='\u10C5')||(LA63_0>='\u10D0' && LA63_0<='\u10F8')||(LA63_0>='\u1100' && LA63_0<='\u1159')||(LA63_0>='\u115F' && LA63_0<='\u11A2')||(LA63_0>='\u11A8' && LA63_0<='\u11F9')||(LA63_0>='\u1200' && LA63_0<='\u1206')||(LA63_0>='\u1208' && LA63_0<='\u1246')||LA63_0=='\u1248'||(LA63_0>='\u124A' && LA63_0<='\u124D')||(LA63_0>='\u1250' && LA63_0<='\u1256')||LA63_0=='\u1258'||(LA63_0>='\u125A' && LA63_0<='\u125D')||(LA63_0>='\u1260' && LA63_0<='\u1286')||LA63_0=='\u1288'||(LA63_0>='\u128A' && LA63_0<='\u128D')||(LA63_0>='\u1290' && LA63_0<='\u12AE')||LA63_0=='\u12B0'||(LA63_0>='\u12B2' && LA63_0<='\u12B5')||(LA63_0>='\u12B8' && LA63_0<='\u12BE')||LA63_0=='\u12C0'||(LA63_0>='\u12C2' && LA63_0<='\u12C5')||(LA63_0>='\u12C8' && LA63_0<='\u12CE')||(LA63_0>='\u12D0' && LA63_0<='\u12D6')||(LA63_0>='\u12D8' && LA63_0<='\u12EE')||(LA63_0>='\u12F0' && LA63_0<='\u130E')||LA63_0=='\u1310'||(LA63_0>='\u1312' && LA63_0<='\u1315')||(LA63_0>='\u1318' && LA63_0<='\u131E')||(LA63_0>='\u1320' && LA63_0<='\u1346')||(LA63_0>='\u1348' && LA63_0<='\u135A')||(LA63_0>='\u1369' && LA63_0<='\u1371')||(LA63_0>='\u13A0' && LA63_0<='\u13F4')||(LA63_0>='\u1401' && LA63_0<='\u166C')||(LA63_0>='\u166F' && LA63_0<='\u1676')||(LA63_0>='\u1681' && LA63_0<='\u169A')||(LA63_0>='\u16A0' && LA63_0<='\u16EA')||(LA63_0>='\u16EE' && LA63_0<='\u16F0')||(LA63_0>='\u1700' && LA63_0<='\u170C')||(LA63_0>='\u170E' && LA63_0<='\u1714')||(LA63_0>='\u1720' && LA63_0<='\u1734')||(LA63_0>='\u1740' && LA63_0<='\u1753')||(LA63_0>='\u1760' && LA63_0<='\u176C')||(LA63_0>='\u176E' && LA63_0<='\u1770')||(LA63_0>='\u1772' && LA63_0<='\u1773')||(LA63_0>='\u1780' && LA63_0<='\u17D3')||LA63_0=='\u17D7'||(LA63_0>='\u17DB' && LA63_0<='\u17DD')||(LA63_0>='\u17E0' && LA63_0<='\u17E9')||(LA63_0>='\u180B' && LA63_0<='\u180D')||(LA63_0>='\u1810' && LA63_0<='\u1819')||(LA63_0>='\u1820' && LA63_0<='\u1877')||(LA63_0>='\u1880' && LA63_0<='\u18A9')||(LA63_0>='\u1900' && LA63_0<='\u191C')||(LA63_0>='\u1920' && LA63_0<='\u192B')||(LA63_0>='\u1930' && LA63_0<='\u193B')||(LA63_0>='\u1946' && LA63_0<='\u196D')||(LA63_0>='\u1970' && LA63_0<='\u1974')||(LA63_0>='\u1D00' && LA63_0<='\u1D6B')||(LA63_0>='\u1E00' && LA63_0<='\u1E9B')||(LA63_0>='\u1EA0' && LA63_0<='\u1EF9')||(LA63_0>='\u1F00' && LA63_0<='\u1F15')||(LA63_0>='\u1F18' && LA63_0<='\u1F1D')||(LA63_0>='\u1F20' && LA63_0<='\u1F45')||(LA63_0>='\u1F48' && LA63_0<='\u1F4D')||(LA63_0>='\u1F50' && LA63_0<='\u1F57')||LA63_0=='\u1F59'||LA63_0=='\u1F5B'||LA63_0=='\u1F5D'||(LA63_0>='\u1F5F' && LA63_0<='\u1F7D')||(LA63_0>='\u1F80' && LA63_0<='\u1FB4')||(LA63_0>='\u1FB6' && LA63_0<='\u1FBC')||LA63_0=='\u1FBE'||(LA63_0>='\u1FC2' && LA63_0<='\u1FC4')||(LA63_0>='\u1FC6' && LA63_0<='\u1FCC')||(LA63_0>='\u1FD0' && LA63_0<='\u1FD3')||(LA63_0>='\u1FD6' && LA63_0<='\u1FDB')||(LA63_0>='\u1FE0' && LA63_0<='\u1FEC')||(LA63_0>='\u1FF2' && LA63_0<='\u1FF4')||(LA63_0>='\u1FF6' && LA63_0<='\u1FFC')||(LA63_0>='\u200C' && LA63_0<='\u200F')||(LA63_0>='\u202A' && LA63_0<='\u202E')||(LA63_0>='\u203F' && LA63_0<='\u2040')||LA63_0=='\u2054'||(LA63_0>='\u2060' && LA63_0<='\u2063')||(LA63_0>='\u206A' && LA63_0<='\u206F')||LA63_0=='\u2071'||LA63_0=='\u207F'||(LA63_0>='\u20A0' && LA63_0<='\u20B1')||(LA63_0>='\u20D0' && LA63_0<='\u20DC')||LA63_0=='\u20E1'||(LA63_0>='\u20E5' && LA63_0<='\u20EA')||LA63_0=='\u2102'||LA63_0=='\u2107'||(LA63_0>='\u210A' && LA63_0<='\u2113')||LA63_0=='\u2115'||(LA63_0>='\u2119' && LA63_0<='\u211D')||LA63_0=='\u2124'||LA63_0=='\u2126'||LA63_0=='\u2128'||(LA63_0>='\u212A' && LA63_0<='\u212D')||(LA63_0>='\u212F' && LA63_0<='\u2131')||(LA63_0>='\u2133' && LA63_0<='\u2139')||(LA63_0>='\u213D' && LA63_0<='\u213F')||(LA63_0>='\u2145' && LA63_0<='\u2149')||(LA63_0>='\u2160' && LA63_0<='\u2183')||(LA63_0>='\u3005' && LA63_0<='\u3007')||(LA63_0>='\u3021' && LA63_0<='\u302F')||(LA63_0>='\u3031' && LA63_0<='\u3035')||(LA63_0>='\u3038' && LA63_0<='\u303C')||(LA63_0>='\u3041' && LA63_0<='\u3096')||(LA63_0>='\u3099' && LA63_0<='\u309A')||(LA63_0>='\u309D' && LA63_0<='\u309F')||(LA63_0>='\u30A1' && LA63_0<='\u30FF')||(LA63_0>='\u3105' && LA63_0<='\u312C')||(LA63_0>='\u3131' && LA63_0<='\u318E')||(LA63_0>='\u31A0' && LA63_0<='\u31B7')||(LA63_0>='\u31F0' && LA63_0<='\u31FF')||(LA63_0>='\u3400' && LA63_0<='\u4DB5')||(LA63_0>='\u4E00' && LA63_0<='\u9FA5')||(LA63_0>='\uA000' && LA63_0<='\uA48C')||(LA63_0>='\uAC00' && LA63_0<='\uD7A3')||(LA63_0>='\uF900' && LA63_0<='\uFA2D')||(LA63_0>='\uFA30' && LA63_0<='\uFA6A')||(LA63_0>='\uFB00' && LA63_0<='\uFB06')||(LA63_0>='\uFB13' && LA63_0<='\uFB17')||(LA63_0>='\uFB1D' && LA63_0<='\uFB28')||(LA63_0>='\uFB2A' && LA63_0<='\uFB36')||(LA63_0>='\uFB38' && LA63_0<='\uFB3C')||LA63_0=='\uFB3E'||(LA63_0>='\uFB40' && LA63_0<='\uFB41')||(LA63_0>='\uFB43' && LA63_0<='\uFB44')||(LA63_0>='\uFB46' && LA63_0<='\uFBB1')||(LA63_0>='\uFBD3' && LA63_0<='\uFD3D')||(LA63_0>='\uFD50' && LA63_0<='\uFD8F')||(LA63_0>='\uFD92' && LA63_0<='\uFDC7')||(LA63_0>='\uFDF0' && LA63_0<='\uFDFC')||(LA63_0>='\uFE00' && LA63_0<='\uFE0F')||(LA63_0>='\uFE20' && LA63_0<='\uFE23')||(LA63_0>='\uFE33' && LA63_0<='\uFE34')||(LA63_0>='\uFE4D' && LA63_0<='\uFE4F')||LA63_0=='\uFE69'||(LA63_0>='\uFE70' && LA63_0<='\uFE74')||(LA63_0>='\uFE76' && LA63_0<='\uFEFC')||LA63_0=='\uFEFF'||LA63_0=='\uFF04'||(LA63_0>='\uFF10' && LA63_0<='\uFF19')||(LA63_0>='\uFF21' && LA63_0<='\uFF3A')||LA63_0=='\uFF3F'||(LA63_0>='\uFF41' && LA63_0<='\uFF5A')||(LA63_0>='\uFF65' && LA63_0<='\uFFBE')||(LA63_0>='\uFFC2' && LA63_0<='\uFFC7')||(LA63_0>='\uFFCA' && LA63_0<='\uFFCF')||(LA63_0>='\uFFD2' && LA63_0<='\uFFD7')||(LA63_0>='\uFFDA' && LA63_0<='\uFFDC')||(LA63_0>='\uFFE0' && LA63_0<='\uFFE1')||(LA63_0>='\uFFE5' && LA63_0<='\uFFE6')||(LA63_0>='\uFFF9' && LA63_0<='\uFFFB')) ) {
                            alt63=1;
                        }


                        switch (alt63) {
                    	case 1 :
                    	    // src/main/resources/org/drools/lang/DRL6Lexer.g:339:27: IdentifierPart
                    	    {
                    	    mIdentifierPart(); if (state.failed) return ;

                    	    }
                    	    break;

                    	default :
                    	    break loop63;
                        }
                    } while (true);

                    match('`'); if (state.failed) return ;
                    if ( state.backtracking==0 ) {
                      	state.text = getText().substring(1, getText().length() - 1);	
                    }

                    }
                    break;

            }
            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "ID"

    // $ANTLR start "DIV"
    public final void mDIV() throws RecognitionException {
        try {
            int _type = DIV;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:344:5: ( '/' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:344:7: '/'
            {
            match('/'); if (state.failed) return ;

            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "DIV"

    // $ANTLR start "MISC"
    public final void mMISC() throws RecognitionException {
        try {
            int _type = MISC;
            int _channel = DEFAULT_TOKEN_CHANNEL;
            // src/main/resources/org/drools/lang/DRL6Lexer.g:347:7: ( '\\'' | '\\\\' | '$' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:
            {
            if ( input.LA(1)=='$'||input.LA(1)=='\''||input.LA(1)=='\\' ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

            state.type = _type;
            state.channel = _channel;
        }
        finally {
        }
    }
    // $ANTLR end "MISC"

    // $ANTLR start "IdentifierStart"
    public final void mIdentifierStart() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:353:5: ( '\\u0024' | '\\u0041' .. '\\u005a' | '\\u005f' | '\\u0061' .. '\\u007a' | '\\u00a2' .. '\\u00a5' | '\\u00aa' | '\\u00b5' | '\\u00ba' | '\\u00c0' .. '\\u00d6' | '\\u00d8' .. '\\u00f6' | '\\u00f8' .. '\\u0236' | '\\u0250' .. '\\u02c1' | '\\u02c6' .. '\\u02d1' | '\\u02e0' .. '\\u02e4' | '\\u02ee' | '\\u037a' | '\\u0386' | '\\u0388' .. '\\u038a' | '\\u038c' | '\\u038e' .. '\\u03a1' | '\\u03a3' .. '\\u03ce' | '\\u03d0' .. '\\u03f5' | '\\u03f7' .. '\\u03fb' | '\\u0400' .. '\\u0481' | '\\u048a' .. '\\u04ce' | '\\u04d0' .. '\\u04f5' | '\\u04f8' .. '\\u04f9' | '\\u0500' .. '\\u050f' | '\\u0531' .. '\\u0556' | '\\u0559' | '\\u0561' .. '\\u0587' | '\\u05d0' .. '\\u05ea' | '\\u05f0' .. '\\u05f2' | '\\u0621' .. '\\u063a' | '\\u0640' .. '\\u064a' | '\\u066e' .. '\\u066f' | '\\u0671' .. '\\u06d3' | '\\u06d5' | '\\u06e5' .. '\\u06e6' | '\\u06ee' .. '\\u06ef' | '\\u06fa' .. '\\u06fc' | '\\u06ff' | '\\u0710' | '\\u0712' .. '\\u072f' | '\\u074d' .. '\\u074f' | '\\u0780' .. '\\u07a5' | '\\u07b1' | '\\u0904' .. '\\u0939' | '\\u093d' | '\\u0950' | '\\u0958' .. '\\u0961' | '\\u0985' .. '\\u098c' | '\\u098f' .. '\\u0990' | '\\u0993' .. '\\u09a8' | '\\u09aa' .. '\\u09b0' | '\\u09b2' | '\\u09b6' .. '\\u09b9' | '\\u09bd' | '\\u09dc' .. '\\u09dd' | '\\u09df' .. '\\u09e1' | '\\u09f0' .. '\\u09f3' | '\\u0a05' .. '\\u0a0a' | '\\u0a0f' .. '\\u0a10' | '\\u0a13' .. '\\u0a28' | '\\u0a2a' .. '\\u0a30' | '\\u0a32' .. '\\u0a33' | '\\u0a35' .. '\\u0a36' | '\\u0a38' .. '\\u0a39' | '\\u0a59' .. '\\u0a5c' | '\\u0a5e' | '\\u0a72' .. '\\u0a74' | '\\u0a85' .. '\\u0a8d' | '\\u0a8f' .. '\\u0a91' | '\\u0a93' .. '\\u0aa8' | '\\u0aaa' .. '\\u0ab0' | '\\u0ab2' .. '\\u0ab3' | '\\u0ab5' .. '\\u0ab9' | '\\u0abd' | '\\u0ad0' | '\\u0ae0' .. '\\u0ae1' | '\\u0af1' | '\\u0b05' .. '\\u0b0c' | '\\u0b0f' .. '\\u0b10' | '\\u0b13' .. '\\u0b28' | '\\u0b2a' .. '\\u0b30' | '\\u0b32' .. '\\u0b33' | '\\u0b35' .. '\\u0b39' | '\\u0b3d' | '\\u0b5c' .. '\\u0b5d' | '\\u0b5f' .. '\\u0b61' | '\\u0b71' | '\\u0b83' | '\\u0b85' .. '\\u0b8a' | '\\u0b8e' .. '\\u0b90' | '\\u0b92' .. '\\u0b95' | '\\u0b99' .. '\\u0b9a' | '\\u0b9c' | '\\u0b9e' .. '\\u0b9f' | '\\u0ba3' .. '\\u0ba4' | '\\u0ba8' .. '\\u0baa' | '\\u0bae' .. '\\u0bb5' | '\\u0bb7' .. '\\u0bb9' | '\\u0bf9' | '\\u0c05' .. '\\u0c0c' | '\\u0c0e' .. '\\u0c10' | '\\u0c12' .. '\\u0c28' | '\\u0c2a' .. '\\u0c33' | '\\u0c35' .. '\\u0c39' | '\\u0c60' .. '\\u0c61' | '\\u0c85' .. '\\u0c8c' | '\\u0c8e' .. '\\u0c90' | '\\u0c92' .. '\\u0ca8' | '\\u0caa' .. '\\u0cb3' | '\\u0cb5' .. '\\u0cb9' | '\\u0cbd' | '\\u0cde' | '\\u0ce0' .. '\\u0ce1' | '\\u0d05' .. '\\u0d0c' | '\\u0d0e' .. '\\u0d10' | '\\u0d12' .. '\\u0d28' | '\\u0d2a' .. '\\u0d39' | '\\u0d60' .. '\\u0d61' | '\\u0d85' .. '\\u0d96' | '\\u0d9a' .. '\\u0db1' | '\\u0db3' .. '\\u0dbb' | '\\u0dbd' | '\\u0dc0' .. '\\u0dc6' | '\\u0e01' .. '\\u0e30' | '\\u0e32' .. '\\u0e33' | '\\u0e3f' .. '\\u0e46' | '\\u0e81' .. '\\u0e82' | '\\u0e84' | '\\u0e87' .. '\\u0e88' | '\\u0e8a' | '\\u0e8d' | '\\u0e94' .. '\\u0e97' | '\\u0e99' .. '\\u0e9f' | '\\u0ea1' .. '\\u0ea3' | '\\u0ea5' | '\\u0ea7' | '\\u0eaa' .. '\\u0eab' | '\\u0ead' .. '\\u0eb0' | '\\u0eb2' .. '\\u0eb3' | '\\u0ebd' | '\\u0ec0' .. '\\u0ec4' | '\\u0ec6' | '\\u0edc' .. '\\u0edd' | '\\u0f00' | '\\u0f40' .. '\\u0f47' | '\\u0f49' .. '\\u0f6a' | '\\u0f88' .. '\\u0f8b' | '\\u1000' .. '\\u1021' | '\\u1023' .. '\\u1027' | '\\u1029' .. '\\u102a' | '\\u1050' .. '\\u1055' | '\\u10a0' .. '\\u10c5' | '\\u10d0' .. '\\u10f8' | '\\u1100' .. '\\u1159' | '\\u115f' .. '\\u11a2' | '\\u11a8' .. '\\u11f9' | '\\u1200' .. '\\u1206' | '\\u1208' .. '\\u1246' | '\\u1248' | '\\u124a' .. '\\u124d' | '\\u1250' .. '\\u1256' | '\\u1258' | '\\u125a' .. '\\u125d' | '\\u1260' .. '\\u1286' | '\\u1288' | '\\u128a' .. '\\u128d' | '\\u1290' .. '\\u12ae' | '\\u12b0' | '\\u12b2' .. '\\u12b5' | '\\u12b8' .. '\\u12be' | '\\u12c0' | '\\u12c2' .. '\\u12c5' | '\\u12c8' .. '\\u12ce' | '\\u12d0' .. '\\u12d6' | '\\u12d8' .. '\\u12ee' | '\\u12f0' .. '\\u130e' | '\\u1310' | '\\u1312' .. '\\u1315' | '\\u1318' .. '\\u131e' | '\\u1320' .. '\\u1346' | '\\u1348' .. '\\u135a' | '\\u13a0' .. '\\u13f4' | '\\u1401' .. '\\u166c' | '\\u166f' .. '\\u1676' | '\\u1681' .. '\\u169a' | '\\u16a0' .. '\\u16ea' | '\\u16ee' .. '\\u16f0' | '\\u1700' .. '\\u170c' | '\\u170e' .. '\\u1711' | '\\u1720' .. '\\u1731' | '\\u1740' .. '\\u1751' | '\\u1760' .. '\\u176c' | '\\u176e' .. '\\u1770' | '\\u1780' .. '\\u17b3' | '\\u17d7' | '\\u17db' .. '\\u17dc' | '\\u1820' .. '\\u1877' | '\\u1880' .. '\\u18a8' | '\\u1900' .. '\\u191c' | '\\u1950' .. '\\u196d' | '\\u1970' .. '\\u1974' | '\\u1d00' .. '\\u1d6b' | '\\u1e00' .. '\\u1e9b' | '\\u1ea0' .. '\\u1ef9' | '\\u1f00' .. '\\u1f15' | '\\u1f18' .. '\\u1f1d' | '\\u1f20' .. '\\u1f45' | '\\u1f48' .. '\\u1f4d' | '\\u1f50' .. '\\u1f57' | '\\u1f59' | '\\u1f5b' | '\\u1f5d' | '\\u1f5f' .. '\\u1f7d' | '\\u1f80' .. '\\u1fb4' | '\\u1fb6' .. '\\u1fbc' | '\\u1fbe' | '\\u1fc2' .. '\\u1fc4' | '\\u1fc6' .. '\\u1fcc' | '\\u1fd0' .. '\\u1fd3' | '\\u1fd6' .. '\\u1fdb' | '\\u1fe0' .. '\\u1fec' | '\\u1ff2' .. '\\u1ff4' | '\\u1ff6' .. '\\u1ffc' | '\\u203f' .. '\\u2040' | '\\u2054' | '\\u2071' | '\\u207f' | '\\u20a0' .. '\\u20b1' | '\\u2102' | '\\u2107' | '\\u210a' .. '\\u2113' | '\\u2115' | '\\u2119' .. '\\u211d' | '\\u2124' | '\\u2126' | '\\u2128' | '\\u212a' .. '\\u212d' | '\\u212f' .. '\\u2131' | '\\u2133' .. '\\u2139' | '\\u213d' .. '\\u213f' | '\\u2145' .. '\\u2149' | '\\u2160' .. '\\u2183' | '\\u3005' .. '\\u3007' | '\\u3021' .. '\\u3029' | '\\u3031' .. '\\u3035' | '\\u3038' .. '\\u303c' | '\\u3041' .. '\\u3096' | '\\u309d' .. '\\u309f' | '\\u30a1' .. '\\u30ff' | '\\u3105' .. '\\u312c' | '\\u3131' .. '\\u318e' | '\\u31a0' .. '\\u31b7' | '\\u31f0' .. '\\u31ff' | '\\u3400' .. '\\u4db5' | '\\u4e00' .. '\\u9fa5' | '\\ua000' .. '\\ua48c' | '\\uac00' .. '\\ud7a3' | '\\uf900' .. '\\ufa2d' | '\\ufa30' .. '\\ufa6a' | '\\ufb00' .. '\\ufb06' | '\\ufb13' .. '\\ufb17' | '\\ufb1d' | '\\ufb1f' .. '\\ufb28' | '\\ufb2a' .. '\\ufb36' | '\\ufb38' .. '\\ufb3c' | '\\ufb3e' | '\\ufb40' .. '\\ufb41' | '\\ufb43' .. '\\ufb44' | '\\ufb46' .. '\\ufbb1' | '\\ufbd3' .. '\\ufd3d' | '\\ufd50' .. '\\ufd8f' | '\\ufd92' .. '\\ufdc7' | '\\ufdf0' .. '\\ufdfc' | '\\ufe33' .. '\\ufe34' | '\\ufe4d' .. '\\ufe4f' | '\\ufe69' | '\\ufe70' .. '\\ufe74' | '\\ufe76' .. '\\ufefc' | '\\uff04' | '\\uff21' .. '\\uff3a' | '\\uff3f' | '\\uff41' .. '\\uff5a' | '\\uff65' .. '\\uffbe' | '\\uffc2' .. '\\uffc7' | '\\uffca' .. '\\uffcf' | '\\uffd2' .. '\\uffd7' | '\\uffda' .. '\\uffdc' | '\\uffe0' .. '\\uffe1' | '\\uffe5' .. '\\uffe6' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:
            {
            if ( input.LA(1)=='$'||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z')||(input.LA(1)>='\u00A2' && input.LA(1)<='\u00A5')||input.LA(1)=='\u00AA'||input.LA(1)=='\u00B5'||input.LA(1)=='\u00BA'||(input.LA(1)>='\u00C0' && input.LA(1)<='\u00D6')||(input.LA(1)>='\u00D8' && input.LA(1)<='\u00F6')||(input.LA(1)>='\u00F8' && input.LA(1)<='\u0236')||(input.LA(1)>='\u0250' && input.LA(1)<='\u02C1')||(input.LA(1)>='\u02C6' && input.LA(1)<='\u02D1')||(input.LA(1)>='\u02E0' && input.LA(1)<='\u02E4')||input.LA(1)=='\u02EE'||input.LA(1)=='\u037A'||input.LA(1)=='\u0386'||(input.LA(1)>='\u0388' && input.LA(1)<='\u038A')||input.LA(1)=='\u038C'||(input.LA(1)>='\u038E' && input.LA(1)<='\u03A1')||(input.LA(1)>='\u03A3' && input.LA(1)<='\u03CE')||(input.LA(1)>='\u03D0' && input.LA(1)<='\u03F5')||(input.LA(1)>='\u03F7' && input.LA(1)<='\u03FB')||(input.LA(1)>='\u0400' && input.LA(1)<='\u0481')||(input.LA(1)>='\u048A' && input.LA(1)<='\u04CE')||(input.LA(1)>='\u04D0' && input.LA(1)<='\u04F5')||(input.LA(1)>='\u04F8' && input.LA(1)<='\u04F9')||(input.LA(1)>='\u0500' && input.LA(1)<='\u050F')||(input.LA(1)>='\u0531' && input.LA(1)<='\u0556')||input.LA(1)=='\u0559'||(input.LA(1)>='\u0561' && input.LA(1)<='\u0587')||(input.LA(1)>='\u05D0' && input.LA(1)<='\u05EA')||(input.LA(1)>='\u05F0' && input.LA(1)<='\u05F2')||(input.LA(1)>='\u0621' && input.LA(1)<='\u063A')||(input.LA(1)>='\u0640' && input.LA(1)<='\u064A')||(input.LA(1)>='\u066E' && input.LA(1)<='\u066F')||(input.LA(1)>='\u0671' && input.LA(1)<='\u06D3')||input.LA(1)=='\u06D5'||(input.LA(1)>='\u06E5' && input.LA(1)<='\u06E6')||(input.LA(1)>='\u06EE' && input.LA(1)<='\u06EF')||(input.LA(1)>='\u06FA' && input.LA(1)<='\u06FC')||input.LA(1)=='\u06FF'||input.LA(1)=='\u0710'||(input.LA(1)>='\u0712' && input.LA(1)<='\u072F')||(input.LA(1)>='\u074D' && input.LA(1)<='\u074F')||(input.LA(1)>='\u0780' && input.LA(1)<='\u07A5')||input.LA(1)=='\u07B1'||(input.LA(1)>='\u0904' && input.LA(1)<='\u0939')||input.LA(1)=='\u093D'||input.LA(1)=='\u0950'||(input.LA(1)>='\u0958' && input.LA(1)<='\u0961')||(input.LA(1)>='\u0985' && input.LA(1)<='\u098C')||(input.LA(1)>='\u098F' && input.LA(1)<='\u0990')||(input.LA(1)>='\u0993' && input.LA(1)<='\u09A8')||(input.LA(1)>='\u09AA' && input.LA(1)<='\u09B0')||input.LA(1)=='\u09B2'||(input.LA(1)>='\u09B6' && input.LA(1)<='\u09B9')||input.LA(1)=='\u09BD'||(input.LA(1)>='\u09DC' && input.LA(1)<='\u09DD')||(input.LA(1)>='\u09DF' && input.LA(1)<='\u09E1')||(input.LA(1)>='\u09F0' && input.LA(1)<='\u09F3')||(input.LA(1)>='\u0A05' && input.LA(1)<='\u0A0A')||(input.LA(1)>='\u0A0F' && input.LA(1)<='\u0A10')||(input.LA(1)>='\u0A13' && input.LA(1)<='\u0A28')||(input.LA(1)>='\u0A2A' && input.LA(1)<='\u0A30')||(input.LA(1)>='\u0A32' && input.LA(1)<='\u0A33')||(input.LA(1)>='\u0A35' && input.LA(1)<='\u0A36')||(input.LA(1)>='\u0A38' && input.LA(1)<='\u0A39')||(input.LA(1)>='\u0A59' && input.LA(1)<='\u0A5C')||input.LA(1)=='\u0A5E'||(input.LA(1)>='\u0A72' && input.LA(1)<='\u0A74')||(input.LA(1)>='\u0A85' && input.LA(1)<='\u0A8D')||(input.LA(1)>='\u0A8F' && input.LA(1)<='\u0A91')||(input.LA(1)>='\u0A93' && input.LA(1)<='\u0AA8')||(input.LA(1)>='\u0AAA' && input.LA(1)<='\u0AB0')||(input.LA(1)>='\u0AB2' && input.LA(1)<='\u0AB3')||(input.LA(1)>='\u0AB5' && input.LA(1)<='\u0AB9')||input.LA(1)=='\u0ABD'||input.LA(1)=='\u0AD0'||(input.LA(1)>='\u0AE0' && input.LA(1)<='\u0AE1')||input.LA(1)=='\u0AF1'||(input.LA(1)>='\u0B05' && input.LA(1)<='\u0B0C')||(input.LA(1)>='\u0B0F' && input.LA(1)<='\u0B10')||(input.LA(1)>='\u0B13' && input.LA(1)<='\u0B28')||(input.LA(1)>='\u0B2A' && input.LA(1)<='\u0B30')||(input.LA(1)>='\u0B32' && input.LA(1)<='\u0B33')||(input.LA(1)>='\u0B35' && input.LA(1)<='\u0B39')||input.LA(1)=='\u0B3D'||(input.LA(1)>='\u0B5C' && input.LA(1)<='\u0B5D')||(input.LA(1)>='\u0B5F' && input.LA(1)<='\u0B61')||input.LA(1)=='\u0B71'||input.LA(1)=='\u0B83'||(input.LA(1)>='\u0B85' && input.LA(1)<='\u0B8A')||(input.LA(1)>='\u0B8E' && input.LA(1)<='\u0B90')||(input.LA(1)>='\u0B92' && input.LA(1)<='\u0B95')||(input.LA(1)>='\u0B99' && input.LA(1)<='\u0B9A')||input.LA(1)=='\u0B9C'||(input.LA(1)>='\u0B9E' && input.LA(1)<='\u0B9F')||(input.LA(1)>='\u0BA3' && input.LA(1)<='\u0BA4')||(input.LA(1)>='\u0BA8' && input.LA(1)<='\u0BAA')||(input.LA(1)>='\u0BAE' && input.LA(1)<='\u0BB5')||(input.LA(1)>='\u0BB7' && input.LA(1)<='\u0BB9')||input.LA(1)=='\u0BF9'||(input.LA(1)>='\u0C05' && input.LA(1)<='\u0C0C')||(input.LA(1)>='\u0C0E' && input.LA(1)<='\u0C10')||(input.LA(1)>='\u0C12' && input.LA(1)<='\u0C28')||(input.LA(1)>='\u0C2A' && input.LA(1)<='\u0C33')||(input.LA(1)>='\u0C35' && input.LA(1)<='\u0C39')||(input.LA(1)>='\u0C60' && input.LA(1)<='\u0C61')||(input.LA(1)>='\u0C85' && input.LA(1)<='\u0C8C')||(input.LA(1)>='\u0C8E' && input.LA(1)<='\u0C90')||(input.LA(1)>='\u0C92' && input.LA(1)<='\u0CA8')||(input.LA(1)>='\u0CAA' && input.LA(1)<='\u0CB3')||(input.LA(1)>='\u0CB5' && input.LA(1)<='\u0CB9')||input.LA(1)=='\u0CBD'||input.LA(1)=='\u0CDE'||(input.LA(1)>='\u0CE0' && input.LA(1)<='\u0CE1')||(input.LA(1)>='\u0D05' && input.LA(1)<='\u0D0C')||(input.LA(1)>='\u0D0E' && input.LA(1)<='\u0D10')||(input.LA(1)>='\u0D12' && input.LA(1)<='\u0D28')||(input.LA(1)>='\u0D2A' && input.LA(1)<='\u0D39')||(input.LA(1)>='\u0D60' && input.LA(1)<='\u0D61')||(input.LA(1)>='\u0D85' && input.LA(1)<='\u0D96')||(input.LA(1)>='\u0D9A' && input.LA(1)<='\u0DB1')||(input.LA(1)>='\u0DB3' && input.LA(1)<='\u0DBB')||input.LA(1)=='\u0DBD'||(input.LA(1)>='\u0DC0' && input.LA(1)<='\u0DC6')||(input.LA(1)>='\u0E01' && input.LA(1)<='\u0E30')||(input.LA(1)>='\u0E32' && input.LA(1)<='\u0E33')||(input.LA(1)>='\u0E3F' && input.LA(1)<='\u0E46')||(input.LA(1)>='\u0E81' && input.LA(1)<='\u0E82')||input.LA(1)=='\u0E84'||(input.LA(1)>='\u0E87' && input.LA(1)<='\u0E88')||input.LA(1)=='\u0E8A'||input.LA(1)=='\u0E8D'||(input.LA(1)>='\u0E94' && input.LA(1)<='\u0E97')||(input.LA(1)>='\u0E99' && input.LA(1)<='\u0E9F')||(input.LA(1)>='\u0EA1' && input.LA(1)<='\u0EA3')||input.LA(1)=='\u0EA5'||input.LA(1)=='\u0EA7'||(input.LA(1)>='\u0EAA' && input.LA(1)<='\u0EAB')||(input.LA(1)>='\u0EAD' && input.LA(1)<='\u0EB0')||(input.LA(1)>='\u0EB2' && input.LA(1)<='\u0EB3')||input.LA(1)=='\u0EBD'||(input.LA(1)>='\u0EC0' && input.LA(1)<='\u0EC4')||input.LA(1)=='\u0EC6'||(input.LA(1)>='\u0EDC' && input.LA(1)<='\u0EDD')||input.LA(1)=='\u0F00'||(input.LA(1)>='\u0F40' && input.LA(1)<='\u0F47')||(input.LA(1)>='\u0F49' && input.LA(1)<='\u0F6A')||(input.LA(1)>='\u0F88' && input.LA(1)<='\u0F8B')||(input.LA(1)>='\u1000' && input.LA(1)<='\u1021')||(input.LA(1)>='\u1023' && input.LA(1)<='\u1027')||(input.LA(1)>='\u1029' && input.LA(1)<='\u102A')||(input.LA(1)>='\u1050' && input.LA(1)<='\u1055')||(input.LA(1)>='\u10A0' && input.LA(1)<='\u10C5')||(input.LA(1)>='\u10D0' && input.LA(1)<='\u10F8')||(input.LA(1)>='\u1100' && input.LA(1)<='\u1159')||(input.LA(1)>='\u115F' && input.LA(1)<='\u11A2')||(input.LA(1)>='\u11A8' && input.LA(1)<='\u11F9')||(input.LA(1)>='\u1200' && input.LA(1)<='\u1206')||(input.LA(1)>='\u1208' && input.LA(1)<='\u1246')||input.LA(1)=='\u1248'||(input.LA(1)>='\u124A' && input.LA(1)<='\u124D')||(input.LA(1)>='\u1250' && input.LA(1)<='\u1256')||input.LA(1)=='\u1258'||(input.LA(1)>='\u125A' && input.LA(1)<='\u125D')||(input.LA(1)>='\u1260' && input.LA(1)<='\u1286')||input.LA(1)=='\u1288'||(input.LA(1)>='\u128A' && input.LA(1)<='\u128D')||(input.LA(1)>='\u1290' && input.LA(1)<='\u12AE')||input.LA(1)=='\u12B0'||(input.LA(1)>='\u12B2' && input.LA(1)<='\u12B5')||(input.LA(1)>='\u12B8' && input.LA(1)<='\u12BE')||input.LA(1)=='\u12C0'||(input.LA(1)>='\u12C2' && input.LA(1)<='\u12C5')||(input.LA(1)>='\u12C8' && input.LA(1)<='\u12CE')||(input.LA(1)>='\u12D0' && input.LA(1)<='\u12D6')||(input.LA(1)>='\u12D8' && input.LA(1)<='\u12EE')||(input.LA(1)>='\u12F0' && input.LA(1)<='\u130E')||input.LA(1)=='\u1310'||(input.LA(1)>='\u1312' && input.LA(1)<='\u1315')||(input.LA(1)>='\u1318' && input.LA(1)<='\u131E')||(input.LA(1)>='\u1320' && input.LA(1)<='\u1346')||(input.LA(1)>='\u1348' && input.LA(1)<='\u135A')||(input.LA(1)>='\u13A0' && input.LA(1)<='\u13F4')||(input.LA(1)>='\u1401' && input.LA(1)<='\u166C')||(input.LA(1)>='\u166F' && input.LA(1)<='\u1676')||(input.LA(1)>='\u1681' && input.LA(1)<='\u169A')||(input.LA(1)>='\u16A0' && input.LA(1)<='\u16EA')||(input.LA(1)>='\u16EE' && input.LA(1)<='\u16F0')||(input.LA(1)>='\u1700' && input.LA(1)<='\u170C')||(input.LA(1)>='\u170E' && input.LA(1)<='\u1711')||(input.LA(1)>='\u1720' && input.LA(1)<='\u1731')||(input.LA(1)>='\u1740' && input.LA(1)<='\u1751')||(input.LA(1)>='\u1760' && input.LA(1)<='\u176C')||(input.LA(1)>='\u176E' && input.LA(1)<='\u1770')||(input.LA(1)>='\u1780' && input.LA(1)<='\u17B3')||input.LA(1)=='\u17D7'||(input.LA(1)>='\u17DB' && input.LA(1)<='\u17DC')||(input.LA(1)>='\u1820' && input.LA(1)<='\u1877')||(input.LA(1)>='\u1880' && input.LA(1)<='\u18A8')||(input.LA(1)>='\u1900' && input.LA(1)<='\u191C')||(input.LA(1)>='\u1950' && input.LA(1)<='\u196D')||(input.LA(1)>='\u1970' && input.LA(1)<='\u1974')||(input.LA(1)>='\u1D00' && input.LA(1)<='\u1D6B')||(input.LA(1)>='\u1E00' && input.LA(1)<='\u1E9B')||(input.LA(1)>='\u1EA0' && input.LA(1)<='\u1EF9')||(input.LA(1)>='\u1F00' && input.LA(1)<='\u1F15')||(input.LA(1)>='\u1F18' && input.LA(1)<='\u1F1D')||(input.LA(1)>='\u1F20' && input.LA(1)<='\u1F45')||(input.LA(1)>='\u1F48' && input.LA(1)<='\u1F4D')||(input.LA(1)>='\u1F50' && input.LA(1)<='\u1F57')||input.LA(1)=='\u1F59'||input.LA(1)=='\u1F5B'||input.LA(1)=='\u1F5D'||(input.LA(1)>='\u1F5F' && input.LA(1)<='\u1F7D')||(input.LA(1)>='\u1F80' && input.LA(1)<='\u1FB4')||(input.LA(1)>='\u1FB6' && input.LA(1)<='\u1FBC')||input.LA(1)=='\u1FBE'||(input.LA(1)>='\u1FC2' && input.LA(1)<='\u1FC4')||(input.LA(1)>='\u1FC6' && input.LA(1)<='\u1FCC')||(input.LA(1)>='\u1FD0' && input.LA(1)<='\u1FD3')||(input.LA(1)>='\u1FD6' && input.LA(1)<='\u1FDB')||(input.LA(1)>='\u1FE0' && input.LA(1)<='\u1FEC')||(input.LA(1)>='\u1FF2' && input.LA(1)<='\u1FF4')||(input.LA(1)>='\u1FF6' && input.LA(1)<='\u1FFC')||(input.LA(1)>='\u203F' && input.LA(1)<='\u2040')||input.LA(1)=='\u2054'||input.LA(1)=='\u2071'||input.LA(1)=='\u207F'||(input.LA(1)>='\u20A0' && input.LA(1)<='\u20B1')||input.LA(1)=='\u2102'||input.LA(1)=='\u2107'||(input.LA(1)>='\u210A' && input.LA(1)<='\u2113')||input.LA(1)=='\u2115'||(input.LA(1)>='\u2119' && input.LA(1)<='\u211D')||input.LA(1)=='\u2124'||input.LA(1)=='\u2126'||input.LA(1)=='\u2128'||(input.LA(1)>='\u212A' && input.LA(1)<='\u212D')||(input.LA(1)>='\u212F' && input.LA(1)<='\u2131')||(input.LA(1)>='\u2133' && input.LA(1)<='\u2139')||(input.LA(1)>='\u213D' && input.LA(1)<='\u213F')||(input.LA(1)>='\u2145' && input.LA(1)<='\u2149')||(input.LA(1)>='\u2160' && input.LA(1)<='\u2183')||(input.LA(1)>='\u3005' && input.LA(1)<='\u3007')||(input.LA(1)>='\u3021' && input.LA(1)<='\u3029')||(input.LA(1)>='\u3031' && input.LA(1)<='\u3035')||(input.LA(1)>='\u3038' && input.LA(1)<='\u303C')||(input.LA(1)>='\u3041' && input.LA(1)<='\u3096')||(input.LA(1)>='\u309D' && input.LA(1)<='\u309F')||(input.LA(1)>='\u30A1' && input.LA(1)<='\u30FF')||(input.LA(1)>='\u3105' && input.LA(1)<='\u312C')||(input.LA(1)>='\u3131' && input.LA(1)<='\u318E')||(input.LA(1)>='\u31A0' && input.LA(1)<='\u31B7')||(input.LA(1)>='\u31F0' && input.LA(1)<='\u31FF')||(input.LA(1)>='\u3400' && input.LA(1)<='\u4DB5')||(input.LA(1)>='\u4E00' && input.LA(1)<='\u9FA5')||(input.LA(1)>='\uA000' && input.LA(1)<='\uA48C')||(input.LA(1)>='\uAC00' && input.LA(1)<='\uD7A3')||(input.LA(1)>='\uF900' && input.LA(1)<='\uFA2D')||(input.LA(1)>='\uFA30' && input.LA(1)<='\uFA6A')||(input.LA(1)>='\uFB00' && input.LA(1)<='\uFB06')||(input.LA(1)>='\uFB13' && input.LA(1)<='\uFB17')||input.LA(1)=='\uFB1D'||(input.LA(1)>='\uFB1F' && input.LA(1)<='\uFB28')||(input.LA(1)>='\uFB2A' && input.LA(1)<='\uFB36')||(input.LA(1)>='\uFB38' && input.LA(1)<='\uFB3C')||input.LA(1)=='\uFB3E'||(input.LA(1)>='\uFB40' && input.LA(1)<='\uFB41')||(input.LA(1)>='\uFB43' && input.LA(1)<='\uFB44')||(input.LA(1)>='\uFB46' && input.LA(1)<='\uFBB1')||(input.LA(1)>='\uFBD3' && input.LA(1)<='\uFD3D')||(input.LA(1)>='\uFD50' && input.LA(1)<='\uFD8F')||(input.LA(1)>='\uFD92' && input.LA(1)<='\uFDC7')||(input.LA(1)>='\uFDF0' && input.LA(1)<='\uFDFC')||(input.LA(1)>='\uFE33' && input.LA(1)<='\uFE34')||(input.LA(1)>='\uFE4D' && input.LA(1)<='\uFE4F')||input.LA(1)=='\uFE69'||(input.LA(1)>='\uFE70' && input.LA(1)<='\uFE74')||(input.LA(1)>='\uFE76' && input.LA(1)<='\uFEFC')||input.LA(1)=='\uFF04'||(input.LA(1)>='\uFF21' && input.LA(1)<='\uFF3A')||input.LA(1)=='\uFF3F'||(input.LA(1)>='\uFF41' && input.LA(1)<='\uFF5A')||(input.LA(1)>='\uFF65' && input.LA(1)<='\uFFBE')||(input.LA(1)>='\uFFC2' && input.LA(1)<='\uFFC7')||(input.LA(1)>='\uFFCA' && input.LA(1)<='\uFFCF')||(input.LA(1)>='\uFFD2' && input.LA(1)<='\uFFD7')||(input.LA(1)>='\uFFDA' && input.LA(1)<='\uFFDC')||(input.LA(1)>='\uFFE0' && input.LA(1)<='\uFFE1')||(input.LA(1)>='\uFFE5' && input.LA(1)<='\uFFE6') ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "IdentifierStart"

    // $ANTLR start "IdentifierPart"
    public final void mIdentifierPart() throws RecognitionException {
        try {
            // src/main/resources/org/drools/lang/DRL6Lexer.g:651:5: ( '\\u0000' .. '\\u0008' | '\\u000e' .. '\\u001b' | '\\u0024' | '\\u0030' .. '\\u0039' | '\\u0041' .. '\\u005a' | '\\u005f' | '\\u0061' .. '\\u007a' | '\\u007f' .. '\\u009f' | '\\u00a2' .. '\\u00a5' | '\\u00aa' | '\\u00ad' | '\\u00b5' | '\\u00ba' | '\\u00c0' .. '\\u00d6' | '\\u00d8' .. '\\u00f6' | '\\u00f8' .. '\\u0236' | '\\u0250' .. '\\u02c1' | '\\u02c6' .. '\\u02d1' | '\\u02e0' .. '\\u02e4' | '\\u02ee' | '\\u0300' .. '\\u0357' | '\\u035d' .. '\\u036f' | '\\u037a' | '\\u0386' | '\\u0388' .. '\\u038a' | '\\u038c' | '\\u038e' .. '\\u03a1' | '\\u03a3' .. '\\u03ce' | '\\u03d0' .. '\\u03f5' | '\\u03f7' .. '\\u03fb' | '\\u0400' .. '\\u0481' | '\\u0483' .. '\\u0486' | '\\u048a' .. '\\u04ce' | '\\u04d0' .. '\\u04f5' | '\\u04f8' .. '\\u04f9' | '\\u0500' .. '\\u050f' | '\\u0531' .. '\\u0556' | '\\u0559' | '\\u0561' .. '\\u0587' | '\\u0591' .. '\\u05a1' | '\\u05a3' .. '\\u05b9' | '\\u05bb' .. '\\u05bd' | '\\u05bf' | '\\u05c1' .. '\\u05c2' | '\\u05c4' | '\\u05d0' .. '\\u05ea' | '\\u05f0' .. '\\u05f2' | '\\u0600' .. '\\u0603' | '\\u0610' .. '\\u0615' | '\\u0621' .. '\\u063a' | '\\u0640' .. '\\u0658' | '\\u0660' .. '\\u0669' | '\\u066e' .. '\\u06d3' | '\\u06d5' .. '\\u06dd' | '\\u06df' .. '\\u06e8' | '\\u06ea' .. '\\u06fc' | '\\u06ff' | '\\u070f' .. '\\u074a' | '\\u074d' .. '\\u074f' | '\\u0780' .. '\\u07b1' | '\\u0901' .. '\\u0939' | '\\u093c' .. '\\u094d' | '\\u0950' .. '\\u0954' | '\\u0958' .. '\\u0963' | '\\u0966' .. '\\u096f' | '\\u0981' .. '\\u0983' | '\\u0985' .. '\\u098c' | '\\u098f' .. '\\u0990' | '\\u0993' .. '\\u09a8' | '\\u09aa' .. '\\u09b0' | '\\u09b2' | '\\u09b6' .. '\\u09b9' | '\\u09bc' .. '\\u09c4' | '\\u09c7' .. '\\u09c8' | '\\u09cb' .. '\\u09cd' | '\\u09d7' | '\\u09dc' .. '\\u09dd' | '\\u09df' .. '\\u09e3' | '\\u09e6' .. '\\u09f3' | '\\u0a01' .. '\\u0a03' | '\\u0a05' .. '\\u0a0a' | '\\u0a0f' .. '\\u0a10' | '\\u0a13' .. '\\u0a28' | '\\u0a2a' .. '\\u0a30' | '\\u0a32' .. '\\u0a33' | '\\u0a35' .. '\\u0a36' | '\\u0a38' .. '\\u0a39' | '\\u0a3c' | '\\u0a3e' .. '\\u0a42' | '\\u0a47' .. '\\u0a48' | '\\u0a4b' .. '\\u0a4d' | '\\u0a59' .. '\\u0a5c' | '\\u0a5e' | '\\u0a66' .. '\\u0a74' | '\\u0a81' .. '\\u0a83' | '\\u0a85' .. '\\u0a8d' | '\\u0a8f' .. '\\u0a91' | '\\u0a93' .. '\\u0aa8' | '\\u0aaa' .. '\\u0ab0' | '\\u0ab2' .. '\\u0ab3' | '\\u0ab5' .. '\\u0ab9' | '\\u0abc' .. '\\u0ac5' | '\\u0ac7' .. '\\u0ac9' | '\\u0acb' .. '\\u0acd' | '\\u0ad0' | '\\u0ae0' .. '\\u0ae3' | '\\u0ae6' .. '\\u0aef' | '\\u0af1' | '\\u0b01' .. '\\u0b03' | '\\u0b05' .. '\\u0b0c' | '\\u0b0f' .. '\\u0b10' | '\\u0b13' .. '\\u0b28' | '\\u0b2a' .. '\\u0b30' | '\\u0b32' .. '\\u0b33' | '\\u0b35' .. '\\u0b39' | '\\u0b3c' .. '\\u0b43' | '\\u0b47' .. '\\u0b48' | '\\u0b4b' .. '\\u0b4d' | '\\u0b56' .. '\\u0b57' | '\\u0b5c' .. '\\u0b5d' | '\\u0b5f' .. '\\u0b61' | '\\u0b66' .. '\\u0b6f' | '\\u0b71' | '\\u0b82' .. '\\u0b83' | '\\u0b85' .. '\\u0b8a' | '\\u0b8e' .. '\\u0b90' | '\\u0b92' .. '\\u0b95' | '\\u0b99' .. '\\u0b9a' | '\\u0b9c' | '\\u0b9e' .. '\\u0b9f' | '\\u0ba3' .. '\\u0ba4' | '\\u0ba8' .. '\\u0baa' | '\\u0bae' .. '\\u0bb5' | '\\u0bb7' .. '\\u0bb9' | '\\u0bbe' .. '\\u0bc2' | '\\u0bc6' .. '\\u0bc8' | '\\u0bca' .. '\\u0bcd' | '\\u0bd7' | '\\u0be7' .. '\\u0bef' | '\\u0bf9' | '\\u0c01' .. '\\u0c03' | '\\u0c05' .. '\\u0c0c' | '\\u0c0e' .. '\\u0c10' | '\\u0c12' .. '\\u0c28' | '\\u0c2a' .. '\\u0c33' | '\\u0c35' .. '\\u0c39' | '\\u0c3e' .. '\\u0c44' | '\\u0c46' .. '\\u0c48' | '\\u0c4a' .. '\\u0c4d' | '\\u0c55' .. '\\u0c56' | '\\u0c60' .. '\\u0c61' | '\\u0c66' .. '\\u0c6f' | '\\u0c82' .. '\\u0c83' | '\\u0c85' .. '\\u0c8c' | '\\u0c8e' .. '\\u0c90' | '\\u0c92' .. '\\u0ca8' | '\\u0caa' .. '\\u0cb3' | '\\u0cb5' .. '\\u0cb9' | '\\u0cbc' .. '\\u0cc4' | '\\u0cc6' .. '\\u0cc8' | '\\u0cca' .. '\\u0ccd' | '\\u0cd5' .. '\\u0cd6' | '\\u0cde' | '\\u0ce0' .. '\\u0ce1' | '\\u0ce6' .. '\\u0cef' | '\\u0d02' .. '\\u0d03' | '\\u0d05' .. '\\u0d0c' | '\\u0d0e' .. '\\u0d10' | '\\u0d12' .. '\\u0d28' | '\\u0d2a' .. '\\u0d39' | '\\u0d3e' .. '\\u0d43' | '\\u0d46' .. '\\u0d48' | '\\u0d4a' .. '\\u0d4d' | '\\u0d57' | '\\u0d60' .. '\\u0d61' | '\\u0d66' .. '\\u0d6f' | '\\u0d82' .. '\\u0d83' | '\\u0d85' .. '\\u0d96' | '\\u0d9a' .. '\\u0db1' | '\\u0db3' .. '\\u0dbb' | '\\u0dbd' | '\\u0dc0' .. '\\u0dc6' | '\\u0dca' | '\\u0dcf' .. '\\u0dd4' | '\\u0dd6' | '\\u0dd8' .. '\\u0ddf' | '\\u0df2' .. '\\u0df3' | '\\u0e01' .. '\\u0e3a' | '\\u0e3f' .. '\\u0e4e' | '\\u0e50' .. '\\u0e59' | '\\u0e81' .. '\\u0e82' | '\\u0e84' | '\\u0e87' .. '\\u0e88' | '\\u0e8a' | '\\u0e8d' | '\\u0e94' .. '\\u0e97' | '\\u0e99' .. '\\u0e9f' | '\\u0ea1' .. '\\u0ea3' | '\\u0ea5' | '\\u0ea7' | '\\u0eaa' .. '\\u0eab' | '\\u0ead' .. '\\u0eb9' | '\\u0ebb' .. '\\u0ebd' | '\\u0ec0' .. '\\u0ec4' | '\\u0ec6' | '\\u0ec8' .. '\\u0ecd' | '\\u0ed0' .. '\\u0ed9' | '\\u0edc' .. '\\u0edd' | '\\u0f00' | '\\u0f18' .. '\\u0f19' | '\\u0f20' .. '\\u0f29' | '\\u0f35' | '\\u0f37' | '\\u0f39' | '\\u0f3e' .. '\\u0f47' | '\\u0f49' .. '\\u0f6a' | '\\u0f71' .. '\\u0f84' | '\\u0f86' .. '\\u0f8b' | '\\u0f90' .. '\\u0f97' | '\\u0f99' .. '\\u0fbc' | '\\u0fc6' | '\\u1000' .. '\\u1021' | '\\u1023' .. '\\u1027' | '\\u1029' .. '\\u102a' | '\\u102c' .. '\\u1032' | '\\u1036' .. '\\u1039' | '\\u1040' .. '\\u1049' | '\\u1050' .. '\\u1059' | '\\u10a0' .. '\\u10c5' | '\\u10d0' .. '\\u10f8' | '\\u1100' .. '\\u1159' | '\\u115f' .. '\\u11a2' | '\\u11a8' .. '\\u11f9' | '\\u1200' .. '\\u1206' | '\\u1208' .. '\\u1246' | '\\u1248' | '\\u124a' .. '\\u124d' | '\\u1250' .. '\\u1256' | '\\u1258' | '\\u125a' .. '\\u125d' | '\\u1260' .. '\\u1286' | '\\u1288' | '\\u128a' .. '\\u128d' | '\\u1290' .. '\\u12ae' | '\\u12b0' | '\\u12b2' .. '\\u12b5' | '\\u12b8' .. '\\u12be' | '\\u12c0' | '\\u12c2' .. '\\u12c5' | '\\u12c8' .. '\\u12ce' | '\\u12d0' .. '\\u12d6' | '\\u12d8' .. '\\u12ee' | '\\u12f0' .. '\\u130e' | '\\u1310' | '\\u1312' .. '\\u1315' | '\\u1318' .. '\\u131e' | '\\u1320' .. '\\u1346' | '\\u1348' .. '\\u135a' | '\\u1369' .. '\\u1371' | '\\u13a0' .. '\\u13f4' | '\\u1401' .. '\\u166c' | '\\u166f' .. '\\u1676' | '\\u1681' .. '\\u169a' | '\\u16a0' .. '\\u16ea' | '\\u16ee' .. '\\u16f0' | '\\u1700' .. '\\u170c' | '\\u170e' .. '\\u1714' | '\\u1720' .. '\\u1734' | '\\u1740' .. '\\u1753' | '\\u1760' .. '\\u176c' | '\\u176e' .. '\\u1770' | '\\u1772' .. '\\u1773' | '\\u1780' .. '\\u17d3' | '\\u17d7' | '\\u17db' .. '\\u17dd' | '\\u17e0' .. '\\u17e9' | '\\u180b' .. '\\u180d' | '\\u1810' .. '\\u1819' | '\\u1820' .. '\\u1877' | '\\u1880' .. '\\u18a9' | '\\u1900' .. '\\u191c' | '\\u1920' .. '\\u192b' | '\\u1930' .. '\\u193b' | '\\u1946' .. '\\u196d' | '\\u1970' .. '\\u1974' | '\\u1d00' .. '\\u1d6b' | '\\u1e00' .. '\\u1e9b' | '\\u1ea0' .. '\\u1ef9' | '\\u1f00' .. '\\u1f15' | '\\u1f18' .. '\\u1f1d' | '\\u1f20' .. '\\u1f45' | '\\u1f48' .. '\\u1f4d' | '\\u1f50' .. '\\u1f57' | '\\u1f59' | '\\u1f5b' | '\\u1f5d' | '\\u1f5f' .. '\\u1f7d' | '\\u1f80' .. '\\u1fb4' | '\\u1fb6' .. '\\u1fbc' | '\\u1fbe' | '\\u1fc2' .. '\\u1fc4' | '\\u1fc6' .. '\\u1fcc' | '\\u1fd0' .. '\\u1fd3' | '\\u1fd6' .. '\\u1fdb' | '\\u1fe0' .. '\\u1fec' | '\\u1ff2' .. '\\u1ff4' | '\\u1ff6' .. '\\u1ffc' | '\\u200c' .. '\\u200f' | '\\u202a' .. '\\u202e' | '\\u203f' .. '\\u2040' | '\\u2054' | '\\u2060' .. '\\u2063' | '\\u206a' .. '\\u206f' | '\\u2071' | '\\u207f' | '\\u20a0' .. '\\u20b1' | '\\u20d0' .. '\\u20dc' | '\\u20e1' | '\\u20e5' .. '\\u20ea' | '\\u2102' | '\\u2107' | '\\u210a' .. '\\u2113' | '\\u2115' | '\\u2119' .. '\\u211d' | '\\u2124' | '\\u2126' | '\\u2128' | '\\u212a' .. '\\u212d' | '\\u212f' .. '\\u2131' | '\\u2133' .. '\\u2139' | '\\u213d' .. '\\u213f' | '\\u2145' .. '\\u2149' | '\\u2160' .. '\\u2183' | '\\u3005' .. '\\u3007' | '\\u3021' .. '\\u302f' | '\\u3031' .. '\\u3035' | '\\u3038' .. '\\u303c' | '\\u3041' .. '\\u3096' | '\\u3099' .. '\\u309a' | '\\u309d' .. '\\u309f' | '\\u30a1' .. '\\u30ff' | '\\u3105' .. '\\u312c' | '\\u3131' .. '\\u318e' | '\\u31a0' .. '\\u31b7' | '\\u31f0' .. '\\u31ff' | '\\u3400' .. '\\u4db5' | '\\u4e00' .. '\\u9fa5' | '\\ua000' .. '\\ua48c' | '\\uac00' .. '\\ud7a3' | '\\uf900' .. '\\ufa2d' | '\\ufa30' .. '\\ufa6a' | '\\ufb00' .. '\\ufb06' | '\\ufb13' .. '\\ufb17' | '\\ufb1d' .. '\\ufb28' | '\\ufb2a' .. '\\ufb36' | '\\ufb38' .. '\\ufb3c' | '\\ufb3e' | '\\ufb40' .. '\\ufb41' | '\\ufb43' .. '\\ufb44' | '\\ufb46' .. '\\ufbb1' | '\\ufbd3' .. '\\ufd3d' | '\\ufd50' .. '\\ufd8f' | '\\ufd92' .. '\\ufdc7' | '\\ufdf0' .. '\\ufdfc' | '\\ufe00' .. '\\ufe0f' | '\\ufe20' .. '\\ufe23' | '\\ufe33' .. '\\ufe34' | '\\ufe4d' .. '\\ufe4f' | '\\ufe69' | '\\ufe70' .. '\\ufe74' | '\\ufe76' .. '\\ufefc' | '\\ufeff' | '\\uff04' | '\\uff10' .. '\\uff19' | '\\uff21' .. '\\uff3a' | '\\uff3f' | '\\uff41' .. '\\uff5a' | '\\uff65' .. '\\uffbe' | '\\uffc2' .. '\\uffc7' | '\\uffca' .. '\\uffcf' | '\\uffd2' .. '\\uffd7' | '\\uffda' .. '\\uffdc' | '\\uffe0' .. '\\uffe1' | '\\uffe5' .. '\\uffe6' | '\\ufff9' .. '\\ufffb' )
            // src/main/resources/org/drools/lang/DRL6Lexer.g:
            {
            if ( (input.LA(1)>='\u0000' && input.LA(1)<='\b')||(input.LA(1)>='\u000E' && input.LA(1)<='\u001B')||input.LA(1)=='$'||(input.LA(1)>='0' && input.LA(1)<='9')||(input.LA(1)>='A' && input.LA(1)<='Z')||input.LA(1)=='_'||(input.LA(1)>='a' && input.LA(1)<='z')||(input.LA(1)>='\u007F' && input.LA(1)<='\u009F')||(input.LA(1)>='\u00A2' && input.LA(1)<='\u00A5')||input.LA(1)=='\u00AA'||input.LA(1)=='\u00AD'||input.LA(1)=='\u00B5'||input.LA(1)=='\u00BA'||(input.LA(1)>='\u00C0' && input.LA(1)<='\u00D6')||(input.LA(1)>='\u00D8' && input.LA(1)<='\u00F6')||(input.LA(1)>='\u00F8' && input.LA(1)<='\u0236')||(input.LA(1)>='\u0250' && input.LA(1)<='\u02C1')||(input.LA(1)>='\u02C6' && input.LA(1)<='\u02D1')||(input.LA(1)>='\u02E0' && input.LA(1)<='\u02E4')||input.LA(1)=='\u02EE'||(input.LA(1)>='\u0300' && input.LA(1)<='\u0357')||(input.LA(1)>='\u035D' && input.LA(1)<='\u036F')||input.LA(1)=='\u037A'||input.LA(1)=='\u0386'||(input.LA(1)>='\u0388' && input.LA(1)<='\u038A')||input.LA(1)=='\u038C'||(input.LA(1)>='\u038E' && input.LA(1)<='\u03A1')||(input.LA(1)>='\u03A3' && input.LA(1)<='\u03CE')||(input.LA(1)>='\u03D0' && input.LA(1)<='\u03F5')||(input.LA(1)>='\u03F7' && input.LA(1)<='\u03FB')||(input.LA(1)>='\u0400' && input.LA(1)<='\u0481')||(input.LA(1)>='\u0483' && input.LA(1)<='\u0486')||(input.LA(1)>='\u048A' && input.LA(1)<='\u04CE')||(input.LA(1)>='\u04D0' && input.LA(1)<='\u04F5')||(input.LA(1)>='\u04F8' && input.LA(1)<='\u04F9')||(input.LA(1)>='\u0500' && input.LA(1)<='\u050F')||(input.LA(1)>='\u0531' && input.LA(1)<='\u0556')||input.LA(1)=='\u0559'||(input.LA(1)>='\u0561' && input.LA(1)<='\u0587')||(input.LA(1)>='\u0591' && input.LA(1)<='\u05A1')||(input.LA(1)>='\u05A3' && input.LA(1)<='\u05B9')||(input.LA(1)>='\u05BB' && input.LA(1)<='\u05BD')||input.LA(1)=='\u05BF'||(input.LA(1)>='\u05C1' && input.LA(1)<='\u05C2')||input.LA(1)=='\u05C4'||(input.LA(1)>='\u05D0' && input.LA(1)<='\u05EA')||(input.LA(1)>='\u05F0' && input.LA(1)<='\u05F2')||(input.LA(1)>='\u0600' && input.LA(1)<='\u0603')||(input.LA(1)>='\u0610' && input.LA(1)<='\u0615')||(input.LA(1)>='\u0621' && input.LA(1)<='\u063A')||(input.LA(1)>='\u0640' && input.LA(1)<='\u0658')||(input.LA(1)>='\u0660' && input.LA(1)<='\u0669')||(input.LA(1)>='\u066E' && input.LA(1)<='\u06D3')||(input.LA(1)>='\u06D5' && input.LA(1)<='\u06DD')||(input.LA(1)>='\u06DF' && input.LA(1)<='\u06E8')||(input.LA(1)>='\u06EA' && input.LA(1)<='\u06FC')||input.LA(1)=='\u06FF'||(input.LA(1)>='\u070F' && input.LA(1)<='\u074A')||(input.LA(1)>='\u074D' && input.LA(1)<='\u074F')||(input.LA(1)>='\u0780' && input.LA(1)<='\u07B1')||(input.LA(1)>='\u0901' && input.LA(1)<='\u0939')||(input.LA(1)>='\u093C' && input.LA(1)<='\u094D')||(input.LA(1)>='\u0950' && input.LA(1)<='\u0954')||(input.LA(1)>='\u0958' && input.LA(1)<='\u0963')||(input.LA(1)>='\u0966' && input.LA(1)<='\u096F')||(input.LA(1)>='\u0981' && input.LA(1)<='\u0983')||(input.LA(1)>='\u0985' && input.LA(1)<='\u098C')||(input.LA(1)>='\u098F' && input.LA(1)<='\u0990')||(input.LA(1)>='\u0993' && input.LA(1)<='\u09A8')||(input.LA(1)>='\u09AA' && input.LA(1)<='\u09B0')||input.LA(1)=='\u09B2'||(input.LA(1)>='\u09B6' && input.LA(1)<='\u09B9')||(input.LA(1)>='\u09BC' && input.LA(1)<='\u09C4')||(input.LA(1)>='\u09C7' && input.LA(1)<='\u09C8')||(input.LA(1)>='\u09CB' && input.LA(1)<='\u09CD')||input.LA(1)=='\u09D7'||(input.LA(1)>='\u09DC' && input.LA(1)<='\u09DD')||(input.LA(1)>='\u09DF' && input.LA(1)<='\u09E3')||(input.LA(1)>='\u09E6' && input.LA(1)<='\u09F3')||(input.LA(1)>='\u0A01' && input.LA(1)<='\u0A03')||(input.LA(1)>='\u0A05' && input.LA(1)<='\u0A0A')||(input.LA(1)>='\u0A0F' && input.LA(1)<='\u0A10')||(input.LA(1)>='\u0A13' && input.LA(1)<='\u0A28')||(input.LA(1)>='\u0A2A' && input.LA(1)<='\u0A30')||(input.LA(1)>='\u0A32' && input.LA(1)<='\u0A33')||(input.LA(1)>='\u0A35' && input.LA(1)<='\u0A36')||(input.LA(1)>='\u0A38' && input.LA(1)<='\u0A39')||input.LA(1)=='\u0A3C'||(input.LA(1)>='\u0A3E' && input.LA(1)<='\u0A42')||(input.LA(1)>='\u0A47' && input.LA(1)<='\u0A48')||(input.LA(1)>='\u0A4B' && input.LA(1)<='\u0A4D')||(input.LA(1)>='\u0A59' && input.LA(1)<='\u0A5C')||input.LA(1)=='\u0A5E'||(input.LA(1)>='\u0A66' && input.LA(1)<='\u0A74')||(input.LA(1)>='\u0A81' && input.LA(1)<='\u0A83')||(input.LA(1)>='\u0A85' && input.LA(1)<='\u0A8D')||(input.LA(1)>='\u0A8F' && input.LA(1)<='\u0A91')||(input.LA(1)>='\u0A93' && input.LA(1)<='\u0AA8')||(input.LA(1)>='\u0AAA' && input.LA(1)<='\u0AB0')||(input.LA(1)>='\u0AB2' && input.LA(1)<='\u0AB3')||(input.LA(1)>='\u0AB5' && input.LA(1)<='\u0AB9')||(input.LA(1)>='\u0ABC' && input.LA(1)<='\u0AC5')||(input.LA(1)>='\u0AC7' && input.LA(1)<='\u0AC9')||(input.LA(1)>='\u0ACB' && input.LA(1)<='\u0ACD')||input.LA(1)=='\u0AD0'||(input.LA(1)>='\u0AE0' && input.LA(1)<='\u0AE3')||(input.LA(1)>='\u0AE6' && input.LA(1)<='\u0AEF')||input.LA(1)=='\u0AF1'||(input.LA(1)>='\u0B01' && input.LA(1)<='\u0B03')||(input.LA(1)>='\u0B05' && input.LA(1)<='\u0B0C')||(input.LA(1)>='\u0B0F' && input.LA(1)<='\u0B10')||(input.LA(1)>='\u0B13' && input.LA(1)<='\u0B28')||(input.LA(1)>='\u0B2A' && input.LA(1)<='\u0B30')||(input.LA(1)>='\u0B32' && input.LA(1)<='\u0B33')||(input.LA(1)>='\u0B35' && input.LA(1)<='\u0B39')||(input.LA(1)>='\u0B3C' && input.LA(1)<='\u0B43')||(input.LA(1)>='\u0B47' && input.LA(1)<='\u0B48')||(input.LA(1)>='\u0B4B' && input.LA(1)<='\u0B4D')||(input.LA(1)>='\u0B56' && input.LA(1)<='\u0B57')||(input.LA(1)>='\u0B5C' && input.LA(1)<='\u0B5D')||(input.LA(1)>='\u0B5F' && input.LA(1)<='\u0B61')||(input.LA(1)>='\u0B66' && input.LA(1)<='\u0B6F')||input.LA(1)=='\u0B71'||(input.LA(1)>='\u0B82' && input.LA(1)<='\u0B83')||(input.LA(1)>='\u0B85' && input.LA(1)<='\u0B8A')||(input.LA(1)>='\u0B8E' && input.LA(1)<='\u0B90')||(input.LA(1)>='\u0B92' && input.LA(1)<='\u0B95')||(input.LA(1)>='\u0B99' && input.LA(1)<='\u0B9A')||input.LA(1)=='\u0B9C'||(input.LA(1)>='\u0B9E' && input.LA(1)<='\u0B9F')||(input.LA(1)>='\u0BA3' && input.LA(1)<='\u0BA4')||(input.LA(1)>='\u0BA8' && input.LA(1)<='\u0BAA')||(input.LA(1)>='\u0BAE' && input.LA(1)<='\u0BB5')||(input.LA(1)>='\u0BB7' && input.LA(1)<='\u0BB9')||(input.LA(1)>='\u0BBE' && input.LA(1)<='\u0BC2')||(input.LA(1)>='\u0BC6' && input.LA(1)<='\u0BC8')||(input.LA(1)>='\u0BCA' && input.LA(1)<='\u0BCD')||input.LA(1)=='\u0BD7'||(input.LA(1)>='\u0BE7' && input.LA(1)<='\u0BEF')||input.LA(1)=='\u0BF9'||(input.LA(1)>='\u0C01' && input.LA(1)<='\u0C03')||(input.LA(1)>='\u0C05' && input.LA(1)<='\u0C0C')||(input.LA(1)>='\u0C0E' && input.LA(1)<='\u0C10')||(input.LA(1)>='\u0C12' && input.LA(1)<='\u0C28')||(input.LA(1)>='\u0C2A' && input.LA(1)<='\u0C33')||(input.LA(1)>='\u0C35' && input.LA(1)<='\u0C39')||(input.LA(1)>='\u0C3E' && input.LA(1)<='\u0C44')||(input.LA(1)>='\u0C46' && input.LA(1)<='\u0C48')||(input.LA(1)>='\u0C4A' && input.LA(1)<='\u0C4D')||(input.LA(1)>='\u0C55' && input.LA(1)<='\u0C56')||(input.LA(1)>='\u0C60' && input.LA(1)<='\u0C61')||(input.LA(1)>='\u0C66' && input.LA(1)<='\u0C6F')||(input.LA(1)>='\u0C82' && input.LA(1)<='\u0C83')||(input.LA(1)>='\u0C85' && input.LA(1)<='\u0C8C')||(input.LA(1)>='\u0C8E' && input.LA(1)<='\u0C90')||(input.LA(1)>='\u0C92' && input.LA(1)<='\u0CA8')||(input.LA(1)>='\u0CAA' && input.LA(1)<='\u0CB3')||(input.LA(1)>='\u0CB5' && input.LA(1)<='\u0CB9')||(input.LA(1)>='\u0CBC' && input.LA(1)<='\u0CC4')||(input.LA(1)>='\u0CC6' && input.LA(1)<='\u0CC8')||(input.LA(1)>='\u0CCA' && input.LA(1)<='\u0CCD')||(input.LA(1)>='\u0CD5' && input.LA(1)<='\u0CD6')||input.LA(1)=='\u0CDE'||(input.LA(1)>='\u0CE0' && input.LA(1)<='\u0CE1')||(input.LA(1)>='\u0CE6' && input.LA(1)<='\u0CEF')||(input.LA(1)>='\u0D02' && input.LA(1)<='\u0D03')||(input.LA(1)>='\u0D05' && input.LA(1)<='\u0D0C')||(input.LA(1)>='\u0D0E' && input.LA(1)<='\u0D10')||(input.LA(1)>='\u0D12' && input.LA(1)<='\u0D28')||(input.LA(1)>='\u0D2A' && input.LA(1)<='\u0D39')||(input.LA(1)>='\u0D3E' && input.LA(1)<='\u0D43')||(input.LA(1)>='\u0D46' && input.LA(1)<='\u0D48')||(input.LA(1)>='\u0D4A' && input.LA(1)<='\u0D4D')||input.LA(1)=='\u0D57'||(input.LA(1)>='\u0D60' && input.LA(1)<='\u0D61')||(input.LA(1)>='\u0D66' && input.LA(1)<='\u0D6F')||(input.LA(1)>='\u0D82' && input.LA(1)<='\u0D83')||(input.LA(1)>='\u0D85' && input.LA(1)<='\u0D96')||(input.LA(1)>='\u0D9A' && input.LA(1)<='\u0DB1')||(input.LA(1)>='\u0DB3' && input.LA(1)<='\u0DBB')||input.LA(1)=='\u0DBD'||(input.LA(1)>='\u0DC0' && input.LA(1)<='\u0DC6')||input.LA(1)=='\u0DCA'||(input.LA(1)>='\u0DCF' && input.LA(1)<='\u0DD4')||input.LA(1)=='\u0DD6'||(input.LA(1)>='\u0DD8' && input.LA(1)<='\u0DDF')||(input.LA(1)>='\u0DF2' && input.LA(1)<='\u0DF3')||(input.LA(1)>='\u0E01' && input.LA(1)<='\u0E3A')||(input.LA(1)>='\u0E3F' && input.LA(1)<='\u0E4E')||(input.LA(1)>='\u0E50' && input.LA(1)<='\u0E59')||(input.LA(1)>='\u0E81' && input.LA(1)<='\u0E82')||input.LA(1)=='\u0E84'||(input.LA(1)>='\u0E87' && input.LA(1)<='\u0E88')||input.LA(1)=='\u0E8A'||input.LA(1)=='\u0E8D'||(input.LA(1)>='\u0E94' && input.LA(1)<='\u0E97')||(input.LA(1)>='\u0E99' && input.LA(1)<='\u0E9F')||(input.LA(1)>='\u0EA1' && input.LA(1)<='\u0EA3')||input.LA(1)=='\u0EA5'||input.LA(1)=='\u0EA7'||(input.LA(1)>='\u0EAA' && input.LA(1)<='\u0EAB')||(input.LA(1)>='\u0EAD' && input.LA(1)<='\u0EB9')||(input.LA(1)>='\u0EBB' && input.LA(1)<='\u0EBD')||(input.LA(1)>='\u0EC0' && input.LA(1)<='\u0EC4')||input.LA(1)=='\u0EC6'||(input.LA(1)>='\u0EC8' && input.LA(1)<='\u0ECD')||(input.LA(1)>='\u0ED0' && input.LA(1)<='\u0ED9')||(input.LA(1)>='\u0EDC' && input.LA(1)<='\u0EDD')||input.LA(1)=='\u0F00'||(input.LA(1)>='\u0F18' && input.LA(1)<='\u0F19')||(input.LA(1)>='\u0F20' && input.LA(1)<='\u0F29')||input.LA(1)=='\u0F35'||input.LA(1)=='\u0F37'||input.LA(1)=='\u0F39'||(input.LA(1)>='\u0F3E' && input.LA(1)<='\u0F47')||(input.LA(1)>='\u0F49' && input.LA(1)<='\u0F6A')||(input.LA(1)>='\u0F71' && input.LA(1)<='\u0F84')||(input.LA(1)>='\u0F86' && input.LA(1)<='\u0F8B')||(input.LA(1)>='\u0F90' && input.LA(1)<='\u0F97')||(input.LA(1)>='\u0F99' && input.LA(1)<='\u0FBC')||input.LA(1)=='\u0FC6'||(input.LA(1)>='\u1000' && input.LA(1)<='\u1021')||(input.LA(1)>='\u1023' && input.LA(1)<='\u1027')||(input.LA(1)>='\u1029' && input.LA(1)<='\u102A')||(input.LA(1)>='\u102C' && input.LA(1)<='\u1032')||(input.LA(1)>='\u1036' && input.LA(1)<='\u1039')||(input.LA(1)>='\u1040' && input.LA(1)<='\u1049')||(input.LA(1)>='\u1050' && input.LA(1)<='\u1059')||(input.LA(1)>='\u10A0' && input.LA(1)<='\u10C5')||(input.LA(1)>='\u10D0' && input.LA(1)<='\u10F8')||(input.LA(1)>='\u1100' && input.LA(1)<='\u1159')||(input.LA(1)>='\u115F' && input.LA(1)<='\u11A2')||(input.LA(1)>='\u11A8' && input.LA(1)<='\u11F9')||(input.LA(1)>='\u1200' && input.LA(1)<='\u1206')||(input.LA(1)>='\u1208' && input.LA(1)<='\u1246')||input.LA(1)=='\u1248'||(input.LA(1)>='\u124A' && input.LA(1)<='\u124D')||(input.LA(1)>='\u1250' && input.LA(1)<='\u1256')||input.LA(1)=='\u1258'||(input.LA(1)>='\u125A' && input.LA(1)<='\u125D')||(input.LA(1)>='\u1260' && input.LA(1)<='\u1286')||input.LA(1)=='\u1288'||(input.LA(1)>='\u128A' && input.LA(1)<='\u128D')||(input.LA(1)>='\u1290' && input.LA(1)<='\u12AE')||input.LA(1)=='\u12B0'||(input.LA(1)>='\u12B2' && input.LA(1)<='\u12B5')||(input.LA(1)>='\u12B8' && input.LA(1)<='\u12BE')||input.LA(1)=='\u12C0'||(input.LA(1)>='\u12C2' && input.LA(1)<='\u12C5')||(input.LA(1)>='\u12C8' && input.LA(1)<='\u12CE')||(input.LA(1)>='\u12D0' && input.LA(1)<='\u12D6')||(input.LA(1)>='\u12D8' && input.LA(1)<='\u12EE')||(input.LA(1)>='\u12F0' && input.LA(1)<='\u130E')||input.LA(1)=='\u1310'||(input.LA(1)>='\u1312' && input.LA(1)<='\u1315')||(input.LA(1)>='\u1318' && input.LA(1)<='\u131E')||(input.LA(1)>='\u1320' && input.LA(1)<='\u1346')||(input.LA(1)>='\u1348' && input.LA(1)<='\u135A')||(input.LA(1)>='\u1369' && input.LA(1)<='\u1371')||(input.LA(1)>='\u13A0' && input.LA(1)<='\u13F4')||(input.LA(1)>='\u1401' && input.LA(1)<='\u166C')||(input.LA(1)>='\u166F' && input.LA(1)<='\u1676')||(input.LA(1)>='\u1681' && input.LA(1)<='\u169A')||(input.LA(1)>='\u16A0' && input.LA(1)<='\u16EA')||(input.LA(1)>='\u16EE' && input.LA(1)<='\u16F0')||(input.LA(1)>='\u1700' && input.LA(1)<='\u170C')||(input.LA(1)>='\u170E' && input.LA(1)<='\u1714')||(input.LA(1)>='\u1720' && input.LA(1)<='\u1734')||(input.LA(1)>='\u1740' && input.LA(1)<='\u1753')||(input.LA(1)>='\u1760' && input.LA(1)<='\u176C')||(input.LA(1)>='\u176E' && input.LA(1)<='\u1770')||(input.LA(1)>='\u1772' && input.LA(1)<='\u1773')||(input.LA(1)>='\u1780' && input.LA(1)<='\u17D3')||input.LA(1)=='\u17D7'||(input.LA(1)>='\u17DB' && input.LA(1)<='\u17DD')||(input.LA(1)>='\u17E0' && input.LA(1)<='\u17E9')||(input.LA(1)>='\u180B' && input.LA(1)<='\u180D')||(input.LA(1)>='\u1810' && input.LA(1)<='\u1819')||(input.LA(1)>='\u1820' && input.LA(1)<='\u1877')||(input.LA(1)>='\u1880' && input.LA(1)<='\u18A9')||(input.LA(1)>='\u1900' && input.LA(1)<='\u191C')||(input.LA(1)>='\u1920' && input.LA(1)<='\u192B')||(input.LA(1)>='\u1930' && input.LA(1)<='\u193B')||(input.LA(1)>='\u1946' && input.LA(1)<='\u196D')||(input.LA(1)>='\u1970' && input.LA(1)<='\u1974')||(input.LA(1)>='\u1D00' && input.LA(1)<='\u1D6B')||(input.LA(1)>='\u1E00' && input.LA(1)<='\u1E9B')||(input.LA(1)>='\u1EA0' && input.LA(1)<='\u1EF9')||(input.LA(1)>='\u1F00' && input.LA(1)<='\u1F15')||(input.LA(1)>='\u1F18' && input.LA(1)<='\u1F1D')||(input.LA(1)>='\u1F20' && input.LA(1)<='\u1F45')||(input.LA(1)>='\u1F48' && input.LA(1)<='\u1F4D')||(input.LA(1)>='\u1F50' && input.LA(1)<='\u1F57')||input.LA(1)=='\u1F59'||input.LA(1)=='\u1F5B'||input.LA(1)=='\u1F5D'||(input.LA(1)>='\u1F5F' && input.LA(1)<='\u1F7D')||(input.LA(1)>='\u1F80' && input.LA(1)<='\u1FB4')||(input.LA(1)>='\u1FB6' && input.LA(1)<='\u1FBC')||input.LA(1)=='\u1FBE'||(input.LA(1)>='\u1FC2' && input.LA(1)<='\u1FC4')||(input.LA(1)>='\u1FC6' && input.LA(1)<='\u1FCC')||(input.LA(1)>='\u1FD0' && input.LA(1)<='\u1FD3')||(input.LA(1)>='\u1FD6' && input.LA(1)<='\u1FDB')||(input.LA(1)>='\u1FE0' && input.LA(1)<='\u1FEC')||(input.LA(1)>='\u1FF2' && input.LA(1)<='\u1FF4')||(input.LA(1)>='\u1FF6' && input.LA(1)<='\u1FFC')||(input.LA(1)>='\u200C' && input.LA(1)<='\u200F')||(input.LA(1)>='\u202A' && input.LA(1)<='\u202E')||(input.LA(1)>='\u203F' && input.LA(1)<='\u2040')||input.LA(1)=='\u2054'||(input.LA(1)>='\u2060' && input.LA(1)<='\u2063')||(input.LA(1)>='\u206A' && input.LA(1)<='\u206F')||input.LA(1)=='\u2071'||input.LA(1)=='\u207F'||(input.LA(1)>='\u20A0' && input.LA(1)<='\u20B1')||(input.LA(1)>='\u20D0' && input.LA(1)<='\u20DC')||input.LA(1)=='\u20E1'||(input.LA(1)>='\u20E5' && input.LA(1)<='\u20EA')||input.LA(1)=='\u2102'||input.LA(1)=='\u2107'||(input.LA(1)>='\u210A' && input.LA(1)<='\u2113')||input.LA(1)=='\u2115'||(input.LA(1)>='\u2119' && input.LA(1)<='\u211D')||input.LA(1)=='\u2124'||input.LA(1)=='\u2126'||input.LA(1)=='\u2128'||(input.LA(1)>='\u212A' && input.LA(1)<='\u212D')||(input.LA(1)>='\u212F' && input.LA(1)<='\u2131')||(input.LA(1)>='\u2133' && input.LA(1)<='\u2139')||(input.LA(1)>='\u213D' && input.LA(1)<='\u213F')||(input.LA(1)>='\u2145' && input.LA(1)<='\u2149')||(input.LA(1)>='\u2160' && input.LA(1)<='\u2183')||(input.LA(1)>='\u3005' && input.LA(1)<='\u3007')||(input.LA(1)>='\u3021' && input.LA(1)<='\u302F')||(input.LA(1)>='\u3031' && input.LA(1)<='\u3035')||(input.LA(1)>='\u3038' && input.LA(1)<='\u303C')||(input.LA(1)>='\u3041' && input.LA(1)<='\u3096')||(input.LA(1)>='\u3099' && input.LA(1)<='\u309A')||(input.LA(1)>='\u309D' && input.LA(1)<='\u309F')||(input.LA(1)>='\u30A1' && input.LA(1)<='\u30FF')||(input.LA(1)>='\u3105' && input.LA(1)<='\u312C')||(input.LA(1)>='\u3131' && input.LA(1)<='\u318E')||(input.LA(1)>='\u31A0' && input.LA(1)<='\u31B7')||(input.LA(1)>='\u31F0' && input.LA(1)<='\u31FF')||(input.LA(1)>='\u3400' && input.LA(1)<='\u4DB5')||(input.LA(1)>='\u4E00' && input.LA(1)<='\u9FA5')||(input.LA(1)>='\uA000' && input.LA(1)<='\uA48C')||(input.LA(1)>='\uAC00' && input.LA(1)<='\uD7A3')||(input.LA(1)>='\uF900' && input.LA(1)<='\uFA2D')||(input.LA(1)>='\uFA30' && input.LA(1)<='\uFA6A')||(input.LA(1)>='\uFB00' && input.LA(1)<='\uFB06')||(input.LA(1)>='\uFB13' && input.LA(1)<='\uFB17')||(input.LA(1)>='\uFB1D' && input.LA(1)<='\uFB28')||(input.LA(1)>='\uFB2A' && input.LA(1)<='\uFB36')||(input.LA(1)>='\uFB38' && input.LA(1)<='\uFB3C')||input.LA(1)=='\uFB3E'||(input.LA(1)>='\uFB40' && input.LA(1)<='\uFB41')||(input.LA(1)>='\uFB43' && input.LA(1)<='\uFB44')||(input.LA(1)>='\uFB46' && input.LA(1)<='\uFBB1')||(input.LA(1)>='\uFBD3' && input.LA(1)<='\uFD3D')||(input.LA(1)>='\uFD50' && input.LA(1)<='\uFD8F')||(input.LA(1)>='\uFD92' && input.LA(1)<='\uFDC7')||(input.LA(1)>='\uFDF0' && input.LA(1)<='\uFDFC')||(input.LA(1)>='\uFE00' && input.LA(1)<='\uFE0F')||(input.LA(1)>='\uFE20' && input.LA(1)<='\uFE23')||(input.LA(1)>='\uFE33' && input.LA(1)<='\uFE34')||(input.LA(1)>='\uFE4D' && input.LA(1)<='\uFE4F')||input.LA(1)=='\uFE69'||(input.LA(1)>='\uFE70' && input.LA(1)<='\uFE74')||(input.LA(1)>='\uFE76' && input.LA(1)<='\uFEFC')||input.LA(1)=='\uFEFF'||input.LA(1)=='\uFF04'||(input.LA(1)>='\uFF10' && input.LA(1)<='\uFF19')||(input.LA(1)>='\uFF21' && input.LA(1)<='\uFF3A')||input.LA(1)=='\uFF3F'||(input.LA(1)>='\uFF41' && input.LA(1)<='\uFF5A')||(input.LA(1)>='\uFF65' && input.LA(1)<='\uFFBE')||(input.LA(1)>='\uFFC2' && input.LA(1)<='\uFFC7')||(input.LA(1)>='\uFFCA' && input.LA(1)<='\uFFCF')||(input.LA(1)>='\uFFD2' && input.LA(1)<='\uFFD7')||(input.LA(1)>='\uFFDA' && input.LA(1)<='\uFFDC')||(input.LA(1)>='\uFFE0' && input.LA(1)<='\uFFE1')||(input.LA(1)>='\uFFE5' && input.LA(1)<='\uFFE6')||(input.LA(1)>='\uFFF9' && input.LA(1)<='\uFFFB') ) {
                input.consume();
            state.failed=false;
            }
            else {
                if (state.backtracking>0) {state.failed=true; return ;}
                MismatchedSetException mse = new MismatchedSetException(null,input);
                recover(mse);
                throw mse;}


            }

        }
        finally {
        }
    }
    // $ANTLR end "IdentifierPart"

    public void mTokens() throws RecognitionException {
        // src/main/resources/org/drools/lang/DRL6Lexer.g:1:8: ( WS | FLOAT | HEX | DECIMAL | STRING | TIME_INTERVAL | BOOL | NULL | AT | PLUS_ASSIGN | MINUS_ASSIGN | MULT_ASSIGN | DIV_ASSIGN | AND_ASSIGN | OR_ASSIGN | XOR_ASSIGN | MOD_ASSIGN | UNIFY | DECR | INCR | ARROW | SEMICOLON | COLON | EQUALS | NOT_EQUALS | GREATER_EQUALS | LESS_EQUALS | GREATER | LESS | EQUALS_ASSIGN | LEFT_PAREN | RIGHT_PAREN | LEFT_SQUARE | RIGHT_SQUARE | LEFT_CURLY | RIGHT_CURLY | COMMA | DOT | NULL_SAFE_DOT | DOUBLE_AMPER | DOUBLE_PIPE | QUESTION | NEGATION | TILDE | PIPE | AMPER | XOR | MOD | STAR | MINUS | PLUS | SH_STYLE_SINGLE_LINE_COMMENT | C_STYLE_SINGLE_LINE_COMMENT | MULTI_LINE_COMMENT | ID | DIV | MISC )
        int alt65=57;
        alt65 = dfa65.predict(input);
        switch (alt65) {
            case 1 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:10: WS
                {
                mWS(); if (state.failed) return ;

                }
                break;
            case 2 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:13: FLOAT
                {
                mFLOAT(); if (state.failed) return ;

                }
                break;
            case 3 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:19: HEX
                {
                mHEX(); if (state.failed) return ;

                }
                break;
            case 4 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:23: DECIMAL
                {
                mDECIMAL(); if (state.failed) return ;

                }
                break;
            case 5 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:31: STRING
                {
                mSTRING(); if (state.failed) return ;

                }
                break;
            case 6 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:38: TIME_INTERVAL
                {
                mTIME_INTERVAL(); if (state.failed) return ;

                }
                break;
            case 7 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:52: BOOL
                {
                mBOOL(); if (state.failed) return ;

                }
                break;
            case 8 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:57: NULL
                {
                mNULL(); if (state.failed) return ;

                }
                break;
            case 9 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:62: AT
                {
                mAT(); if (state.failed) return ;

                }
                break;
            case 10 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:65: PLUS_ASSIGN
                {
                mPLUS_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 11 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:77: MINUS_ASSIGN
                {
                mMINUS_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 12 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:90: MULT_ASSIGN
                {
                mMULT_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 13 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:102: DIV_ASSIGN
                {
                mDIV_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 14 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:113: AND_ASSIGN
                {
                mAND_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 15 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:124: OR_ASSIGN
                {
                mOR_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 16 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:134: XOR_ASSIGN
                {
                mXOR_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 17 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:145: MOD_ASSIGN
                {
                mMOD_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 18 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:156: UNIFY
                {
                mUNIFY(); if (state.failed) return ;

                }
                break;
            case 19 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:162: DECR
                {
                mDECR(); if (state.failed) return ;

                }
                break;
            case 20 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:167: INCR
                {
                mINCR(); if (state.failed) return ;

                }
                break;
            case 21 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:172: ARROW
                {
                mARROW(); if (state.failed) return ;

                }
                break;
            case 22 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:178: SEMICOLON
                {
                mSEMICOLON(); if (state.failed) return ;

                }
                break;
            case 23 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:188: COLON
                {
                mCOLON(); if (state.failed) return ;

                }
                break;
            case 24 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:194: EQUALS
                {
                mEQUALS(); if (state.failed) return ;

                }
                break;
            case 25 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:201: NOT_EQUALS
                {
                mNOT_EQUALS(); if (state.failed) return ;

                }
                break;
            case 26 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:212: GREATER_EQUALS
                {
                mGREATER_EQUALS(); if (state.failed) return ;

                }
                break;
            case 27 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:227: LESS_EQUALS
                {
                mLESS_EQUALS(); if (state.failed) return ;

                }
                break;
            case 28 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:239: GREATER
                {
                mGREATER(); if (state.failed) return ;

                }
                break;
            case 29 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:247: LESS
                {
                mLESS(); if (state.failed) return ;

                }
                break;
            case 30 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:252: EQUALS_ASSIGN
                {
                mEQUALS_ASSIGN(); if (state.failed) return ;

                }
                break;
            case 31 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:266: LEFT_PAREN
                {
                mLEFT_PAREN(); if (state.failed) return ;

                }
                break;
            case 32 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:277: RIGHT_PAREN
                {
                mRIGHT_PAREN(); if (state.failed) return ;

                }
                break;
            case 33 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:289: LEFT_SQUARE
                {
                mLEFT_SQUARE(); if (state.failed) return ;

                }
                break;
            case 34 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:301: RIGHT_SQUARE
                {
                mRIGHT_SQUARE(); if (state.failed) return ;

                }
                break;
            case 35 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:314: LEFT_CURLY
                {
                mLEFT_CURLY(); if (state.failed) return ;

                }
                break;
            case 36 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:325: RIGHT_CURLY
                {
                mRIGHT_CURLY(); if (state.failed) return ;

                }
                break;
            case 37 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:337: COMMA
                {
                mCOMMA(); if (state.failed) return ;

                }
                break;
            case 38 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:343: DOT
                {
                mDOT(); if (state.failed) return ;

                }
                break;
            case 39 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:347: NULL_SAFE_DOT
                {
                mNULL_SAFE_DOT(); if (state.failed) return ;

                }
                break;
            case 40 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:361: DOUBLE_AMPER
                {
                mDOUBLE_AMPER(); if (state.failed) return ;

                }
                break;
            case 41 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:374: DOUBLE_PIPE
                {
                mDOUBLE_PIPE(); if (state.failed) return ;

                }
                break;
            case 42 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:386: QUESTION
                {
                mQUESTION(); if (state.failed) return ;

                }
                break;
            case 43 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:395: NEGATION
                {
                mNEGATION(); if (state.failed) return ;

                }
                break;
            case 44 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:404: TILDE
                {
                mTILDE(); if (state.failed) return ;

                }
                break;
            case 45 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:410: PIPE
                {
                mPIPE(); if (state.failed) return ;

                }
                break;
            case 46 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:415: AMPER
                {
                mAMPER(); if (state.failed) return ;

                }
                break;
            case 47 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:421: XOR
                {
                mXOR(); if (state.failed) return ;

                }
                break;
            case 48 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:425: MOD
                {
                mMOD(); if (state.failed) return ;

                }
                break;
            case 49 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:429: STAR
                {
                mSTAR(); if (state.failed) return ;

                }
                break;
            case 50 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:434: MINUS
                {
                mMINUS(); if (state.failed) return ;

                }
                break;
            case 51 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:440: PLUS
                {
                mPLUS(); if (state.failed) return ;

                }
                break;
            case 52 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:445: SH_STYLE_SINGLE_LINE_COMMENT
                {
                mSH_STYLE_SINGLE_LINE_COMMENT(); if (state.failed) return ;

                }
                break;
            case 53 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:474: C_STYLE_SINGLE_LINE_COMMENT
                {
                mC_STYLE_SINGLE_LINE_COMMENT(); if (state.failed) return ;

                }
                break;
            case 54 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:502: MULTI_LINE_COMMENT
                {
                mMULTI_LINE_COMMENT(); if (state.failed) return ;

                }
                break;
            case 55 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:521: ID
                {
                mID(); if (state.failed) return ;

                }
                break;
            case 56 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:524: DIV
                {
                mDIV(); if (state.failed) return ;

                }
                break;
            case 57 :
                // src/main/resources/org/drools/lang/DRL6Lexer.g:1:528: MISC
                {
                mMISC(); if (state.failed) return ;

                }
                break;

        }

    }

    // $ANTLR start synpred1_DRL6Lexer
    public final void synpred1_DRL6Lexer_fragment() throws RecognitionException {   
        // src/main/resources/org/drools/lang/DRL6Lexer.g:81:20: ( '\\r\\n' )
        // src/main/resources/org/drools/lang/DRL6Lexer.g:81:22: '\\r\\n'
        {
        match("\r\n"); if (state.failed) return ;


        }
    }
    // $ANTLR end synpred1_DRL6Lexer

    public final boolean synpred1_DRL6Lexer() {
        state.backtracking++;
        int start = input.mark();
        try {
            synpred1_DRL6Lexer_fragment(); // can never throw exception
        } catch (RecognitionException re) {
            System.err.println("impossible: "+re);
        }
        boolean success = !state.failed;
        input.rewind(start);
        state.backtracking--;
        state.failed=false;
        return success;
    }


    protected DFA13 dfa13 = new DFA13(this);
    protected DFA53 dfa53 = new DFA53(this);
    protected DFA25 dfa25 = new DFA25(this);
    protected DFA27 dfa27 = new DFA27(this);
    protected DFA29 dfa29 = new DFA29(this);
    protected DFA35 dfa35 = new DFA35(this);
    protected DFA37 dfa37 = new DFA37(this);
    protected DFA43 dfa43 = new DFA43(this);
    protected DFA65 dfa65 = new DFA65(this);
    static final String DFA13_eotS =
        "\6\uffff";
    static final String DFA13_eofS =
        "\6\uffff";
    static final String DFA13_minS =
        "\2\56\4\uffff";
    static final String DFA13_maxS =
        "\1\71\1\146\4\uffff";
    static final String DFA13_acceptS =
        "\2\uffff\1\2\1\1\1\3\1\4";
    static final String DFA13_specialS =
        "\6\uffff}>";
    static final String[] DFA13_transitionS = {
            "\1\2\1\uffff\12\1",
            "\1\3\1\uffff\12\1\10\uffff\1\5\1\uffff\1\5\1\4\1\5\35\uffff"+
            "\1\5\1\4\1\5",
            "",
            "",
            "",
            ""
    };

    static final short[] DFA13_eot = DFA.unpackEncodedString(DFA13_eotS);
    static final short[] DFA13_eof = DFA.unpackEncodedString(DFA13_eofS);
    static final char[] DFA13_min = DFA.unpackEncodedStringToUnsignedChars(DFA13_minS);
    static final char[] DFA13_max = DFA.unpackEncodedStringToUnsignedChars(DFA13_maxS);
    static final short[] DFA13_accept = DFA.unpackEncodedString(DFA13_acceptS);
    static final short[] DFA13_special = DFA.unpackEncodedString(DFA13_specialS);
    static final short[][] DFA13_transition;

    static {
        int numStates = DFA13_transitionS.length;
        DFA13_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA13_transition[i] = DFA.unpackEncodedString(DFA13_transitionS[i]);
        }
    }

    class DFA13 extends DFA {

        public DFA13(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 13;
            this.eot = DFA13_eot;
            this.eof = DFA13_eof;
            this.min = DFA13_min;
            this.max = DFA13_max;
            this.accept = DFA13_accept;
            this.special = DFA13_special;
            this.transition = DFA13_transition;
        }
        public String getDescription() {
            return "87:1: FLOAT : ( ( '0' .. '9' )+ '.' ( '0' .. '9' )* ( Exponent )? ( FloatTypeSuffix )? | '.' ( '0' .. '9' )+ ( Exponent )? ( FloatTypeSuffix )? | ( '0' .. '9' )+ Exponent ( FloatTypeSuffix )? | ( '0' .. '9' )+ FloatTypeSuffix );";
        }
    }
    static final String DFA53_eotS =
        "\1\uffff\1\6\2\uffff\1\7\3\uffff";
    static final String DFA53_eofS =
        "\10\uffff";
    static final String DFA53_minS =
        "\2\60\2\uffff\1\163\3\uffff";
    static final String DFA53_maxS =
        "\1\71\1\163\2\uffff\1\163\3\uffff";
    static final String DFA53_acceptS =
        "\2\uffff\1\1\1\2\1\uffff\1\4\1\5\1\3";
    static final String DFA53_specialS =
        "\10\uffff}>";
    static final String[] DFA53_transitionS = {
            "\12\1",
            "\12\1\52\uffff\1\2\3\uffff\1\3\4\uffff\1\4\5\uffff\1\5",
            "",
            "",
            "\1\6",
            "",
            "",
            ""
    };

    static final short[] DFA53_eot = DFA.unpackEncodedString(DFA53_eotS);
    static final short[] DFA53_eof = DFA.unpackEncodedString(DFA53_eofS);
    static final char[] DFA53_min = DFA.unpackEncodedStringToUnsignedChars(DFA53_minS);
    static final char[] DFA53_max = DFA.unpackEncodedStringToUnsignedChars(DFA53_maxS);
    static final short[] DFA53_accept = DFA.unpackEncodedString(DFA53_acceptS);
    static final short[] DFA53_special = DFA.unpackEncodedString(DFA53_specialS);
    static final short[][] DFA53_transition;

    static {
        int numStates = DFA53_transitionS.length;
        DFA53_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA53_transition[i] = DFA.unpackEncodedString(DFA53_transitionS[i]);
        }
    }

    class DFA53 extends DFA {

        public DFA53(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 53;
            this.eot = DFA53_eot;
            this.eof = DFA53_eof;
            this.min = DFA53_min;
            this.max = DFA53_max;
            this.accept = DFA53_accept;
            this.special = DFA53_special;
            this.transition = DFA53_transition;
        }
        public String getDescription() {
            return "113:1: TIME_INTERVAL : ( ( ( '0' .. '9' )+ 'd' ) ( ( '0' .. '9' )+ 'h' )? ( ( '0' .. '9' )+ 'm' )? ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ 'h' ) ( ( '0' .. '9' )+ 'm' )? ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ 'm' ) ( ( '0' .. '9' )+ 's' )? ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ 's' ) ( ( '0' .. '9' )+ ( 'ms' )? )? | ( ( '0' .. '9' )+ ( 'ms' )? ) );";
        }
    }
    static final String DFA25_eotS =
        "\2\2\2\uffff";
    static final String DFA25_eofS =
        "\4\uffff";
    static final String DFA25_minS =
        "\2\60\2\uffff";
    static final String DFA25_maxS =
        "\1\71\1\150\2\uffff";
    static final String DFA25_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA25_specialS =
        "\4\uffff}>";
    static final String[] DFA25_transitionS = {
            "\12\1",
            "\12\1\56\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA25_eot = DFA.unpackEncodedString(DFA25_eotS);
    static final short[] DFA25_eof = DFA.unpackEncodedString(DFA25_eofS);
    static final char[] DFA25_min = DFA.unpackEncodedStringToUnsignedChars(DFA25_minS);
    static final char[] DFA25_max = DFA.unpackEncodedStringToUnsignedChars(DFA25_maxS);
    static final short[] DFA25_accept = DFA.unpackEncodedString(DFA25_acceptS);
    static final short[] DFA25_special = DFA.unpackEncodedString(DFA25_specialS);
    static final short[][] DFA25_transition;

    static {
        int numStates = DFA25_transitionS.length;
        DFA25_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA25_transition[i] = DFA.unpackEncodedString(DFA25_transitionS[i]);
        }
    }

    class DFA25 extends DFA {

        public DFA25(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 25;
            this.eot = DFA25_eot;
            this.eof = DFA25_eof;
            this.min = DFA25_min;
            this.max = DFA25_max;
            this.accept = DFA25_accept;
            this.special = DFA25_special;
            this.transition = DFA25_transition;
        }
        public String getDescription() {
            return "114:25: ( ( '0' .. '9' )+ 'h' )?";
        }
    }
    static final String DFA27_eotS =
        "\2\2\1\uffff\1\4\1\uffff";
    static final String DFA27_eofS =
        "\5\uffff";
    static final String DFA27_minS =
        "\2\60\1\uffff\1\163\1\uffff";
    static final String DFA27_maxS =
        "\1\71\1\155\1\uffff\1\163\1\uffff";
    static final String DFA27_acceptS =
        "\2\uffff\1\2\1\uffff\1\1";
    static final String DFA27_specialS =
        "\5\uffff}>";
    static final String[] DFA27_transitionS = {
            "\12\1",
            "\12\1\63\uffff\1\3",
            "",
            "\1\2",
            ""
    };

    static final short[] DFA27_eot = DFA.unpackEncodedString(DFA27_eotS);
    static final short[] DFA27_eof = DFA.unpackEncodedString(DFA27_eofS);
    static final char[] DFA27_min = DFA.unpackEncodedStringToUnsignedChars(DFA27_minS);
    static final char[] DFA27_max = DFA.unpackEncodedStringToUnsignedChars(DFA27_maxS);
    static final short[] DFA27_accept = DFA.unpackEncodedString(DFA27_acceptS);
    static final short[] DFA27_special = DFA.unpackEncodedString(DFA27_specialS);
    static final short[][] DFA27_transition;

    static {
        int numStates = DFA27_transitionS.length;
        DFA27_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA27_transition[i] = DFA.unpackEncodedString(DFA27_transitionS[i]);
        }
    }

    class DFA27 extends DFA {

        public DFA27(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 27;
            this.eot = DFA27_eot;
            this.eof = DFA27_eof;
            this.min = DFA27_min;
            this.max = DFA27_max;
            this.accept = DFA27_accept;
            this.special = DFA27_special;
            this.transition = DFA27_transition;
        }
        public String getDescription() {
            return "114:43: ( ( '0' .. '9' )+ 'm' )?";
        }
    }
    static final String DFA29_eotS =
        "\2\2\2\uffff";
    static final String DFA29_eofS =
        "\4\uffff";
    static final String DFA29_minS =
        "\2\60\2\uffff";
    static final String DFA29_maxS =
        "\1\71\1\163\2\uffff";
    static final String DFA29_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA29_specialS =
        "\4\uffff}>";
    static final String[] DFA29_transitionS = {
            "\12\1",
            "\12\1\71\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA29_eot = DFA.unpackEncodedString(DFA29_eotS);
    static final short[] DFA29_eof = DFA.unpackEncodedString(DFA29_eofS);
    static final char[] DFA29_min = DFA.unpackEncodedStringToUnsignedChars(DFA29_minS);
    static final char[] DFA29_max = DFA.unpackEncodedStringToUnsignedChars(DFA29_maxS);
    static final short[] DFA29_accept = DFA.unpackEncodedString(DFA29_acceptS);
    static final short[] DFA29_special = DFA.unpackEncodedString(DFA29_specialS);
    static final short[][] DFA29_transition;

    static {
        int numStates = DFA29_transitionS.length;
        DFA29_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA29_transition[i] = DFA.unpackEncodedString(DFA29_transitionS[i]);
        }
    }

    class DFA29 extends DFA {

        public DFA29(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 29;
            this.eot = DFA29_eot;
            this.eof = DFA29_eof;
            this.min = DFA29_min;
            this.max = DFA29_max;
            this.accept = DFA29_accept;
            this.special = DFA29_special;
            this.transition = DFA29_transition;
        }
        public String getDescription() {
            return "114:61: ( ( '0' .. '9' )+ 's' )?";
        }
    }
    static final String DFA35_eotS =
        "\2\2\1\uffff\1\4\1\uffff";
    static final String DFA35_eofS =
        "\5\uffff";
    static final String DFA35_minS =
        "\2\60\1\uffff\1\163\1\uffff";
    static final String DFA35_maxS =
        "\1\71\1\155\1\uffff\1\163\1\uffff";
    static final String DFA35_acceptS =
        "\2\uffff\1\2\1\uffff\1\1";
    static final String DFA35_specialS =
        "\5\uffff}>";
    static final String[] DFA35_transitionS = {
            "\12\1",
            "\12\1\63\uffff\1\3",
            "",
            "\1\2",
            ""
    };

    static final short[] DFA35_eot = DFA.unpackEncodedString(DFA35_eotS);
    static final short[] DFA35_eof = DFA.unpackEncodedString(DFA35_eofS);
    static final char[] DFA35_min = DFA.unpackEncodedStringToUnsignedChars(DFA35_minS);
    static final char[] DFA35_max = DFA.unpackEncodedStringToUnsignedChars(DFA35_maxS);
    static final short[] DFA35_accept = DFA.unpackEncodedString(DFA35_acceptS);
    static final short[] DFA35_special = DFA.unpackEncodedString(DFA35_specialS);
    static final short[][] DFA35_transition;

    static {
        int numStates = DFA35_transitionS.length;
        DFA35_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA35_transition[i] = DFA.unpackEncodedString(DFA35_transitionS[i]);
        }
    }

    class DFA35 extends DFA {

        public DFA35(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 35;
            this.eot = DFA35_eot;
            this.eof = DFA35_eof;
            this.min = DFA35_min;
            this.max = DFA35_max;
            this.accept = DFA35_accept;
            this.special = DFA35_special;
            this.transition = DFA35_transition;
        }
        public String getDescription() {
            return "115:25: ( ( '0' .. '9' )+ 'm' )?";
        }
    }
    static final String DFA37_eotS =
        "\2\2\2\uffff";
    static final String DFA37_eofS =
        "\4\uffff";
    static final String DFA37_minS =
        "\2\60\2\uffff";
    static final String DFA37_maxS =
        "\1\71\1\163\2\uffff";
    static final String DFA37_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA37_specialS =
        "\4\uffff}>";
    static final String[] DFA37_transitionS = {
            "\12\1",
            "\12\1\71\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA37_eot = DFA.unpackEncodedString(DFA37_eotS);
    static final short[] DFA37_eof = DFA.unpackEncodedString(DFA37_eofS);
    static final char[] DFA37_min = DFA.unpackEncodedStringToUnsignedChars(DFA37_minS);
    static final char[] DFA37_max = DFA.unpackEncodedStringToUnsignedChars(DFA37_maxS);
    static final short[] DFA37_accept = DFA.unpackEncodedString(DFA37_acceptS);
    static final short[] DFA37_special = DFA.unpackEncodedString(DFA37_specialS);
    static final short[][] DFA37_transition;

    static {
        int numStates = DFA37_transitionS.length;
        DFA37_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA37_transition[i] = DFA.unpackEncodedString(DFA37_transitionS[i]);
        }
    }

    class DFA37 extends DFA {

        public DFA37(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 37;
            this.eot = DFA37_eot;
            this.eof = DFA37_eof;
            this.min = DFA37_min;
            this.max = DFA37_max;
            this.accept = DFA37_accept;
            this.special = DFA37_special;
            this.transition = DFA37_transition;
        }
        public String getDescription() {
            return "115:43: ( ( '0' .. '9' )+ 's' )?";
        }
    }
    static final String DFA43_eotS =
        "\2\2\2\uffff";
    static final String DFA43_eofS =
        "\4\uffff";
    static final String DFA43_minS =
        "\2\60\2\uffff";
    static final String DFA43_maxS =
        "\1\71\1\163\2\uffff";
    static final String DFA43_acceptS =
        "\2\uffff\1\2\1\1";
    static final String DFA43_specialS =
        "\4\uffff}>";
    static final String[] DFA43_transitionS = {
            "\12\1",
            "\12\1\71\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA43_eot = DFA.unpackEncodedString(DFA43_eotS);
    static final short[] DFA43_eof = DFA.unpackEncodedString(DFA43_eofS);
    static final char[] DFA43_min = DFA.unpackEncodedStringToUnsignedChars(DFA43_minS);
    static final char[] DFA43_max = DFA.unpackEncodedStringToUnsignedChars(DFA43_maxS);
    static final short[] DFA43_accept = DFA.unpackEncodedString(DFA43_acceptS);
    static final short[] DFA43_special = DFA.unpackEncodedString(DFA43_specialS);
    static final short[][] DFA43_transition;

    static {
        int numStates = DFA43_transitionS.length;
        DFA43_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA43_transition[i] = DFA.unpackEncodedString(DFA43_transitionS[i]);
        }
    }

    class DFA43 extends DFA {

        public DFA43(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 43;
            this.eot = DFA43_eot;
            this.eof = DFA43_eof;
            this.min = DFA43_min;
            this.max = DFA43_max;
            this.accept = DFA43_accept;
            this.special = DFA43_special;
            this.transition = DFA43_transition;
        }
        public String getDescription() {
            return "116:25: ( ( '0' .. '9' )+ 's' )?";
        }
    }
    static final String DFA65_eotS =
        "\2\uffff\1\51\1\53\1\51\1\uffff\1\45\3\44\1\uffff\1\61\1\65\1\67"+
        "\1\73\1\76\1\101\1\103\1\105\1\107\1\uffff\1\111\1\114\1\116\1\120"+
        "\17\uffff\1\47\3\uffff\3\44\42\uffff\3\44\1\127\1\44\1\131\1\uffff"+
        "\1\127\1\uffff";
    static final String DFA65_eofS =
        "\132\uffff";
    static final String DFA65_minS =
        "\1\11\1\uffff\1\56\1\60\1\56\1\uffff\1\0\1\162\1\141\1\165\1\uffff"+
        "\1\53\1\55\1\75\1\52\1\46\4\75\1\uffff\1\75\1\56\2\75\17\uffff\1"+
        "\60\3\uffff\1\165\2\154\42\uffff\1\145\1\163\1\154\1\0\1\145\1\0"+
        "\1\uffff\1\0\1\uffff";
    static final String DFA65_maxS =
        "\1\uffe6\1\uffff\1\170\1\71\1\163\1\uffff\1\uffff\1\162\1\141\1"+
        "\165\1\uffff\1\75\1\76\3\75\1\174\3\75\1\uffff\4\75\17\uffff\1\71"+
        "\3\uffff\1\165\2\154\42\uffff\1\145\1\163\1\154\1\ufffb\1\145\1"+
        "\ufffb\1\uffff\1\ufffb\1\uffff";
    static final String DFA65_acceptS =
        "\1\uffff\1\1\3\uffff\1\5\4\uffff\1\11\11\uffff\1\26\4\uffff\1\37"+
        "\1\40\1\41\1\42\1\43\1\44\1\45\1\52\1\54\1\64\2\67\1\71\1\3\1\2"+
        "\1\uffff\1\4\1\6\1\46\3\uffff\1\12\1\24\1\63\1\13\1\23\1\25\1\62"+
        "\1\14\1\61\1\15\1\65\1\66\1\70\1\16\1\50\1\56\1\17\1\51\1\55\1\20"+
        "\1\57\1\21\1\60\1\22\1\27\1\30\1\36\1\31\1\47\1\53\1\32\1\34\1\33"+
        "\1\35\6\uffff\1\7\1\uffff\1\10";
    static final String DFA65_specialS =
        "\6\uffff\1\0\123\uffff}>";
    static final String[] DFA65_transitionS = {
            "\2\1\1\uffff\2\1\22\uffff\1\1\1\26\1\5\1\42\1\43\1\22\1\17\1"+
            "\6\1\31\1\32\1\15\1\13\1\37\1\14\1\3\1\16\1\2\11\4\1\23\1\24"+
            "\1\30\1\25\1\27\1\40\1\12\32\44\1\33\1\45\1\34\1\21\7\44\1\10"+
            "\7\44\1\11\5\44\1\7\6\44\1\35\1\20\1\36\1\41\43\uffff\4\44\4"+
            "\uffff\1\44\12\uffff\1\44\4\uffff\1\44\5\uffff\27\44\1\uffff"+
            "\37\44\1\uffff\u013f\44\31\uffff\162\44\4\uffff\14\44\16\uffff"+
            "\5\44\11\uffff\1\44\u008b\uffff\1\44\13\uffff\1\44\1\uffff\3"+
            "\44\1\uffff\1\44\1\uffff\24\44\1\uffff\54\44\1\uffff\46\44\1"+
            "\uffff\5\44\4\uffff\u0082\44\10\uffff\105\44\1\uffff\46\44\2"+
            "\uffff\2\44\6\uffff\20\44\41\uffff\46\44\2\uffff\1\44\7\uffff"+
            "\47\44\110\uffff\33\44\5\uffff\3\44\56\uffff\32\44\5\uffff\13"+
            "\44\43\uffff\2\44\1\uffff\143\44\1\uffff\1\44\17\uffff\2\44"+
            "\7\uffff\2\44\12\uffff\3\44\2\uffff\1\44\20\uffff\1\44\1\uffff"+
            "\36\44\35\uffff\3\44\60\uffff\46\44\13\uffff\1\44\u0152\uffff"+
            "\66\44\3\uffff\1\44\22\uffff\1\44\7\uffff\12\44\43\uffff\10"+
            "\44\2\uffff\2\44\2\uffff\26\44\1\uffff\7\44\1\uffff\1\44\3\uffff"+
            "\4\44\3\uffff\1\44\36\uffff\2\44\1\uffff\3\44\16\uffff\4\44"+
            "\21\uffff\6\44\4\uffff\2\44\2\uffff\26\44\1\uffff\7\44\1\uffff"+
            "\2\44\1\uffff\2\44\1\uffff\2\44\37\uffff\4\44\1\uffff\1\44\23"+
            "\uffff\3\44\20\uffff\11\44\1\uffff\3\44\1\uffff\26\44\1\uffff"+
            "\7\44\1\uffff\2\44\1\uffff\5\44\3\uffff\1\44\22\uffff\1\44\17"+
            "\uffff\2\44\17\uffff\1\44\23\uffff\10\44\2\uffff\2\44\2\uffff"+
            "\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\3\uffff\1\44\36"+
            "\uffff\2\44\1\uffff\3\44\17\uffff\1\44\21\uffff\1\44\1\uffff"+
            "\6\44\3\uffff\3\44\1\uffff\4\44\3\uffff\2\44\1\uffff\1\44\1"+
            "\uffff\2\44\3\uffff\2\44\3\uffff\3\44\3\uffff\10\44\1\uffff"+
            "\3\44\77\uffff\1\44\13\uffff\10\44\1\uffff\3\44\1\uffff\27\44"+
            "\1\uffff\12\44\1\uffff\5\44\46\uffff\2\44\43\uffff\10\44\1\uffff"+
            "\3\44\1\uffff\27\44\1\uffff\12\44\1\uffff\5\44\3\uffff\1\44"+
            "\40\uffff\1\44\1\uffff\2\44\43\uffff\10\44\1\uffff\3\44\1\uffff"+
            "\27\44\1\uffff\20\44\46\uffff\2\44\43\uffff\22\44\3\uffff\30"+
            "\44\1\uffff\11\44\1\uffff\1\44\2\uffff\7\44\72\uffff\60\44\1"+
            "\uffff\2\44\13\uffff\10\44\72\uffff\2\44\1\uffff\1\44\2\uffff"+
            "\2\44\1\uffff\1\44\2\uffff\1\44\6\uffff\4\44\1\uffff\7\44\1"+
            "\uffff\3\44\1\uffff\1\44\1\uffff\1\44\2\uffff\2\44\1\uffff\4"+
            "\44\1\uffff\2\44\11\uffff\1\44\2\uffff\5\44\1\uffff\1\44\25"+
            "\uffff\2\44\42\uffff\1\44\77\uffff\10\44\1\uffff\42\44\35\uffff"+
            "\4\44\164\uffff\42\44\1\uffff\5\44\1\uffff\2\44\45\uffff\6\44"+
            "\112\uffff\46\44\12\uffff\51\44\7\uffff\132\44\5\uffff\104\44"+
            "\5\uffff\122\44\6\uffff\7\44\1\uffff\77\44\1\uffff\1\44\1\uffff"+
            "\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff\47\44\1"+
            "\uffff\1\44\1\uffff\4\44\2\uffff\37\44\1\uffff\1\44\1\uffff"+
            "\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff\7\44\1"+
            "\uffff\7\44\1\uffff\27\44\1\uffff\37\44\1\uffff\1\44\1\uffff"+
            "\4\44\2\uffff\7\44\1\uffff\47\44\1\uffff\23\44\105\uffff\125"+
            "\44\14\uffff\u026c\44\2\uffff\10\44\12\uffff\32\44\5\uffff\113"+
            "\44\3\uffff\3\44\17\uffff\15\44\1\uffff\4\44\16\uffff\22\44"+
            "\16\uffff\22\44\16\uffff\15\44\1\uffff\3\44\17\uffff\64\44\43"+
            "\uffff\1\44\3\uffff\2\44\103\uffff\130\44\10\uffff\51\44\127"+
            "\uffff\35\44\63\uffff\36\44\2\uffff\5\44\u038b\uffff\154\44"+
            "\u0094\uffff\u009c\44\4\uffff\132\44\6\uffff\26\44\2\uffff\6"+
            "\44\2\uffff\46\44\2\uffff\6\44\2\uffff\10\44\1\uffff\1\44\1"+
            "\uffff\1\44\1\uffff\1\44\1\uffff\37\44\2\uffff\65\44\1\uffff"+
            "\7\44\1\uffff\1\44\3\uffff\3\44\1\uffff\7\44\3\uffff\4\44\2"+
            "\uffff\6\44\4\uffff\15\44\5\uffff\3\44\1\uffff\7\44\102\uffff"+
            "\2\44\23\uffff\1\44\34\uffff\1\44\15\uffff\1\44\40\uffff\22"+
            "\44\120\uffff\1\44\4\uffff\1\44\2\uffff\12\44\1\uffff\1\44\3"+
            "\uffff\5\44\6\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff\4"+
            "\44\1\uffff\3\44\1\uffff\7\44\3\uffff\3\44\5\uffff\5\44\26\uffff"+
            "\44\44\u0e81\uffff\3\44\31\uffff\11\44\7\uffff\5\44\2\uffff"+
            "\5\44\4\uffff\126\44\6\uffff\3\44\1\uffff\137\44\5\uffff\50"+
            "\44\4\uffff\136\44\21\uffff\30\44\70\uffff\20\44\u0200\uffff"+
            "\u19b6\44\112\uffff\u51a6\44\132\uffff\u048d\44\u0773\uffff"+
            "\u2ba4\44\u215c\uffff\u012e\44\2\uffff\73\44\u0095\uffff\7\44"+
            "\14\uffff\5\44\5\uffff\1\44\1\uffff\12\44\1\uffff\15\44\1\uffff"+
            "\5\44\1\uffff\1\44\1\uffff\2\44\1\uffff\2\44\1\uffff\154\44"+
            "\41\uffff\u016b\44\22\uffff\100\44\2\uffff\66\44\50\uffff\15"+
            "\44\66\uffff\2\44\30\uffff\3\44\31\uffff\1\44\6\uffff\5\44\1"+
            "\uffff\u0087\44\7\uffff\1\44\34\uffff\32\44\4\uffff\1\44\1\uffff"+
            "\32\44\12\uffff\132\44\3\uffff\6\44\2\uffff\6\44\2\uffff\6\44"+
            "\2\uffff\3\44\3\uffff\2\44\3\uffff\2\44",
            "",
            "\1\47\1\uffff\12\4\10\uffff\1\47\1\uffff\3\47\21\uffff\1\46"+
            "\13\uffff\1\50\2\47\1\uffff\1\52\4\uffff\1\52\5\uffff\1\52\4"+
            "\uffff\1\46",
            "\12\47",
            "\1\47\1\uffff\12\4\10\uffff\1\47\1\uffff\3\47\35\uffff\1\50"+
            "\2\47\1\uffff\1\52\4\uffff\1\52\5\uffff\1\52",
            "",
            "\0\5",
            "\1\54",
            "\1\55",
            "\1\56",
            "",
            "\1\60\21\uffff\1\57",
            "\1\63\17\uffff\1\62\1\64",
            "\1\66",
            "\1\72\4\uffff\1\71\15\uffff\1\70",
            "\1\75\26\uffff\1\74",
            "\1\77\76\uffff\1\100",
            "\1\102",
            "\1\104",
            "\1\106",
            "",
            "\1\110",
            "\1\113\16\uffff\1\112",
            "\1\115",
            "\1\117",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\12\52",
            "",
            "",
            "",
            "\1\121",
            "\1\122",
            "\1\123",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "\1\124",
            "\1\125",
            "\1\126",
            "\11\44\5\uffff\16\44\10\uffff\1\44\13\uffff\12\44\7\uffff\32"+
            "\44\4\uffff\1\44\1\uffff\32\44\4\uffff\41\44\2\uffff\4\44\4"+
            "\uffff\1\44\2\uffff\1\44\7\uffff\1\44\4\uffff\1\44\5\uffff\27"+
            "\44\1\uffff\37\44\1\uffff\u013f\44\31\uffff\162\44\4\uffff\14"+
            "\44\16\uffff\5\44\11\uffff\1\44\21\uffff\130\44\5\uffff\23\44"+
            "\12\uffff\1\44\13\uffff\1\44\1\uffff\3\44\1\uffff\1\44\1\uffff"+
            "\24\44\1\uffff\54\44\1\uffff\46\44\1\uffff\5\44\4\uffff\u0082"+
            "\44\1\uffff\4\44\3\uffff\105\44\1\uffff\46\44\2\uffff\2\44\6"+
            "\uffff\20\44\41\uffff\46\44\2\uffff\1\44\7\uffff\47\44\11\uffff"+
            "\21\44\1\uffff\27\44\1\uffff\3\44\1\uffff\1\44\1\uffff\2\44"+
            "\1\uffff\1\44\13\uffff\33\44\5\uffff\3\44\15\uffff\4\44\14\uffff"+
            "\6\44\13\uffff\32\44\5\uffff\31\44\7\uffff\12\44\4\uffff\146"+
            "\44\1\uffff\11\44\1\uffff\12\44\1\uffff\23\44\2\uffff\1\44\17"+
            "\uffff\74\44\2\uffff\3\44\60\uffff\62\44\u014f\uffff\71\44\2"+
            "\uffff\22\44\2\uffff\5\44\3\uffff\14\44\2\uffff\12\44\21\uffff"+
            "\3\44\1\uffff\10\44\2\uffff\2\44\2\uffff\26\44\1\uffff\7\44"+
            "\1\uffff\1\44\3\uffff\4\44\2\uffff\11\44\2\uffff\2\44\2\uffff"+
            "\3\44\11\uffff\1\44\4\uffff\2\44\1\uffff\5\44\2\uffff\16\44"+
            "\15\uffff\3\44\1\uffff\6\44\4\uffff\2\44\2\uffff\26\44\1\uffff"+
            "\7\44\1\uffff\2\44\1\uffff\2\44\1\uffff\2\44\2\uffff\1\44\1"+
            "\uffff\5\44\4\uffff\2\44\2\uffff\3\44\13\uffff\4\44\1\uffff"+
            "\1\44\7\uffff\17\44\14\uffff\3\44\1\uffff\11\44\1\uffff\3\44"+
            "\1\uffff\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\2\uffff"+
            "\12\44\1\uffff\3\44\1\uffff\3\44\2\uffff\1\44\17\uffff\4\44"+
            "\2\uffff\12\44\1\uffff\1\44\17\uffff\3\44\1\uffff\10\44\2\uffff"+
            "\2\44\2\uffff\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\2"+
            "\uffff\10\44\3\uffff\2\44\2\uffff\3\44\10\uffff\2\44\4\uffff"+
            "\2\44\1\uffff\3\44\4\uffff\12\44\1\uffff\1\44\20\uffff\2\44"+
            "\1\uffff\6\44\3\uffff\3\44\1\uffff\4\44\3\uffff\2\44\1\uffff"+
            "\1\44\1\uffff\2\44\3\uffff\2\44\3\uffff\3\44\3\uffff\10\44\1"+
            "\uffff\3\44\4\uffff\5\44\3\uffff\3\44\1\uffff\4\44\11\uffff"+
            "\1\44\17\uffff\11\44\11\uffff\1\44\7\uffff\3\44\1\uffff\10\44"+
            "\1\uffff\3\44\1\uffff\27\44\1\uffff\12\44\1\uffff\5\44\4\uffff"+
            "\7\44\1\uffff\3\44\1\uffff\4\44\7\uffff\2\44\11\uffff\2\44\4"+
            "\uffff\12\44\22\uffff\2\44\1\uffff\10\44\1\uffff\3\44\1\uffff"+
            "\27\44\1\uffff\12\44\1\uffff\5\44\2\uffff\11\44\1\uffff\3\44"+
            "\1\uffff\4\44\7\uffff\2\44\7\uffff\1\44\1\uffff\2\44\4\uffff"+
            "\12\44\22\uffff\2\44\1\uffff\10\44\1\uffff\3\44\1\uffff\27\44"+
            "\1\uffff\20\44\4\uffff\6\44\2\uffff\3\44\1\uffff\4\44\11\uffff"+
            "\1\44\10\uffff\2\44\4\uffff\12\44\22\uffff\2\44\1\uffff\22\44"+
            "\3\uffff\30\44\1\uffff\11\44\1\uffff\1\44\2\uffff\7\44\3\uffff"+
            "\1\44\4\uffff\6\44\1\uffff\1\44\1\uffff\10\44\22\uffff\2\44"+
            "\15\uffff\72\44\4\uffff\20\44\1\uffff\12\44\47\uffff\2\44\1"+
            "\uffff\1\44\2\uffff\2\44\1\uffff\1\44\2\uffff\1\44\6\uffff\4"+
            "\44\1\uffff\7\44\1\uffff\3\44\1\uffff\1\44\1\uffff\1\44\2\uffff"+
            "\2\44\1\uffff\15\44\1\uffff\3\44\2\uffff\5\44\1\uffff\1\44\1"+
            "\uffff\6\44\2\uffff\12\44\2\uffff\2\44\42\uffff\1\44\27\uffff"+
            "\2\44\6\uffff\12\44\13\uffff\1\44\1\uffff\1\44\1\uffff\1\44"+
            "\4\uffff\12\44\1\uffff\42\44\6\uffff\24\44\1\uffff\6\44\4\uffff"+
            "\10\44\1\uffff\44\44\11\uffff\1\44\71\uffff\42\44\1\uffff\5"+
            "\44\1\uffff\2\44\1\uffff\7\44\3\uffff\4\44\6\uffff\12\44\6\uffff"+
            "\12\44\106\uffff\46\44\12\uffff\51\44\7\uffff\132\44\5\uffff"+
            "\104\44\5\uffff\122\44\6\uffff\7\44\1\uffff\77\44\1\uffff\1"+
            "\44\1\uffff\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff"+
            "\47\44\1\uffff\1\44\1\uffff\4\44\2\uffff\37\44\1\uffff\1\44"+
            "\1\uffff\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff"+
            "\7\44\1\uffff\7\44\1\uffff\27\44\1\uffff\37\44\1\uffff\1\44"+
            "\1\uffff\4\44\2\uffff\7\44\1\uffff\47\44\1\uffff\23\44\16\uffff"+
            "\11\44\56\uffff\125\44\14\uffff\u026c\44\2\uffff\10\44\12\uffff"+
            "\32\44\5\uffff\113\44\3\uffff\3\44\17\uffff\15\44\1\uffff\7"+
            "\44\13\uffff\25\44\13\uffff\24\44\14\uffff\15\44\1\uffff\3\44"+
            "\1\uffff\2\44\14\uffff\124\44\3\uffff\1\44\3\uffff\3\44\2\uffff"+
            "\12\44\41\uffff\3\44\2\uffff\12\44\6\uffff\130\44\10\uffff\52"+
            "\44\126\uffff\35\44\3\uffff\14\44\4\uffff\14\44\12\uffff\50"+
            "\44\2\uffff\5\44\u038b\uffff\154\44\u0094\uffff\u009c\44\4\uffff"+
            "\132\44\6\uffff\26\44\2\uffff\6\44\2\uffff\46\44\2\uffff\6\44"+
            "\2\uffff\10\44\1\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff"+
            "\37\44\2\uffff\65\44\1\uffff\7\44\1\uffff\1\44\3\uffff\3\44"+
            "\1\uffff\7\44\3\uffff\4\44\2\uffff\6\44\4\uffff\15\44\5\uffff"+
            "\3\44\1\uffff\7\44\17\uffff\4\44\32\uffff\5\44\20\uffff\2\44"+
            "\23\uffff\1\44\13\uffff\4\44\6\uffff\6\44\1\uffff\1\44\15\uffff"+
            "\1\44\40\uffff\22\44\36\uffff\15\44\4\uffff\1\44\3\uffff\6\44"+
            "\27\uffff\1\44\4\uffff\1\44\2\uffff\12\44\1\uffff\1\44\3\uffff"+
            "\5\44\6\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff\4\44\1"+
            "\uffff\3\44\1\uffff\7\44\3\uffff\3\44\5\uffff\5\44\26\uffff"+
            "\44\44\u0e81\uffff\3\44\31\uffff\17\44\1\uffff\5\44\2\uffff"+
            "\5\44\4\uffff\126\44\2\uffff\2\44\2\uffff\3\44\1\uffff\137\44"+
            "\5\uffff\50\44\4\uffff\136\44\21\uffff\30\44\70\uffff\20\44"+
            "\u0200\uffff\u19b6\44\112\uffff\u51a6\44\132\uffff\u048d\44"+
            "\u0773\uffff\u2ba4\44\u215c\uffff\u012e\44\2\uffff\73\44\u0095"+
            "\uffff\7\44\14\uffff\5\44\5\uffff\14\44\1\uffff\15\44\1\uffff"+
            "\5\44\1\uffff\1\44\1\uffff\2\44\1\uffff\2\44\1\uffff\154\44"+
            "\41\uffff\u016b\44\22\uffff\100\44\2\uffff\66\44\50\uffff\15"+
            "\44\3\uffff\20\44\20\uffff\4\44\17\uffff\2\44\30\uffff\3\44"+
            "\31\uffff\1\44\6\uffff\5\44\1\uffff\u0087\44\2\uffff\1\44\4"+
            "\uffff\1\44\13\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff"+
            "\32\44\12\uffff\132\44\3\uffff\6\44\2\uffff\6\44\2\uffff\6\44"+
            "\2\uffff\3\44\3\uffff\2\44\3\uffff\2\44\22\uffff\3\44",
            "\1\130",
            "\11\44\5\uffff\16\44\10\uffff\1\44\13\uffff\12\44\7\uffff\32"+
            "\44\4\uffff\1\44\1\uffff\32\44\4\uffff\41\44\2\uffff\4\44\4"+
            "\uffff\1\44\2\uffff\1\44\7\uffff\1\44\4\uffff\1\44\5\uffff\27"+
            "\44\1\uffff\37\44\1\uffff\u013f\44\31\uffff\162\44\4\uffff\14"+
            "\44\16\uffff\5\44\11\uffff\1\44\21\uffff\130\44\5\uffff\23\44"+
            "\12\uffff\1\44\13\uffff\1\44\1\uffff\3\44\1\uffff\1\44\1\uffff"+
            "\24\44\1\uffff\54\44\1\uffff\46\44\1\uffff\5\44\4\uffff\u0082"+
            "\44\1\uffff\4\44\3\uffff\105\44\1\uffff\46\44\2\uffff\2\44\6"+
            "\uffff\20\44\41\uffff\46\44\2\uffff\1\44\7\uffff\47\44\11\uffff"+
            "\21\44\1\uffff\27\44\1\uffff\3\44\1\uffff\1\44\1\uffff\2\44"+
            "\1\uffff\1\44\13\uffff\33\44\5\uffff\3\44\15\uffff\4\44\14\uffff"+
            "\6\44\13\uffff\32\44\5\uffff\31\44\7\uffff\12\44\4\uffff\146"+
            "\44\1\uffff\11\44\1\uffff\12\44\1\uffff\23\44\2\uffff\1\44\17"+
            "\uffff\74\44\2\uffff\3\44\60\uffff\62\44\u014f\uffff\71\44\2"+
            "\uffff\22\44\2\uffff\5\44\3\uffff\14\44\2\uffff\12\44\21\uffff"+
            "\3\44\1\uffff\10\44\2\uffff\2\44\2\uffff\26\44\1\uffff\7\44"+
            "\1\uffff\1\44\3\uffff\4\44\2\uffff\11\44\2\uffff\2\44\2\uffff"+
            "\3\44\11\uffff\1\44\4\uffff\2\44\1\uffff\5\44\2\uffff\16\44"+
            "\15\uffff\3\44\1\uffff\6\44\4\uffff\2\44\2\uffff\26\44\1\uffff"+
            "\7\44\1\uffff\2\44\1\uffff\2\44\1\uffff\2\44\2\uffff\1\44\1"+
            "\uffff\5\44\4\uffff\2\44\2\uffff\3\44\13\uffff\4\44\1\uffff"+
            "\1\44\7\uffff\17\44\14\uffff\3\44\1\uffff\11\44\1\uffff\3\44"+
            "\1\uffff\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\2\uffff"+
            "\12\44\1\uffff\3\44\1\uffff\3\44\2\uffff\1\44\17\uffff\4\44"+
            "\2\uffff\12\44\1\uffff\1\44\17\uffff\3\44\1\uffff\10\44\2\uffff"+
            "\2\44\2\uffff\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\2"+
            "\uffff\10\44\3\uffff\2\44\2\uffff\3\44\10\uffff\2\44\4\uffff"+
            "\2\44\1\uffff\3\44\4\uffff\12\44\1\uffff\1\44\20\uffff\2\44"+
            "\1\uffff\6\44\3\uffff\3\44\1\uffff\4\44\3\uffff\2\44\1\uffff"+
            "\1\44\1\uffff\2\44\3\uffff\2\44\3\uffff\3\44\3\uffff\10\44\1"+
            "\uffff\3\44\4\uffff\5\44\3\uffff\3\44\1\uffff\4\44\11\uffff"+
            "\1\44\17\uffff\11\44\11\uffff\1\44\7\uffff\3\44\1\uffff\10\44"+
            "\1\uffff\3\44\1\uffff\27\44\1\uffff\12\44\1\uffff\5\44\4\uffff"+
            "\7\44\1\uffff\3\44\1\uffff\4\44\7\uffff\2\44\11\uffff\2\44\4"+
            "\uffff\12\44\22\uffff\2\44\1\uffff\10\44\1\uffff\3\44\1\uffff"+
            "\27\44\1\uffff\12\44\1\uffff\5\44\2\uffff\11\44\1\uffff\3\44"+
            "\1\uffff\4\44\7\uffff\2\44\7\uffff\1\44\1\uffff\2\44\4\uffff"+
            "\12\44\22\uffff\2\44\1\uffff\10\44\1\uffff\3\44\1\uffff\27\44"+
            "\1\uffff\20\44\4\uffff\6\44\2\uffff\3\44\1\uffff\4\44\11\uffff"+
            "\1\44\10\uffff\2\44\4\uffff\12\44\22\uffff\2\44\1\uffff\22\44"+
            "\3\uffff\30\44\1\uffff\11\44\1\uffff\1\44\2\uffff\7\44\3\uffff"+
            "\1\44\4\uffff\6\44\1\uffff\1\44\1\uffff\10\44\22\uffff\2\44"+
            "\15\uffff\72\44\4\uffff\20\44\1\uffff\12\44\47\uffff\2\44\1"+
            "\uffff\1\44\2\uffff\2\44\1\uffff\1\44\2\uffff\1\44\6\uffff\4"+
            "\44\1\uffff\7\44\1\uffff\3\44\1\uffff\1\44\1\uffff\1\44\2\uffff"+
            "\2\44\1\uffff\15\44\1\uffff\3\44\2\uffff\5\44\1\uffff\1\44\1"+
            "\uffff\6\44\2\uffff\12\44\2\uffff\2\44\42\uffff\1\44\27\uffff"+
            "\2\44\6\uffff\12\44\13\uffff\1\44\1\uffff\1\44\1\uffff\1\44"+
            "\4\uffff\12\44\1\uffff\42\44\6\uffff\24\44\1\uffff\6\44\4\uffff"+
            "\10\44\1\uffff\44\44\11\uffff\1\44\71\uffff\42\44\1\uffff\5"+
            "\44\1\uffff\2\44\1\uffff\7\44\3\uffff\4\44\6\uffff\12\44\6\uffff"+
            "\12\44\106\uffff\46\44\12\uffff\51\44\7\uffff\132\44\5\uffff"+
            "\104\44\5\uffff\122\44\6\uffff\7\44\1\uffff\77\44\1\uffff\1"+
            "\44\1\uffff\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff"+
            "\47\44\1\uffff\1\44\1\uffff\4\44\2\uffff\37\44\1\uffff\1\44"+
            "\1\uffff\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff"+
            "\7\44\1\uffff\7\44\1\uffff\27\44\1\uffff\37\44\1\uffff\1\44"+
            "\1\uffff\4\44\2\uffff\7\44\1\uffff\47\44\1\uffff\23\44\16\uffff"+
            "\11\44\56\uffff\125\44\14\uffff\u026c\44\2\uffff\10\44\12\uffff"+
            "\32\44\5\uffff\113\44\3\uffff\3\44\17\uffff\15\44\1\uffff\7"+
            "\44\13\uffff\25\44\13\uffff\24\44\14\uffff\15\44\1\uffff\3\44"+
            "\1\uffff\2\44\14\uffff\124\44\3\uffff\1\44\3\uffff\3\44\2\uffff"+
            "\12\44\41\uffff\3\44\2\uffff\12\44\6\uffff\130\44\10\uffff\52"+
            "\44\126\uffff\35\44\3\uffff\14\44\4\uffff\14\44\12\uffff\50"+
            "\44\2\uffff\5\44\u038b\uffff\154\44\u0094\uffff\u009c\44\4\uffff"+
            "\132\44\6\uffff\26\44\2\uffff\6\44\2\uffff\46\44\2\uffff\6\44"+
            "\2\uffff\10\44\1\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff"+
            "\37\44\2\uffff\65\44\1\uffff\7\44\1\uffff\1\44\3\uffff\3\44"+
            "\1\uffff\7\44\3\uffff\4\44\2\uffff\6\44\4\uffff\15\44\5\uffff"+
            "\3\44\1\uffff\7\44\17\uffff\4\44\32\uffff\5\44\20\uffff\2\44"+
            "\23\uffff\1\44\13\uffff\4\44\6\uffff\6\44\1\uffff\1\44\15\uffff"+
            "\1\44\40\uffff\22\44\36\uffff\15\44\4\uffff\1\44\3\uffff\6\44"+
            "\27\uffff\1\44\4\uffff\1\44\2\uffff\12\44\1\uffff\1\44\3\uffff"+
            "\5\44\6\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff\4\44\1"+
            "\uffff\3\44\1\uffff\7\44\3\uffff\3\44\5\uffff\5\44\26\uffff"+
            "\44\44\u0e81\uffff\3\44\31\uffff\17\44\1\uffff\5\44\2\uffff"+
            "\5\44\4\uffff\126\44\2\uffff\2\44\2\uffff\3\44\1\uffff\137\44"+
            "\5\uffff\50\44\4\uffff\136\44\21\uffff\30\44\70\uffff\20\44"+
            "\u0200\uffff\u19b6\44\112\uffff\u51a6\44\132\uffff\u048d\44"+
            "\u0773\uffff\u2ba4\44\u215c\uffff\u012e\44\2\uffff\73\44\u0095"+
            "\uffff\7\44\14\uffff\5\44\5\uffff\14\44\1\uffff\15\44\1\uffff"+
            "\5\44\1\uffff\1\44\1\uffff\2\44\1\uffff\2\44\1\uffff\154\44"+
            "\41\uffff\u016b\44\22\uffff\100\44\2\uffff\66\44\50\uffff\15"+
            "\44\3\uffff\20\44\20\uffff\4\44\17\uffff\2\44\30\uffff\3\44"+
            "\31\uffff\1\44\6\uffff\5\44\1\uffff\u0087\44\2\uffff\1\44\4"+
            "\uffff\1\44\13\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff"+
            "\32\44\12\uffff\132\44\3\uffff\6\44\2\uffff\6\44\2\uffff\6\44"+
            "\2\uffff\3\44\3\uffff\2\44\3\uffff\2\44\22\uffff\3\44",
            "",
            "\11\44\5\uffff\16\44\10\uffff\1\44\13\uffff\12\44\7\uffff\32"+
            "\44\4\uffff\1\44\1\uffff\32\44\4\uffff\41\44\2\uffff\4\44\4"+
            "\uffff\1\44\2\uffff\1\44\7\uffff\1\44\4\uffff\1\44\5\uffff\27"+
            "\44\1\uffff\37\44\1\uffff\u013f\44\31\uffff\162\44\4\uffff\14"+
            "\44\16\uffff\5\44\11\uffff\1\44\21\uffff\130\44\5\uffff\23\44"+
            "\12\uffff\1\44\13\uffff\1\44\1\uffff\3\44\1\uffff\1\44\1\uffff"+
            "\24\44\1\uffff\54\44\1\uffff\46\44\1\uffff\5\44\4\uffff\u0082"+
            "\44\1\uffff\4\44\3\uffff\105\44\1\uffff\46\44\2\uffff\2\44\6"+
            "\uffff\20\44\41\uffff\46\44\2\uffff\1\44\7\uffff\47\44\11\uffff"+
            "\21\44\1\uffff\27\44\1\uffff\3\44\1\uffff\1\44\1\uffff\2\44"+
            "\1\uffff\1\44\13\uffff\33\44\5\uffff\3\44\15\uffff\4\44\14\uffff"+
            "\6\44\13\uffff\32\44\5\uffff\31\44\7\uffff\12\44\4\uffff\146"+
            "\44\1\uffff\11\44\1\uffff\12\44\1\uffff\23\44\2\uffff\1\44\17"+
            "\uffff\74\44\2\uffff\3\44\60\uffff\62\44\u014f\uffff\71\44\2"+
            "\uffff\22\44\2\uffff\5\44\3\uffff\14\44\2\uffff\12\44\21\uffff"+
            "\3\44\1\uffff\10\44\2\uffff\2\44\2\uffff\26\44\1\uffff\7\44"+
            "\1\uffff\1\44\3\uffff\4\44\2\uffff\11\44\2\uffff\2\44\2\uffff"+
            "\3\44\11\uffff\1\44\4\uffff\2\44\1\uffff\5\44\2\uffff\16\44"+
            "\15\uffff\3\44\1\uffff\6\44\4\uffff\2\44\2\uffff\26\44\1\uffff"+
            "\7\44\1\uffff\2\44\1\uffff\2\44\1\uffff\2\44\2\uffff\1\44\1"+
            "\uffff\5\44\4\uffff\2\44\2\uffff\3\44\13\uffff\4\44\1\uffff"+
            "\1\44\7\uffff\17\44\14\uffff\3\44\1\uffff\11\44\1\uffff\3\44"+
            "\1\uffff\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\2\uffff"+
            "\12\44\1\uffff\3\44\1\uffff\3\44\2\uffff\1\44\17\uffff\4\44"+
            "\2\uffff\12\44\1\uffff\1\44\17\uffff\3\44\1\uffff\10\44\2\uffff"+
            "\2\44\2\uffff\26\44\1\uffff\7\44\1\uffff\2\44\1\uffff\5\44\2"+
            "\uffff\10\44\3\uffff\2\44\2\uffff\3\44\10\uffff\2\44\4\uffff"+
            "\2\44\1\uffff\3\44\4\uffff\12\44\1\uffff\1\44\20\uffff\2\44"+
            "\1\uffff\6\44\3\uffff\3\44\1\uffff\4\44\3\uffff\2\44\1\uffff"+
            "\1\44\1\uffff\2\44\3\uffff\2\44\3\uffff\3\44\3\uffff\10\44\1"+
            "\uffff\3\44\4\uffff\5\44\3\uffff\3\44\1\uffff\4\44\11\uffff"+
            "\1\44\17\uffff\11\44\11\uffff\1\44\7\uffff\3\44\1\uffff\10\44"+
            "\1\uffff\3\44\1\uffff\27\44\1\uffff\12\44\1\uffff\5\44\4\uffff"+
            "\7\44\1\uffff\3\44\1\uffff\4\44\7\uffff\2\44\11\uffff\2\44\4"+
            "\uffff\12\44\22\uffff\2\44\1\uffff\10\44\1\uffff\3\44\1\uffff"+
            "\27\44\1\uffff\12\44\1\uffff\5\44\2\uffff\11\44\1\uffff\3\44"+
            "\1\uffff\4\44\7\uffff\2\44\7\uffff\1\44\1\uffff\2\44\4\uffff"+
            "\12\44\22\uffff\2\44\1\uffff\10\44\1\uffff\3\44\1\uffff\27\44"+
            "\1\uffff\20\44\4\uffff\6\44\2\uffff\3\44\1\uffff\4\44\11\uffff"+
            "\1\44\10\uffff\2\44\4\uffff\12\44\22\uffff\2\44\1\uffff\22\44"+
            "\3\uffff\30\44\1\uffff\11\44\1\uffff\1\44\2\uffff\7\44\3\uffff"+
            "\1\44\4\uffff\6\44\1\uffff\1\44\1\uffff\10\44\22\uffff\2\44"+
            "\15\uffff\72\44\4\uffff\20\44\1\uffff\12\44\47\uffff\2\44\1"+
            "\uffff\1\44\2\uffff\2\44\1\uffff\1\44\2\uffff\1\44\6\uffff\4"+
            "\44\1\uffff\7\44\1\uffff\3\44\1\uffff\1\44\1\uffff\1\44\2\uffff"+
            "\2\44\1\uffff\15\44\1\uffff\3\44\2\uffff\5\44\1\uffff\1\44\1"+
            "\uffff\6\44\2\uffff\12\44\2\uffff\2\44\42\uffff\1\44\27\uffff"+
            "\2\44\6\uffff\12\44\13\uffff\1\44\1\uffff\1\44\1\uffff\1\44"+
            "\4\uffff\12\44\1\uffff\42\44\6\uffff\24\44\1\uffff\6\44\4\uffff"+
            "\10\44\1\uffff\44\44\11\uffff\1\44\71\uffff\42\44\1\uffff\5"+
            "\44\1\uffff\2\44\1\uffff\7\44\3\uffff\4\44\6\uffff\12\44\6\uffff"+
            "\12\44\106\uffff\46\44\12\uffff\51\44\7\uffff\132\44\5\uffff"+
            "\104\44\5\uffff\122\44\6\uffff\7\44\1\uffff\77\44\1\uffff\1"+
            "\44\1\uffff\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff"+
            "\47\44\1\uffff\1\44\1\uffff\4\44\2\uffff\37\44\1\uffff\1\44"+
            "\1\uffff\4\44\2\uffff\7\44\1\uffff\1\44\1\uffff\4\44\2\uffff"+
            "\7\44\1\uffff\7\44\1\uffff\27\44\1\uffff\37\44\1\uffff\1\44"+
            "\1\uffff\4\44\2\uffff\7\44\1\uffff\47\44\1\uffff\23\44\16\uffff"+
            "\11\44\56\uffff\125\44\14\uffff\u026c\44\2\uffff\10\44\12\uffff"+
            "\32\44\5\uffff\113\44\3\uffff\3\44\17\uffff\15\44\1\uffff\7"+
            "\44\13\uffff\25\44\13\uffff\24\44\14\uffff\15\44\1\uffff\3\44"+
            "\1\uffff\2\44\14\uffff\124\44\3\uffff\1\44\3\uffff\3\44\2\uffff"+
            "\12\44\41\uffff\3\44\2\uffff\12\44\6\uffff\130\44\10\uffff\52"+
            "\44\126\uffff\35\44\3\uffff\14\44\4\uffff\14\44\12\uffff\50"+
            "\44\2\uffff\5\44\u038b\uffff\154\44\u0094\uffff\u009c\44\4\uffff"+
            "\132\44\6\uffff\26\44\2\uffff\6\44\2\uffff\46\44\2\uffff\6\44"+
            "\2\uffff\10\44\1\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff"+
            "\37\44\2\uffff\65\44\1\uffff\7\44\1\uffff\1\44\3\uffff\3\44"+
            "\1\uffff\7\44\3\uffff\4\44\2\uffff\6\44\4\uffff\15\44\5\uffff"+
            "\3\44\1\uffff\7\44\17\uffff\4\44\32\uffff\5\44\20\uffff\2\44"+
            "\23\uffff\1\44\13\uffff\4\44\6\uffff\6\44\1\uffff\1\44\15\uffff"+
            "\1\44\40\uffff\22\44\36\uffff\15\44\4\uffff\1\44\3\uffff\6\44"+
            "\27\uffff\1\44\4\uffff\1\44\2\uffff\12\44\1\uffff\1\44\3\uffff"+
            "\5\44\6\uffff\1\44\1\uffff\1\44\1\uffff\1\44\1\uffff\4\44\1"+
            "\uffff\3\44\1\uffff\7\44\3\uffff\3\44\5\uffff\5\44\26\uffff"+
            "\44\44\u0e81\uffff\3\44\31\uffff\17\44\1\uffff\5\44\2\uffff"+
            "\5\44\4\uffff\126\44\2\uffff\2\44\2\uffff\3\44\1\uffff\137\44"+
            "\5\uffff\50\44\4\uffff\136\44\21\uffff\30\44\70\uffff\20\44"+
            "\u0200\uffff\u19b6\44\112\uffff\u51a6\44\132\uffff\u048d\44"+
            "\u0773\uffff\u2ba4\44\u215c\uffff\u012e\44\2\uffff\73\44\u0095"+
            "\uffff\7\44\14\uffff\5\44\5\uffff\14\44\1\uffff\15\44\1\uffff"+
            "\5\44\1\uffff\1\44\1\uffff\2\44\1\uffff\2\44\1\uffff\154\44"+
            "\41\uffff\u016b\44\22\uffff\100\44\2\uffff\66\44\50\uffff\15"+
            "\44\3\uffff\20\44\20\uffff\4\44\17\uffff\2\44\30\uffff\3\44"+
            "\31\uffff\1\44\6\uffff\5\44\1\uffff\u0087\44\2\uffff\1\44\4"+
            "\uffff\1\44\13\uffff\12\44\7\uffff\32\44\4\uffff\1\44\1\uffff"+
            "\32\44\12\uffff\132\44\3\uffff\6\44\2\uffff\6\44\2\uffff\6\44"+
            "\2\uffff\3\44\3\uffff\2\44\3\uffff\2\44\22\uffff\3\44",
            ""
    };

    static final short[] DFA65_eot = DFA.unpackEncodedString(DFA65_eotS);
    static final short[] DFA65_eof = DFA.unpackEncodedString(DFA65_eofS);
    static final char[] DFA65_min = DFA.unpackEncodedStringToUnsignedChars(DFA65_minS);
    static final char[] DFA65_max = DFA.unpackEncodedStringToUnsignedChars(DFA65_maxS);
    static final short[] DFA65_accept = DFA.unpackEncodedString(DFA65_acceptS);
    static final short[] DFA65_special = DFA.unpackEncodedString(DFA65_specialS);
    static final short[][] DFA65_transition;

    static {
        int numStates = DFA65_transitionS.length;
        DFA65_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA65_transition[i] = DFA.unpackEncodedString(DFA65_transitionS[i]);
        }
    }

    class DFA65 extends DFA {

        public DFA65(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 65;
            this.eot = DFA65_eot;
            this.eof = DFA65_eof;
            this.min = DFA65_min;
            this.max = DFA65_max;
            this.accept = DFA65_accept;
            this.special = DFA65_special;
            this.transition = DFA65_transition;
        }
        public String getDescription() {
            return "1:1: Tokens : ( WS | FLOAT | HEX | DECIMAL | STRING | TIME_INTERVAL | BOOL | NULL | AT | PLUS_ASSIGN | MINUS_ASSIGN | MULT_ASSIGN | DIV_ASSIGN | AND_ASSIGN | OR_ASSIGN | XOR_ASSIGN | MOD_ASSIGN | UNIFY | DECR | INCR | ARROW | SEMICOLON | COLON | EQUALS | NOT_EQUALS | GREATER_EQUALS | LESS_EQUALS | GREATER | LESS | EQUALS_ASSIGN | LEFT_PAREN | RIGHT_PAREN | LEFT_SQUARE | RIGHT_SQUARE | LEFT_CURLY | RIGHT_CURLY | COMMA | DOT | NULL_SAFE_DOT | DOUBLE_AMPER | DOUBLE_PIPE | QUESTION | NEGATION | TILDE | PIPE | AMPER | XOR | MOD | STAR | MINUS | PLUS | SH_STYLE_SINGLE_LINE_COMMENT | C_STYLE_SINGLE_LINE_COMMENT | MULTI_LINE_COMMENT | ID | DIV | MISC );";
        }
        public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
            IntStream input = _input;
        	int _s = s;
            switch ( s ) {
                    case 0 : 
                        int LA65_6 = input.LA(1);

                        s = -1;
                        if ( ((LA65_6>='\u0000' && LA65_6<='\uFFFF')) ) {s = 5;}

                        else s = 37;

                        if ( s>=0 ) return s;
                        break;
            }
            if (state.backtracking>0) {state.failed=true; return -1;}
            NoViableAltException nvae =
                new NoViableAltException(getDescription(), 65, _s, input);
            error(nvae);
            throw nvae;
        }
    }
 

}