/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.Collection;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.common.InternalFactHandle;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.Context;

public class FromExternalFactHandleCommand
implements GenericCommand<FactHandle> {
    private String factHandleExternalForm;
    private boolean disconnected;

    public FromExternalFactHandleCommand(String factHandleExternalForm) {
        this(factHandleExternalForm, false);
    }

    public FromExternalFactHandleCommand(String factHandleExternalForm, boolean disconnected) {
        this.factHandleExternalForm = factHandleExternalForm;
        this.disconnected = disconnected;
    }

    @Override
    public FactHandle execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        Collection factHandles = ksession.getFactHandles();
        int fhId = Integer.parseInt(this.factHandleExternalForm.split(":")[1]);
        for (FactHandle factHandle : factHandles) {
            if (!(factHandle instanceof InternalFactHandle) || ((InternalFactHandle)factHandle).getId() != fhId) continue;
            InternalFactHandle fhClone = ((InternalFactHandle)factHandle).clone();
            if (this.disconnected) {
                fhClone.disconnect();
            }
            return fhClone;
        }
        return null;
    }

    public String toString() {
        return "ksession.getFactHandle( " + this.factHandleExternalForm + " );";
    }
}

