/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.UpdateContext;
import org.drools.core.reteoo.CompositeObjectSinkAdapter;
import org.drools.core.reteoo.EmptyObjectSinkAdapter;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SingleObjectSinkAdapter;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;

public abstract class ObjectSource
extends BaseNode
implements Externalizable {
    protected ObjectSinkPropagator sink;
    protected ObjectSource source;
    private int alphaNodeHashingThreshold;
    protected long declaredMask;
    protected long inferredMask;

    public ObjectSource() {
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled) {
        this(id, partitionId, partitionsEnabled, null, 3);
    }

    ObjectSource(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, int alphaNodeHashingThreshold) {
        super(id, partitionId, partitionsEnabled);
        this.source = objectSource;
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.sink = EmptyObjectSinkAdapter.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.sink = (ObjectSinkPropagator)in.readObject();
        this.source = (ObjectSource)in.readObject();
        this.alphaNodeHashingThreshold = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.sink);
        out.writeObject(this.source);
        out.writeInt(this.alphaNodeHashingThreshold);
    }

    public ObjectSource getParentObjectSource() {
        return this.source;
    }

    public void initDeclaredMask(BuildContext context) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.declaredMask = Long.MAX_VALUE;
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        ObjectType objectType = pattern.getObjectType();
        if (!(objectType instanceof ClassObjectType)) {
            this.declaredMask = Long.MAX_VALUE;
            return;
        }
        Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
        TypeDeclaration typeDeclaration = context.getRuleBase().getTypeDeclaration(objectClass);
        if (typeDeclaration == null || !typeDeclaration.isPropertyReactive()) {
            this.declaredMask = Long.MAX_VALUE;
        } else {
            List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getRuleBase(), objectClass);
            this.declaredMask = this.calculateDeclaredMask(settableProperties);
        }
    }

    public abstract long calculateDeclaredMask(List<String> var1);

    public void resetInferredMask() {
        this.inferredMask = 0L;
    }

    public long updateMask(long mask) {
        long returnMask = this.source.getType() != 30 ? this.source.updateMask(this.declaredMask | mask) : this.declaredMask | mask;
        this.inferredMask |= returnMask;
        return returnMask;
    }

    public void addObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            this.sink = new SingleObjectSinkAdapter(this.getPartitionId(), objectSink);
        } else if (this.sink instanceof SingleObjectSinkAdapter) {
            CompositeObjectSinkAdapter sinkAdapter = new CompositeObjectSinkAdapter(this.getPartitionId(), this.alphaNodeHashingThreshold);
            sinkAdapter.addObjectSink(this.sink.getSinks()[0]);
            sinkAdapter.addObjectSink(objectSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeObjectSinkAdapter)this.sink).addObjectSink(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleObjectSinkAdapter) {
            this.sink = EmptyObjectSinkAdapter.getInstance();
        } else {
            CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)this.sink;
            sinkAdapter.removeObjectSink(objectSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleObjectSinkAdapter(this.getPartitionId(), sinkAdapter.getSinks()[0]);
            }
        }
    }

    public abstract void updateSink(ObjectSink var1, PropagationContext var2, InternalWorkingMemory var3);

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.source.networkUpdated(updateContext);
    }

    public ObjectSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    @Override
    public boolean isInUse() {
        return this.sink.size() > 0;
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse() && this instanceof MemoryFactory) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory((MemoryFactory)((Object)this));
            }
        }
        if (!this.isInUse() && this instanceof ObjectSink) {
            this.source.removeObjectSink((ObjectSink)((Object)this));
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.source.collectAncestors(nodeSet);
    }

    protected ObjectTypeNode getObjectTypeNode() {
        ObjectSource source = this;
        while (source != null) {
            if (source.getType() == 30) {
                return (ObjectTypeNode)source;
            }
            source = source.source;
        }
        return null;
    }

    public long getDeclaredMask() {
        return 0L;
    }
}

