/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.phreak.RuleNetworkEvaluatorActivation;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMemory
extends AbstractBaseLinkedListNode<Memory>
implements Memory {
    protected static transient Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    private long linkedSegmentMask;
    private long allLinkedMaskTest;
    private TerminalNode rtn;
    private RuleNetworkEvaluatorActivation agendaItem;
    private SegmentMemory[] segmentMemories;
    private SegmentMemory segmentMemory;

    public PathMemory(TerminalNode rtn) {
        this.rtn = rtn;
    }

    public TerminalNode getRuleTerminalNode() {
        return this.rtn;
    }

    public RuleNetworkEvaluatorActivation getAgendaItem() {
        return this.agendaItem;
    }

    public void setAgendaItem(RuleNetworkEvaluatorActivation agendaItem) {
        this.agendaItem = agendaItem;
    }

    public long getLinkedSegmentMask() {
        return this.linkedSegmentMask;
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public void linkNodeWithoutRuleNotify(long mask) {
        this.linkedSegmentMask |= mask;
    }

    public void linkSegment(long mask, InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            if (this.getRuleTerminalNode() != null) {
                log.trace("  LinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this.getRuleTerminalNode().getRule().getName()});
            } else {
                log.trace("  LinkSegment smask={} rmask={} name={}", (Object)mask, (Object)"RiaNode");
            }
        }
        this.linkedSegmentMask |= mask;
        if (this.isRuleLinked()) {
            this.doLinkRule(wm);
        }
    }

    public void doLinkRule(InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            log.trace("    LinkRule name={}", (Object)this.getRuleTerminalNode().getRule().getName());
        }
        if (this.agendaItem == null) {
            int salience = this.rtn.getRule().getSalience().getValue(null, this.rtn.getRule(), wm);
            this.agendaItem = ((InternalAgenda)wm.getAgenda()).createRuleNetworkEvaluatorActivation(salience, this, this.rtn);
        } else if (!this.agendaItem.isActive()) {
            ((InternalAgenda)wm.getAgenda()).addActivation(this.agendaItem);
        }
    }

    public void doUnlinkRule(InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            log.trace("    UnlinkRule name={}", (Object)this.getRuleTerminalNode().getRule().getName());
        }
        if (this.agendaItem == null) {
            int salience = this.rtn.getRule().getSalience().getValue(null, this.rtn.getRule(), wm);
            this.agendaItem = ((InternalAgenda)wm.getAgenda()).createRuleNetworkEvaluatorActivation(salience, this, this.rtn);
        } else if (!this.agendaItem.isActive()) {
            ((InternalAgenda)wm.getAgenda()).addActivation(this.agendaItem);
        }
    }

    public void unlinkedSegment(long mask, InternalWorkingMemory wm) {
        if (log.isTraceEnabled()) {
            log.trace("  UnlinkSegment smask={} rmask={} name={}", new Object[]{mask, this.linkedSegmentMask, this});
        }
        if (this.isRuleLinked()) {
            this.doUnlinkRule(wm);
        }
        this.linkedSegmentMask ^= mask;
    }

    public boolean isRuleLinked() {
        return (this.linkedSegmentMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    @Override
    public short getNodeType() {
        return 101;
    }

    public SegmentMemory[] getSegmentMemories() {
        return this.segmentMemories;
    }

    public void setSegmentMemories(SegmentMemory[] segmentMemories) {
        this.segmentMemories = segmentMemories;
    }

    public void setSegmentMemory(SegmentMemory sm) {
        this.segmentMemory = sm;
    }

    @Override
    public SegmentMemory getSegmentMemory() {
        return this.segmentMemory;
    }

    public String toString() {
        return "[RuleMem " + this.getRuleTerminalNode().getRule().getName() + "]";
    }
}

