/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.InternalViewChangedEventListener;
import org.drools.core.base.extractors.ArrayElementReader;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleIterator;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.common.UpdateContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufInputMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNodeLeftTuple;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.QueryElement;
import org.drools.core.rule.Rule;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.index.RightTupleList;
import org.kie.api.runtime.rule.Variable;

public class QueryElementNode
extends LeftTupleSource
implements LeftTupleSinkNode,
MemoryFactory {
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private QueryElement queryElement;
    private boolean tupleMemoryEnabled;
    private boolean openQuery;
    private boolean unlinkedEnabled;

    public QueryElementNode() {
    }

    public QueryElementNode(int id, LeftTupleSource tupleSource, QueryElement queryElement, boolean tupleMemoryEnabled, boolean openQuery, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.setLeftTupleSource(tupleSource);
        this.queryElement = queryElement;
        this.tupleMemoryEnabled = tupleMemoryEnabled;
        this.openQuery = openQuery;
        this.unlinkedEnabled = context.getRuleBase().getConfiguration().isPhreakEnabled();
        this.initMasks(context, tupleSource);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.queryElement = (QueryElement)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.openQuery = in.readBoolean();
        this.unlinkedEnabled = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.queryElement);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeBoolean(this.openQuery);
        out.writeBoolean(this.unlinkedEnabled);
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleIterator it = LeftTupleIterator.iterator(workingMemory, this);
        LeftTuple leftTuple = (LeftTuple)it.next();
        while (leftTuple != null) {
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            while (childLeftTuple != null) {
                RightTuple rightParent = childLeftTuple.getRightParent();
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, rightParent, childLeftTuple, null, sink, true), context, workingMemory);
                while (childLeftTuple != null && childLeftTuple.getRightParent() == rightParent) {
                    childLeftTuple = childLeftTuple.getLeftParentNext();
                }
            }
            leftTuple = (LeftTuple)it.next();
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!this.isInUse()) {
            this.getLeftTupleSource().removeTupleSink(this);
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
        this.getLeftTupleSource().collectAncestors(nodeSet);
    }

    @Override
    public void attach(BuildContext context) {
        this.leftInput.addTupleSink(this, context);
        if (context == null) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.leftInput.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.leftInput.networkUpdated(updateContext);
    }

    @Override
    public short getType() {
        return 165;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public QueryElement getQueryElement() {
        return this.queryElement;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        workingMemory.getNodeMemory(this);
        InternalFactHandle handle = this.createFactHandle(context, workingMemory, leftTuple);
        DroolsQuery queryObject = this.createDroolsQuery(leftTuple, handle, null, null, null, null, workingMemory);
        ReteooWorkingMemory.QueryInsertAction action = new ReteooWorkingMemory.QueryInsertAction(context, handle, leftTuple, this);
        queryObject.setAction(action);
        context.addInsertAction(action);
    }

    public InternalFactHandle createFactHandle(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple) {
        Map map;
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = ((ProtobufInputMarshaller.QueryElementContext)map.get((Object)PersisterHelper.createTupleKey((LeftTuple)leftTuple))).handle;
        }
        handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), null, _handle.getRecency(), null, workingMemory, workingMemory) : workingMemory.getFactHandleFactory().newFactHandle(null, null, workingMemory, workingMemory);
        return handle;
    }

    public DroolsQuery createDroolsQuery(LeftTuple leftTuple, InternalFactHandle handle, RuleNetworkEvaluator.StackEntry stackEntry, List<PathMemory> rmems, LeftTupleSets trgLeftTuples, LeftTupleSink sink, InternalWorkingMemory workingMemory) {
        Object object;
        Object[] argTemplate = this.queryElement.getArgTemplate();
        Object[] args = new Object[argTemplate.length];
        System.arraycopy(argTemplate, 0, args, 0, args.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Object o;
            Declaration declr = (Declaration)argTemplate[declIndexes[i]];
            Object tupleObject = leftTuple.get(declr).getObject();
            if (tupleObject instanceof DroolsQuery) {
                ArrayElementReader arrayReader = (ArrayElementReader)declr.getExtractor();
                o = ((DroolsQuery)tupleObject).getVariables()[arrayReader.getIndex()] != null ? Variable.v : declr.getValue(workingMemory, tupleObject);
            } else {
                o = declr.getValue(workingMemory, tupleObject);
            }
            args[declIndexes[i]] = o;
        }
        int[] varIndexes = this.queryElement.getVariableIndexes();
        int length2 = varIndexes.length;
        for (int i = 0; i < length2; ++i) {
            if (argTemplate[varIndexes[i]] != Variable.v) continue;
            args[varIndexes[i]] = Variable.v;
        }
        UnificationNodeViewChangedEventListener collector = this.createCollector(leftTuple, varIndexes, this.tupleMemoryEnabled);
        boolean executeAsOpenQuery = this.openQuery;
        if (executeAsOpenQuery && (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            executeAsOpenQuery = false;
        }
        DroolsQuery queryObject = new DroolsQuery(this.queryElement.getQueryName(), args, collector, executeAsOpenQuery, stackEntry, rmems, trgLeftTuples, sink);
        collector.setFactHandle(handle);
        handle.setObject(queryObject);
        leftTuple.setObject(handle);
        return queryObject;
    }

    protected UnificationNodeViewChangedEventListener createCollector(LeftTuple leftTuple, int[] varIndexes, boolean tupleMemoryEnabled) {
        return new UnificationNodeViewChangedEventListener(leftTuple, varIndexes, this, tupleMemoryEnabled, this.unlinkedEnabled);
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        ReteooWorkingMemory.QueryRetractAction action = new ReteooWorkingMemory.QueryRetractAction(context, leftTuple, this);
        context.addInsertAction(action);
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        boolean executeAsOpenQuery = this.openQuery;
        if (executeAsOpenQuery && (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && !((DroolsQuery)object).isOpen()) {
            executeAsOpenQuery = false;
        }
        if (!executeAsOpenQuery) {
            if (leftTuple.getFirstChild() != null) {
                this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            }
            this.assertLeftTuple(leftTuple, context, workingMemory);
            return;
        }
        InternalFactHandle handle = (InternalFactHandle)leftTuple.getObject();
        DroolsQuery queryObject = (DroolsQuery)handle.getObject();
        if (queryObject.getAction() != null) {
            return;
        }
        Object[] argTemplate = this.queryElement.getArgTemplate();
        Object[] args = new Object[argTemplate.length];
        System.arraycopy(argTemplate, 0, args, 0, args.length);
        int[] declIndexes = this.queryElement.getDeclIndexes();
        int length = declIndexes.length;
        for (int i = 0; i < length; ++i) {
            Object o;
            Declaration declr = (Declaration)argTemplate[declIndexes[i]];
            Object tupleObject = leftTuple.get(declr).getObject();
            if (tupleObject instanceof DroolsQuery) {
                ArrayElementReader arrayReader = (ArrayElementReader)declr.getExtractor();
                o = ((DroolsQuery)tupleObject).getVariables()[arrayReader.getIndex()] != null ? Variable.v : declr.getValue(workingMemory, tupleObject);
            } else {
                o = declr.getValue(workingMemory, tupleObject);
            }
            args[declIndexes[i]] = o;
        }
        int[] varIndexes = this.queryElement.getVariableIndexes();
        int length2 = varIndexes.length;
        for (int i = 0; i < length2; ++i) {
            if (argTemplate[varIndexes[i]] != Variable.v) continue;
            args[varIndexes[i]] = Variable.v;
        }
        queryObject.setParameters(args);
        ((UnificationNodeViewChangedEventListener)queryObject.getQueryResultCollector()).setVariables(varIndexes);
        ReteooWorkingMemory.QueryUpdateAction action = new ReteooWorkingMemory.QueryUpdateAction(context, handle, leftTuple, this);
        context.addInsertAction(action);
    }

    @Override
    public LeftTupleSource getLeftTupleSource() {
        return this.leftInput;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new QueryElementNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.openQuery ? 1231 : 1237);
        result = 31 * result + (this.queryElement == null ? 0 : this.queryElement.hashCode());
        result = 31 * result + (this.leftInput == null ? 0 : this.leftInput.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryElementNode other = (QueryElementNode)obj;
        if (this.openQuery != other.openQuery) {
            return false;
        }
        if (this.queryElement == null ? other.queryElement != null : !this.queryElement.equals(other.queryElement)) {
            return false;
        }
        return !(this.leftInput == null ? other.leftInput != null : !this.leftInput.equals(other.leftInput));
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new QueryElementNodeMemory(this);
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        return this.leftInput.getObjectTypeNode();
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        QueryElementNodeLeftTuple peer = new QueryElementNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public String toString() {
        return "[" + this.getClass().getSimpleName() + "(" + this.id + ", " + this.queryElement.getQueryName() + ")]";
    }

    public static class QueryElementNodeMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        private QueryElementNode node;
        private SegmentMemory smem;
        private SegmentMemory querySegmentMemory;
        private LeftTupleSets resultLeftTuples;

        public QueryElementNodeMemory(QueryElementNode node) {
            this.node = node;
            this.resultLeftTuples = new LeftTupleSets();
        }

        public QueryElementNode getNode() {
            return this.node;
        }

        @Override
        public short getNodeType() {
            return 165;
        }

        public void setSegmentMemory(SegmentMemory smem) {
            this.smem = smem;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.smem;
        }

        public SegmentMemory getQuerySegmentMemory() {
            return this.querySegmentMemory;
        }

        public void setQuerySegmentMemory(SegmentMemory querySegmentMemory) {
            this.querySegmentMemory = querySegmentMemory;
        }

        public LeftTupleSets getResultLeftTuples() {
            return this.resultLeftTuples;
        }
    }

    public static class UnificationNodeViewChangedEventListener
    implements InternalViewChangedEventListener {
        private LeftTuple leftTuple;
        protected QueryElementNode node;
        private InternalFactHandle factHandle;
        private int[] variables;
        private boolean tupleMemoryEnabled;
        private boolean unlinkedEnabled;

        public UnificationNodeViewChangedEventListener(LeftTuple leftTuple, int[] variables, QueryElementNode node, boolean tupleMemoryEnabled, boolean unlinkedEnabled) {
            this.leftTuple = leftTuple;
            this.variables = variables;
            this.node = node;
            this.tupleMemoryEnabled = tupleMemoryEnabled;
            this.unlinkedEnabled = unlinkedEnabled;
        }

        public InternalFactHandle getFactHandle() {
            return this.factHandle;
        }

        public void setFactHandle(InternalFactHandle factHandle) {
            this.factHandle = factHandle;
        }

        public void setVariables(int[] variables) {
            this.variables = variables;
        }

        @Override
        public void rowAdded(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            DroolsQuery dquery = (DroolsQuery)this.factHandle.getObject();
            Object[] objects = new Object[dquery.getElements().length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                Declaration decl = decls[this.variables[i]];
                objects[this.variables[i]] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle resultHandle = this.createQueryResultHandle(context, workingMemory, objects);
            RightTuple rightTuple = this.createResultRightTuple(resultHandle, resultLeftTuple, dquery.isOpen());
            if (this.unlinkedEnabled) {
                LeftTupleSink sink = dquery.getLeftTupleSink();
                LeftTuple childLeftTuple = sink.createLeftTuple(this.leftTuple, rightTuple, sink);
                dquery.getResultLeftTupleSets().addInsert(childLeftTuple);
            } else {
                this.node.getSinkPropagator().createChildLeftTuplesforQuery(this.leftTuple, rightTuple, true, dquery.isOpen());
                RightTupleList rightTuples = dquery.getResultInsertRightTupleList();
                if (rightTuples == null) {
                    rightTuples = new RightTupleList();
                    dquery.setResultInsertRightTupleList(rightTuples);
                    ReteooWorkingMemory.QueryResultInsertAction evalAction = new ReteooWorkingMemory.QueryResultInsertAction(context, this.factHandle, this.leftTuple, this.node);
                    context.getQueue2().addFirst(evalAction);
                }
                rightTuples.add(rightTuple);
            }
        }

        protected RightTuple createResultRightTuple(QueryElementFactHandle resultHandle, LeftTuple resultLeftTuple, boolean open) {
            RightTuple rightTuple = new RightTuple(resultHandle);
            if (open) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setObject(rightTuple);
            }
            rightTuple.setPropagationContext(resultLeftTuple.getPropagationContext());
            return rightTuple;
        }

        private QueryElementFactHandle createQueryResultHandle(PropagationContext context, InternalWorkingMemory workingMemory, Object[] objects) {
            ProtobufInputMarshaller.QueryElementContext _context;
            Map map;
            QueryElementFactHandle handle = null;
            ProtobufMessages.FactHandle _handle = null;
            if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.node.getId())) != null && (_context = (ProtobufInputMarshaller.QueryElementContext)map.get(PersisterHelper.createTupleKey(this.leftTuple))) != null) {
                _handle = _context.results.removeFirst();
            }
            handle = _handle != null ? new QueryElementFactHandle(objects, _handle.getId(), _handle.getRecency()) : new QueryElementFactHandle(objects, workingMemory.getFactHandleFactory().getAtomicId().incrementAndGet(), workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            return handle;
        }

        @Override
        public void rowRemoved(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getObject();
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setObject(null);
            DroolsQuery query = (DroolsQuery)this.factHandle.getObject();
            if (this.unlinkedEnabled) {
                LeftTupleSets leftTuples = query.getResultLeftTupleSets();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        leftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        leftTuples.removeUpdate(childLeftTuple);
                    }
                }
                leftTuples.addDelete(childLeftTuple);
                return;
            }
            RightTupleList rightTuples = query.getResultRetractRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                query.setResultRetractRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultRetractAction retractAction = new ReteooWorkingMemory.QueryResultRetractAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(retractAction);
            }
            if (rightTuple.getMemory() != null) {
                throw new RuntimeException();
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public void rowUpdated(Rule rule, LeftTuple resultLeftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            RightTuple rightTuple = (RightTuple)resultLeftTuple.getObject();
            if (rightTuple.getMemory() != null) {
                return;
            }
            rightTuple.setLeftTuple(null);
            resultLeftTuple.setObject(null);
            QueryTerminalNode node = (QueryTerminalNode)resultLeftTuple.getLeftTupleSink();
            Declaration[] decls = node.getDeclarations();
            InternalFactHandle rootHandle = resultLeftTuple.get(0);
            DroolsQuery dquery = (DroolsQuery)rootHandle.getObject();
            Object[] objects = new Object[dquery.getElements().length];
            int length = this.variables.length;
            for (int i = 0; i < length; ++i) {
                Declaration decl = decls[this.variables[i]];
                objects[this.variables[i]] = decl.getValue(workingMemory, resultLeftTuple.get(decl).getObject());
            }
            QueryElementFactHandle handle = (QueryElementFactHandle)rightTuple.getFactHandle();
            handle.setRecency(workingMemory.getFactHandleFactory().getAtomicRecency().incrementAndGet());
            handle.setObject(objects);
            if (dquery.isOpen()) {
                rightTuple.setLeftTuple(resultLeftTuple);
                resultLeftTuple.setObject(rightTuple);
            }
            if (this.unlinkedEnabled) {
                LeftTupleSets leftTuples = dquery.getResultLeftTupleSets();
                LeftTuple childLeftTuple = rightTuple.getFirstChild();
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        leftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        leftTuples.removeUpdate(childLeftTuple);
                    }
                }
                leftTuples.addUpdate(childLeftTuple);
                return;
            }
            RightTupleList rightTuples = dquery.getResultUpdateRightTupleList();
            if (rightTuples == null) {
                rightTuples = new RightTupleList();
                dquery.setResultUpdateRightTupleList(rightTuples);
                ReteooWorkingMemory.QueryResultUpdateAction updateAction = new ReteooWorkingMemory.QueryResultUpdateAction(context, this.factHandle, this.leftTuple, this.node);
                context.getQueue2().addFirst(updateAction);
            }
            rightTuples.add(rightTuple);
        }

        @Override
        public List<? extends Object> getResults() {
            throw new UnsupportedOperationException(this.getClass().getCanonicalName() + " does not support the getResults() method.");
        }

        public LeftTuple getLeftTuple() {
            return this.leftTuple;
        }
    }
}

