/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.compiler.compiler.PackageBuilderConfiguration;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ResultsImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.core.util.StringUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.Results;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.ResourceConfiguration;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.definition.KnowledgePackage;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.io.ResourceTypeImpl;
import org.kie.internal.utils.CompositeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKieModule
implements InternalKieModule {
    private static final Logger log = LoggerFactory.getLogger(AbstractKieModule.class);
    private final Map<String, KnowledgeBuilder> kBuilders = new HashMap<String, KnowledgeBuilder>();
    private final Map<String, Results> resultsCache = new HashMap<String, Results>();
    protected final ReleaseId releaseId;
    private final KieModuleModel kModuleModel;
    private Map<ReleaseId, InternalKieModule> dependencies;

    public AbstractKieModule(ReleaseId releaseId, KieModuleModel kModuleModel) {
        this.releaseId = releaseId;
        this.kModuleModel = kModuleModel;
    }

    @Override
    public KieModuleModel getKieModuleModel() {
        return this.kModuleModel;
    }

    @Override
    public Map<ReleaseId, InternalKieModule> getDependencies() {
        return this.dependencies == null ? Collections.emptyMap() : this.dependencies;
    }

    @Override
    public void addDependency(InternalKieModule dependency) {
        if (this.dependencies == null) {
            this.dependencies = new HashMap<ReleaseId, InternalKieModule>();
        }
        this.dependencies.put(dependency.getReleaseId(), dependency);
    }

    public ReleaseId getReleaseId() {
        return this.releaseId;
    }

    @Override
    public KnowledgeBuilder getKnowledgeBuilderForKieBase(String kieBaseName) {
        return this.kBuilders.get(kieBaseName);
    }

    @Override
    public Collection<KnowledgePackage> getKnowledgePackagesForKieBase(String kieBaseName) {
        KnowledgeBuilder kbuilder = this.kBuilders.get(kieBaseName);
        return kbuilder != null ? kbuilder.getKnowledgePackages() : null;
    }

    @Override
    public void cacheKnowledgeBuilderForKieBase(String kieBaseName, KnowledgeBuilder kbuilder) {
        this.kBuilders.put(kieBaseName, kbuilder);
    }

    @Override
    public Map<String, Results> getKnowledgeResultsCache() {
        return this.resultsCache;
    }

    @Override
    public void cacheResultsForKieBase(String kieBaseName, Results results) {
        this.resultsCache.put(kieBaseName, results);
    }

    @Override
    public Map<String, byte[]> getClassesMap() {
        HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
        for (String fileName : this.getFileNames()) {
            if (!fileName.endsWith(".class")) continue;
            classes.put(fileName, this.getBytes(fileName));
        }
        return classes;
    }

    static KnowledgeBuilder buildKnowledgePackages(KieBaseModelImpl kBaseModel, KieProject kieProject, ResultsImpl messages) {
        CompositeClassLoader cl = kieProject.getClassLoader();
        PackageBuilderConfiguration pconf = new PackageBuilderConfiguration(null, cl.clone());
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)pconf);
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        Set<String> includes = kBaseModel.getIncludes();
        if (includes != null && !includes.isEmpty()) {
            for (String include : includes) {
                if (StringUtils.isEmpty((CharSequence)include)) continue;
                InternalKieModule includeModule = kieProject.getKieModuleForKBase(include);
                if (includeModule == null) {
                    log.error("Unable to build KieBase, could not find include: " + include);
                    return null;
                }
                AbstractKieModule.addFiles(ckbuilder, kieProject.getKieBaseModel(include), includeModule);
            }
        }
        InternalKieModule kModule = kieProject.getKieModuleForKBase(kBaseModel.getName());
        AbstractKieModule.addFiles(ckbuilder, kBaseModel, kModule);
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            for (KnowledgeBuilderError error : kbuilder.getErrors()) {
                messages.addMessage((KnowledgeBuilderResult)error);
            }
            log.error("Unable to build KieBaseModel:" + kBaseModel.getName() + "\n" + kbuilder.getErrors().toString());
        }
        kModule.cacheKnowledgeBuilderForKieBase(kBaseModel.getName(), kbuilder);
        kModule.cacheResultsForKieBase(kBaseModel.getName(), messages);
        return kbuilder;
    }

    private static void addFiles(CompositeKnowledgeBuilder ckbuilder, KieBaseModel kieBaseModel, InternalKieModule kieModule) {
        int fileCount = 0;
        for (String fileName : kieModule.getFileNames()) {
            if (!KieBuilderImpl.filterFileInKBase(kieBaseModel, fileName) || fileName.endsWith(".properties")) continue;
            ResourceConfiguration conf = AbstractKieModule.getResourceConfiguration(kieModule, fileName);
            byte[] bytes = kieModule.getBytes(fileName);
            if (bytes == null || bytes.length == 0) continue;
            if (conf == null) {
                ckbuilder.add(ResourceFactory.newByteArrayResource((byte[])bytes).setSourcePath(fileName), ResourceType.determineResourceType((String)fileName));
            } else {
                ckbuilder.add(ResourceFactory.newByteArrayResource((byte[])bytes).setSourcePath(fileName), ResourceType.determineResourceType((String)fileName), conf);
            }
            ++fileCount;
        }
        if (fileCount == 0) {
            if (kieModule instanceof FileKieModule) {
                log.warn("No files found for KieBase " + kieBaseModel.getName() + ", searching folder " + kieModule.getFile());
            } else {
                log.warn("No files found for KieBase " + kieBaseModel.getName());
            }
        }
    }

    public static ResourceConfiguration getResourceConfiguration(InternalKieModule kieModule, String fileName) {
        ResourceConfiguration conf = null;
        if (kieModule.isAvailable(fileName + ".properties")) {
            Properties prop = new Properties();
            try {
                prop.load(new ByteArrayInputStream(kieModule.getBytes(fileName + ".properties")));
            }
            catch (IOException e) {
                log.error("Error loading resource configuration from file: " + fileName + ".properties");
            }
            conf = ResourceTypeImpl.fromProperties((Properties)prop);
        }
        return conf;
    }
}

