/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.BaseEvaluator;
import org.drools.core.base.ValueType;
import org.drools.core.base.evaluators.EvaluatorDefinition;
import org.drools.core.base.evaluators.Operator;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.rule.VariableRestriction;
import org.drools.core.spi.Evaluator;
import org.drools.core.spi.FieldValue;
import org.drools.core.spi.InternalReadAccessor;

public class StrEvaluatorDefinition
implements EvaluatorDefinition {
    public static final Operator STR_COMPARE = Operator.addOperatorToRegistry("str", false);
    public static final Operator NOT_STR_COMPARE = Operator.addOperatorToRegistry("str", true);
    private static final String[] SUPPORTED_IDS = new String[]{STR_COMPARE.getOperatorString()};
    private Evaluator[] evaluator;

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.FACT, EvaluatorDefinition.Target.FACT);
    }

    @Override
    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target leftTarget, EvaluatorDefinition.Target rightTarget) {
        StrEvaluator evaluator = new StrEvaluator(type, isNegated);
        evaluator.setParameterText(parameterText);
        return evaluator;
    }

    @Override
    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    @Override
    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.FACT;
    }

    @Override
    public boolean isNegatable() {
        return true;
    }

    @Override
    public boolean supportsType(ValueType type) {
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.evaluator = (Evaluator[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.evaluator);
    }

    public static class StrEvaluator
    extends BaseEvaluator {
        private Operations parameter;

        public void setParameterText(String parameterText) {
            this.parameter = Operations.valueOf(parameterText);
        }

        public Operations getParameter() {
            return this.parameter;
        }

        public StrEvaluator(ValueType type, boolean isNegated) {
            super(type, isNegated ? NOT_STR_COMPARE : STR_COMPARE);
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle factHandle, FieldValue value) {
            Object objectValue = extractor.getValue(workingMemory, factHandle);
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)objectValue).startsWith((String)value.getValue());
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)objectValue).endsWith((String)value.getValue());
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)objectValue).length() == value.getLongValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor leftExtractor, InternalFactHandle left, InternalReadAccessor rightExtractor, InternalFactHandle right) {
            Object value1 = leftExtractor.getValue(workingMemory, left);
            Object value2 = rightExtractor.getValue(workingMemory, right);
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)value1).startsWith((String)value2);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)value1).endsWith((String)value2);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)value1).length() == ((Number)value2).longValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)right.getObject()).startsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)right.getObject()).endsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).left);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)right.getObject()).length() == ((Number)((VariableRestriction.ObjectVariableContextEntry)context).left).longValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            switch (this.parameter) {
                case startsWith: {
                    return this.getOperator().isNegated() ^ ((String)left.getObject()).startsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).right);
                }
                case endsWith: {
                    return this.getOperator().isNegated() ^ ((String)left.getObject()).endsWith((String)((VariableRestriction.ObjectVariableContextEntry)context).right);
                }
                case length: {
                    return this.getOperator().isNegated() ^ (long)((String)left.getObject()).length() == ((Number)((VariableRestriction.ObjectVariableContextEntry)context).right).longValue();
                }
            }
            throw new IllegalAccessError("Illegal str comparison parameter");
        }

        @Override
        public String toString() {
            return "StrEvaluatorDefinition str";
        }
    }

    public static enum Operations {
        startsWith,
        endsWith,
        length;

    }
}

