/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.reteoo.RightTuple;

public class RightTupleSets {
    private RightTuple insertFirst;
    private int insertSize;
    private RightTuple deleteFirst;
    private int deleteSize;
    private RightTuple updateFirst;
    private int updateSize;

    public RightTuple getInsertFirst() {
        return this.insertFirst;
    }

    public RightTuple getDeleteFirst() {
        return this.deleteFirst;
    }

    public RightTuple getUpdateFirst() {
        return this.updateFirst;
    }

    public void resetInsert() {
        this.insertFirst = null;
        this.insertSize = 0;
    }

    public void resetDelete() {
        this.deleteFirst = null;
        this.deleteSize = 0;
    }

    public void resetUpdate() {
        this.updateFirst = null;
        this.updateSize = 0;
    }

    public void resetAll() {
        this.resetInsert();
        this.resetDelete();
        this.resetUpdate();
    }

    public int insertSize() {
        return this.insertSize;
    }

    public int deleteSize() {
        return this.insertSize;
    }

    public int updateSize() {
        return this.updateSize;
    }

    public void addInsert(RightTuple rightTuple) {
        rightTuple.setStagedType((short)1);
        if (this.insertFirst == null) {
            this.insertFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.insertFirst);
            this.insertFirst.setStagePrevious(rightTuple);
            this.insertFirst = rightTuple;
        }
        ++this.insertSize;
    }

    public void addDelete(RightTuple rightTuple) {
        rightTuple.setStagedType((short)3);
        if (this.deleteFirst == null) {
            this.deleteFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.deleteFirst);
            this.deleteFirst.setStagePrevious(rightTuple);
            this.deleteFirst = rightTuple;
        }
        ++this.deleteSize;
    }

    public void addUpdate(RightTuple rightTuple) {
        rightTuple.setStagedType((short)2);
        if (this.updateFirst == null) {
            this.updateFirst = rightTuple;
        } else {
            rightTuple.setStagedNext(this.updateFirst);
            this.updateFirst.setStagePrevious(rightTuple);
            this.updateFirst = rightTuple;
        }
        ++this.updateSize;
    }

    public void removeInsert(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.insertFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.insertFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.insertSize;
        rightTuple.clearStaged();
    }

    public void removeDelete(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.deleteFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.deleteFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        --this.deleteSize;
        rightTuple.clearStaged();
    }

    public void removeUpdate(RightTuple rightTuple) {
        rightTuple.setStagedType((short)0);
        if (rightTuple == this.updateFirst) {
            RightTuple next = rightTuple.getStagedNext();
            if (next != null) {
                next.setStagePrevious(null);
            }
            this.updateFirst = next;
        } else {
            RightTuple next = rightTuple.getStagedNext();
            RightTuple previous = rightTuple.getStagedPrevious();
            if (next != null) {
                next.setStagePrevious(previous);
            }
            previous.setStagedNext(next);
        }
        rightTuple.clearStaged();
        --this.updateSize;
    }

    public void addAllInserts(RightTupleSets tupleSets) {
        if (this.insertFirst == null) {
            this.insertFirst = tupleSets.getInsertFirst();
            this.insertSize = tupleSets.insertSize;
        } else {
            RightTuple last = null;
            for (RightTuple current = this.insertFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            RightTuple rightTuple = tupleSets.getInsertFirst();
            last.setStagedNext(rightTuple);
            rightTuple.setStagePrevious(rightTuple);
            this.insertSize += tupleSets.insertSize();
        }
    }

    public void addAllDeletes(RightTupleSets tupleSets) {
        if (this.deleteFirst == null) {
            this.deleteFirst = tupleSets.getDeleteFirst();
            this.deleteSize = tupleSets.deleteSize;
        } else {
            RightTuple last = null;
            for (RightTuple current = this.deleteFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            RightTuple rightTuple = tupleSets.getDeleteFirst();
            last.setStagedNext(rightTuple);
            rightTuple.setStagePrevious(rightTuple);
            this.deleteSize += tupleSets.deleteSize();
        }
    }

    public void addAllUpdates(RightTupleSets tupleSets) {
        if (this.updateFirst == null) {
            this.updateFirst = tupleSets.getUpdateFirst();
            this.updateSize = tupleSets.updateSize;
        } else {
            RightTuple last = null;
            for (RightTuple current = this.updateFirst; current != null; current = current.getStagedNext()) {
                last = current;
            }
            RightTuple rightTuple = tupleSets.getUpdateFirst();
            last.setStagedNext(rightTuple);
            rightTuple.setStagePrevious(rightTuple);
            this.updateSize += tupleSets.updateSize();
        }
    }

    public void addAll(RightTupleSets source) {
        this.addAllInserts(source);
        this.addAllDeletes(source);
        this.addAllUpdates(source);
    }

    public void clear() {
        RightTuple next;
        RightTuple rightTuple = this.getInsertFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        rightTuple = this.getDeleteFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        rightTuple = this.getUpdateFirst();
        while (rightTuple != null) {
            next = rightTuple.getStagedNext();
            rightTuple.clearStaged();
            rightTuple = next;
        }
        this.resetAll();
    }

    public String toStringSizes() {
        return "TupleSets[insertSize=" + this.insertSize + ", deleteSize=" + this.deleteSize + ", updateSize=" + this.updateSize + "]";
    }

    public String toString() {
        RightTuple rightTuple;
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("Inserted:\n");
        for (rightTuple = this.getInsertFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(" " + rightTuple + "\n");
        }
        sbuilder.append("Deleted:\n");
        for (rightTuple = this.getDeleteFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(" " + rightTuple + "\n");
        }
        sbuilder.append("Updated:\n");
        for (rightTuple = this.getUpdateFirst(); rightTuple != null; rightTuple = rightTuple.getStagedNext()) {
            sbuilder.append(" " + rightTuple + "\n");
        }
        return sbuilder.toString();
    }

    public boolean isEmpty() {
        return this.getInsertFirst() == null && this.getDeleteFirst() == null && this.getUpdateFirst() == null;
    }
}

